/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.Device;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Proveu
extends Device {
    public Proveu(JSONObject config) {
        super(config);
    }

    protected int decodeAFD(JSONArray offs, String filename) throws IOException {
        FileReader fr = new FileReader(filename);
        BufferedReader br = new BufferedReader(fr);
        int qty = 0;
        String line = br.readLine();
        while (line != null) {
            String aux = line.substring(0, 9);
            int nsr = Integer.parseInt(aux);
            aux = line.substring(9, 10);
            int type = Integer.parseInt(aux);
            JSONObject ev = new JSONObject();
            offs.add((Object)ev);
            ev.put((Object)"nsr", (Object)nsr);
            ev.put((Object)"afd", (Object)line);
            if (type == 3) {
                String dh = line.substring(10, 22);
                String pis = line.substring(22, 34);
                ev.put((Object)"pis", (Object)pis);
                dh = dh.substring(4, 8) + "-" + dh.substring(2, 4) + "-" + dh.substring(0, 2) + " " + dh.substring(8, 10) + ":" + dh.substring(10) + ":00";
                ev.put((Object)"datahora", (Object)dh);
            }
            line = br.readLine();
            ++qty;
        }
        br.close();
        fr.close();
        File f = new File(filename);
        if (f.delete()) {
            this.verboseINFO(filename + " removido.");
        } else {
            this.verboseERROR("Falha ao tentar remover: " + filename);
        }
        return qty;
    }

    @Override
    public int getEvents(JSONArray offs) {
        if (!this.config.containsKey((Object)"path_coleta_proveu")) {
            return 0;
        }
        String path = this.config.get((Object)"path_coleta_proveu").toString();
        String prefix = "CD-AFD";
        String suffix = ".txt";
        File[] files = null;
        int qty = 0;
        String filename = path;
        try {
            File dir = new File(path);
            if (dir.isDirectory()) {
                files = dir.listFiles();
            }
            for (File file : files) {
                filename = file.getName();
                if (!filename.startsWith(prefix) || !filename.endsWith(suffix)) continue;
                qty += this.decodeAFD(offs, dir.getName() + File.separator + filename);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.verboseERROR("Falha ao tentar abrir: " + filename);
            return -1;
        }
        catch (IOException fnfe) {
            this.verboseERROR("Falha ao tentar ler: " + filename);
            return -2;
        }
        return qty;
    }

    @Override
    public void getInfo(JSONObject info) {
        for (Object key : this.config.keySet()) {
            info.put(key, this.config.get(key));
        }
    }

    @Override
    public Date getTime() {
        Date ret2 = new Date();
        return ret2;
    }

    @Override
    public boolean setTime(int timediff) {
        return true;
    }

    @Override
    public int sendUsers(JSONArray jusers, JSONArray results) {
        IfaceJSONIter list = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject juser, Object[] pars, int[] qty) {
                FileWriter fw = (FileWriter)pars[0];
                JSONArray res = (JSONArray)pars[1];
                int id = 0;
                for (String key : new String[]{"codigo", "cod", "pis", "cracha", "nome"}) {
                    if (!juser.containsKey((Object)key)) {
                        return 0;
                    }
                    if (juser.get((Object)key) != null) continue;
                    return 0;
                }
                id = Integer.parseInt(juser.get((Object)"codigo").toString());
                juser.put((Object)"id", (Object)id);
                String aux = juser.get((Object)"cracha").toString();
                if (aux.length() > 11) {
                    aux = "cracha ignorado: " + aux;
                    Proveu.this.verboseWARN(aux);
                    Proveu.this.addResult(juser, res, aux, 1);
                    return 0;
                }
                String rfid = aux;
                qty[0] = qty[0] + 1;
                String nome = juser.get((Object)"nome").toString();
                String pis = juser.get((Object)"pis").toString();
                if (juser.containsKey((Object)"tipo")) {
                    if (juser.get((Object)"tipo").equals("excluir")) {
                        return 0;
                    }
                    Proveu.this.addResult(juser, res, "inclui pis: " + pis, 0);
                }
                String bio = "SIM";
                if (juser.containsKey((Object)"verificar_biometria") && juser.get((Object)"verificar_biometria").toString().equals("0")) {
                    bio = "NAO";
                }
                if ((nome = String.format("%-52s", nome)).length() > 52) {
                    nome.substring(0, 52);
                }
                try {
                    aux = String.format("%016d", Long.parseLong(rfid)) + ";";
                    aux = aux + String.format("%012d;%s;%s\r\n", Long.parseLong(pis), nome, bio);
                    fw.write(aux);
                }
                catch (IOException ioe) {
                    Proveu.this.verboseERROR("Falha ao tentar gravar arquivo de lista");
                    return 1;
                }
                catch (NumberFormatException nfe) {
                    Proveu.this.verboseERROR("Registro ignorado. pis: " + pis);
                    Proveu.this.verboseERROR(nfe.getMessage());
                    return 0;
                }
                return 0;
            }
        };
        String filename = "Funcionarios.PRV";
        int[] qty = new int[]{0};
        try {
            FileWriter fw = new FileWriter(filename, true);
            Util.jsonIter(jusers, list, new Object[]{fw, results}, qty);
            fw.close();
        }
        catch (IOException ioe) {
            this.verboseERROR("Falha ao tentar finalizar: " + filename);
            return -1;
        }
        return qty[0];
    }

    @Override
    public JSONArray getUsers() {
        return null;
    }

    @Override
    public int sendBio(JSONArray usrs, JSONArray results) {
        return 0;
    }

    @Override
    public int getBio(JSONArray usrs) {
        return 0;
    }
}

