/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.desktop;

import com.ifractal.desktop.Scanner;
import com.ifractal.desktop.ScannerListener;

public class ScannerDummy<T>
extends Scanner<T> {
    public static final String name = "Dummy Scanner Test";
    public static final String library = "dummy";
    private static double xS = -0.75;
    private static double yS = 0.1;
    private static double dx = 0.0;
    private static double dy = 0.0;

    public ScannerDummy(long[] ctx, String[] args) {
        super(ctx, args);
    }

    public ScannerDummy(long[] ctx, String[] args, ScannerListener<T> sl) {
        super(ctx, args, sl);
    }

    @Override
    public int init(int index) {
        this.width = 500;
        this.height = 500;
        return 0;
    }

    @Override
    public String[] getInfo() {
        String[] info = new String[]{"name", name, "library", library, "vendor", this.getClass().toString(), "width", this.width + "", "height", this.height + ""};
        return info;
    }

    @Override
    public int terminate() {
        return 0;
    }

    @Override
    public int deleteBio(String id) {
        return 0;
    }

    @Override
    public int captureImage(int qty_samples, T user_data) {
        int size = this.width * this.height;
        byte[] img = new byte[size];
        double rad = 1000.0;
        for (int i = 0; i < qty_samples; ++i) {
            double[] space = ScannerDummy.createMandelbrotImage(this.width, this.height, rad / 500.0);
            int stride = this.width;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    img[y * stride + x] = ScannerDummy.getGray(space[y * this.width + x]);
                }
            }
            this.listener.onImage(this, img, this.width, this.height, user_data);
            rad += -(rad / 200.0 + 0.1);
        }
        return 0;
    }

    @Override
    public int enroll(int qty_frames, String id, byte[] quality, T user_data) {
        int r = this.captureImage(qty_frames, user_data);
        quality[0] = 10;
        this.listener.onTemplate(this, library, id, "teste".getBytes(), quality[0], user_data);
        this.listener.onMessage(this, "Enroll id: " + id + "   Quality: " + quality[0], user_data);
        return r;
    }

    @Override
    public String identify(int[] finger, int[] score, T user_data) {
        this.captureImage(150, user_data);
        score[0] = 1000;
        finger[0] = 1;
        this.listener.onMessage(this, "identify...", user_data);
        return "teste";
    }

    @Override
    public int verify(byte[] template, T user_data) {
        int r = this.captureImage(150, user_data);
        this.listener.onMessage(this, "Verify...", user_data);
        return r;
    }

    @Override
    public int deleteAll() {
        return 0;
    }

    public static double[] createMandelbrotImage(int width, int height, double rad) {
        int maxIteration = 50;
        double[] buffer = new double[width * height];
        double minMu = maxIteration;
        double maxMu = 0.0;
        double offy = dy * rad / 1000.0;
        double offx = dx * rad / 1000.0;
        xS += offx;
        yS += offy;
        if (xS > 1.0) {
            xS = 1.0;
        }
        if (xS < -2.0) {
            xS = -2.0;
        }
        if (yS > 1.0) {
            yS = 1.0;
        }
        if (yS < -1.0) {
            yS = -1.0;
        }
        for (int yPos = 0; yPos < height; ++yPos) {
            double yP = yS - rad + 2.0 * rad / (double)height * (double)yPos;
            for (int xPos = 0; xPos < width; ++xPos) {
                int iteration;
                double xP = xS - rad + 2.0 * rad / (double)width * (double)xPos;
                double x = 0.0;
                double y = 0.0;
                for (iteration = 0; x * x + y * y <= 4.0 && iteration < maxIteration; ++iteration) {
                    double tmp = x * x - y * y + xP;
                    y = 2.0 * x * y + yP;
                    x = tmp;
                }
                if (iteration < maxIteration) {
                    double modZ = Math.sqrt(x * x + y * y);
                    double mu = (double)iteration - Math.log(Math.log(modZ)) / Math.log(2.0);
                    if (mu > maxMu) {
                        maxMu = mu;
                    }
                    if (mu < minMu) {
                        minMu = mu;
                    }
                    buffer[yPos * width + xPos] = mu;
                    continue;
                }
                buffer[yPos * width + xPos] = 0.0;
            }
        }
        int count = width * height;
        while (count > 0) {
            buffer[--count] = (buffer[count] - minMu) / (maxMu - minMu);
        }
        return buffer;
    }

    private static byte getGray(double val) {
        int v = (int)(val * 767.0);
        if (v < 0) {
            v = 0;
        }
        if (v > 767) {
            v = 767;
        }
        int offset = v % 85;
        byte r = 0;
        r = v < 256 ? (byte)offset : (v < 512 ? (byte)(offset + 85) : (byte)(offset + 170));
        return r;
    }
}

