/*
 * Decompiled with CFR 0.152.
 */
package com.henry.hexa;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Auth {
    private static final int AES_KEY_SIZE = 16;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private String aesKey;

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String generateAESKey() {
        try {
            Random rd = new Random();
            byte[] key = new byte[16];
            rd.nextBytes(key);
            return new String(Base64.encodeBase64((byte[])key));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public static byte[] generateAESIV() {
        try {
            Random rd = new Random(System.currentTimeMillis());
            byte[] key = new byte[16];
            rd.nextBytes(key);
            return key;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static byte[] encodeAES(String key, byte[] c) {
        Random gerador = new Random();
        byte[] iv = new byte[16];
        gerador.nextBytes(iv);
        return Auth.encodeAES(key, c, iv);
    }

    public static byte[] encodeAES(String key, char[] data, byte[] iv) {
        byte[] cipherBytes = new byte[data.length];
        for (int v = 0; v < data.length; v = (int)((short)(v + 1))) {
            cipherBytes[v] = (byte)data[v];
        }
        return Auth.encodeAES(key, cipherBytes, iv);
    }

    public static byte[] encodeAES(String key, byte[] cipherBytes, byte[] iv) {
        try {
            byte[] keyBytes = Base64.decodeBase64((byte[])key.getBytes());
            SecretKeySpec aesKey = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(1, (Key)aesKey, new IvParameterSpec(iv));
            int packs = cipherBytes.length / 16;
            int rest = cipherBytes.length % 16;
            if (rest > 0) {
                rest = 16;
            }
            byte[] ciph = new byte[packs * 16 + rest];
            System.arraycopy(cipherBytes, 0, ciph, 0, cipherBytes.length);
            byte[] result = cipher.doFinal(ciph);
            byte[] result2 = new byte[result.length + iv.length];
            System.arraycopy(iv, 0, result2, 0, iv.length);
            System.arraycopy(result, 0, result2, iv.length, result.length);
            return result2;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static byte[] encodeAES(String key, String data) {
        Random gerador = new Random();
        byte[] iv = new byte[16];
        gerador.nextBytes(iv);
        return Auth.encodeAES(key, data, iv);
    }

    public static byte[] encodeAES(String key, String data, byte[] iv) {
        try {
            byte[] cipherBytes = data.getBytes();
            byte[] keyBytes = Base64.decodeBase64((byte[])key.getBytes());
            SecretKeySpec aesKey = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(1, (Key)aesKey, new IvParameterSpec(iv));
            int packs = cipherBytes.length / 16;
            int rest = cipherBytes.length % 16;
            if (rest > 0) {
                rest = 16;
            }
            byte[] ciph = new byte[packs * 16 + rest];
            System.arraycopy(cipherBytes, 0, ciph, 0, cipherBytes.length);
            byte[] result = cipher.doFinal(ciph);
            byte[] result2 = new byte[result.length + iv.length];
            System.arraycopy(iv, 0, result2, 0, iv.length);
            System.arraycopy(result, 0, result2, iv.length, result.length);
            return result2;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static byte[] decodeAES(String key, byte[] cipherBytes) {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        return Auth.decodeAES(key, cipherBytes, iv);
    }

    public static byte[] decodeAES(String key, byte[] cipherBytes, byte[] iv) {
        try {
            byte[] keyBytes = Base64.decodeBase64((byte[])key.getBytes());
            SecretKeySpec aesKey = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)aesKey, new IvParameterSpec(iv));
            byte[] result = cipher.doFinal(cipherBytes);
            return result;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static String encodeRSA(String keyModulus, String keyExponent, String data) {
        try {
            byte[] btMod = Base64.decodeBase64((byte[])keyModulus.getBytes());
            byte[] btExp = Base64.decodeBase64((byte[])keyExponent.getBytes());
            BigInteger modulus = new BigInteger(1, btMod);
            BigInteger pubExp = new BigInteger(1, btExp);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(modulus, pubExp);
            RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(pubKeySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, key);
            byte[] cipherData = cipher.doFinal(data.getBytes());
            String tmp = new String(Base64.encodeBase64((byte[])cipherData));
            return tmp;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public String getAES() {
        return this.aesKey;
    }

    public void setAES(String aesKey) {
        this.aesKey = aesKey;
    }
}

