/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.utils.PeerNative;
import com.ifractal.utils.TunnelListener;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Verbosity;

public class TunnelNative<T>
extends TunnelServer<T> {
    protected long serverPtr = 0L;

    public static native long server_newC(String var0);

    public static native int server_openC(long var0, int var2);

    public static native long server_acceptC(long var0);

    public static native String peer_getIPC(long var0);

    public static native void peer_close(long var0);

    public static native String[] server_next_messageC(long var0, long[] var2);

    public static native int peer_send_messageC(long var0, String[] var2);

    public static native void server_closeC(long var0);

    public static native void server_freeC(long var0);

    public static native String[] sendRecv(String var0, String var1, String[] var2);

    public TunnelNative(String[] args, T ctx, TunnelListener<T> tsl) {
        super(ctx, tsl);
        try {
            System.loadLibrary("ifdevice4j");
        }
        catch (UnsatisfiedLinkError ule) {
            Verbosity.println(ule.getMessage());
            System.exit(2);
        }
    }

    @Override
    public boolean open(int port) {
        this.serverPtr = TunnelNative.server_newC(null);
        int r = TunnelNative.server_openC(this.serverPtr, port);
        if (r < 1) {
            TunnelNative.server_freeC(this.serverPtr);
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        TunnelNative.server_closeC(this.serverPtr);
        TunnelNative.server_freeC(this.serverPtr);
    }

    @Override
    public void run() {
        this.alive = true;
        do {
            long[] msg_peer;
            String[] pack;
            PeerNative<Object> pn = null;
            long peer = TunnelNative.server_acceptC(this.serverPtr);
            if (peer != 0L) {
                pn = new PeerNative<Object>(this.context, this, this.listener, peer);
                Object id = this.listener.onAccept(this.context, pn);
                pn.resetContext(id);
                this.addPeer(pn);
            }
            if ((pack = TunnelNative.server_next_messageC(this.serverPtr, msg_peer = new long[1])) == null) {
                pn = this.getPeer(msg_peer[0]);
                if (pn != null) {
                    this.peers.remove(pn);
                    this.listener.onClose(pn.context, pn);
                    continue;
                }
                this.alive = this.listener.idle(this.context);
                continue;
            }
            pn = this.getPeer(msg_peer[0]);
            if (pn != null) {
                this.listener.onMessage(this.context, this, pn, pack);
                continue;
            }
            this.sendMessage(3, "timeout nao sincronizado.");
        } while (this.alive);
    }

    protected PeerNative<T> getPeer(long ptr) {
        for (TunnelPeer p : this.peers) {
            PeerNative pn = (PeerNative)p;
            if (pn.peerPtr != ptr) continue;
            p.refresh();
            return pn;
        }
        return null;
    }
}

