/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.DeviceListener;
import com.ifractal.ifponto.Engine;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.IfpontoDB;
import com.ifractal.ifponto.SIIN;
import com.ifractal.ifponto.SIINListener;
import com.ifractal.ifponto.ServerListener;
import com.ifractal.ifponto.VirtualEngine;
import com.ifractal.utils.ConcurrentListener;
import com.ifractal.utils.Peer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Tunnel;
import com.ifractal.utils.TunnelListener;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SIINServer
extends Producer
implements Runnable,
DeviceListener,
SIINListener,
TunnelListener<String>,
ConcurrentListener<TunnelPeer<String>> {
    public static final int LOCAL_PORT = 7000;
    public static SIINServer server = null;
    public static String tunnelHost = "74.50.60.155";
    public static int tunnelPort = 10999;
    public static int localPort = 7000;
    protected static IfpontoDB idb = null;
    protected static SIIN siin = null;
    protected static VirtualEngine engine;
    protected static TunnelServer<String> tunnel;
    protected static ServerListener serverListener;
    public static int verbosity;
    protected String siin_key = null;
    protected boolean tunnel_alive = false;
    protected static boolean alive;

    public static SIINServer getInstance(long[] ctx, String[] args) {
        if (server != null) {
            return server;
        }
        server = new SIINServer(ctx, args);
        return server;
    }

    private SIINServer(long[] ctx, String[] args) {
        super(ctx, args);
    }

    public void init(String[] args, TunnelServer<String> t, VirtualEngine e, SIIN s, ServerListener sl) {
        serverListener = sl;
        tunnel = t;
        engine = e;
        siin = s;
        if (args == null) {
            return;
        }
        if (Util.getValueFromArgs(args, "VERBOSITY") != null) {
            verbosity = Util.getIntFromArgs(args, "VERBOSITY");
        }
        if (Util.getValueFromArgs(args, "tunnel_host") != null) {
            tunnelHost = Util.getValueFromArgs(args, "tunnel_host");
        }
        if (Util.getIntFromArgs(args, "tunnel_port") != 0) {
            tunnelPort = Util.getIntFromArgs(args, "tunnel_port");
        }
        if (Util.getIntFromArgs(args, "local_port") != 0) {
            localPort = Util.getIntFromArgs(args, "local_port");
        }
    }

    @Override
    public void onMessage(Producer prod, int vl, String msg, int code) {
        if (vl > verbosity) {
            return;
        }
        String klass = prod.getClass().getName();
        String level = Verbosity.getLevel(vl);
        String[] pack = new String[]{"broadcast", "onMessage", "class", klass, "verbosity", level, "message", msg, "code", "" + code};
        String txt = klass + "|" + level + "|" + code + "| " + msg;
        this.broadcast(pack);
        if (this.native_context != null) {
            this.messageC(this.native_context, pack, null);
        } else {
            System.err.println("(stderr) " + txt);
        }
    }

    @Override
    public void onMessage(Producer prod, int verbosityLevel, String msg) {
        this.onMessage(prod, verbosityLevel, msg, 0);
    }

    protected JSONObject cleanJSONDevice(JSONObject jdev) {
        HashMap<String, String> pars = IFPONTO_config.getParams();
        JSONObject j = (JSONObject)jdev.clone();
        for (String key : pars.keySet()) {
            j.remove((Object)key);
        }
        j.remove((Object)"status");
        return j;
    }

    @Override
    public void onStart(JSONObject jdev) {
        JSONObject dev = this.cleanJSONDevice(jdev);
        this.broadcast(new String[]{"broadcast", "onStart", "device", dev.toString()});
    }

    @Override
    public void onStop(JSONObject jdev) {
        JSONObject dev = this.cleanJSONDevice(jdev);
        this.broadcast(new String[]{"broadcast", "onStop", "device", dev.toString()});
    }

    @Override
    public void onGetTime(JSONObject jdev, Date date) {
        JSONObject dev = this.cleanJSONDevice(jdev);
        if (date == null) {
            return;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dt = fmt.format(date);
        String[] msg = new String[]{"broadcast", "onGetTime", "device", dev.toString(), "date", dt};
        this.broadcast(msg);
    }

    @Override
    public void onSetTime(JSONObject jdev, int timediff) {
        JSONObject dev = this.cleanJSONDevice(jdev);
        String[] msg = new String[]{"broadcast", "onSetTime", "device", dev.toString(), "timediff", timediff + ""};
        this.broadcast(msg);
    }

    @Override
    public void onSendUser(JSONObject jdev, JSONObject juser, JSONObject jres, int pos, int total) {
        JSONObject dev = this.cleanJSONDevice(jdev);
        String user = null;
        String res = null;
        if (juser != null) {
            user = juser.toString();
        }
        if (jres != null) {
            res = jres.toString();
        }
        String[] msg = new String[]{"broadcast", "onSendUser", "device", dev.toString(), "user", user, "result", res, "pos", pos + "", "total", total + ""};
        this.broadcast(msg);
    }

    @Override
    public void onGetBio(JSONObject jdev, JSONObject juserBios, int pos, int total) {
        JSONObject dev = this.cleanJSONDevice(jdev);
        String userBios = null;
        if (juserBios != null) {
            userBios = juserBios.toString();
        }
        String[] msg = new String[]{"broadcast", "onGetBio", "device", dev.toString(), "userBios", userBios, "pos", pos + "", "total", total + ""};
        this.broadcast(msg);
    }

    @Override
    public void onEvents(JSONObject jdev, JSONArray offs) {
        JSONObject dev = this.cleanJSONDevice(jdev);
        if (offs == null) {
            return;
        }
        String[] msg = new String[]{"broadcast", "onEvents", "device", dev.toString(), "offs", offs.toString()};
        this.broadcast(msg);
    }

    @Override
    public void onFinalize(JSONObject jdev, boolean online, JSONArray jusers, JSONArray jres) {
        JSONObject dev = this.cleanJSONDevice(jdev);
        String users = null;
        String res = null;
        if (jusers != null) {
            users = jusers.toString();
        }
        if (jres != null) {
            res = jres.toString();
        }
        String[] msg = new String[]{"broadcast", "onFinalize", "device", dev.toString(), "online", online + "", "users", users, "result", res};
        this.broadcast(msg);
    }

    @Override
    public void onStart() {
        this.broadcast(new String[]{"broadcast", "onStart"});
    }

    @Override
    public void onStop() {
        engine.stopAllDevices();
        this.broadcast(new String[]{"broadcast", "onStop"});
    }

    @Override
    public void onSynchronized() {
        this.broadcast(new String[]{"broadcast", "onSynchronized"});
    }

    @Override
    public void onProgress(int progressTotal, int progressPos, String notify) {
        this.broadcast(new String[]{"broadcast", "onProgress", "progressTotal", Integer.toString(progressTotal), "progressPos", Integer.toString(progressPos), "notify", notify});
    }

    @Override
    public void onFail(String msg) {
        this.broadcast(new String[]{"broadcast", "onFail", "message", msg});
    }

    @Override
    public void onEnable(String key) {
        this.siin_key = key;
        this.broadcast(new String[]{"broadcast", "onEnable", "key", key});
    }

    @Override
    public void onIdle() {
        JSONArray devs = engine.getDBDevices();
        if (devs == null) {
            return;
        }
        int n = engine.initDevices(devs);
        if (n == 0) {
            this.sendMessage(4, "Nenhum equipamento vinculado a este dispositivo.");
        } else if (n > 0 && Producer.androidContext == null) {
            this.sendMessage(5, "Start all devices.");
            engine.startAllDevices(this, this);
        }
    }

    @Override
    public void onBroadcast(String ctx, TunnelPeer<String> from, TunnelPeer<String> to, String[] pack) {
        to.send(pack);
    }

    @Override
    public void onConnect(String ctx, TunnelPeer<String> peer) {
        this.tunnel_alive = true;
        serverListener.onTunnelConnect();
        JSONObject jid = SIIN.getInfo("SIIN", IfpontoDB.config, Producer.androidContext);
        JSONObject jinfo = (JSONObject)jid.get((Object)"info");
        jinfo.put((Object)"port", (Object)localPort);
        peer.sendInfo(jid);
    }

    @Override
    public String onAccept(String ctx, TunnelPeer<String> peer) {
        String id = System.currentTimeMillis() + "  -  " + peer.getIP();
        return id;
    }

    @Override
    public void onClose(String ctx, TunnelPeer<String> peer) {
        this.tunnel_alive = false;
        serverListener.onTunnelClose();
    }

    @Override
    public void onMessage(String ctx, TunnelServer<String> ts, TunnelPeer<String> peer, String[] msg) {
        String[] lmeths;
        String[] smeths;
        String[] emeths;
        String info = Util.getValueFromArgs(msg, "match");
        if (info != null) {
            if (info.equals("")) {
                this.sendMessage(6, "No Observers...");
            } else {
                this.sendMessage(4, "Observer connected...");
                this.sendMessage(5, "Observer: " + info.toString());
            }
            return;
        }
        String method = Util.getValueFromArgs(msg, "method");
        if (method == null) {
            if (msg.length < 2) {
                return;
            }
            this.sendMessage(3, "Solicitacao invalida - length: " + msg.length);
            for (String e : msg) {
                this.sendMessage(3, e);
            }
            return;
        }
        for (String m : emeths = new String[]{"stopDevice", "getDBUsers", "getDBDevices", "getDeviceUsers"}) {
            if (!m.equals(method)) continue;
            engine.call(peer, this, msg);
            return;
        }
        for (String m : smeths = new String[]{"startSIINLoop", "stopSIINLoop"}) {
            if (!m.equals(method)) continue;
            siin.call(peer, this, msg);
            return;
        }
        for (String m : lmeths = new String[]{"setVerbosity", "startDevice"}) {
            if (!m.equals(method)) continue;
            this.concurrentCall(peer, this, msg);
            return;
        }
    }

    @Override
    public void onData(TunnelPeer<String> peer, Producer prod, String[] in, String data) {
        if (data == null || peer == null) {
            return;
        }
        String[] msg = in;
        msg = Util.setValueInArgs(msg, "onResponse", data);
        peer.send(msg);
    }

    @Override
    public void onData(TunnelPeer<String> peer, Producer prod, String[] in, byte[] data) {
        if (data == null) {
            return;
        }
    }

    @Override
    public void onFail(TunnelPeer<String> peer, Producer prod, String[] in) {
        String meth = Util.getValueFromArgs(in, "method");
        if (meth == null) {
            prod.sendMessage(5, "Falha execucao: solicitacao invalida.");
        } else {
            prod.sendMessage(5, "Falha execucao: " + meth);
        }
    }

    @Override
    public void run() {
        boolean opened;
        Socket sock = null;
        int port = localPort;
        while (!(opened = tunnel.open(port))) {
            serverListener.onServerFail("Falha - Porta: " + port);
            ++port;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                break;
            }
            if (!opened && port < 65535) continue;
        }
        if (!opened) {
            return;
        }
        localPort = port;
        serverListener.onServerOpen(port);
        tunnel.start();
        alive = true;
        block5: do {
            System.err.println("-");
            System.err.println("-");
            System.err.println("-");
            System.err.println("SIIINServer connect tunnel");
            System.err.println("-");
            System.err.println("-");
            System.err.println("-");
            sock = Peer.connect("tunnel", this, tunnelHost, tunnelPort);
            if (sock == null) {
                serverListener.onTunnelFail("Falha - " + tunnelHost + ":" + tunnelPort);
            }
            int timeout = 300;
            long start = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    this.sendMessage(3, ie.getMessage());
                    continue block5;
                }
            } while ((System.currentTimeMillis() - start) / 1000L <= (long)timeout && this.tunnel_alive && alive);
        } while (alive);
        tunnel.stop();
    }

    public void startDevice(int codigo, int startNsr) {
        engine.startDevice(codigo, this, this, startNsr);
    }

    public String setVerbosity(int level) {
        verbosity = level;
        return Verbosity.getLevel(level);
    }

    protected int broadcast(String[] msg) {
        if (tunnel == null) {
            return -1;
        }
        int n = tunnel.broadcast(msg);
        return n;
    }

    public static final Object start(long[] ctx, String[] args) {
        ServerListener sl = new ServerListener(){};
        SIINServer serv = SIINServer.start(ctx, null, sl, args);
        siin.startSIINLoop();
        return serv;
    }

    public static final SIINServer start(long[] ctx, Object androidCtx, ServerListener sl, String[] args) {
        try {
            String lib = Util.getValueFromArgs(args, "library");
            if (lib != null) {
                System.loadLibrary(lib);
                Device.initC(null);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            Verbosity.println(ule.getMessage());
        }
        JSONArray jmodels = Device.getModels(args);
        Verbosity.println(jmodels.toString());
        SIINServer.getInstance(ctx, args);
        server.setAndroidContext(androidCtx);
        idb = new IfpontoDB(args, server);
        idb.setAndroidContext(androidCtx);
        idb.init(args, server);
        idb.open(androidCtx, server);
        engine = Engine.getInstance(args, idb, server);
        siin = SIIN.getInstance(args, idb, server);
        siin.setAndroidContext(androidCtx);
        Tunnel<String> tn = new Tunnel<String>("LocalServer", server);
        server.init(args, tn, engine, siin, sl);
        Thread th = new Thread(server);
        th.start();
        return server;
    }

    public static final void stop() {
        alive = false;
    }

    public static final void main(String[] args) throws InterruptedException {
        SIINServer.start(null, args);
        while (true) {
            Thread.sleep(1000L);
        }
    }

    static {
        verbosity = 4;
        alive = false;
    }
}

