/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.utils.Producer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DB {
    public static synchronized boolean executeUpdate(Producer prod, PreparedStatement pstmt, String[] fields) throws SQLException {
        int updates;
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                pstmt.setString(i + 1, fields[i]);
            }
        }
        return (updates = pstmt.executeUpdate()) >= 1;
    }

    private static HashMap<String, String> resultset2Hash(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        if (cols < 2) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            map.put(rs.getString(1), rs.getString(2));
        }
        return map;
    }

    public static synchronized HashMap<String, String> getHash(Producer prod, PreparedStatement ps, String[] fields) {
        try {
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    ps.setString(i + 1, fields[i]);
                }
            }
            ResultSet rs = ps.executeQuery();
            HashMap<String, String> map = DB.resultset2Hash(rs);
            rs.close();
            return map;
        }
        catch (SQLException sqle) {
            prod.sendMessage(2, sqle.getMessage());
            return null;
        }
    }

    private static JSONArray resultset2json(ResultSet rs) throws SQLException {
        JSONArray res = new JSONArray();
        ResultSetMetaData meta = rs.getMetaData();
        if (meta == null) {
            return res;
        }
        int cols = meta.getColumnCount();
        while (rs.next()) {
            JSONObject e = new JSONObject();
            res.add((Object)e);
            for (int j = 1; j <= cols; ++j) {
                String col = meta.getColumnName(j);
                e.put((Object)col, (Object)rs.getString(j));
            }
        }
        return res;
    }

    public static synchronized JSONArray executeQuery(Producer prod, PreparedStatement pstmt, String[] fields) {
        JSONArray res = null;
        try {
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    pstmt.setString(i + 1, fields[i]);
                }
            }
            ResultSet rs = pstmt.executeQuery();
            res = DB.resultset2json(rs);
            rs.close();
        }
        catch (SQLException sqle) {
            prod.sendMessage(2, pstmt.toString() + "\n" + sqle.getMessage());
            return null;
        }
        return res;
    }
}

