/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.ifponto.IfpontoDB;
import com.ifractal.ifponto.Version;
import com.ifractal.utils.ConnectDB;
import com.ifractal.utils.ConsumerDB;
import com.ifractal.utils.DB;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.SessionDB;
import com.ifractal.utils.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ConnectJDBC
extends Producer
implements ConnectDB {
    public static final int SQLITE_CONSTRAINT = 19;
    protected final ConsumerDB consumer;
    protected final String dbname;
    protected final int version;

    public ConnectJDBC(String db, int ver, ConsumerDB cons, Observer obs) {
        super(obs);
        this.dbname = db;
        this.version = ver;
        this.consumer = cons;
        this.init();
    }

    public int getVersion() {
        String content = Util.getContent("version.txt");
        if (content == null) {
            return 0;
        }
        int ver = 0;
        try {
            ver = Integer.parseInt(content.trim());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        return ver;
    }

    public void saveVersion() throws IOException {
        FileWriter fw = new FileWriter("version.txt");
        fw.write(Version.getRevision() + "\n");
        fw.close();
    }

    private int applyChanges(Statement stmt, String[] changes) {
        int n = 0;
        for (String ch : changes) {
            try {
                stmt.executeUpdate(ch);
                ++n;
            }
            catch (SQLException e) {
                this.sendMessage(1, e.getMessage());
            }
        }
        return n;
    }

    public boolean init() {
        int last = this.getVersion();
        String sql = null;
        String[] changes = null;
        if (!this.dbname.startsWith("jdbc:sqlite:")) {
            return true;
        }
        String[] file = this.dbname.split(":");
        File f = new File(file[2]);
        if (f.exists()) {
            if (last == 0) {
                this.sendMessage(3, "Vers\u00e3o n\u00e3o encontrada.");
                return true;
            }
            if (this.version == last) {
                this.sendMessage(4, "Sem novas atualiza\u00e7\u00f5es.");
                return true;
            }
            changes = this.consumer.getSQLChangeSchema(last);
        } else {
            sql = this.consumer.getSQLSchema();
            changes = this.consumer.getSQLChangeSchema(0);
        }
        if (sql == null && changes == null) {
            this.sendMessage(3, "Sem atualiza\u00e7\u00f5es.");
            return true;
        }
        try {
            Connection conn = DriverManager.getConnection(this.dbname);
            Statement stmt = conn.createStatement();
            if (sql != null) {
                stmt.executeUpdate(sql);
            }
            if (changes != null) {
                this.applyChanges(stmt, changes);
            }
            stmt.close();
            conn.close();
            this.saveVersion();
        }
        catch (SQLException se) {
            this.sendMessage(1, se.getMessage());
            return false;
        }
        catch (IOException ioe) {
            this.sendMessage(1, ioe.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public SessionDB getNewSession(ConsumerDB consumer, Observer obs) {
        SessionJDBC sess = new SessionJDBC(consumer, this, obs);
        return sess;
    }

    public static final void main(String[] args) {
        final Observer obs = new Observer(){

            @Override
            public void onMessage(Producer prod, int level, String msg, int code) {
                System.out.println(msg);
            }

            @Override
            public void onMessage(Producer prod, int level, String msg) {
                this.onMessage(prod, level, msg, 0);
            }
        };
        final IfpontoDB idb = new IfpontoDB(null, obs);
        String dbfile = "./conf/ifponto.db";
        if (!args[0].equals("-")) {
            dbfile = args[0];
        }
        idb.init(new String[]{"DB", dbfile}, null);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (!idb.open(obs)) {
                    System.err.println("Falha ao tentar inicializar banco de dados.");
                    return;
                }
                JSONArray off = idb.getNotSyncEvents(2, 1);
                idb.updateOffs("2", off);
                System.err.println(Thread.currentThread());
            }
        };
        for (int i = 0; i < Integer.parseInt(args[1]); ++i) {
            Thread th = new Thread(run);
            th.start();
        }
    }

    private class SessionJDBC
    extends SessionDB {
        ConsumerDB cons;
        Connection conn;
        String[] stmtkeys;
        PreparedStatement[] pstmts;

        public SessionJDBC(ConsumerDB consumer, ConnectJDBC c, Observer obs) {
            super(obs);
            this.cons = null;
            this.conn = null;
            this.stmtkeys = null;
            this.pstmts = null;
            this.cons = consumer;
        }

        @Override
        public boolean open() {
            if (this.pstmts != null) {
                return true;
            }
            try {
                this.conn = DriverManager.getConnection(ConnectJDBC.this.dbname);
                String[] stmts = this.cons.getStatements();
                if (stmts == null) {
                    return true;
                }
                this.pstmts = new PreparedStatement[stmts.length / 2];
                this.stmtkeys = new String[this.pstmts.length];
                int i = 0;
                int k = 0;
                while (i + 1 < stmts.length) {
                    this.stmtkeys[k] = stmts[i + 0];
                    this.pstmts[k] = this.conn.prepareStatement(stmts[i + 1]);
                    i += 2;
                    ++k;
                }
            }
            catch (SQLException se) {
                this.sendMessage(1, se.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public void close() {
            try {
                if (this.conn == null) {
                    return;
                }
                if (this.pstmts != null) {
                    for (PreparedStatement ps : this.pstmts) {
                        ps.close();
                    }
                }
                this.conn.close();
                this.pstmts = null;
            }
            catch (SQLException se) {
                this.sendMessage(1, se.getMessage());
            }
        }

        @Override
        public synchronized JSONArray execute(String stmtKey, String[] fields, String iStmtKey, String[] iFields) {
            int error = 0;
            JSONArray res = new JSONArray();
            JSONObject ret2 = new JSONObject();
            if (!this.open()) {
                return res;
            }
            if (stmtKey.startsWith("Select")) {
                res = this.executeQuery(stmtKey, fields);
                this.close();
                return res;
            }
            if (iStmtKey != null && iFields != null) {
                error = this.executeUpsert(stmtKey, iStmtKey, fields, iFields);
            } else if (stmtKey.startsWith("Update") || stmtKey.startsWith("Insert") || stmtKey.startsWith("Delete")) {
                error = this.executeUpdate(stmtKey, fields);
            }
            ret2.put((Object)"error", (Object)error);
            res.add((Object)ret2);
            this.close();
            return res;
        }

        @Override
        public int executeUpsert(String uStmtKey, String iStmtKey, String[] uFields, String[] iFields) {
            boolean update = false;
            PreparedStatement uPs = this.getStatement(uStmtKey);
            if (uPs == null) {
                return -1;
            }
            try {
                update = DB.executeUpdate(this, uPs, uFields);
                if (update) {
                    return 0;
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 19) {
                    return 0;
                }
                this.sendMessage(5, e.getMessage());
                String msg = uStmtKey + "\n";
                for (String s : uFields) {
                    msg = msg + s + "|";
                }
                this.sendMessage(5, msg);
            }
            return this.executeUpdate(iStmtKey, iFields);
        }

        @Override
        public int executeUpdate(String stmtKey, String[] fields) {
            PreparedStatement ps = this.getStatement(stmtKey);
            if (ps == null) {
                return -1;
            }
            try {
                boolean ret2 = DB.executeUpdate(this, ps, fields);
                if (ret2) {
                    return 0;
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 19) {
                    this.sendMessage(5, e.getMessage());
                    return 0;
                }
                this.sendMessage(2, stmtKey + "\n" + e.getMessage());
                String msg = stmtKey + "\n";
                if (fields != null) {
                    for (String s : fields) {
                        msg = msg + s + "|";
                    }
                }
                this.sendMessage(2, msg);
                return e.getErrorCode();
            }
            return -1;
        }

        @Override
        public JSONArray executeQuery(String stmtKey, String[] fields) {
            PreparedStatement ps = this.getStatement(stmtKey);
            if (ps == null) {
                return null;
            }
            JSONArray res = DB.executeQuery(this, ps, fields);
            return res;
        }

        @Override
        public synchronized HashMap<String, String> getHash(String stmtKey, String[] fields) {
            if (!this.open()) {
                return null;
            }
            PreparedStatement ps = this.getStatement(stmtKey);
            if (ps == null) {
                return null;
            }
            HashMap<String, String> map = DB.getHash(this, ps, fields);
            this.close();
            return map;
        }

        private PreparedStatement getStatement(String key) {
            for (int i = 0; i < this.stmtkeys.length; ++i) {
                if (!this.stmtkeys[i].equals(key)) continue;
                return this.pstmts[i];
            }
            return null;
        }
    }
}

