/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.ControlID;
import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.IfpontoDBAcesso;
import com.ifractal.utils.HttpServer;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Util;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class IDAccess
extends ControlID {
    protected final String SET_SYSTEM_TIME = "set_system_time";
    protected final String SYSTEM_INFORMATION = "system_information";
    protected final String LOAD_OBJECTS = "load_objects";
    protected final String SET_CONFIGURATION = "set_configuration";
    protected final String CREATE_OBJECTS = "create_objects";
    protected final String MODIFY_OBJECTS = "modify_objects";
    protected final String DESTROY_OBJECTS = "destroy_objects";
    protected final String USER_SET_IMAGE_LIST = "user_set_image_list";
    protected static final String[] EVENT = new String[]{"---", "Equipamento inv\u00e1lido", "Par\u00e2metros de regra de identifica\u00e7\u00e3o inv\u00e1lidos", "N\u00e3o identificado", "Identifica\u00e7\u00e3o pendente", "Timeout na identifica\u00e7\u00e3o", "Acesso negado", "Acesso autorizado", "Acesso pendente", "Usu\u00e1rio n\u00e3o \u00e9 administrador", "Acesso n\u00e3o identificado", "Acesso atrav\u00e9s de botoeira", "Acesso atrav\u00e9s da interface WEB", "Desist\u00eancia de entrada"};
    protected long ten_minutes = 600L;
    protected long timediff = 0L;
    protected JSONObject jresponse = null;

    public IDAccess(JSONObject config) {
        super(config);
    }

    public IDAccess(IfpontoDBAcesso db, JSONObject config) {
        super(db, config);
    }

    protected JSONObject exec(String action, JSONObject jdata) {
        Thread th;
        int modo = 0;
        if (this.config.containsKey((Object)"MODO")) {
            modo = Integer.parseInt(this.config.get((Object)"MODO").toString());
        }
        if ((th = HttpServer.initServer(this.config)) == null || modo > 0) {
            JSONArray res = this.exec(action + ".fcgi", jdata.toString());
            if (res == null || res.size() < 1) {
                return null;
            }
            return (JSONObject)res.get(0);
        }
        this.jresponse = null;
        HttpServer.addDevice(this);
        this.addCmd(action, jdata);
        int r = this.waitData();
        if (r < 0) {
            HttpServer.removeDevice(this);
            return null;
        }
        return this.jresponse;
    }

    @Override
    public byte[] handler(String[] headers, String type, String path, String[] GET, String data) {
        byte[] r = this.handler(headers, type, path, GET, new JSONObject());
        return r;
    }

    @Override
    public byte[] handler(String[] headers, String type, String path, String[] GET, JSONObject jdata) {
        if (jdata == null) {
            return this.makeResponse(null);
        }
        String content = "";
        String endpoint = Util.getValueFromArgs(GET, "endpoint");
        byte[] out = null;
        if (type.equals("POST") && jdata != null) {
            if (!jdata.containsKey((Object)"response")) {
                return this.makeResponse(null);
            }
            String resp = jdata.get((Object)"response").toString();
            this.sendMessage(5, "==>" + resp + "<==");
        }
        if (endpoint == null) {
            if (this.cmdQueue.isEmpty()) {
                out = this.makeResponse("");
            } else {
                content = (String)this.cmdQueue.remove();
                out = this.makeResponse(content);
            }
        } else {
            if (!jdata.containsKey((Object)"response")) {
                this.jresponse = jdata;
            } else {
                try {
                    JSONParser parser = new JSONParser();
                    String aux = jdata.get((Object)"response").toString();
                    this.jresponse = (JSONObject)parser.parse(aux);
                }
                catch (ParseException pe) {
                    this.jresponse = jdata;
                }
            }
            if (endpoint.equals("system_information")) {
                jdata.put((Object)"deviceId", (Object)Util.getValueFromArgs(GET, "deviceId"));
            }
            if (this.confirmList.size() > 0) {
                this.confirmList.remove(0);
            }
        }
        this.last = new Date().getTime();
        return out;
    }

    @Override
    public boolean checkDevice(String ip, String[] dataIn) {
        return this.checkDevice(ip, dataIn, "deviceId");
    }

    protected int deleteObjects(String obj, String key, long id) {
        JSONObject main = new JSONObject();
        JSONObject where = new JSONObject();
        JSONObject objs = new JSONObject();
        main.put((Object)"object", (Object)obj);
        main.put((Object)"where", (Object)where);
        where.put((Object)obj, (Object)objs);
        objs.put((Object)key, (Object)id);
        JSONObject exec_res = this.exec("destroy_objects", main);
        if (exec_res == null) {
            return IFPONTO_config.valueOf((String)"ERRO_DELETE").codigo;
        }
        return 0;
    }

    protected int insertTemplates(JSONObject juser, final int id) {
        JSONObject res;
        if (!juser.containsKey((Object)"templates") || !(juser.get((Object)"templates") instanceof JSONArray)) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jtemp, Object[] pars, int[] q) {
                int user_id = (Integer)pars[0];
                JSONArray valuesBio = (JSONArray)pars[1];
                JSONArray valuesFace = (JSONArray)pars[2];
                for (String k : new String[]{"vendor", "template"}) {
                    if (jtemp.containsKey((Object)k)) continue;
                    return 0;
                }
                String vendor = jtemp.get((Object)"vendor").toString();
                String template = jtemp.get((Object)"template").toString();
                if (template.equals("")) {
                    return 0;
                }
                JSONObject reg = new JSONObject();
                reg.put((Object)"user_id", (Object)user_id);
                if (vendor.equals("idclass") || vendor.equals("idbio")) {
                    reg.put((Object)"id", (Object)((id + 100000) * 100 + q[0]));
                    reg.put((Object)"finger_type", (Object)0);
                    reg.put((Object)"template", jtemp.get((Object)"template"));
                    valuesBio.add((Object)reg);
                    q[0] = q[0] + 1;
                }
                if (vendor.equals("jpg")) {
                    if ((template = Device.resizePhotoTemplate(template)) == null) {
                        return 0;
                    }
                    reg.put((Object)"timestamp", (Object)(System.currentTimeMillis() / 1000L));
                    reg.put((Object)"image", (Object)template);
                    valuesFace.add((Object)reg);
                    q[0] = q[0] + 1;
                }
                return 0;
            }
        };
        boolean ok = false;
        JSONObject mainBio = new JSONObject();
        JSONObject mainFace = new JSONObject();
        JSONArray valuesBio = new JSONArray();
        JSONArray valuesFace = new JSONArray();
        mainBio.put((Object)"object", (Object)"templates");
        mainBio.put((Object)"values", (Object)valuesBio);
        mainFace.put((Object)"match", (Object)true);
        mainFace.put((Object)"user_images", (Object)valuesFace);
        int[] q = new int[]{0};
        Object[] pars = new Object[]{id, valuesBio, valuesFace};
        Util.jsonIter((JSONArray)juser.get((Object)"templates"), iter2, pars, q);
        if (q[0] <= 0) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        if (valuesBio.size() > 0) {
            res = this.exec("create_objects", mainBio);
            if (res == null && valuesFace.size() < 1) {
                return IFPONTO_config.valueOf((String)"ERRO_INSERT_BIO").codigo;
            }
            if (res != null) {
                ok = true;
            }
        }
        if (valuesFace.size() > 0 && this.modelo.equalsIgnoreCase("idface")) {
            JSONArray results;
            JSONObject result;
            res = this.exec("user_set_image_list", mainFace);
            if (res == null) {
                return IFPONTO_config.valueOf((String)"ERRO_INSERT_FACE").codigo;
            }
            JSONObject ret2 = res;
            if (ret2.containsKey((Object)"results") && (result = (JSONObject)(results = (JSONArray)ret2.get((Object)"results")).get(0)).containsKey((Object)"success") && !((Boolean)result.get((Object)"success")).booleanValue()) {
                return IFPONTO_config.valueOf((String)"ERRO_INSERT_FACE").codigo;
            }
            ok = true;
        }
        if (ok) {
            return 0;
        }
        return IFPONTO_config.valueOf((String)"ERRO_INSERT_BIO").codigo;
    }

    protected int insertCards(JSONObject juser, int id) {
        IfaceJSONIter card_iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jcard, Object[] pars, int[] q) {
                int user_id = (Integer)pars[0];
                JSONArray values = (JSONArray)pars[1];
                JSONObject reg = new JSONObject();
                try {
                    String val = jcard.get((Object)"nro").toString();
                    long value = ControlID.convertRFID_nominal2code(val);
                    reg.put((Object)"user_id", (Object)user_id);
                    reg.put((Object)"id", (Object)value);
                    reg.put((Object)"value", (Object)value);
                    values.add((Object)reg);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return 0;
            }
        };
        JSONObject main = new JSONObject();
        JSONArray values = new JSONArray();
        main.put((Object)"object", (Object)"cards");
        main.put((Object)"values", (Object)values);
        Object[] pars = new Object[]{id, values};
        Util.jsonIter((JSONArray)juser.get((Object)"nro_cartao"), card_iter2, pars, null);
        if (values.size() < 1) {
            return 0;
        }
        JSONObject res = this.exec("create_objects", main);
        if (res == null) {
            return IFPONTO_config.valueOf((String)"ERRO_INSERT_CRACHA").codigo;
        }
        return 0;
    }

    protected int bindTimeSpan(int id) {
        JSONObject main = new JSONObject();
        main.put((Object)"object", (Object)"user_access_rules");
        JSONArray values = new JSONArray();
        main.put((Object)"values", (Object)values);
        JSONObject reg = new JSONObject();
        reg.put((Object)"user_id", (Object)id);
        reg.put((Object)"access_rule_id", (Object)1);
        values.add((Object)reg);
        JSONObject res = this.exec("create_objects", main);
        if (res == null) {
            return IFPONTO_config.valueOf((String)"ERRO_INSERT_REGRAS_ACESSO").codigo;
        }
        return 0;
    }

    protected int insertCPF(JSONObject juser, int id, String cpf) {
        JSONObject main = new JSONObject();
        main.put((Object)"object", (Object)"c_users");
        JSONArray values = new JSONArray();
        main.put((Object)"values", (Object)values);
        JSONObject reg = new JSONObject();
        reg.put((Object)"user_id", (Object)id);
        reg.put((Object)"cpf", (Object)cpf);
        values.add((Object)reg);
        JSONObject res = this.exec("create_objects", main);
        if (res == null) {
            return IFPONTO_config.valueOf((String)"ERRO_INSERT_USER").codigo;
        }
        return 0;
    }

    protected int insert(JSONObject juser, int id) {
        String cpf = null;
        if (juser.containsKey((Object)"cpf")) {
            cpf = juser.get((Object)"cpf").toString();
            this.deleteUser((Object)null, juser);
        }
        JSONObject main = new JSONObject();
        main.put((Object)"object", (Object)"users");
        JSONArray values = new JSONArray();
        main.put((Object)"values", (Object)values);
        JSONObject reg = new JSONObject();
        reg.put((Object)"id", (Object)id);
        reg.put((Object)"registration", (Object)("" + id));
        reg.put((Object)"password", (Object)"");
        reg.put((Object)"salt", (Object)"");
        reg.put((Object)"name", juser.get((Object)"nome"));
        values.add((Object)reg);
        JSONObject res = this.exec("create_objects", main);
        if (res == null) {
            return IFPONTO_config.valueOf((String)"ERRO_INSERT_USER").codigo;
        }
        if (cpf != null && !cpf.equals("")) {
            this.insertCPF(juser, id, cpf);
        }
        int r = this.insertCards(juser, id);
        this.bindTimeSpan(id);
        return r;
    }

    protected int update(JSONObject juser, int id) {
        JSONObject main = new JSONObject();
        JSONObject values = new JSONObject();
        JSONObject where = new JSONObject();
        JSONObject users = new JSONObject();
        main.put((Object)"object", (Object)"users");
        main.put((Object)"values", (Object)values);
        main.put((Object)"where", (Object)where);
        where.put((Object)"users", (Object)users);
        values.put((Object)"name", juser.get((Object)"nome"));
        values.put((Object)"registration", (Object)("" + id));
        users.put((Object)"id", (Object)id);
        this.exec("modify_objects", main);
        this.deleteObjects("cards", "user_id", id);
        int r = this.insertCards(juser, id);
        return r;
    }

    public JSONArray getUsers(Object user_data) {
        Object[] ctx = (Object[])user_data;
        long now = new Date().getTime() / 1000L;
        long last = (Long)ctx[1];
        JSONArray users = (JSONArray)ctx[2];
        if (users == null || now - last > this.ten_minutes) {
            users = this.getUsers();
        }
        ctx[1] = now;
        ctx[2] = users;
        return users;
    }

    @Override
    public int updateUser(Object ctx, JSONObject juser) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject reg, Object[] pars, int[] q) {
                int codigo = (Integer)pars[0];
                boolean[] exist = (boolean[])pars[1];
                if (!reg.containsKey((Object)"id")) {
                    return 0;
                }
                try {
                    int id = Integer.parseInt(reg.get((Object)"id").toString());
                    if (id != codigo) {
                        return 0;
                    }
                }
                catch (NumberFormatException e) {
                    return 0;
                }
                exist[0] = true;
                return 1;
            }
        };
        for (String key : new String[]{"nome", "codigo", "nro_cartao"}) {
            if (juser.containsKey((Object)key)) continue;
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        JSONArray cid_users = this.getUsers(ctx);
        if (cid_users == null) {
            return IFPONTO_config.valueOf((String)"ERRO_GET_USERS").codigo;
        }
        int r = 0;
        int codigo = Integer.parseInt(juser.get((Object)"codigo").toString());
        boolean[] exist = new boolean[]{false};
        Util.jsonIter(cid_users, iter2, new Object[]{codigo, exist}, null);
        r = exist[0] ? this.update(juser, codigo) : this.insert(juser, codigo);
        return r;
    }

    @Override
    public int deleteUser(Object ctx, JSONObject juser) {
        long id = Long.parseLong(juser.get((Object)"codigo").toString());
        int r = this.deleteObjects("cards", "user_id", id);
        this.deleteObjects("user_access_rules", "id", id);
        this.deleteObjects("c_users", "id", id);
        r = this.deleteObjects("users", "id", id);
        return r;
    }

    @Override
    public int sendUserBio(Object ctx, JSONObject juser) {
        if (juser.containsKey((Object)"tipo") && juser.get((Object)"tipo").equals("excluir")) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        int r = this.updateUser(ctx, juser);
        if (r != 0) {
            return r;
        }
        int id = Integer.parseInt(juser.get((Object)"codigo").toString());
        r = this.deleteUserBio(ctx, juser);
        r = this.insertTemplates(juser, id);
        return r;
    }

    @Override
    public int deleteUserBio(Object ctx, JSONObject juser) {
        long id = Long.parseLong(juser.get((Object)"codigo").toString());
        int r = this.deleteObjects("templates", "user_id", id);
        return r;
    }

    @Override
    public int getUserBio(Object ctx, JSONObject juser) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jtemp, Object[] pars, int[] q) {
                JSONArray jtemps = (JSONArray)pars[0];
                JSONObject reg = new JSONObject();
                String temp = jtemp.get((Object)"template").toString();
                reg.put((Object)"vendor", (Object)"idclass");
                reg.put((Object)"encode", (Object)"b64");
                reg.put((Object)"template", (Object)temp);
                jtemps.add((Object)reg);
                return 0;
            }
        };
        int id = Integer.parseInt(juser.get((Object)"codigo").toString());
        JSONObject req = new JSONObject();
        JSONObject where = new JSONObject();
        JSONObject where_temp = new JSONObject();
        req.put((Object)"object", (Object)"templates");
        req.put((Object)"where", (Object)where);
        where.put((Object)"templates", (Object)where_temp);
        where_temp.put((Object)"user_id", (Object)id);
        JSONObject e = this.exec("load_objects", req);
        if (e == null) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        if (!e.containsKey((Object)"templates")) {
            return IFPONTO_config.valueOf((String)"OK").codigo;
        }
        JSONArray temps = (JSONArray)e.get((Object)"templates");
        JSONArray juser_temps = new JSONArray();
        juser.put((Object)"templates", (Object)juser_temps);
        Util.jsonIter(temps, iter2, new Object[]{juser_temps}, null);
        return IFPONTO_config.valueOf((String)"OK").codigo;
    }

    public int setPushConfiguration(String ip, int port) {
        int period = 1;
        int timeout = 5000;
        if (ip == null || ip.equals("")) {
            ip = Util.getLocalIP(Producer.androidContext);
        }
        if (ip == null || port < 1) {
            return -1;
        }
        JSONObject req = new JSONObject();
        JSONObject push_server = new JSONObject();
        push_server.put((Object)"push_remote_address", (Object)(ip + ":" + port));
        push_server.put((Object)"push_request_period", (Object)(period + ""));
        push_server.put((Object)"push_request_timeout", (Object)(timeout + ""));
        req.put((Object)"push_server", (Object)push_server);
        JSONArray res = this.exec("set_configuration.fcgi", req.toString());
        if (res == null) {
            return -2;
        }
        return 0;
    }

    public int setMonitorConfiguration(String hostname, int port, String path, long timeout_milis) {
        if (timeout_milis < 1000L) {
            timeout_milis = 1000L;
        }
        if (hostname == null || hostname.equals("")) {
            hostname = Util.getLocalIP(Producer.androidContext);
        }
        if (hostname == null || port < 1) {
            return -1;
        }
        JSONObject req = new JSONObject();
        JSONObject monitor = new JSONObject();
        monitor.put((Object)"request_timeout", (Object)timeout_milis);
        monitor.put((Object)"hostname", (Object)hostname);
        monitor.put((Object)"port", (Object)(port + ""));
        monitor.put((Object)"path", (Object)path);
        req.put((Object)"monitor", (Object)monitor);
        JSONArray res = this.exec("set_configuration.fcgi", req.toString());
        if (res == null) {
            return -2;
        }
        return 0;
    }

    public int createServerConfiguration(String server_ip, int server_port, String server_name, String server_path) {
        if (server_ip == null || server_ip.equals("")) {
            server_ip = Util.getLocalIP(Producer.androidContext);
        }
        if (server_ip == null || server_port < 1) {
            return -1;
        }
        JSONObject req = new JSONObject();
        JSONArray values = new JSONArray();
        JSONObject create_devices = new JSONObject();
        create_devices.put((Object)"name", (Object)server_name);
        create_devices.put((Object)"ip", (Object)("http://" + server_ip + ":" + server_port + "/" + server_path));
        create_devices.put((Object)"public_key", (Object)"");
        values.add((Object)create_devices);
        req.put((Object)"object", (Object)"devices");
        req.put((Object)"values", (Object)values);
        JSONArray res = this.exec("create_objects.fcgi", req.toString());
        if (res == null || res.size() < 1) {
            return -2;
        }
        JSONObject p1 = (JSONObject)res.get(0);
        if (p1 == null) {
            return -3;
        }
        if (!p1.containsKey((Object)"ids") || p1.get((Object)"ids") == null || !(p1.get((Object)"ids") instanceof JSONArray) || ((JSONArray)p1.get((Object)"ids")).size() < 1 || ((JSONArray)p1.get((Object)"ids")).get(0) == null) {
            return -4;
        }
        long id = (Long)((JSONArray)p1.get((Object)"ids")).get(0);
        JSONObject obj = new JSONObject();
        JSONObject server_id = new JSONObject();
        server_id.put((Object)"server_id", (Object)(id + ""));
        obj.put((Object)"online_client", (Object)server_id);
        JSONArray r = this.exec("set_configuration.fcgi", obj.toString());
        if (r == null) {
            return -2;
        }
        return 0;
    }

    public int destroyServerConfiguration(String server_name) {
        JSONObject req = new JSONObject();
        JSONObject device = new JSONObject();
        JSONObject values = new JSONObject();
        values.put((Object)"name", (Object)server_name);
        device.put((Object)"devices", (Object)values);
        req.put((Object)"object", (Object)"devices");
        req.put((Object)"where", (Object)device);
        JSONArray res = this.exec("destroy_objects.fcgi", req.toString());
        if (res == null) {
            return -2;
        }
        return 0;
    }

    public int setOnlineModoPro(int modo, int local_identification, String password_only) {
        JSONObject req = new JSONObject();
        JSONObject device = new JSONObject();
        JSONObject values = new JSONObject();
        device.put((Object)"online", (Object)(modo + ""));
        device.put((Object)"local_identification", (Object)(local_identification + ""));
        device.put((Object)"password_only", (Object)password_only);
        values.put((Object)"general", (Object)device);
        req.put((Object)"general", (Object)device);
        JSONArray res = this.exec("set_configuration.fcgi", req.toString());
        if (res == null) {
            return -2;
        }
        return 0;
    }

    public int updateServerConfiguration(String server_ip, int server_port, long server_id, String server_path) {
        if (server_ip == null || server_ip.equals("")) {
            server_ip = Util.getLocalIP(Producer.androidContext);
        }
        if (server_ip == null || server_path == null) {
            return -1;
        }
        JSONObject req = new JSONObject();
        JSONObject device = new JSONObject();
        JSONObject create_devices = new JSONObject();
        JSONObject values = new JSONObject();
        create_devices.put((Object)"ip", (Object)(server_ip + ":" + server_port + "/" + server_path));
        values.put((Object)"id", (Object)server_id);
        device.put((Object)"devices", (Object)values);
        req.put((Object)"object", (Object)"devices");
        req.put((Object)"values", (Object)create_devices);
        req.put((Object)"where", (Object)device);
        JSONArray res = this.exec("modify_objects.fcgi", req.toString());
        if (res == null) {
            return -2;
        }
        return 0;
    }

    public int loadServerConfiguration() {
        JSONObject req = new JSONObject();
        req.put((Object)"object", (Object)"devices");
        JSONArray res = this.exec("load_objects.fcgi", req.toString());
        if (res == null) {
            return -2;
        }
        return 0;
    }

    protected int addCmd(String endpoint, JSONObject jbody) {
        int id = this.cmdid++;
        JSONObject jcmd = new JSONObject();
        jcmd.put((Object)"verb", (Object)"POST");
        jcmd.put((Object)"contentType", (Object)"application/json");
        jcmd.put((Object)"endpoint", (Object)endpoint);
        jcmd.put((Object)"body", (Object)jbody);
        this.cmdQueue.add(jcmd.toString());
        this.confirmList.add(id);
        return id;
    }

    @Override
    public void getInfo(JSONObject jconfig) {
        String[] keys;
        long hour = 3600L;
        JSONObject data = this.exec("system_information", new JSONObject());
        if (data == null) {
            this.sendMessage(2, "Falha ao tentar recuperar info.");
            return;
        }
        long reftime = 0L;
        for (String key : keys = new String[]{"serial", "version", "time", "network", "deviceId", "uptime"}) {
            if (!data.containsKey((Object)key)) continue;
            if (key.equals("time")) {
                reftime = (Long)data.get((Object)key);
            }
            jconfig.put((Object)key, data.get((Object)key));
        }
        this.timediff = new Date().getTime() / 1000L - reftime;
        long div = this.timediff / hour;
        this.timediff = this.timediff % hour > 1800L ? hour * (div + 1L) : hour * div;
    }

    @Override
    public Date getTime() {
        JSONObject jinfo = new JSONObject();
        this.getInfo(jinfo);
        if (!jinfo.containsKey((Object)"time")) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        long millis = (Long)jinfo.get((Object)"time") * 1000L;
        Date date = new Date(millis - (long)(calendar.get(15) + calendar.get(16)));
        return date;
    }

    @Override
    public boolean setTime(int diff) {
        JSONObject json = this.getSetTimeRequest(diff);
        JSONObject res = this.exec("set_system_time", json);
        return res != null;
    }

    @Override
    public int getEvents(JSONArray offs) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject log, Object[] pars, int[] nsr) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                JSONArray logs = (JSONArray)pars[0];
                JSONObject off = new JSONObject();
                String[] keys = new String[]{"id", "nsr", "user_id", "codigo", "card_value", "cracha", "log_type_id", "tipo_evento", "event", null, "time", null};
                int i = 0;
                while (i + 1 < keys.length) {
                    if (!log.containsKey((Object)keys[i])) {
                        return 0;
                    }
                    i += 2;
                }
                i = 0;
                while (i + 1 < keys.length) {
                    String val;
                    if (keys[i + 1] != null && (val = log.get((Object)keys[i]).toString()) != null && !val.equals("") && !val.equals("0")) {
                        if (keys[i + 1].equals("cracha")) {
                            off.put((Object)keys[i + 1], (Object)ControlID.convertRFID_code2nominal((Long)log.get((Object)keys[i])));
                        } else {
                            off.put((Object)keys[i + 1], (Object)val);
                        }
                    }
                    i += 2;
                }
                nsr[0] = Integer.parseInt(off.get((Object)"nsr").toString());
                long i2 = (Long)log.get((Object)"event");
                if (i2 > (long)EVENT.length || i2 == 3L) {
                    return 0;
                }
                off.put((Object)"sentido", (Object)"I");
                off.put((Object)"event", (Object)EVENT[(int)i2]);
                long t = ((Long)log.get((Object)"time") + IDAccess.this.timediff) * 1000L;
                Date dt = new Date();
                dt.setTime(t);
                off.put((Object)"datahora", (Object)fmt.format(dt));
                logs.add((Object)off);
                return 0;
            }
        };
        if (this.timediff == 0L) {
            this.getInfo(new JSONObject());
        }
        JSONObject req = new JSONObject();
        req.put((Object)"object", (Object)"access_logs");
        JSONObject where = new JSONObject();
        JSONObject id = new JSONObject();
        id.put((Object)">=", (Object)this.getNsr());
        id.put((Object)"<=", (Object)(this.getNsr() + 50));
        where.put((Object)"id", (Object)id);
        JSONObject access_logs = new JSONObject();
        access_logs.put((Object)"access_logs", (Object)where);
        req.put((Object)"where", (Object)access_logs);
        JSONObject data = this.exec("load_objects", req);
        if (data == null) {
            this.sendMessage(2, "(2) Falha ao tentar recuperar eventos.");
            return -2;
        }
        if (!data.containsKey((Object)"access_logs")) {
            return 0;
        }
        int[] nsr = new int[]{0};
        this.sendMessage(5, data.get((Object)"access_logs").toString());
        Util.jsonIter((JSONArray)data.get((Object)"access_logs"), iter2, new Object[]{offs}, nsr);
        return nsr[0] + 1;
    }

    @Override
    public JSONArray getUsers() {
        JSONObject req = new JSONObject();
        req.put((Object)"object", (Object)"users");
        JSONObject data = this.exec("load_objects", req);
        if (data == null) {
            return new JSONArray();
        }
        return (JSONArray)data.get((Object)"users");
    }
}

