/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.ifractal.ifponto.BatchRequest;
import com.ifractal.ifponto.DeviceListener;
import com.ifractal.ifponto.DeviceProducer;
import com.ifractal.ifponto.Engine;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.IfaceListPerform;
import com.ifractal.ifponto.IfpontoDB;
import com.ifractal.ifponto.Manager;
import com.ifractal.ifponto.SIIN;
import com.ifractal.ifponto.SIINServer;
import com.ifractal.ifponto.TunnelDevice;
import com.ifractal.ifponto.UserWebRequest;
import com.ifractal.ifponto.Version;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class Device
extends DeviceProducer
implements Runnable {
    public static final String[][] class_models = new String[][]{{"IDClass", "idclass", "idclass671"}, {"IDAccess", "idaccess", "idflex", "idblock", "idface"}, {"Proveu", "proveu"}, {"Hexa2", "Hexa", "HexaAdv", "PontoE", "Henry671"}, {"HexaAdv", "HenryAdv"}, {"Vetronic", "vetronic"}, {"ZK", "zkpush", "zkspeedface"}, {"ZKRE", "ZKre"}, {"ZKUF200", "ZKUF200"}, {"ZMM220", "MDFace", "ZKTeco"}, {"Dahua", "DahuaFace"}, {"DummyDevice", "test", "ponto", "acesso"}, {"TunnelDevice", "Dimep", "printpoint2", "printpoint3", "smart", "miniprint", "TopdataREP", "InnerREPPlus", "TopdataOld", "topdata", "InnerREP"}, {null}};
    public Engine engine = null;
    public static final String[] models_without_afd = new String[]{"ZK", "ZKRE", "zkspeedface", "IDAccess", "IDFace", "ZKFace", "DahuaFace"};
    public static final String[] models_old = new String[]{"PrimmeAcesso"};
    public static int dev_port = 7000;
    public static String path_log = "log";
    public static String path_off = "off";
    public String SN = "";
    public boolean isNsrModified = false;
    private boolean alive = false;
    protected Thread thread = null;
    public boolean centralizador = false;
    protected JSONArray jbiousers = null;
    public JSONObject config = null;
    public int internal_delay = 2;
    public int currentNSR = 0;
    public long lastTimeStamp = 0L;
    public long nativeptr = 0L;
    public int timediff = 0;
    public String nome = "0";
    public String nro = "0";
    public String codigo = "0";
    public String port = "";
    public String ip = "";
    public String modelo = "test";
    public int index = 0;
    private static IfaceListPerform list = null;
    private static IfaceListPerform bio = null;

    public static Device getNewDevice(JSONObject params) {
        String modelo = params.get((Object)"modelo").toString();
        Device dev = null;
        String klass = "NativeDevice";
        block7: for (String[] m : class_models) {
            if (m[0] == null) continue;
            for (int i = 1; i < m.length; ++i) {
                if (!modelo.equalsIgnoreCase(m[i])) continue;
                klass = m[0];
                continue block7;
            }
        }
        try {
            Class<?> cls = Class.forName("com.ifractal.ifponto." + klass);
            Class[] dev_args_def = new Class[]{JSONObject.class};
            Constructor<?> dev_constructor = cls.getConstructor(dev_args_def);
            Object[] dev_args = new Object[]{params};
            dev = (Device)dev_constructor.newInstance(dev_args);
        }
        catch (ClassNotFoundException ex) {
            System.err.println(ex.toString());
        }
        catch (InstantiationException ie) {
            System.err.println(ie.toString());
        }
        catch (IllegalAccessException iae) {
            System.err.println(iae.toString());
        }
        catch (NoSuchMethodException nsme) {
            System.err.println(nsme.toString());
        }
        catch (InvocationTargetException ite) {
            System.err.println(ite.toString());
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println(ule.getMessage());
        }
        return dev;
    }

    public Device(JSONObject c) {
        this.config = c;
        if (this.config == null) {
            return;
        }
        if (!this.config.containsKey((Object)"nro")) {
            return;
        }
        this.codigo = this.config.containsKey((Object)"codigo") ? this.config.get((Object)"codigo").toString() : "0";
        if (list == null) {
            Device.initListPerform();
        }
        this.nro = this.config.get((Object)"nro").toString();
        this.setId(this.nro);
        if (this.config.containsKey((Object)"SN")) {
            this.SN = this.config.get((Object)"SN").toString().trim();
        }
        if (this.config.containsKey((Object)"nome")) {
            this.nome = this.config.get((Object)"nome").toString().trim();
        }
        if (this.config.containsKey((Object)"modelo")) {
            this.modelo = this.config.get((Object)"modelo").toString().trim();
        }
        if (this.config.containsKey((Object)"ip")) {
            this.ip = this.config.get((Object)"ip").toString().trim();
        }
        if (this.config.containsKey((Object)"porta")) {
            this.port = this.config.get((Object)"porta").toString().trim();
        }
        if (this.config.containsKey((Object)"PATH_LOG")) {
            path_log = this.config.get((Object)"PATH_LOG").toString().trim();
        }
        if (this.config.containsKey((Object)"PATH_OFF")) {
            path_off = this.config.get((Object)"PATH_OFF").toString().trim();
        }
        if (!this.config.containsKey((Object)"SYNCTIME")) {
            this.config.put((Object)"SYNCTIME", (Object)0);
        }
        try {
            this.loadNSR();
            if (this.config.containsKey((Object)"timediff")) {
                this.timediff = Integer.parseInt(this.config.get((Object)"timediff").toString());
            }
            if (this.config.containsKey((Object)"centralizador") && this.config.get((Object)"centralizador").toString().equals("1")) {
                this.centralizador = true;
            }
            if (this.config.containsKey((Object)"verbosity")) {
                this.setLevel(Integer.parseInt(this.config.get((Object)"verbosity").toString()));
                this.verbose("verbosity: " + this.getLevel());
            }
            if (this.config.containsKey((Object)"internal_delay")) {
                this.internal_delay = Integer.parseInt(this.config.get((Object)"internal_delay").toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IOException nfe) {
            this.verboseWARN("Falha ao tentar obter ultimo currentNSR.");
        }
    }

    protected byte[][] getTemplates(JSONArray jtemps, String vendor) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jtemp, Object[] pars, int[] c) {
                Verbosity log = (Verbosity)pars[0];
                byte[][] temps = (byte[][])pars[1];
                String vendor = (String)pars[2];
                String encode = "hex";
                byte[] temp = null;
                for (String f : new String[]{"template"}) {
                    if (jtemp.containsKey((Object)f)) continue;
                    return 0;
                }
                if (jtemp.containsKey((Object)"vendor") ? !jtemp.get((Object)"vendor").toString().equals(vendor) : !vendor.equals("suprema") || !vendor.equalsIgnoreCase("Henry")) {
                    return 0;
                }
                if (jtemp.containsKey((Object)"encode")) {
                    encode = jtemp.get((Object)"encode").toString();
                } else if (vendor.equalsIgnoreCase("Henry")) {
                    encode = "b64";
                }
                if (encode.equals("hex")) {
                    temp = Util.hex2byte(jtemp.get((Object)"template").toString());
                } else if (encode.equals("b64")) {
                    temp = Util.base642byte(jtemp.get((Object)"template").toString());
                } else if (encode.equals("raw")) {
                    temp = jtemp.get((Object)"template").toString().getBytes();
                } else {
                    log.verboseERROR("Template encode '" + encode + "' nao implementado.");
                    return 0;
                }
                if (temp == null) {
                    log.verboseERROR("Template encode '" + encode + "' corrompido.");
                    return 0;
                }
                temps[c[0]] = temp;
                c[0] = c[0] + 1;
                return 0;
            }
        };
        int qty = jtemps.size();
        if (qty < 1) {
            return null;
        }
        if (vendor == null) {
            vendor = "Suprema";
        }
        int[] count = new int[]{0};
        byte[][] aux = new byte[qty][];
        Util.jsonIter(jtemps, iter2, new Object[]{this, aux, vendor}, count);
        if (count[0] < 1) {
            return null;
        }
        byte[][] temps = new byte[count[0]][];
        for (int i = 0; i < count[0]; ++i) {
            temps[i] = aux[i];
        }
        return temps;
    }

    public int getCodigo() {
        return Integer.parseInt(this.codigo);
    }

    public String getNro() {
        return this.nro;
    }

    public int getNsr() {
        return this.currentNSR;
    }

    public abstract void getInfo(JSONObject var1);

    public abstract Date getTime();

    public abstract boolean setTime(int var1);

    public abstract int sendUsers(JSONArray var1, JSONArray var2);

    public abstract JSONArray getUsers();

    public abstract int sendBio(JSONArray var1, JSONArray var2);

    public abstract int getBio(JSONArray var1);

    public JSONArray getBioList() {
        return null;
    }

    public abstract int getEvents(JSONArray var1);

    protected int getEndIterDelay() {
        return 30;
    }

    public static native long initC(String var0);

    public static native String getModelsC(String var0);

    public native long deviceNewC(String var1);

    public native void deviceFreeC(long var1);

    public native long getTimeC(long var1, long var3);

    public native void setTimeC(long var1, int var3);

    public native String getInfoC(long var1, long var3);

    public native String getEventsC(long var1, int var3);

    public native String sendUsersC(long var1, String var3);

    public native String getUsersC(long var1);

    public native String sendBioC(long var1, String var3);

    public native String getBioC(long var1, String var3);

    protected native int getEndIterDelayC(long var1);

    private static boolean updateTunnelDevice(String[] args) {
        int dev_port = Util.getIntFromArgs(args, "dev_port");
        if (dev_port == 0) {
            dev_port = 7000;
        }
        for (int i = 0; i < class_models.length; ++i) {
            String[] models;
            if (class_models[i][0] != null || (models = TunnelDevice.getModels(new Producer(null, null){}, "127.0.0.1", dev_port)) == null) continue;
            Device.class_models[i] = new String[models.length + 1];
            int k = 0;
            Device.class_models[i][k++] = "TunnelDevice";
            for (int j = 0; j < models.length; ++j) {
                Device.class_models[i][k++] = models[j];
            }
            return true;
        }
        return false;
    }

    public static JSONArray getModels(String[] args) {
        JSONArray jmodels = new JSONArray();
        try {
            String nojava_models = Device.getModelsC(null);
            Device.updateTunnelDevice(args);
            for (String[] m : class_models) {
                JSONObject klass = new JSONObject();
                JSONArray models = new JSONArray();
                for (int i = 1; i < m.length; ++i) {
                    models.add((Object)m[i]);
                }
                if (m[0] == null) continue;
                klass.put((Object)m[0], (Object)models);
                jmodels.add((Object)klass);
            }
            JSONParser parser = new JSONParser();
            JSONArray cmodels = (JSONArray)parser.parse(nojava_models);
            for (int i = 0; i < cmodels.size(); ++i) {
                jmodels.add(cmodels.get(i));
            }
        }
        catch (ParseException e) {
            Verbosity.println(e.getMessage());
        }
        catch (UnsatisfiedLinkError ule) {
            Verbosity.println(ule.getMessage());
        }
        return jmodels;
    }

    public static String resizePhotoTemplate(String template) {
        byte[] photo = Util.base642byte(template);
        if (androidContext == null) {
            BufferedImage buf = Util.byte2bufferedImage(photo);
            if (buf == null) {
                return null;
            }
            int height = buf.getHeight();
            int width = buf.getWidth();
            while (height >= 1000 || width >= 1000) {
                buf = Util.resizeImage(buf, "jpg", 50.0);
                height = buf.getHeight();
                width = buf.getWidth();
            }
            photo = Util.bufferedImage2byte(buf, "jpg");
        } else {
            BitmapFactory.Options options = new BitmapFactory.Options();
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])photo, (int)0, (int)photo.length, (BitmapFactory.Options)options);
            int height = bitmap.getHeight();
            int width = bitmap.getWidth();
            while (height >= 1000 || width >= 1000) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)width * 0.5)), (int)((int)((double)height * 0.5)), (boolean)true);
                height = bitmap.getHeight();
                width = bitmap.getWidth();
            }
            ByteArrayOutputStream blob = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)blob);
            photo = blob.toByteArray();
        }
        template = Util.byte2base64(photo);
        return template;
    }

    protected boolean setTime_in(long unixtime) {
        Date now = new Date();
        long ref = now.getTime() / 1000L + (long)(this.timediff * 3600);
        now.setTime(ref * 1000L);
        if (Math.abs(ref - unixtime) > 50L) {
            if (!this.setTime(this.timediff)) {
                return false;
            }
            this.notifySetTime(this.config, this.timediff);
            this.verboseINFO("Ajustada => " + now);
        }
        return true;
    }

    protected static void fillResult(JSONArray users, JSONArray res) {
        final IfaceJSONIter fill = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] params, int[] qty) {
                JSONObject reg = (JSONObject)params[0];
                String id = null;
                String key = null;
                String msg = null;
                for (String k : IFPONTO_config.IDs) {
                    if (!reg.containsKey((Object)k)) continue;
                    key = k;
                    id = reg.get((Object)key).toString();
                    break;
                }
                if (id == null) {
                    return 1;
                }
                for (String k : new String[]{"cod", "codigo", "nome", key}) {
                    if (user.containsKey((Object)k)) continue;
                    return 0;
                }
                if (!user.get((Object)key).equals(id)) {
                    return 0;
                }
                msg = "ID: " + id + " - Nome: " + user.get((Object)"nome") + " - " + IFPONTO_config.getMsg(Integer.parseInt(reg.get((Object)"cod_error").toString()));
                reg.put((Object)"cod", user.get((Object)"cod"));
                reg.put((Object)"codigo", user.get((Object)"codigo"));
                reg.put((Object)"status", (Object)msg);
                qty[0] = qty[0] + 1;
                return 1;
            }
        };
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject result, Object[] pars, int[] qty) {
                JSONArray users = (JSONArray)pars[0];
                Object[] params = new Object[]{result};
                Util.jsonIter(users, fill, params, qty);
                return 0;
            }
        };
        int[] qty = new int[]{0};
        Object[] pars = new Object[]{users};
        Util.jsonIter(res, iter2, pars, qty);
    }

    protected void addResult(JSONObject user, JSONArray res, String msg, int err) {
        this.addResult(user, res, msg, err, 0, 0);
    }

    protected void addResult(JSONObject user, JSONArray res, String msg, int err, int pos, int total) {
        JSONObject reg = new JSONObject();
        for (String key : new String[]{"cod", "codigo"}) {
            if (user.containsKey((Object)key)) continue;
            return;
        }
        reg.put((Object)"cod", user.get((Object)"cod"));
        reg.put((Object)"codigo", user.get((Object)"codigo"));
        reg.put((Object)"status", (Object)msg);
        reg.put((Object)"cod_error", (Object)err);
        res.add((Object)reg);
        this.notifySendUser(this.config, user, reg, pos, total);
    }

    public static String getID(JSONObject juser) {
        if (juser == null) {
            return null;
        }
        for (String key : IFPONTO_config.IDs) {
            if (!juser.containsKey((Object)key)) continue;
            return key;
        }
        return null;
    }

    protected String makeResultMsg(JSONObject juser, String action, int ret2) {
        String id = "";
        String key = Device.getID(juser);
        if (key == null) {
            this.verboseERROR("Nenhum ID encontrado: " + juser.toString());
            return null;
        }
        if (juser.get((Object)key) != null) {
            id = juser.get((Object)key).toString();
        }
        String msg = key + ": " + id + " " + action + " - " + IFPONTO_config.getMsg(ret2);
        return msg;
    }

    private void getBiosLoop(JSONArray users) {
        IfaceJSONIter callback = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject preuser, Object[] pars, int[] q) {
                JSONArray jbiouser = new JSONArray();
                jbiouser.add((Object)preuser);
                int r = Device.this.getBio(jbiouser);
                if (r < 1) {
                    return -1;
                }
                JSONObject jbio = (JSONObject)jbiouser.get(0);
                Device.this.notifyGetBio(Device.this.config, jbio, 0, 0);
                q[0] = q[0] + 1;
                return 0;
            }
        };
        Object[] params = new Object[]{};
        int[] qty = new int[]{0};
        Util.jsonIter(users, callback, params, qty);
    }

    private int getEventsLoop(int startNSR) throws InterruptedException, NumberFormatException {
        int n = 0;
        int last_nsr = 0;
        int total = 0;
        int qtd_offs = 100;
        if (this.config.containsKey((Object)"QTD_OFF_FILES")) {
            qtd_offs = Integer.parseInt(this.config.get((Object)"QTD_OFF_FILES").toString());
        }
        do {
            this.notifyEvents(this.config, null);
            Thread.sleep(this.internal_delay * 1000);
            JSONArray offs = new JSONArray();
            this.lastTimeStamp = this.engine.getDBLastTimeStamp(this.nro);
            this.verboseINFO("Recupera NSR: " + this.currentNSR);
            this.verboseINFO("Recupera Ultimo TimesTamp: " + this.lastTimeStamp);
            int nsr = this.getEvents(offs);
            if (nsr < 0) {
                return nsr;
            }
            n = offs.size();
            total += n;
            if (nsr <= 0) continue;
            if (n > 0 && last_nsr >= nsr) {
                Thread.sleep(30000L);
                break;
            }
            if (nsr < 2) break;
            last_nsr = this.currentNSR;
            this.notifyEvents(this.config, offs);
            this.currentNSR = nsr;
        } while (n > 0 && total < qtd_offs);
        return n;
    }

    protected boolean perform(int startNSR, JSONArray users, JSONArray res) {
        boolean online = this.performIn(startNSR, users, res);
        this.notifyFinalize(this.config, online, users, res);
        if (this.config.containsKey((Object)"msg")) {
            this.config.remove((Object)"msg");
        }
        return online;
    }

    private boolean performIn(int startNSR, JSONArray users, JSONArray res) {
        Date dt = null;
        try {
            dt = this.getTime();
            if (dt == null) {
                this.getInfo(this.config);
                return false;
            }
            this.notifyGetTime(this.config, dt);
            Thread.sleep(1000L);
            String synctime = this.config.get((Object)"SYNCTIME").toString();
            if (!synctime.startsWith("0") && !this.setTime_in(dt.getTime() / 1000L)) {
                return false;
            }
            Thread.sleep(this.internal_delay * 1000);
            this.getInfo(this.config);
            if (this.getEventsLoop(startNSR) < 0) {
                return false;
            }
            Thread.sleep(this.internal_delay * 1000);
            if (users == null || users.size() < 1) {
                return true;
            }
            if (this.centralizador) {
                this.verboseDEBUG("Inicia coleta de biometrias (centralizador)");
                this.getBiosLoop(users);
            }
            this.sendUsers(users, res);
            Thread.sleep(this.internal_delay * 1000);
            if (!this.centralizador) {
                this.sendBio(users, res);
            }
        }
        catch (InterruptedException ie) {
            this.verboseFATAL("Thread Fail.");
            return false;
        }
        catch (UnsatisfiedLinkError ule) {
            this.verboseFATAL("Device n\u00e3o implementado: " + this.modelo);
            return false;
        }
        catch (NumberFormatException nfe) {
            this.verboseFATAL("Verificar o campo \"QTD_OFF_FILES\". Deve ser num\u00e9rico.");
            return false;
        }
        return true;
    }

    public Thread startLoop(final Engine siin, Observer[] obss, DeviceListener[] dls, final int startNSR) {
        this.engine = siin;
        Runnable rn = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Device.this.alive = true;
                Device.this.notifyLoop(Device.this.config, Device.this.alive);
                int qtd_users = 30;
                if (Device.this.config.containsKey((Object)"QTD_SEND_USERS")) {
                    qtd_users = Integer.parseInt(Device.this.config.get((Object)"QTD_SEND_USERS").toString());
                }
                try {
                    while (Device.this.alive) {
                        JSONArray users = siin.getDBPendingUsers(Device.this.codigo, qtd_users);
                        JSONArray res = new JSONArray();
                        Device.this.perform(startNSR, users, res);
                        Thread.sleep(10000L);
                    }
                }
                catch (InterruptedException ie) {
                    Device.this.sendMessage(1, "Thread exception...");
                }
                catch (NumberFormatException nfe) {
                    Device.this.sendMessage(1, "Codigo equipamento invalido: " + Device.this.codigo);
                }
                finally {
                    Device.this.alive = false;
                }
                Device.this.notifyLoop(Device.this.config, Device.this.alive);
            }
        };
        if (this.isAlive()) {
            return this.thread;
        }
        if (obss != null) {
            for (Observer obs : obss) {
                this.addObserver(obs);
            }
        }
        if (dls != null) {
            for (int i = 0; i < dls.length; ++i) {
                this.addListener(dls[i]);
            }
        }
        this.thread = new Thread(rn, this.nro);
        this.thread.start();
        return this.thread;
    }

    public void stopLoop() {
        this.alive = false;
    }

    public void setAlive(boolean live) {
        this.alive = live;
    }

    public boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    public boolean getAlive() {
        return this.alive;
    }

    public String toString() {
        return this.ip + ":" + this.port + " - " + this.modelo;
    }

    public static long convertRFID_nominal2code(String nominal) {
        long code = 0L;
        try {
            long in = Long.parseLong(nominal);
            int len = nominal.length();
            if (len <= 5) {
                return in;
            }
            long suffix = Long.parseLong(nominal.substring(len - 5));
            long prefix = Long.parseLong(nominal.substring(0, len - 5));
            code = suffix + 65536L * prefix;
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
        return code;
    }

    public static String convertRFID_code2nominal(long code) {
        long prefix = (code & 0xFF0000L) >> 16;
        long suffix = code & 0xFFFFL;
        return prefix + "" + suffix;
    }

    public static final String getBioI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        if (jin == null) {
            return "arquivo json invalido...";
        }
        dev.getBio(jin);
        return jin.toString();
    }

    public static final String sendBioI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        if (jin == null) {
            return "arquivo json invalido...";
        }
        JSONArray jres = new JSONArray();
        dev.sendBio(jin, jres);
        return jres.toString();
    }

    public static final String sendUsersI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        if (jin == null) {
            return "arquivo json invalido...";
        }
        JSONArray jres = new JSONArray();
        dev.sendUsers(jin, jres);
        return jres.toString();
    }

    public static final String getUsersI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        JSONArray jusers = dev.getUsers();
        if (jusers == null) {
            return "Falha comunica\u00e7\u00e3o...";
        }
        return jusers.toString();
    }

    public static final String getEventsI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        if (!in.startsWith("-")) {
            dev.currentNSR = Integer.parseInt(in);
        }
        JSONArray offs = new JSONArray();
        dev.getEvents(offs);
        return offs.toString();
    }

    public static final String getInfoI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        dev.getInfo(jconf);
        return jconf.toString();
    }

    public static final String getNsrI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        String nsr = Integer.toString(dev.engine.getDBNsr(dev.nro));
        return nsr;
    }

    public static final String deleteEventsI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        String del = Integer.toString(dev.engine.deleteDBEvents(dev.nro));
        return del;
    }

    public static final String recollectAllNsrI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        int nsr = 0;
        try {
            nsr = Integer.parseInt(in);
        }
        catch (NumberFormatException ne) {
            ne.printStackTrace();
        }
        if (nsr > 0) {
            dev.engine.recollectAllDBNsr(nsr);
        }
        return "";
    }

    public static final String statusDBI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        SIIN.statusDB(null);
        return "";
    }

    public static final String setNsrI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        int nsr = 0;
        try {
            nsr = Integer.parseInt(in);
        }
        catch (NumberFormatException ne) {
            ne.printStackTrace();
        }
        if (nsr > 0) {
            dev.engine.setDBNsr(dev.nro, nsr);
        }
        return "";
    }

    public static final String setTimeI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        int diff = 0;
        try {
            diff = Integer.parseInt(in);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        dev.setTime(diff);
        return "";
    }

    public static final String getTimeI(Device dev, JSONObject jconf, String in, JSONArray jin) {
        Date dt = dev.getTime();
        if (dt == null) {
            return "Falha comunica\u00e7\u00e3o...";
        }
        return dt.toString();
    }

    public static final String performCall(Device dev, String cmd, JSONObject jconf, String in) {
        String res;
        JSONParser parser = new JSONParser();
        JSONArray jin = null;
        String m = "";
        try {
            if (in != null && (in.startsWith("[") || in.startsWith("{"))) {
                jin = (JSONArray)parser.parse(in);
            }
            m = cmd + "I";
            Method meth = Device.class.getMethod(m, Device.class, JSONObject.class, String.class, JSONArray.class);
            res = (String)meth.invoke(null, dev, jconf, in, jin);
        }
        catch (InvocationTargetException e) {
            res = "InvocationTargetException\n";
            res = res + "Falha ao tentar executar: " + m + " - " + e.getCause();
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            res = "IllegalAccessException\n";
            res = res + "Falha ao tentar executar: " + m + " - " + e.getMessage();
        }
        catch (NoSuchMethodException e) {
            res = "NoSuchMethodException\n";
            res = res + "Falha ao tentar executar: " + m + " - " + e.getMessage();
        }
        catch (ParseException e) {
            res = "ParserException\n";
            res = res + "Falha ao tentar executar: " + m + " - " + e.getMessage();
        }
        catch (ClassCastException e) {
            res = "ClassCastException\n";
            res = res + "Falha ao tentar executar: " + m + " - " + e.getMessage();
        }
        return res;
    }

    public static final void main(String[] args) throws InterruptedException {
        Device dev;
        String file;
        String[] dev_default = new String[]{"suspended", "1", "nro", "1", "modelo", "dummy", "ip", "172.30.253.97", "porta", "3000"};
        String[] pre = new String[]{"verbosity", "0", "library", "ifdevice4j", "tempo_aguardando_giro", "3"};
        String[] methods = new String[]{"getModels -", "getNsr -", "setNsr <nsr>", "getTime -", "setTime <diff>", "getInfo -", "getEvents <nsr>", "sendUsers <users.json>", "getUsers -", "sendBio <users.json>", "getBio <users.json>", "recollectAllNsr <nsr>", "deleteDBEvents <nro>", "statusDB -"};
        if (args.length < 2) {
            System.err.println("iFractal - Device Unit Teste");
            System.err.println("Versao: " + Version.getFormatedText());
            System.err.println("\nUso:");
            System.err.println("\tshell$ java com.ifractal.ifponto.Device <CMD> <Arquivo JSON> <Param 1> <Val 1> ... <Param N> <Val N>");
            System.err.println("\nOnde <CMD>:");
            for (String m : methods) {
                System.err.println("\t" + m);
            }
            System.err.println("\nOnde <Param>");
            int i = 0;
            while (i + 1 < pre.length) {
                System.err.printf("%25s  -  default: '%s'\n", pre[i], pre[i + 1]);
                i += 2;
            }
            i = 0;
            while (i + 1 < dev_default.length) {
                System.err.printf("%25s  -  default: '%s'\n", dev_default[i], dev_default[i + 1]);
                i += 2;
            }
            System.err.println("\nExemplos:");
            System.err.println("\tshell$ java com.ifractal.ifponto.Device getInfo - modelo idclass nro 2");
            System.err.println("\tshell$ java com.ifractal.ifponto.Device sendUsers list_1_zzz.json modelo idclass nro 3\n");
            System.exit(1);
        } else if (args.length % 2 != 0) {
            System.err.println("\nParametros devem vir em pares <chave> <valor>.\n");
            System.exit(2);
        }
        JSONObject jconf = new JSONObject();
        int i = 0;
        while (i + 1 < pre.length) {
            jconf.put((Object)pre[i], (Object)pre[i + 1]);
            i += 2;
        }
        i = 0;
        while (i + 1 < dev_default.length) {
            jconf.put((Object)dev_default[i], (Object)dev_default[i + 1]);
            i += 2;
        }
        i = 2;
        while (i + 1 < args.length) {
            jconf.put((Object)args[i], (Object)args[i + 1]);
            i += 2;
        }
        try {
            Util.loadLibrary(jconf);
            Device.initC(jconf.toString());
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("Ignora integra\u00e7\u00e3o em C");
            Thread.sleep(2000L);
        }
        String cmd = args[0];
        String json = file = args[1];
        if (cmd.equals("getModels")) {
            System.out.println(Device.getModels(args).toJSONString());
            System.exit(0);
        }
        if ((dev = Device.getNewDevice(jconf)) == null) {
            System.exit(3);
        }
        String[] args_server = new String[]{"tunnel_host", SIINServer.tunnelHost, "tunnel_port", Integer.toString(SIINServer.tunnelPort)};
        SIINServer.getInstance(null, args);
        IfpontoDB idb = new IfpontoDB(args, SIINServer.server);
        idb.init(args, SIINServer.server);
        idb.open(null, SIINServer.server);
        dev.engine = Engine.getInstance(args_server, idb, SIINServer.server);
        if (!file.equals("-")) {
            json = Util.getContent(file);
        }
        if (json == null) {
            json = file;
        }
        String msg = Device.performCall(dev, cmd, jconf, json);
        System.out.println(msg);
        Thread.sleep(2000L);
    }

    @Deprecated
    protected void updateOffs(JSONArray offs, int nsr) throws IOException {
        if (nsr > 1 && nsr < 2000000) {
            this.currentNSR = nsr;
            this.saveNSR();
        }
        this.config.put((Object)"ultimo_nsr", (Object)this.getNsr());
        this.config.put((Object)"notificacoes", (Object)("nsr: " + this.getNsr() + " - ONLINE"));
        if (!this.config.containsKey((Object)"msg")) {
            this.config.put((Object)"msg", (Object)("nsr: " + this.getNsr() + " - ONLINE"));
        }
        this.verboseINFO("NSR: " + this.getNsr() + " (" + nsr + ")");
        this.updateStatus();
        this.config.remove((Object)"msg");
        if (offs.size() < 1) {
            return;
        }
        Date now = new Date();
        String filename = path_off + File.separator + "off_" + this.nro + "_" + now.getTime() + ".json";
        File final_file = new File(filename);
        File temp_file = new File(filename + ".tmp");
        FileWriter file = new FileWriter(temp_file);
        file.write(offs.toJSONString());
        file.close();
        if (!temp_file.renameTo(final_file)) {
            this.verboseERROR("Falha ao tentar renomear arquivo temporario: " + filename);
        }
    }

    @Deprecated
    protected void updateStatus(String msg) {
        try {
            this.config.put((Object)"msg", (Object)msg);
            this.updateStatus();
        }
        catch (IOException ioe) {
            this.verboseERROR("Falha ao tentar atualizar status.");
        }
    }

    @Deprecated
    protected void updateStatus() throws IOException {
        long unixtime = new Date().getTime() / 1000L;
        this.config.put((Object)"unixtime", (Object)unixtime);
        this.config.put((Object)"ultimo_contato", (Object)unixtime);
        if (!this.config.containsKey((Object)"msg")) {
            this.config.put((Object)"msg", (Object)"Falha comunicacao...");
        }
        this.config.put((Object)"notificacoes", this.config.get((Object)"msg"));
        String filename = path_log + File.separator + "status_" + this.nro + ".json";
        FileWriter file = new FileWriter(filename);
        file.write(this.config.toJSONString());
        file.close();
    }

    @Deprecated
    protected void saveResults(JSONArray res) throws IOException {
        if (res == null || res.size() < 1) {
            return;
        }
        Date now = new Date();
        String fileresult = path_off + File.separator + "result_" + this.nro + "_" + now.getTime() + ".json";
        FileWriter file = new FileWriter(fileresult);
        file.write(res.toJSONString());
        file.close();
    }

    @Deprecated
    private static void initListPerform() {
        list = new IfaceListPerform(){

            @Override
            public int perform(Device dev, JSONArray list, JSONArray res, Object[] params) {
                return dev.sendUsers(list, res);
            }
        };
        bio = new IfaceListPerform(){

            @Override
            public int perform(Device dev, JSONArray list, JSONArray res, Object[] params) {
                int r = dev.sendBio(list, res);
                return r;
            }
        };
    }

    @Deprecated
    public int processPrebio() {
        BatchRequest br;
        final IfaceJSONIter clean = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jbiouser, Object[] pars, int[] q) {
                if (!jbiouser.containsKey((Object)"templates")) {
                    return 0;
                }
                if (((JSONArray)jbiouser.get((Object)"templates")).size() < 1) {
                    return 0;
                }
                Device.this.jbiousers = (JSONArray)pars[0];
                Device.this.jbiousers.add((Object)jbiouser);
                return 0;
            }
        };
        IfaceJSONIter callback = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject preuser, Object[] pars, int[] q) {
                JSONArray jbiouser = new JSONArray();
                jbiouser.add((Object)preuser);
                int r = Device.this.getBio(jbiouser);
                if (r < 1) {
                    return -1;
                }
                Device.this.jbiousers = (JSONArray)pars[0];
                Object[] params = new Object[]{Device.this.jbiousers};
                Util.jsonIter(jbiouser, clean, params, null);
                q[0] = q[0] + 1;
                return 0;
            }
        };
        while ((br = BatchRequest.getByNro("", "prebio_")) != null) {
            String[] prefix;
            this.updateStatus("Processando: " + br.filename);
            this.verboseINFO(br.filename + " processando...");
            JSONArray jbiousers = new JSONArray();
            Object[] params = new Object[]{jbiousers};
            int[] qty = new int[]{0};
            Util.jsonIter(br.json, callback, params, qty);
            long now = new Date().getTime();
            for (String p : prefix = new String[]{path_log, path_off}) {
                if (br.nro.equals(this.nro) && p.equals(path_log) || !br.nro.equals(this.nro) && p.equals(path_off)) continue;
                String filename = p + File.separator + "bio_" + br.nro + "_" + now + ".json";
                if (jbiousers.size() <= 0) continue;
                Util.saveJSONArray(this, jbiousers, filename);
            }
            br.state = BatchRequest.State.DONE;
        }
        return 0;
    }

    @Deprecated
    private int sendBatchRequest() throws IOException, NoSuchMethodException, IllegalAccessException {
        Object[][] params;
        BatchRequest br = null;
        int n = 0;
        for (Object[] par : params = new Object[][]{{"list_", list}, {"bio_", bio}}) {
            String type = (String)par[0];
            IfaceListPerform meth = (IfaceListPerform)par[1];
            n = 0;
            while ((br = BatchRequest.getByNro(this.nro, type)) != null) {
                this.verboseINFO(br.filename + " processando...");
                JSONArray result = new JSONArray();
                int r = meth.perform(this, br.json, result, new Object[]{br});
                this.saveResults(result);
                br.state = r > 0 ? BatchRequest.State.DONE : BatchRequest.State.FAIL;
                ++n;
            }
        }
        return n;
    }

    @Deprecated
    private int sendOnlineRequest() throws IOException {
        UserWebRequest uwr;
        int n = 0;
        n = 0;
        while ((uwr = UserWebRequest.onlineRequestGetByNro(this.nro)) != null) {
            JSONArray result = new JSONArray();
            JSONArray jusers = uwr.getUsers();
            if (jusers == null) {
                uwr.setState(UserWebRequest.State.FAIL);
            } else if (jusers.size() < 1) {
                uwr.setState(UserWebRequest.State.DONE);
            } else {
                this.sendUsers(jusers, result);
                this.saveResults(result);
                if (result.size() < 1) {
                    uwr.setState(UserWebRequest.State.FAIL);
                } else {
                    UserWebRequest.State state = UserWebRequest.State.DONE;
                    for (JSONObject res : result) {
                        String cod_error = res.get((Object)"cod_error").toString();
                        if (cod_error.equals("0")) {
                            state = UserWebRequest.State.DONE;
                            continue;
                        }
                        state = UserWebRequest.State.FAIL;
                        break;
                    }
                    uwr.setState(state);
                }
            }
            ++n;
        }
        return n;
    }

    @Deprecated
    public void labeledVerboseDEBUG(String matter, String label) {
        this.verboseDEBUG(String.format("%s:: %s", label, matter));
    }

    @Deprecated
    private int getEventsLoop() throws IOException, InterruptedException {
        int n = 0;
        int last_nsr = 0;
        do {
            Thread.sleep(this.internal_delay * 1000);
            JSONArray offs = new JSONArray();
            this.loadNSR();
            this.verboseINFO("Recupera NSR: " + this.getNsr());
            int nsr = this.getEvents(offs);
            if (nsr < 0) {
                return nsr;
            }
            this.updateOffs(offs, nsr);
            n = offs.size();
            if (nsr > 0 && n > 0 && last_nsr == this.getNsr()) {
                this.verboseWARN("Poss\u00edvel registro corrompido.");
                Thread.sleep(30000L);
                break;
            }
            last_nsr = this.getNsr();
        } while (n > 0);
        return n;
    }

    @Deprecated
    private String getNSRFilename() {
        return "conf" + File.separator + this.nro + ".nsr";
    }

    @Deprecated
    protected void loadNSR() throws IOException {
        String line = "";
        try {
            FileReader fr = new FileReader(this.getNSRFilename());
            BufferedReader br = new BufferedReader(fr);
            line = br.readLine();
            if (line != null) {
                this.currentNSR = Integer.parseInt(line);
            }
            br.close();
            fr.close();
        }
        catch (NumberFormatException nfe) {
            this.currentNSR = 1;
            this.verboseERROR("Falha ao tentar ler NSR: " + line);
        }
        catch (FileNotFoundException fnfe) {
            this.currentNSR = 1;
        }
    }

    @Deprecated
    protected void saveNSR() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.getNSRFilename());
        DataOutputStream bw = new DataOutputStream(fos);
        bw.writeBytes(String.valueOf(this.currentNSR) + "\n");
        bw.close();
        fos.close();
    }

    @Deprecated
    public String getUsersFilename() {
        return "conf" + File.separator + "users_" + this.nro + ".jdat";
    }

    @Override
    @Deprecated
    public void run() {
        Date dt = null;
        try {
            dt = this.getTime();
            if (dt == null) {
                this.getInfo(this.config);
                this.updateStatus();
                int n = BatchRequest.clean(this.nro);
                if (n > 0) {
                    this.verboseWARN("Falha comunicacao. (run) - descarrega fila: " + n);
                }
                return;
            }
            Thread.sleep(1000L);
        }
        catch (IOException ioe) {
            this.verboseERROR("Falha ao tentar gravar status.");
            return;
        }
        catch (UnsatisfiedLinkError ule) {
            this.verboseFATAL("Device n\u00e3o implementado: " + this.modelo);
            return;
        }
        catch (InterruptedException ie) {
            this.verboseFATAL("Thread Fail.");
        }
        this.verboseINFO("Data/hora: " + dt.toString());
        String synctime = Manager.getConfigValue("SYNCTIME");
        if (synctime.startsWith("0")) {
            this.verboseINFO("Sincronizacao de horario desabilitada.");
        } else if (!this.setTime_in(dt.getTime() / 1000L)) {
            this.verboseINFO("Falha setTime.");
            return;
        }
        block9: while (true) {
            try {
                while (!this.config.containsKey((Object)"suspended")) {
                    Thread.sleep(this.internal_delay * 1000);
                    this.getInfo(this.config);
                    if (this.getEventsLoop() < 0) break block9;
                    Thread.sleep(this.internal_delay * 1000);
                    if (this.centralizador) {
                        this.processPrebio();
                    }
                    this.sendBatchRequest();
                    this.sendOnlineRequest();
                    int delay = this.getEndIterDelay();
                    if (delay < 0) break block9;
                    Thread.sleep(delay * 1000);
                }
            }
            catch (InterruptedException ie) {
                this.verboseFATAL("Thread Fail.");
            }
            catch (IOException ioe) {
                this.verboseERROR("Erro ao tentar ler/salvar arquivos.");
                this.verboseFATAL(ioe.getMessage());
                continue;
            }
            catch (NoSuchMethodException nsme) {
                this.verboseERROR("NoSuchMethodException: " + nsme.getMessage());
            }
            catch (IllegalAccessException iae) {
                this.verboseERROR("IllegalAccessException: " + iae.getMessage());
            }
            break;
        }
    }
}

