CREATE TABLE pessoa (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	codigo_ifponto INTEGER NOT NULL UNIQUE,
	id_ifponto TEXT NULL,
	pis TEXT NOT NULL,
	login TEXT NOT NULL DEFAULT '',
	senha TEXT NOT NULL DEFAULT '',
	nome TEXT NOT NULL DEFAULT '',
	verificar_biometria INTEGER NOT NULL DEFAULT 1, json TEXT NULL,
	UNIQUE(codigo_ifponto, pis),
	UNIQUE(codigo_ifponto, id_ifponto)
);

CREATE TABLE cartao (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	pessoa_id INTEGER NOT NULL,
	numero INTEGER NOT NULL UNIQUE,
	tipo TEXT NOT NULL DEFAULT 'Funcionário',
	tecnologia TEXT NOT NULL DEFAULT 'Digital',
	hrinicio TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	hrfim TIMESTAMP NOT NULL DEFAULT '2040-12-31 23:59:59',
	liberador INTEGER NOT NULL DEFAULT 0,
	ativo INTEGER NOT NULL DEFAULT 1,
	json TEXT NULL,
	FOREIGN KEY(pessoa_id) REFERENCES pessoa(id)
);

CREATE TABLE equipamento (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	codigo_ifponto INTEGER NOT NULL UNIQUE,
	numero INTEGER NOT NULL DEFAULT 1 UNIQUE,
	timediff INTEGER NOT NULL DEFAULT 0,
	nsr INTEGER NULL,
	siin_nsr INTEGER NOT NULL DEFAULT 0,
	modelo TEXT NOT NULL DEFAULT 'desktop',
	nome TEXT NOT NULL DEFAULT '',
	ip TEXT NOT NULL DEFAULT '127.0.0.1',
	porta INTEGER NOT NULL DEFAULT 3000,
	login TEXT NOT NULL DEFAULT '',
	senha TEXT NOT NULL DEFAULT '',
	config TEXT NOT NULL DEFAULT '',
	status TEXT NOT NULL DEFAULT '',
	ativo BOOLEAN NOT NULL DEFAULT 'TRUE'
);

CREATE TABLE biometria (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	pessoa_id INTEGER NOT NULL,
	vendor TEXT NOT NULL DEFAULT '',
	encode TEXT NOT NULL DEFAULT 'b64', --b64, hex, raw
	template TEXT NOT NULL DEFAULT '' UNIQUE,
	sincronizado BOOLEAN NOT NULL DEFAULT 'FALSE',
	json TEXT NULL,
	FOREIGN KEY(pessoa_id) REFERENCES pessoa(id)
);

CREATE TABLE pessoa_equipamento (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	codigo_ifponto INTEGER NOT NULL UNIQUE,
	equipamento_id INTEGER NOT NULL,
	pessoa_id INTEGER NOT NULL,
	operacao TEXT NOT NULL DEFAULT 'incluir',
	situacao INTEGER NOT NULL DEFAULT '1', --1: espera, 2: processando, 3: feito, 4: erro
	sincronizado BOOLEAN NOT NULL DEFAULT 'FALSE',
	descricao TEXT NOT NULL DEFAULT '',
	FOREIGN KEY(equipamento_id) REFERENCES equipamento(id),
	FOREIGN KEY(pessoa_id) REFERENCES pessoa(id),
	UNIQUE(pessoa_id, equipamento_id)
);

CREATE TABLE evento (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	pessoa_id INTEGER NULL,
	equipamento_id INTEGER NULL,
	codigo INTEGER NULL,
	nsr INTEGER NULL,
	afd TEXT NOT NULL DEFAULT '',
	descricao TEXT NOT NULL DEFAULT '',
	tipo_afd INTEGER NOT NULL DEFAULT 3, --99 para eventos não definidos no afd
	datahora TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	sincronizado BOOLEAN NOT NULL DEFAULT 'FALSE',
	UNIQUE (equipamento_id, nsr),
	UNIQUE (pessoa_id, datahora),
	FOREIGN KEY(pessoa_id) REFERENCES pessoa(id)
	FOREIGN KEY(equipamento_id) REFERENCES equipamento(id)
);


