/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.whatsapp;

import com.ifractal.utils.Producer;
import com.ifractal.utils.Util;
import com.ifractal.whatsapp.Attendant;
import com.ifractal.whatsapp.Chat;
import com.ifractal.whatsapp.MessageStatus;
import com.ifractal.whatsapp.Person;
import com.ifractal.whatsapp.WhatsappBotKt;
import com.ifractal.whatsapp.messages.Message;
import com.ifractal.whatsapp.messages.Parameter;
import com.ifractal.whatsapp.messages.Template;
import com.ifractal.whatsapp.messages.TemplateKt;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\nJ1\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2!\u0010*\u001a\u001d\u0012\u0013\u0012\u00110,\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(/\u0012\u0004\u0012\u0002000+J&\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006J\u0006\u00106\u001a\u00020\u0006J\u0010\u00107\u001a\u0004\u0018\u00010\u00102\u0006\u00108\u001a\u00020\u0006J\u0010\u00109\u001a\u0004\u0018\u00010\u00142\u0006\u00108\u001a\u00020\u0006J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0;J\u0010\u0010<\u001a\u0004\u0018\u00010\u00142\u0006\u00108\u001a\u00020\u0006J\u000e\u0010=\u001a\u00020>2\u0006\u00108\u001a\u00020\u0006J&\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006J&\u0010?\u001a\u0002002\u0006\u0010A\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006J\u001b\u0010?\u001a\u00020)2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a2\u0006\u0002\u0010BJ&\u0010C\u001a\u0002002\u0006\u0010D\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006J\u00ad\u0001\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010(\u001a\u00020)2\u008f\u0001\u0010*\u001a\u008a\u0001\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(.\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(8\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(3\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(G\u0012\u0004\u0012\u00020>0Fj\u0002`HH\u0016\u00a2\u0006\u0002\u0010IJ\u000e\u0010J\u001a\u00020>2\u0006\u0010K\u001a\u00020\u0006J\u001e\u0010L\u001a\u0002002\u0006\u0010(\u001a\u00020)2\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006J&\u0010M\u001a\u00020'2\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u0010N\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006J \u0010O\u001a\u00020'2\u0006\u00102\u001a\u00020\u00062\u0006\u0010P\u001a\u00020Q2\b\b\u0002\u0010R\u001a\u00020\u0006J\u0016\u0010S\u001a\u00020'2\u0006\u00102\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006T"}, d2={"Lcom/ifractal/whatsapp/WhatsappBot;", "Lcom/ifractal/utils/Producer;", "ctx", "", "args", "", "", "([J[Ljava/lang/String;)V", "admins", "", "Lcom/ifractal/whatsapp/Person;", "getAdmins", "()Ljava/util/Set;", "setAdmins", "(Ljava/util/Set;)V", "attendants", "Lcom/ifractal/whatsapp/Attendant;", "getAttendants", "setAttendants", "chats", "Lcom/ifractal/whatsapp/Chat;", "getChats", "host", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "phoneNumberID", "getPhoneNumberID", "token", "getToken", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "addChat", "wamid", "client", "dispatchEntry", "", "json", "Lorg/json/simple/JSONObject;", "cb", "Lkotlin/Function1;", "Lcom/ifractal/whatsapp/messages/Message;", "Lkotlin/ParameterName;", "name", "msgpack", "", "forward", "to", "type", "media_id", "entry", "getAtendantList", "getAttendant", "wa_id", "getAttendantChat", "getAvailable", "", "getClientChat", "isAdmin", "", "perform", "chat", "person", "([Ljava/lang/String;)Lorg/json/simple/JSONObject;", "performAttendant", "att", "process", "Lkotlin/Function6;", "text", "Lcom/ifractal/whatsapp/messages/onMessage;", "(Lorg/json/simple/JSONObject;Lkotlin/jvm/functions/Function6;)[Ljava/lang/String;", "resetAttendants", "csv", "sendJson", "sendMedia", "img_id", "sendTemplate", "template", "Lcom/ifractal/whatsapp/messages/Template;", "language", "sendText", "ifractal"})
public abstract class WhatsappBot
extends Producer {
    @NotNull
    private Set<Attendant> attendants;
    @NotNull
    private Set<Person> admins;
    @NotNull
    private final Set<Chat> chats;
    @NotNull
    private final String phoneNumberID;
    @NotNull
    private String host;
    @NotNull
    private final String token;
    @NotNull
    private final URL url;

    public WhatsappBot(@Nullable long[] ctx, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super(ctx, args);
        this.attendants = new LinkedHashSet();
        this.admins = new LinkedHashSet();
        this.chats = new LinkedHashSet();
        this.host = "https://graph.facebook.com/v13.0/";
        String adms = Util.getValueFromArgs(args, "admins");
        if (adms != null) {
            WhatsappBotKt.performCSV(adms, 30, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(){

                public final void invoke(@NotNull List<String> nros) {
                    Intrinsics.checkNotNullParameter(nros, (String)"nros");
                    int n = nros.size();
                    for (int n2 = 0; n2 < n; ++n2) {
                        this.getAdmins().add(new Person("Adm " + n2, nros.get(n2), false, null, 0L, null, 60, null));
                    }
                }
            }));
        }
        String string = Util.getValueFromArgs(args, "phoneNumberID");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueFromArgs(args, \"phoneNumberID\")");
        this.phoneNumberID = string;
        String string2 = Util.getValueFromArgs(args, "token");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValueFromArgs(args, \"token\")");
        this.token = string2;
        String[] stringArray = new String[]{"host"};
        if (Util.checkKeysInArgs(args, stringArray)) {
            String string3 = Util.getValueFromArgs(args, "host");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValueFromArgs(args, \"host\")");
            this.host = string3;
        }
        this.url = new URL(this.host + this.phoneNumberID + "/messages");
    }

    @NotNull
    public final Set<Attendant> getAttendants() {
        return this.attendants;
    }

    public final void setAttendants(@NotNull Set<Attendant> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.attendants = set;
    }

    @NotNull
    public final Set<Person> getAdmins() {
        return this.admins;
    }

    public final void setAdmins(@NotNull Set<Person> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.admins = set;
    }

    @NotNull
    public final Set<Chat> getChats() {
        return this.chats;
    }

    @NotNull
    public final String getPhoneNumberID() {
        return this.phoneNumberID;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    public final boolean resetAttendants(@NotNull String csv) {
        Intrinsics.checkNotNullParameter((Object)csv, (String)"csv");
        this.attendants.clear();
        WhatsappBotKt.performCSV(csv, 2, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(this){
            final /* synthetic */ WhatsappBot this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<String> e) {
                Intrinsics.checkNotNullParameter(e, (String)"e");
                this.this$0.getAttendants().add(new Attendant(((Object)StringsKt.trim((CharSequence)e.get(1))).toString(), ((Object)StringsKt.trim((CharSequence)e.get(0))).toString()));
            }
        }));
        return this.attendants.size() >= 1;
    }

    @NotNull
    public final String getAtendantList() {
        String list = "";
        for (Attendant e : this.attendants) {
            list = list + '\n' + e.getWa_id() + " : " + e.getName();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Person> getAvailable() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.attendants;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Attendant it = (Attendant)element$iv$iv;
            boolean bl = false;
            if (!it.getAvailable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List avail = (List)destination$iv$iv;
        return avail;
    }

    public final void sendJson(@NotNull JSONObject json, @NotNull String to, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        json.put((Object)"messaging_product", (Object)"whatsapp");
        json.put((Object)"to", (Object)to);
        json.put((Object)"type", (Object)type);
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
        String data = string;
        this.sendMessage(5, data);
        byte[] bytes = StringsKt.encodeToByteArray((String)data);
        String[] stringArray = new String[]{"Authorization", "Bearer " + this.token};
        String[] headers = stringArray;
        Util.sendPOST(this, this.url, bytes, "application/json", headers);
    }

    public final int sendTemplate(@NotNull String to, @NotNull Template template, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        JSONObject json = new JSONObject();
        JSONObject jtemp = new JSONObject();
        JSONObject jlang = new JSONObject();
        json.put((Object)"template", (Object)jtemp);
        jtemp.put((Object)"language", (Object)jlang);
        jtemp.put((Object)"name", (Object)template.getName());
        jlang.put((Object)"code", (Object)language);
        this.sendJson(json, to, "template");
        Unit resp = Unit.INSTANCE;
        this.sendMessage(5, resp.toString());
        return 0;
    }

    public static /* synthetic */ int sendTemplate$default(WhatsappBot whatsappBot, String string, Template template, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendTemplate");
        }
        if ((n & 4) != 0) {
            string2 = "pt_BR";
        }
        return whatsappBot.sendTemplate(string, template, string2);
    }

    public final int sendMedia(@NotNull String to, @NotNull String type, @NotNull String img_id, @NotNull String entry) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)img_id, (String)"img_id");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        JSONObject json = new JSONObject();
        JSONObject jmedia = new JSONObject();
        jmedia.put((Object)"id", (Object)img_id);
        jmedia.put((Object)"caption", (Object)entry);
        json.put((Object)type, (Object)jmedia);
        this.sendJson(json, to, type);
        Unit resp = Unit.INSTANCE;
        this.sendMessage(5, resp.toString());
        return 0;
    }

    public final int sendText(@NotNull String to, @NotNull String entry) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        JSONObject json = new JSONObject();
        JSONObject jtxt = new JSONObject();
        jtxt.put((Object)"preview_url", (Object)false);
        jtxt.put((Object)"body", (Object)entry);
        json.put((Object)"recipient_type", (Object)"individual");
        json.put((Object)"text", (Object)jtxt);
        this.sendJson(json, to, "text");
        Unit resp = Unit.INSTANCE;
        this.sendMessage(5, resp.toString());
        return 0;
    }

    public final void forward(@NotNull Person to, @NotNull String type, @NotNull String media_id, @NotNull String entry) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)media_id, (String)"media_id");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        to.setLast(System.currentTimeMillis());
        switch (type) {
            case "text": {
                this.sendText(to.getWa_id(), entry);
                break;
            }
            case "image": {
                this.sendMedia(to.getWa_id(), type, media_id, entry);
                break;
            }
            case "video": {
                this.sendMedia(to.getWa_id(), type, media_id, entry);
                break;
            }
            case "audio": {
                this.sendMedia(to.getWa_id(), type, media_id, entry);
                break;
            }
            default: {
                this.sendMessage(3, "type " + type + " nao implementado.");
            }
        }
    }

    public final void perform(@NotNull Chat chat, @NotNull String type, @NotNull String media_id, @NotNull String entry) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)media_id, (String)"media_id");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (chat.getAttendant() != null) {
            this.forward(chat.getAttendant(), type, media_id, entry);
        } else {
            this.perform(chat.getClient(), type, media_id, entry);
        }
    }

    public final void perform(@NotNull Person person, @NotNull String type, @NotNull String media_id, @NotNull String entry) {
        Intrinsics.checkNotNullParameter((Object)person, (String)"person");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)media_id, (String)"media_id");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        List<Person> atts = this.getAvailable();
        person.setLast(System.currentTimeMillis());
        String[] stringArray = new String[]{"type", type, "entry", entry, "media_id", media_id, "from", person.getWa_id(), "attendants", String.valueOf(atts.size()), "status", person.getMessage_status().toString()};
        String[] args = stringArray;
        JSONObject resp = this.perform(args);
        String[] stringArray2 = new String[]{"template", "parameters"};
        for (String k : stringArray2) {
            if (resp.containsKey((Object)k)) continue;
            this.sendMessage(2, "Falta parametro '" + k + '\'');
            return;
        }
        if (!(resp.get((Object)"parameters") instanceof JSONArray)) {
            this.sendMessage(2, "Parametros invalidos.");
            return;
        }
        Object object = resp.get((Object)"parameters");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.simple.JSONArray");
        JSONArray jpars = (JSONArray)object;
        List pars = new ArrayList();
        int i = 0;
        int n = jpars.size();
        if (i <= n) {
            while (true) {
                Object object2 = jpars.get(i);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.json.simple.JSONObject");
                Parameter par = TemplateKt.getParameter((JSONObject)object2);
                if (par != null) {
                    pars.add(par);
                }
                if (i == n) break;
                ++i;
            }
        }
        Template temp = new Template(String.valueOf(resp.get((Object)"template")), pars);
        WhatsappBot.sendTemplate$default(this, person.getWa_id(), temp, null, 4, null);
    }

    @NotNull
    public abstract JSONObject perform(@NotNull String[] var1);

    @NotNull
    public final Chat addChat(@NotNull String wamid, @NotNull Person client) {
        Intrinsics.checkNotNullParameter((Object)wamid, (String)"wamid");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        client.setLast(System.currentTimeMillis());
        client.setAvailable(true);
        client.setMessage_status(MessageStatus.WAIT);
        Chat chat = new Chat(wamid, client, null);
        this.chats.add(chat);
        return chat;
    }

    @Nullable
    public final Chat getClientChat(@NotNull String wa_id) {
        Intrinsics.checkNotNullParameter((Object)wa_id, (String)"wa_id");
        for (Chat c : this.chats) {
            if (!Intrinsics.areEqual((Object)c.getClient().getWa_id(), (Object)wa_id)) continue;
            return c;
        }
        return null;
    }

    public final void performAttendant(@NotNull Attendant att, @NotNull String type, @NotNull String media_id, @NotNull String entry) {
        Intrinsics.checkNotNullParameter((Object)att, (String)"att");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)media_id, (String)"media_id");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        att.setAvailable(true);
        this.perform(att, type, media_id, entry);
    }

    @Nullable
    public final Chat getAttendantChat(@NotNull String wa_id) {
        Intrinsics.checkNotNullParameter((Object)wa_id, (String)"wa_id");
        for (Chat c : this.chats) {
            if (c.getAttendant() == null || !Intrinsics.areEqual((Object)c.getAttendant().getWa_id(), (Object)wa_id)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public final Attendant getAttendant(@NotNull String wa_id) {
        Intrinsics.checkNotNullParameter((Object)wa_id, (String)"wa_id");
        for (Attendant a : this.attendants) {
            if (!Intrinsics.areEqual((Object)a.getWa_id(), (Object)wa_id)) continue;
            return a;
        }
        return null;
    }

    public final boolean isAdmin(@NotNull String wa_id) {
        Intrinsics.checkNotNullParameter((Object)wa_id, (String)"wa_id");
        for (Person a : this.admins) {
            if (!Intrinsics.areEqual((Object)a.getWa_id(), (Object)wa_id)) continue;
            return true;
        }
        return false;
    }

    public final int dispatchEntry(@NotNull JSONObject json, @NotNull Function1<? super Message, Unit> cb) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        int qty = 0;
        if (!json.containsKey((Object)"changes")) {
            return qty;
        }
        boolean ok = false;
        Object object = json.get((Object)"changes");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.simple.JSONArray");
        JSONArray changes = (JSONArray)object;
        int i = 0;
        int n = changes.size() - 1;
        if (i <= n) {
            while (true) {
                Object object2 = changes.get(i);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.json.simple.JSONObject");
                JSONObject e = (JSONObject)object2;
                String[] stringArray = new String[]{"value", "field"};
                ok = WhatsappBotKt.jsonCheckKeys(this, e, stringArray);
                if (ok && Intrinsics.areEqual((Object)String.valueOf(e.get((Object)"field")), (Object)"messages")) {
                    Object object3 = e.get((Object)"value");
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.json.simple.JSONObject");
                    JSONObject value = (JSONObject)object3;
                    String[] stringArray2 = new String[]{"metadata", "contacts", "messages"};
                    ok = WhatsappBotKt.jsonCheckKeys(this, value, stringArray2);
                    if (ok) {
                        Object object4 = value.get((Object)"contacts");
                        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.json.simple.JSONArray");
                        JSONArray jcontacts = (JSONArray)object4;
                        if (jcontacts.size() >= 1) {
                            Object object5 = jcontacts.get(0);
                            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type org.json.simple.JSONObject");
                            JSONObject jcontact = (JSONObject)object5;
                            String[] stringArray3 = new String[]{"profile", "wa_id"};
                            if (WhatsappBotKt.jsonCheckKeys(this, jcontact, stringArray3)) {
                                String wa_id = String.valueOf(jcontact.get((Object)"wa_id"));
                                Object object6 = jcontact.get((Object)"profile");
                                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type org.json.simple.JSONObject");
                                JSONObject jprofile = (JSONObject)object6;
                                String name = String.valueOf(jprofile.get((Object)"name"));
                                Object object7 = value.get((Object)"messages");
                                Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type org.json.simple.JSONArray");
                                cb.invoke((Object)new Message(name, wa_id, (JSONArray)object7));
                                ++qty;
                            }
                        }
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        return qty;
    }

    @NotNull
    public String[] process(@NotNull JSONObject json, @NotNull Function6<? super String, ? super String, ? super String, ? super String, ? super String, ? super String, Boolean> cb) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        String[] stringArray = new String[]{"object", "entry"};
        String[] keys = stringArray;
        boolean ok = WhatsappBotKt.jsonCheckKeys(this, json, keys);
        if (!ok) {
            String[] stringArray2 = new String[]{"error", "json invalido"};
            return stringArray2;
        }
        if (!Intrinsics.areEqual((Object)String.valueOf(json.get((Object)"object")), (Object)"whatsapp_business_account")) {
            String[] stringArray3 = new String[]{"error", "json invalido (versao)"};
            return stringArray3;
        }
        Object object = json.get((Object)"entry");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.simple.JSONArray");
        JSONArray entry = (JSONArray)object;
        int i = 0;
        int n = entry.size() - 1;
        if (i <= n) {
            while (true) {
                Object object2 = entry.get(i);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.json.simple.JSONObject");
                this.dispatchEntry((JSONObject)object2, (Function1<? super Message, Unit>)((Function1)new Function1<Message, Unit>(cb){
                    final /* synthetic */ Function6<String, String, String, String, String, String, Boolean> $cb;
                    {
                        this.$cb = $cb;
                        super(1);
                    }

                    public final void invoke(@NotNull Message msgpack) {
                        Intrinsics.checkNotNullParameter((Object)msgpack, (String)"msgpack");
                        msgpack.performMessages(this.$cb);
                    }
                }));
                if (i == n) break;
                ++i;
            }
        }
        String[] stringArray4 = new String[]{"OK"};
        return stringArray4;
    }
}

