/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.Device;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NativeDevice
extends Device
implements AutoCloseable {
    @Override
    public void close() throws Exception {
        this.deviceFreeC(this.nativeptr);
        this.sendMessage(5, "close (free): " + this.modelo);
    }

    public NativeDevice(JSONObject c) {
        super(c);
        try {
            this.nativeptr = this.deviceNewC(c.toString());
            if (this.config.containsKey((Object)"modelo")) {
                this.setId(this.config.get((Object)"modelo").toString() + "|" + this.getNro());
            }
        }
        catch (UnsatisfiedLinkError ule) {
            this.verboseFATAL("Falha ao tentar carregar '.so' ou '.dll'.");
        }
    }

    public void finalize() {
        this.deviceFreeC(this.nativeptr);
    }

    protected Object string2json(String str) {
        if (str == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        Object json = null;
        try {
            json = parser.parse(str);
        }
        catch (ParseException pe) {
            this.verboseERROR("Falha ao tentar converter JSON: '" + str + "'");
            return null;
        }
        return json;
    }

    private int insertArray(JSONArray users, JSONArray in, JSONArray out) {
        JSONObject reg2 = null;
        int qty = 0;
        if (in == null) {
            return -1;
        }
        for (JSONObject reg2 : in) {
            out.add((Object)reg2);
            ++qty;
        }
        Device.fillResult(users, out);
        return qty;
    }

    @Override
    public void getInfo(JSONObject c) {
        String sinfo = this.getInfoC(this.nativeptr, -1L);
        JSONObject ret2 = (JSONObject)this.string2json(sinfo);
        if (ret2 == null) {
            return;
        }
        for (Object key : ret2.keySet()) {
            c.put(key, ret2.get(key));
        }
    }

    @Override
    public Date getTime() throws UnsatisfiedLinkError {
        Date dt = new Date();
        long unixtime = this.getTimeC(this.nativeptr, -1L);
        if (unixtime == 0L) {
            return null;
        }
        dt.setTime(unixtime * 1000L);
        return dt;
    }

    @Override
    public boolean setTime(int diff) {
        this.setTimeC(this.nativeptr, diff);
        return true;
    }

    @Override
    public int sendUsers(JSONArray usrs, JSONArray results) {
        String sres = this.sendUsersC(this.nativeptr, usrs.toString());
        JSONArray res = (JSONArray)this.string2json(sres);
        int qty = this.insertArray(usrs, res, results);
        return qty;
    }

    @Override
    public int getEvents(JSONArray offs) {
        IfaceJSONIter InsertOffs = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject evt, Object[] pars, int[] max) {
                JSONArray offs = (JSONArray)pars[0];
                int nsr = 0;
                offs.add((Object)evt);
                if (!evt.containsKey((Object)"nsr")) {
                    return 0;
                }
                try {
                    nsr = Integer.parseInt(evt.get((Object)"nsr").toString());
                }
                catch (NumberFormatException nfe) {
                    NativeDevice.this.verboseERROR("NSR corrompido.");
                }
                if (nsr > max[0]) {
                    max[0] = nsr;
                }
                return 0;
            }
        };
        String sevts = this.getEventsC(this.nativeptr, this.getNsr() + 1);
        JSONArray evts = (JSONArray)this.string2json(sevts);
        if (evts == null) {
            this.verboseERROR("Falha comunicacao.");
            return -1;
        }
        int[] max_nsr = new int[]{0};
        Util.jsonIter(evts, InsertOffs, new Object[]{offs}, max_nsr);
        if (max_nsr[0] < this.getNsr()) {
            max_nsr[0] = 0;
        }
        return max_nsr[0];
    }

    @Override
    public int sendBio(JSONArray usrs, JSONArray results) {
        String sres = this.sendBioC(this.nativeptr, usrs.toString());
        JSONArray res = (JSONArray)this.string2json(sres);
        int qty = this.insertArray(usrs, res, results);
        return qty;
    }

    @Override
    public JSONArray getUsers() {
        String usrs = this.getUsersC(this.nativeptr);
        JSONArray r = (JSONArray)this.string2json(usrs);
        return r;
    }

    @Override
    public int getBio(JSONArray usrs) {
        String sbios = this.getBioC(this.nativeptr, usrs.toString());
        JSONArray bios = (JSONArray)this.string2json(sbios);
        int qty = 0;
        if (bios == null) {
            return 0;
        }
        for (JSONObject reg : bios) {
            if (!reg.containsKey((Object)"templates")) continue;
            usrs.add((Object)reg);
            ++qty;
        }
        return qty;
    }

    @Override
    protected int getEndIterDelay() {
        return this.getEndIterDelayC(this.nativeptr);
    }

    public static int getDescriptor(OutputStream os) throws IOException {
        FileDescriptor fd = ((FileOutputStream)os).getFD();
        return NativeDevice.getDescriptor(fd);
    }

    public static int getDescriptor(InputStream is) throws IOException {
        FileDescriptor fd = ((FileInputStream)is).getFD();
        return NativeDevice.getDescriptor(fd);
    }

    public static int getDescriptor(FileDescriptor fd) {
        return 0;
    }
}

