/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.IfpontoDB;
import com.ifractal.ifponto.SIINListener;
import com.ifractal.ifponto.Version;
import com.ifractal.utils.ConcurrentListener;
import com.ifractal.utils.Getopts;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Util;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SIIN
extends Producer
implements Runnable {
    public static final String OS = System.getProperty("os.name").toLowerCase();
    private static SIINListener[] listeners = null;
    private static SIIN siin = null;
    private static Thread thread = null;
    protected static Observer observer = null;
    protected static boolean enabled = false;
    protected static boolean alive = false;
    protected IfpontoDB idb = null;
    public int progressPos = 0;
    public int progressTotal = 8;
    public String notify = "";

    public static SIIN getInstance(String[] args, IfpontoDB db, SIINListener sl) {
        if (siin != null) {
            return siin;
        }
        siin = new SIIN(args, db, sl);
        thread = new Thread((Runnable)siin, "SIIN");
        return siin;
    }

    private SIIN(String[] args, IfpontoDB db, SIINListener sl) {
        super(sl);
        this.idb = db;
        observer = sl;
        this.addListener(sl);
    }

    protected void setEnable(boolean e) {
        enabled = e;
    }

    protected int addListener(SIINListener sl) {
        if (sl == null) {
            return 0;
        }
        if (listeners == null) {
            listeners = new SIINListener[]{sl};
            return 1;
        }
        int len = listeners.length;
        SIINListener[] list = new SIINListener[len + 1];
        for (int i = 0; i < len; ++i) {
            list[i] = listeners[i];
        }
        list[len] = sl;
        listeners = list;
        return len + 1;
    }

    protected void notifyLoop(boolean alive) {
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            if (alive) {
                sl.onStart();
                continue;
            }
            sl.onStop();
            this.progressPos = 0;
            this.notify = "Modulo parado";
            this.notifyProgress();
        }
    }

    protected void notifyProgress() {
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            sl.onProgress(this.progressTotal, this.progressPos, this.notify);
        }
    }

    protected void notifyFinalize(String msg) {
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            if (msg == null) {
                sl.onSynchronized();
                this.progressPos = 8;
                this.notify = "Sincronizado";
                continue;
            }
            sl.onFail(msg);
            this.progressPos = 0;
            this.notify = "Falha na sincroniza\u00e7\u00e3o";
        }
        this.notifyProgress();
    }

    protected void notifyEnable(String key) {
        if (key == null) {
            this.setEnable(false);
        } else {
            this.setEnable(true);
        }
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            sl.onEnable(key);
        }
    }

    protected void notifyIdle() {
        if (listeners == null) {
            return;
        }
        for (SIINListener sl : listeners) {
            sl.onIdle();
        }
        for (int i = 0; i < 60; ++i) {
            this.progressTotal = 60;
            this.progressPos = i;
            this.notify = null;
            this.notifyProgress();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void makeStatus(JSONObject jstatus, String msg) {
        long unixtime = new Date().getTime() / 1000L;
        jstatus.put((Object)"unixtime", (Object)unixtime);
        jstatus.put((Object)"msg", (Object)msg);
        jstatus.put((Object)"notificacoes", jstatus.get((Object)"msg"));
    }

    protected JSONArray getStatusDevices(IfpontoDB db, JSONObject jdata) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jdev, Object[] pars, int[] c) {
                if (jdev.get((Object)"ativo").toString().equals("0")) {
                    return 0;
                }
                IfpontoDB db = (IfpontoDB)pars[0];
                JSONArray res = (JSONArray)pars[1];
                String nro = jdev.get((Object)"nro").toString();
                JSONObject jstatus = new JSONObject();
                JSONArray jeventos = null;
                try {
                    jstatus = (JSONObject)jdev.get((Object)"status");
                }
                catch (ClassCastException cce) {
                    String msg = "OFFLINE.";
                    SIIN.this.sendMessage(3, msg);
                    jstatus = new JSONObject();
                    SIIN.this.makeStatus(jstatus, msg);
                }
                jstatus.put((Object)"codigo", (Object)jdev.get((Object)"codigo").toString());
                jstatus.put((Object)"nro", (Object)nro);
                int limit = Integer.parseInt(IfpontoDB.config.get("QTD_OFF_FILES").toString());
                String modelo = jdev.get((Object)"modelo").toString();
                for (String m : Device.models_without_afd) {
                    if (!modelo.equals(m)) continue;
                    jeventos = db.getNotSyncEvents(Integer.parseInt(nro), limit);
                }
                if (jeventos == null) {
                    jeventos = db.getNotSyncEventsAfd(Integer.parseInt(nro), limit);
                }
                JSONArray jpessoas = db.getNotSyncResults(Integer.parseInt(nro), limit);
                if (jeventos != null) {
                    jstatus.put((Object)"eventos", (Object)jeventos);
                }
                if (jpessoas != null) {
                    jstatus.put((Object)"pessoas", (Object)jpessoas);
                }
                res.add((Object)jstatus);
                return 0;
            }
        };
        JSONArray res = new JSONArray();
        JSONArray devs = db.getDevices();
        if (devs == null) {
            return new JSONArray();
        }
        Util.jsonIter(devs, iter, new Object[]{db, res}, null);
        if (res == null || res.size() < 1) {
            return res;
        }
        JSONObject dev0 = (JSONObject)res.get(0);
        int limit = Integer.parseInt(IfpontoDB.config.get("QTD_OFF_FILES").toString());
        JSONArray jtemps = db.getNotSyncBios(limit);
        if (jtemps != null && jtemps.size() > 0) {
            dev0.put((Object)"templates", (Object)jtemps);
        }
        return res;
    }

    protected JSONObject processSIIN(final IfpontoDB db) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject dev, Object[] pars, int[] c) {
                SIIN.this.progressPos = 3;
                SIIN.this.notify = "Atualiza eventos sincronizados";
                SIIN.this.notifyProgress();
                if (dev.containsKey((Object)"eventos")) {
                    db.updateSyncEvents((JSONArray)dev.get((Object)"eventos"));
                }
                SIIN.this.progressPos = 4;
                SIIN.this.notify = "Atualiza pessoas sincronizadas";
                SIIN.this.notifyProgress();
                if (dev.containsKey((Object)"pessoas")) {
                    db.updateSyncResults((JSONArray)dev.get((Object)"pessoas"));
                }
                SIIN.this.progressPos = 5;
                SIIN.this.notify = "Atualiza templates sincronizados";
                SIIN.this.notifyProgress();
                if (dev.containsKey((Object)"templates")) {
                    db.updateSyncBios((JSONArray)dev.get((Object)"templates"));
                }
                return 0;
            }
        };
        long now = new Date().getTime() / 1000L;
        JSONObject jdata = new JSONObject();
        JSONObject jinfo = Util.getInfo(androidContext);
        JSONArray devs = new JSONArray();
        String webhost = IfpontoDB.config.get("WEBHOST");
        String webport = IfpontoDB.config.get("WEBPORT");
        String clientid = IfpontoDB.config.get("CLIENTID");
        String siinpath = IfpontoDB.config.get("SIIN_PATH");
        String id = IfpontoDB.config.get("ID");
        String chave = IfpontoDB.config.get("CHAVE");
        String readers = IfpontoDB.config.get("READERS");
        String key = "";
        jdata.put((Object)"modulo", (Object)"SIIN");
        jdata.put((Object)"versao", (Object)Version.getFormatedText());
        jdata.put((Object)"info", (Object)jinfo);
        jinfo.put((Object)"READERS", (Object)readers);
        jinfo.put((Object)"CHAVE", (Object)chave);
        jinfo.put((Object)"CLIENTID", (Object)clientid);
        jinfo.put((Object)"ID", (Object)id);
        if (chave == null || chave.equals("")) {
            int i = clientid.indexOf("/");
            key = clientid.substring(i + 1);
        } else {
            devs = this.getStatusDevices(db, jdata);
            jdata.put((Object)"equipamentos", (Object)devs);
            key = String.format("%02X%s%02X", now >> 16 & 0xFFL, chave, now >> 8 & 0xFFL);
        }
        byte[] dados = Util.processRC4(1, key, jdata.toString().getBytes());
        if (dados == null) {
            this.sendMessage(2, "Poss\u00edvel chave inv\u00e1lida: '" + key + "' - verificar CLIENTID");
            return null;
        }
        String[] post = new String[]{"unixtime", "" + now, "dados", Util.byte2base64(dados)};
        String query = clientid + "/db/" + siinpath;
        if (!readers.equals("")) {
            query = query + "?nros=%5B" + readers + "%5D";
        }
        URL url = Util.getURL("https", webhost, webport, query);
        this.sendMessage(5, "JSON Request: " + jdata.toString());
        this.sendMessage(5, "HOST: " + url.toString());
        String resp = null;
        JSONObject jresp = null;
        this.progressPos = 2;
        this.notify = "Envia requisi\u00e7\u00e3o ao sistema";
        this.notifyProgress();
        String b64 = Util.sendFORM(this, url, post);
        if (b64 == null) {
            String msg = "Erro ao tentar acessar servidor.";
            this.sendMessage(1, msg, 500);
            return null;
        }
        if (b64.charAt(0) == '{') {
            resp = b64;
        } else {
            byte[] cipher = Util.base642byte(b64);
            resp = new String(Util.processRC4(2, key, cipher));
        }
        try {
            JSONParser parser = new JSONParser();
            jresp = (JSONObject)parser.parse(resp);
        }
        catch (ParseException pe) {
            this.sendMessage(2, "Servidor n\u00e3o est\u00e1 respondendo adequadamente - Verifique o nome do sistema CLIENTID.");
            this.sendMessage(2, "Falha ao tentar abrir JSON:");
            this.sendMessage(2, resp);
        }
        Util.jsonIter(devs, iter, null, null);
        return jresp;
    }

    protected boolean processResponse(IfpontoDB db, JSONObject jdata) {
        if (!jdata.containsKey((Object)"erro")) {
            this.notifyFinalize("Servi\u00e7o Indispon\u00edvel. (1)");
            return false;
        }
        try {
            int err = Integer.parseInt(jdata.get((Object)"erro").toString());
            if (err == 0) {
                this.notifyEnable(IfpontoDB.config.get("CHAVE").toString());
            } else if (err == 1) {
                this.notifyEnable(null);
            }
            if (err != 0) {
                if (jdata.containsKey((Object)"msg")) {
                    this.notifyFinalize(jdata.get((Object)"msg").toString());
                    IfpontoDB.config.put("CHAVE", "");
                    Getopts.saveIniFile(IfpontoDB.config, IfpontoDB.INIFILE);
                } else {
                    this.notifyFinalize("Servi\u00e7o indispon\u00edvel. (2)");
                }
                return false;
            }
            if (jdata.containsKey((Object)"id")) {
                String key = jdata.get((Object)"id").toString();
                IfpontoDB.config.put("CHAVE", key);
                Getopts.saveIniFile(IfpontoDB.config, IfpontoDB.INIFILE);
                this.notifyEnable(key);
                return true;
            }
            if (!jdata.containsKey((Object)"equipamentos")) {
                return true;
            }
            this.progressPos = 7;
            this.notify = "Atualizando banco de dados";
            this.notifyProgress();
            db.updateDevices((JSONArray)jdata.get((Object)"equipamentos"));
        }
        catch (IOException ioe) {
            this.sendMessage(2, "Falha ao tentar salvar: " + IfpontoDB.INIFILE);
        }
        catch (NumberFormatException nfe) {
            this.sendMessage(2, "Erro interno.");
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        alive = true;
        this.notifyLoop(alive);
        if (this.observers.length < 2) {
            this.addObserver(this);
        }
        while (alive) {
            this.progressPos = 1;
            this.notify = "Inicia loop";
            this.notifyProgress();
            JSONObject jdata = this.processSIIN(this.idb);
            if (jdata != null) {
                this.sendMessage(5, "Resp: " + jdata.toString());
                this.sendMessage(5, "Marca todos os equipamentos como inativos.");
                this.idb.disableDevices();
                this.progressPos = 6;
                this.notify = "Processando resposta do sistema";
                this.notifyProgress();
                boolean r = this.processResponse(this.idb, jdata);
                if (r) {
                    this.notifyFinalize(null);
                } else {
                    this.notifyFinalize("Falha sincroniza\u00e7\u00e3o.");
                }
            } else {
                this.notifyFinalize("Falha comunica\u00e7\u00e3o com o sistema.");
            }
            this.notifyIdle();
            this.progressPos = 0;
            this.notify = "Fim do loop";
            this.notifyProgress();
        }
        this.notifyLoop(alive);
    }

    public <T> Thread call(T ctx, ConcurrentListener<T> cl, String[] args) {
        Thread th = this.concurrentCall(ctx, cl, args);
        return th;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void startSIINLoop() {
        if (thread != null && thread.isAlive()) {
            return;
        }
        thread = new Thread((Runnable)this, "SIIN");
        thread.start();
    }

    public void stopSIINLoop() {
        alive = false;
    }

    public static final JSONObject getInfo(String modulo, HashMap<String, String> conf, Object androidContext) {
        String[] keys;
        JSONObject jdata = new JSONObject();
        JSONObject jinfo = Util.getInfo(androidContext);
        for (String key : keys = new String[]{"READERS", "CHAVE", "CLIENTID", "ID"}) {
            if (!conf.containsKey(key)) continue;
            jdata.put((Object)key, (Object)conf.get(key));
        }
        jdata.put((Object)"modulo", (Object)modulo);
        jdata.put((Object)"versao", (Object)Version.getFormatedText());
        jdata.put((Object)"info", (Object)jinfo);
        return jdata;
    }
}

