/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.file;

import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.TextStreamOutput;
import com.github.akurilov.commons.io.file.FileOutput;
import com.github.akurilov.commons.io.file.TextFileInput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TextFileOutput
extends TextStreamOutput
implements FileOutput<String> {
    private final Path filePath;

    public TextFileOutput() throws IOException {
        this(Files.createTempFile(null, ".txt", new FileAttribute[0]));
    }

    public TextFileOutput(Path filePath) throws IOException {
        super(Files.newOutputStream(filePath, OUTPUT_OPEN_OPTIONS));
        this.filePath = filePath;
    }

    @Override
    public Input<String> getInput() throws IOException {
        return new TextFileInput(this.filePath);
    }

    @Override
    public Path getFilePath() {
        return this.filePath;
    }
}

