/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.file;

import com.github.akurilov.commons.io.BinOutput;
import com.github.akurilov.commons.io.file.BinFileInput;
import com.github.akurilov.commons.io.file.FileOutput;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class BinFileOutput<T>
extends BinOutput<T>
implements FileOutput<T> {
    protected final Path dstPath;

    public BinFileOutput(Path dstPath) throws IOException {
        super(new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(dstPath, OUTPUT_OPEN_OPTIONS))));
        this.dstPath = dstPath;
    }

    public BinFileOutput() throws IOException {
        this(Files.createTempFile(null, ".bin", new FileAttribute[0]));
        this.dstPath.toFile().deleteOnExit();
    }

    @Override
    public BinFileInput<T> getInput() throws IOException {
        return new BinFileInput(this.dstPath);
    }

    @Override
    public String toString() {
        return "binFileOutput<" + this.dstPath.getFileName() + ">";
    }

    @Override
    public final Path getFilePath() {
        return this.dstPath;
    }
}

