/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.file;

import com.github.akurilov.commons.io.BinInput;
import com.github.akurilov.commons.io.file.FileInput;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.Path;

public class BinFileInput<T>
extends BinInput<T>
implements FileInput<T> {
    protected final Path srcPath;

    public BinFileInput(Path srcPath) throws IOException {
        super(BinFileInput.buildObjectInputStream(srcPath));
        this.srcPath = srcPath;
    }

    protected static ObjectInputStream buildObjectInputStream(Path itemsSrcPath) throws IOException {
        return new ObjectInputStream(new BufferedInputStream(Files.newInputStream(itemsSrcPath, INPUT_OPEN_OPTIONS)));
    }

    @Override
    public String toString() {
        return "binFileInput<" + this.srcPath.getFileName() + ">";
    }

    @Override
    public final Path getFilePath() {
        return this.srcPath;
    }

    @Override
    public void reset() throws IOException {
        if (this.itemsSrc != null) {
            this.itemsSrc.close();
        }
        this.setItemsSrc(BinFileInput.buildObjectInputStream(this.srcPath));
    }
}

