/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.collection.ArrayInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

public class CircularArrayInput<T>
extends ArrayInput<T> {
    public CircularArrayInput(T[] items) {
        super(items);
    }

    @Override
    public T get() throws IOException {
        if (this.i >= this.size) {
            this.reset();
        }
        return (T)this.items[this.i++];
    }

    @Override
    public int get(List<T> buffer, int maxCount) throws EOFException, IOException {
        int n;
        for (n = 0; n < maxCount; n += super.get(buffer, Math.min(this.size - this.i, maxCount - n))) {
            if (this.i < this.size) continue;
            this.reset();
        }
        return n;
    }

    @Override
    public String toString() {
        return "circularArrayInput<" + this.items.hashCode() + ">";
    }
}

