/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.collection.ListInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class BufferingInputBase<T>
extends ListInput<T> {
    protected final int capacity;

    public BufferingInputBase(int capacity) {
        super(new ArrayList(capacity));
        this.capacity = capacity;
    }

    private int loadMore() throws IOException {
        T lastItem = this.size > 0 ? (T)this.items.get(this.size - 1) : null;
        this.i = 0;
        this.items.clear();
        this.size = this.loadMoreItems(lastItem);
        return this.size;
    }

    protected abstract int loadMoreItems(T var1) throws IOException;

    @Override
    public final T get() throws IOException {
        if (this.i == this.size && this.loadMore() <= 0) {
            throw new EOFException();
        }
        return (T)this.items.get(this.i++);
    }

    @Override
    public final int get(List<T> buffer, int maxCount) throws IOException {
        int n = this.size - this.i;
        if (n == 0 && this.loadMore() <= 0) {
            throw new EOFException();
        }
        n = Math.min(this.size - this.i, maxCount);
        for (int j = this.i; j < this.i + n; ++j) {
            buffer.add(this.items.get(j));
        }
        this.i += n;
        return n;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.items.clear();
    }
}

