/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.collection;

import com.github.akurilov.commons.collection.Listable;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.map.AbstractLinkedMap;
import org.apache.commons.collections4.map.LRUMap;

public class ListingLRUMap<K, V>
extends LRUMap<K, V>
implements Listable<V> {
    private final AtomicInteger size = new AtomicInteger(0);

    public ListingLRUMap(int capacity) {
        super(capacity);
    }

    public int size() {
        return this.size.get();
    }

    public V put(K key, V value) {
        Object oldValue = super.put(key, value);
        if (null == oldValue) {
            this.size.incrementAndGet();
        }
        return (V)oldValue;
    }

    public V remove(Object key) {
        Object value = super.remove(key);
        if (value != null) {
            this.size.decrementAndGet();
        }
        return (V)value;
    }

    @Override
    public V list(String afterObjectId, Collection<V> outputBuffer, int limit) {
        if (this.isEmpty()) {
            return null;
        }
        AbstractLinkedMap.LinkEntry nextEntry = this.getEntry(afterObjectId);
        for (int i = 0; i < limit && (nextEntry = nextEntry == null ? this.getEntry(this.firstKey()) : this.entryAfter(nextEntry)) != null && nextEntry.getKey() != null; ++i) {
            outputBuffer.add(nextEntry.getValue());
        }
        return (V)(nextEntry == null || nextEntry.getKey() == null ? null : nextEntry.getValue());
    }

    protected void moveToMRU(AbstractLinkedMap.LinkEntry<K, V> entry) {
    }

    protected void decrementSize() {
        this.size.decrementAndGet();
    }
}

