/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import java.io.IOException;
import java.io.OutputStream;

public class FastBufferedOutputStream
extends OutputStream {
    private static final boolean ASSERTS = false;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected byte[] buffer;
    protected int pos;
    protected int avail;
    protected OutputStream os;

    public FastBufferedOutputStream(OutputStream os, int bufferSize) {
        this.os = os;
        this.buffer = new byte[bufferSize];
        this.avail = bufferSize;
    }

    public FastBufferedOutputStream(OutputStream os) {
        this(os, 8192);
    }

    private void dumpBuffer(boolean ifFull) throws IOException {
        if (!ifFull || this.avail == 0) {
            this.os.write(this.buffer, 0, this.pos);
            this.pos = 0;
            this.avail = this.buffer.length;
        }
    }

    public void write(int b) throws IOException {
        --this.avail;
        this.buffer[this.pos++] = (byte)b;
        this.dumpBuffer(true);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if (length >= this.buffer.length) {
            this.dumpBuffer(false);
            this.os.write(b, offset, length);
            return;
        }
        if (length <= this.avail) {
            System.arraycopy(b, offset, this.buffer, this.pos, length);
            this.pos += length;
            this.avail -= length;
            this.dumpBuffer(true);
            return;
        }
        this.dumpBuffer(false);
        System.arraycopy(b, offset, this.buffer, 0, length);
        this.pos = length;
        this.avail -= length;
    }

    public void flush() throws IOException {
        this.dumpBuffer(false);
        this.os.flush();
    }

    public void close() throws IOException {
        if (this.os == null) {
            return;
        }
        this.flush();
        if (this.os != System.out) {
            this.os.close();
        }
        this.os = null;
        this.buffer = null;
    }
}

