/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2DoubleSortedMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSortedSet;
import it.unimi.dsi.fastutil.doubles.Double2DoubleMap;
import it.unimi.dsi.fastutil.doubles.Double2DoubleSortedMap;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Double2DoubleLinkedOpenHashMap
extends AbstractDouble2DoubleSortedMap
implements Serializable,
Cloneable,
Hash {
    protected transient double[] key;
    protected transient double[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSortedSet<Map.Entry<Double, Double>> entries;
    protected volatile transient DoubleSortedSet keys;
    protected volatile transient DoubleCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Double2DoubleLinkedOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new double[this.free];
        this.value = new double[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Double2DoubleLinkedOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Double2DoubleLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Double2DoubleLinkedOpenHashMap(Map<? extends Double, ? extends Double> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2DoubleLinkedOpenHashMap(Map<? extends Double, ? extends Double> m) {
        this(m, 0.75f);
    }

    public Double2DoubleLinkedOpenHashMap(Double2DoubleMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2DoubleLinkedOpenHashMap(Double2DoubleMap m) {
        this(m, 0.75f);
    }

    public Double2DoubleLinkedOpenHashMap(double[] k, double[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Double2DoubleLinkedOpenHashMap(double[] k, double[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(double k) {
        double[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(double k) {
        double[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public double put(double k, double v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            double oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    @Override
    public Double put(Double ok, Double ov) {
        double v = ov;
        double k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            double oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    @Override
    public boolean containsValue(double v) {
        double[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    @Override
    public double firstDoubleKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public double lastDoubleKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public DoubleComparator comparator() {
        return null;
    }

    @Override
    public Double2DoubleSortedMap tailMap(double from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2DoubleSortedMap headMap(double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2DoubleSortedMap subMap(double from, double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(double k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public double get(double k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    @Override
    public double remove(double k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return this.value[i];
    }

    public Double get(Double ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : Double.valueOf(this.value[i]);
    }

    @Override
    public Double remove(Object ok) {
        int i = this.findKey((Double)ok);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return this.value[i];
    }

    @Override
    public ObjectSortedSet<Map.Entry<Double, Double>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSortedSet<Map.Entry<Double, Double>>(){

                @Override
                public ObjectBidirectionalIterator<Map.Entry<Double, Double>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public Comparator<? super Map.Entry<Double, Double>> comparator() {
                    return null;
                }

                @Override
                public ObjectSortedSet<Map.Entry<Double, Double>> subSet(Map.Entry<Double, Double> fromElement, Map.Entry<Double, Double> toElement) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ObjectSortedSet<Map.Entry<Double, Double>> headSet(Map.Entry<Double, Double> toElement) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ObjectSortedSet<Map.Entry<Double, Double>> tailSet(Map.Entry<Double, Double> fromElement) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Map.Entry<Double, Double> first() {
                    if (Double2DoubleLinkedOpenHashMap.this.count == 0) {
                        throw new NoSuchElementException();
                    }
                    return new MapEntry(Double2DoubleLinkedOpenHashMap.this.first);
                }

                @Override
                public Map.Entry<Double, Double> last() {
                    if (Double2DoubleLinkedOpenHashMap.this.count == 0) {
                        throw new NoSuchElementException();
                    }
                    return new MapEntry(Double2DoubleLinkedOpenHashMap.this.last);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Double2DoubleLinkedOpenHashMap.this.findKey((Double)e.getKey());
                    return i >= 0 && Double2DoubleLinkedOpenHashMap.this.value[i] == (Double)e.getValue();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Double2DoubleLinkedOpenHashMap.this.findKey((Double)e.getKey());
                    if (i >= 0) {
                        Double2DoubleLinkedOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                @Override
                public int size() {
                    return Double2DoubleLinkedOpenHashMap.this.count;
                }

                @Override
                public void clear() {
                    Double2DoubleLinkedOpenHashMap.this.clear();
                }

                @Override
                public ObjectBidirectionalIterator<Map.Entry<Double, Double>> iterator(Map.Entry<Double, Double> from) {
                    return new EntryIterator(from.getKey());
                }
            };
        }
        return this.entries;
    }

    @Override
    public DoubleSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public DoubleCollection values() {
        if (this.values == null) {
            this.values = new AbstractDoubleCollection(){

                public DoubleIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Double2DoubleLinkedOpenHashMap.this.count;
                }

                public boolean contains(double v) {
                    return Double2DoubleLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Double2DoubleLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        double[] key = this.key;
        double[] newKey = new double[newN];
        double[] value = this.value;
        double[] newValue = new double[newN];
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            double k = key[i];
            double v = value[i];
            int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Object clone() {
        Double2DoubleLinkedOpenHashMap c;
        try {
            c = (Double2DoubleLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (double[])this.key.clone();
        c.value = (double[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = HashCommon.double2int(this.key[i]);
            h += (t ^= HashCommon.double2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        double[] key = this.key;
        double[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeDouble(key[e]);
            s.writeDouble(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new double[n];
        double[] key = this.key;
        this.value = new double[n];
        double[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            double k = s.readDouble();
            double v = s.readDouble();
            int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements DoubleListIterator {
        public double previousDouble() {
            return Double2DoubleLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Double previous() {
            return Double2DoubleLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public void set(Double ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Double ok) {
            throw new UnsupportedOperationException();
        }

        public void set(double v) {
            throw new UnsupportedOperationException();
        }

        public void add(double v) {
            throw new UnsupportedOperationException();
        }

        public double nextDouble() {
            return Double2DoubleLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Double next() {
            return Double2DoubleLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractDoubleSortedSet {
        private KeySet() {
        }

        public DoubleBidirectionalIterator iterator(double from) {
            return new KeyIterator(from);
        }

        public DoubleBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Double2DoubleLinkedOpenHashMap.this.count;
        }

        public boolean contains(double k) {
            return Double2DoubleLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(double k) {
            int oldCount = Double2DoubleLinkedOpenHashMap.this.count;
            Double2DoubleLinkedOpenHashMap.this.remove(k);
            return Double2DoubleLinkedOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Double2DoubleLinkedOpenHashMap.this.clear();
        }

        public double firstDouble() {
            if (Double2DoubleLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Double2DoubleLinkedOpenHashMap.this.key[Double2DoubleLinkedOpenHashMap.this.first];
        }

        public double lastDouble() {
            if (Double2DoubleLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Double2DoubleLinkedOpenHashMap.this.key[Double2DoubleLinkedOpenHashMap.this.last];
        }

        public DoubleComparator comparator() {
            return null;
        }

        public final DoubleSortedSet tailSet(double from) {
            throw new UnsupportedOperationException();
        }

        public final DoubleSortedSet headSet(double to) {
            throw new UnsupportedOperationException();
        }

        public final DoubleSortedSet subSet(double from, double to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements DoubleListIterator {
        public KeyIterator(double k) {
            super(k);
        }

        public double previousDouble() {
            return Double2DoubleLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(double k) {
            throw new UnsupportedOperationException();
        }

        public void add(double k) {
            throw new UnsupportedOperationException();
        }

        public Double previous() {
            return Double2DoubleLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(Double ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Double ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        public double nextDouble() {
            return Double2DoubleLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public Double next() {
            return Double2DoubleLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Map.Entry<Double, Double>> {
        public EntryIterator() {
        }

        public EntryIterator(double from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Map.Entry<Double, Double> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<Double, Double> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Double2DoubleLinkedOpenHashMap.this.first;
        }

        MapIterator(double from) {
            if (Double2DoubleLinkedOpenHashMap.this.key[Double2DoubleLinkedOpenHashMap.this.last] == from) {
                this.prev = Double2DoubleLinkedOpenHashMap.this.last;
                this.index = Double2DoubleLinkedOpenHashMap.this.count;
            } else {
                int e;
                if (!Double2DoubleLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Double2DoubleLinkedOpenHashMap.this.first;
                while (Double2DoubleLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Double2DoubleLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Double2DoubleLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Double2DoubleLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Double2DoubleLinkedOpenHashMap.this.state[this.curr] = 1;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Double2DoubleLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Double2DoubleLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Double2DoubleLinkedOpenHashMap.this.count;
            if (this.prev == -1) {
                Double2DoubleLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Double2DoubleLinkedOpenHashMap.this.link[n] = Double2DoubleLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Double2DoubleLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Double2DoubleLinkedOpenHashMap.this.link[n] = Double2DoubleLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Double2DoubleMap.Entry,
    Map.Entry<Double, Double> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Double getKey() {
            return Double2DoubleLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public double getDoubleKey() {
            return Double2DoubleLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Double getValue() {
            return Double2DoubleLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public double getDoubleValue() {
            return Double2DoubleLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public double setValue(double v) {
            double oldValue = Double2DoubleLinkedOpenHashMap.this.value[this.index];
            Double2DoubleLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Double setValue(Double v) {
            return this.setValue((double)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Double2DoubleLinkedOpenHashMap.this.key[this.index] == (Double)e.getKey() && Double2DoubleLinkedOpenHashMap.this.value[this.index] == (Double)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(Double2DoubleLinkedOpenHashMap.this.key[this.index]) ^ HashCommon.double2int(Double2DoubleLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Double2DoubleLinkedOpenHashMap.this.key[this.index] + "->" + Double2DoubleLinkedOpenHashMap.this.value[this.index];
        }
    }
}

