/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.CircularList;
import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.ReversedList;
import com.machinezoo.sourceafis.SkeletonMinutia;
import java.util.List;

class SkeletonRidge {
    final List<IntPoint> points;
    final SkeletonRidge reversed;
    private SkeletonMinutia startMinutia;
    private SkeletonMinutia endMinutia;

    SkeletonRidge() {
        this.points = new CircularList<IntPoint>();
        this.reversed = new SkeletonRidge(this);
    }

    SkeletonRidge(SkeletonRidge reversed) {
        this.points = new ReversedList<IntPoint>(reversed.points);
        this.reversed = reversed;
    }

    SkeletonMinutia start() {
        return this.startMinutia;
    }

    void start(SkeletonMinutia value) {
        if (this.startMinutia != value) {
            if (this.startMinutia != null) {
                SkeletonMinutia detachFrom = this.startMinutia;
                this.startMinutia = null;
                detachFrom.detachStart(this);
            }
            this.startMinutia = value;
            if (this.startMinutia != null) {
                this.startMinutia.attachStart(this);
            }
            this.reversed.endMinutia = value;
        }
    }

    SkeletonMinutia end() {
        return this.endMinutia;
    }

    void end(SkeletonMinutia value) {
        if (this.endMinutia != value) {
            this.endMinutia = value;
            this.reversed.start(value);
        }
    }

    void detach() {
        this.start(null);
        this.end(null);
    }

    double direction() {
        int first = 1;
        int last = 21;
        if (last >= this.points.size()) {
            int shift = last - this.points.size() + 1;
            last -= shift;
            first -= shift;
        }
        if (first < 0) {
            first = 0;
        }
        return DoubleAngle.atan(this.points.get(first), this.points.get(last));
    }
}

