/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.noexception.Exceptions;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

class PlatformCheck {
    private static final Pattern versionRe1 = Pattern.compile("1\\.([0-9]{1,3})\\..*");
    private static final Pattern versionRe2 = Pattern.compile("([0-9]{1,3})\\..*");

    PlatformCheck() {
    }

    private static void requireJava() {
        String version = System.getProperty("java.version");
        if (version != null) {
            Matcher matcher = versionRe1.matcher(version);
            if (!matcher.matches() && !(matcher = versionRe2.matcher(version)).matches()) {
                return;
            }
            int major = Integer.parseInt(matcher.group(1));
            if (major < 8) {
                throw new RuntimeException("SourceAFIS requires Java 8 or higher. Currently running JRE " + version + ".");
            }
        }
    }

    static void run() {
    }

    static byte[] resource(String filename) {
        return (byte[])Exceptions.wrap(ex -> new IllegalStateException("Cannot read SourceAFIS resource: " + filename + ". Use proper dependency management tool.", (Throwable)ex)).get(() -> {
            try (InputStream stream = PlatformCheck.class.getResourceAsStream(filename);){
                if (stream == null) {
                    throw new IllegalStateException("SourceAFIS resource not found: " + filename + ". Use proper dependency management tool.");
                }
                byte[] byArray = IOUtils.toByteArray((InputStream)stream);
                return byArray;
            }
        });
    }

    static boolean hasClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static {
        PlatformCheck.requireJava();
    }
}

