/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.FingerprintCompatibility;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.MinutiaType;
import com.machinezoo.sourceafis.MutableMinutia;
import com.machinezoo.sourceafis.MutableTemplate;
import java.util.ArrayList;
import java.util.Objects;

class PersistentTemplate {
    String version;
    int width;
    int height;
    int[] positionsX;
    int[] positionsY;
    double[] directions;
    String types;

    PersistentTemplate() {
    }

    PersistentTemplate(MutableTemplate mutable) {
        this.version = FingerprintCompatibility.version();
        this.width = mutable.size.x;
        this.height = mutable.size.y;
        int count = mutable.minutiae.size();
        this.positionsX = new int[count];
        this.positionsY = new int[count];
        this.directions = new double[count];
        char[] chars = new char[count];
        for (int i = 0; i < count; ++i) {
            MutableMinutia minutia = mutable.minutiae.get(i);
            this.positionsX[i] = minutia.position.x;
            this.positionsY[i] = minutia.position.y;
            this.directions[i] = minutia.direction;
            chars[i] = minutia.type == MinutiaType.BIFURCATION ? 66 : 69;
        }
        this.types = new String(chars);
    }

    MutableTemplate mutable() {
        MutableTemplate mutable = new MutableTemplate();
        mutable.size = new IntPoint(this.width, this.height);
        mutable.minutiae = new ArrayList<MutableMinutia>();
        for (int i = 0; i < this.types.length(); ++i) {
            MinutiaType type = this.types.charAt(i) == 'B' ? MinutiaType.BIFURCATION : MinutiaType.ENDING;
            mutable.minutiae.add(new MutableMinutia(new IntPoint(this.positionsX[i], this.positionsY[i]), this.directions[i], type));
        }
        return mutable;
    }

    void validate() {
        Objects.requireNonNull(this.positionsX, "Null array of X positions.");
        Objects.requireNonNull(this.positionsY, "Null array of Y positions.");
        Objects.requireNonNull(this.directions, "Null array of minutia directions.");
        Objects.requireNonNull(this.types, "Null minutia type string.");
        if (this.positionsX.length != this.types.length() || this.positionsY.length != this.types.length() || this.directions.length != this.types.length()) {
            throw new IllegalArgumentException("Inconsistent lengths of minutia property arrays.");
        }
        for (int i = 0; i < this.types.length(); ++i) {
            if (Math.abs(this.positionsX[i]) > 10000 || Math.abs(this.positionsY[i]) > 10000) {
                throw new IllegalArgumentException("Minutia position out of range.");
            }
            if (!DoubleAngle.normalized(this.directions[i])) {
                throw new IllegalArgumentException("Denormalized minutia direction.");
            }
            if (this.types.charAt(i) == 'E' || this.types.charAt(i) == 'B') continue;
            throw new IllegalArgumentException("Unknown minutia type.");
        }
    }
}

