/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.IntPoint;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

class IntRect
implements Iterable<IntPoint> {
    final int x;
    final int y;
    final int width;
    final int height;

    IntRect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    IntRect(IntPoint size) {
        this(0, 0, size.x, size.y);
    }

    int left() {
        return this.x;
    }

    int top() {
        return this.y;
    }

    int right() {
        return this.x + this.width;
    }

    int bottom() {
        return this.y + this.height;
    }

    int area() {
        return this.width * this.height;
    }

    static IntRect between(int startX, int startY, int endX, int endY) {
        return new IntRect(startX, startY, endX - startX, endY - startY);
    }

    static IntRect between(IntPoint start, IntPoint end) {
        return IntRect.between(start.x, start.y, end.x, end.y);
    }

    static IntRect around(int x, int y, int radius) {
        return IntRect.between(x - radius, y - radius, x + radius + 1, y + radius + 1);
    }

    static IntRect around(IntPoint center, int radius) {
        return IntRect.around(center.x, center.y, radius);
    }

    IntPoint center() {
        return new IntPoint((this.right() + this.left()) / 2, (this.top() + this.bottom()) / 2);
    }

    IntRect intersect(IntRect other) {
        return IntRect.between(new IntPoint(Math.max(this.left(), other.left()), Math.max(this.top(), other.top())), new IntPoint(Math.min(this.right(), other.right()), Math.min(this.bottom(), other.bottom())));
    }

    IntRect move(IntPoint delta) {
        return new IntRect(this.x + delta.x, this.y + delta.y, this.width, this.height);
    }

    private List<Object> fields() {
        return Arrays.asList(this.x, this.y, this.width, this.height);
    }

    public boolean equals(Object obj) {
        return obj instanceof IntRect && this.fields().equals(((IntRect)obj).fields());
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return String.format("[%d,%d] @ [%d,%d]", this.width, this.height, this.x, this.y);
    }

    @Override
    public Iterator<IntPoint> iterator() {
        return new BlockIterator();
    }

    private class BlockIterator
    implements Iterator<IntPoint> {
        int atX;
        int atY;

        private BlockIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.atY < IntRect.this.height && this.atX < IntRect.this.width;
        }

        @Override
        public IntPoint next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IntPoint result = new IntPoint(IntRect.this.x + this.atX, IntRect.this.y + this.atY);
            ++this.atX;
            if (this.atX >= IntRect.this.width) {
                this.atX = 0;
                ++this.atY;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

