/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoublePoint;
import com.machinezoo.sourceafis.Integers;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

class IntPoint
implements Iterable<IntPoint> {
    static final IntPoint ZERO = new IntPoint(0, 0);
    static final IntPoint[] EDGE_NEIGHBORS = new IntPoint[]{new IntPoint(0, -1), new IntPoint(-1, 0), new IntPoint(1, 0), new IntPoint(0, 1)};
    static final IntPoint[] CORNER_NEIGHBORS = new IntPoint[]{new IntPoint(-1, -1), new IntPoint(0, -1), new IntPoint(1, -1), new IntPoint(-1, 0), new IntPoint(1, 0), new IntPoint(-1, 1), new IntPoint(0, 1), new IntPoint(1, 1)};
    final int x;
    final int y;

    IntPoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    int area() {
        return this.x * this.y;
    }

    int lengthSq() {
        return Integers.sq(this.x) + Integers.sq(this.y);
    }

    boolean contains(IntPoint other) {
        return other.x >= 0 && other.y >= 0 && other.x < this.x && other.y < this.y;
    }

    IntPoint plus(IntPoint other) {
        return new IntPoint(this.x + other.x, this.y + other.y);
    }

    IntPoint minus(IntPoint other) {
        return new IntPoint(this.x - other.x, this.y - other.y);
    }

    IntPoint negate() {
        return new IntPoint(-this.x, -this.y);
    }

    DoublePoint toPoint() {
        return new DoublePoint(this.x, this.y);
    }

    IntPoint[] lineTo(IntPoint to) {
        IntPoint[] result;
        IntPoint relative = to.minus(this);
        if (Math.abs(relative.x) >= Math.abs(relative.y)) {
            result = new IntPoint[Math.abs(relative.x) + 1];
            if (relative.x > 0) {
                for (int i = 0; i <= relative.x; ++i) {
                    result[i] = new IntPoint(this.x + i, this.y + (int)Math.round((double)i * ((double)relative.y / (double)relative.x)));
                }
            } else if (relative.x < 0) {
                for (int i = 0; i <= -relative.x; ++i) {
                    result[i] = new IntPoint(this.x - i, this.y - (int)Math.round((double)i * ((double)relative.y / (double)relative.x)));
                }
            } else {
                result[0] = this;
            }
        } else {
            result = new IntPoint[Math.abs(relative.y) + 1];
            if (relative.y > 0) {
                for (int i = 0; i <= relative.y; ++i) {
                    result[i] = new IntPoint(this.x + (int)Math.round((double)i * ((double)relative.x / (double)relative.y)), this.y + i);
                }
            } else if (relative.y < 0) {
                for (int i = 0; i <= -relative.y; ++i) {
                    result[i] = new IntPoint(this.x - (int)Math.round((double)i * ((double)relative.x / (double)relative.y)), this.y - i);
                }
            } else {
                result[0] = this;
            }
        }
        return result;
    }

    private List<Object> fields() {
        return Arrays.asList(this.x, this.y);
    }

    public boolean equals(Object obj) {
        return obj instanceof IntPoint && this.fields().equals(((IntPoint)obj).fields());
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return String.format("[%d,%d]", this.x, this.y);
    }

    @Override
    public Iterator<IntPoint> iterator() {
        return new CellIterator();
    }

    private class CellIterator
    implements Iterator<IntPoint> {
        int atX;
        int atY;

        private CellIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.atY < IntPoint.this.y && this.atX < IntPoint.this.x;
        }

        @Override
        public IntPoint next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IntPoint result = new IntPoint(this.atX, this.atY);
            ++this.atX;
            if (this.atX >= IntPoint.this.x) {
                this.atX = 0;
                ++this.atY;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

