/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.IntPoint;

class HistogramCube {
    final int width;
    final int height;
    final int bins;
    private final int[] counts;

    HistogramCube(int width, int height, int bins) {
        this.width = width;
        this.height = height;
        this.bins = bins;
        this.counts = new int[width * height * bins];
    }

    HistogramCube(IntPoint size, int bins) {
        this(size.x, size.y, bins);
    }

    int constrain(int z) {
        return Math.max(0, Math.min(this.bins - 1, z));
    }

    int get(int x, int y, int z) {
        return this.counts[this.offset(x, y, z)];
    }

    int get(IntPoint at, int z) {
        return this.get(at.x, at.y, z);
    }

    int sum(int x, int y) {
        int sum = 0;
        for (int i = 0; i < this.bins; ++i) {
            sum += this.get(x, y, i);
        }
        return sum;
    }

    int sum(IntPoint at) {
        return this.sum(at.x, at.y);
    }

    void set(int x, int y, int z, int value) {
        this.counts[this.offset((int)x, (int)y, (int)z)] = value;
    }

    void set(IntPoint at, int z, int value) {
        this.set(at.x, at.y, z, value);
    }

    void add(int x, int y, int z, int value) {
        int n = this.offset(x, y, z);
        this.counts[n] = this.counts[n] + value;
    }

    void add(IntPoint at, int z, int value) {
        this.add(at.x, at.y, z, value);
    }

    void increment(int x, int y, int z) {
        this.add(x, y, z, 1);
    }

    void increment(IntPoint at, int z) {
        this.increment(at.x, at.y, z);
    }

    private int offset(int x, int y, int z) {
        return (y * this.width + x) * this.bins + z;
    }
}

