/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoublePoint;
import com.machinezoo.sourceafis.IntPoint;

class DoubleAngle {
    static final double PI2 = Math.PI * 2;
    static final double INV_PI2 = 0.15915494309189535;
    static final double HALF_PI = 1.5707963267948966;

    DoubleAngle() {
    }

    static DoublePoint toVector(double angle) {
        return new DoublePoint(Math.cos(angle), Math.sin(angle));
    }

    static double atan(DoublePoint vector) {
        double angle = Math.atan2(vector.y, vector.x);
        return angle >= 0.0 ? angle : angle + Math.PI * 2;
    }

    static double atan(IntPoint vector) {
        return DoubleAngle.atan(vector.toPoint());
    }

    static double atan(IntPoint center, IntPoint point) {
        return DoubleAngle.atan(point.minus(center));
    }

    static double toOrientation(double angle) {
        return angle < Math.PI ? 2.0 * angle : 2.0 * (angle - Math.PI);
    }

    static double fromOrientation(double angle) {
        return 0.5 * angle;
    }

    static double add(double start, double delta) {
        double angle = start + delta;
        return angle < Math.PI * 2 ? angle : angle - Math.PI * 2;
    }

    static double bucketCenter(int bucket, int resolution) {
        return Math.PI * 2 * (double)(2 * bucket + 1) / (double)(2 * resolution);
    }

    static int quantize(double angle, int resolution) {
        int result = (int)(angle * 0.15915494309189535 * (double)resolution);
        if (result < 0) {
            return 0;
        }
        if (result >= resolution) {
            return resolution - 1;
        }
        return result;
    }

    static double opposite(double angle) {
        return angle < Math.PI ? angle + Math.PI : angle - Math.PI;
    }

    static double distance(double first, double second) {
        double delta = Math.abs(first - second);
        return delta <= Math.PI ? delta : Math.PI * 2 - delta;
    }

    static double difference(double first, double second) {
        double angle = first - second;
        return angle >= 0.0 ? angle : angle + Math.PI * 2;
    }

    static double complementary(double angle) {
        double complement = Math.PI * 2 - angle;
        return complement < Math.PI * 2 ? complement : complement - Math.PI * 2;
    }

    static boolean normalized(double angle) {
        return angle >= 0.0 && angle < Math.PI * 2;
    }
}

