CREATE TABLE ifmodulo_pessoa (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	codigo_ifponto INTEGER NOT NULL UNIQUE,
	id_ifponto TEXT NULL,
	pis TEXT NOT NULL,
	cpf TEXT NOT NULL,
	login TEXT NOT NULL DEFAULT '',
	senha TEXT NOT NULL DEFAULT '',
	nome TEXT NOT NULL DEFAULT '',
	verificar_biometria INTEGER NOT NULL DEFAULT 1, 
	json json NULL,
	UNIQUE(codigo_ifponto, pis),
	UNIQUE(codigo_ifponto, id_ifponto)
);

CREATE TABLE ifmodulo_cartao (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	pessoa_id INTEGER NOT NULL,
	numero INTEGER NOT NULL UNIQUE,
	tipo TEXT NOT NULL DEFAULT 'Funcionário',
	tecnologia TEXT NOT NULL DEFAULT 'Digital',
	hrinicio TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	hrfim TIMESTAMP NOT NULL DEFAULT '2040-12-31 23:59:59',
	liberador INTEGER NOT NULL DEFAULT 0,
	ativo INTEGER NOT NULL DEFAULT 1,
	json json NULL,
	FOREIGN KEY(pessoa_id) REFERENCES ifmodulo_pessoa(id)
);

CREATE TABLE ifmodulo_equipamento (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	codigo_ifponto INTEGER NOT NULL UNIQUE,
	numero INTEGER NOT NULL DEFAULT 1 UNIQUE,
	timediff INTEGER NOT NULL DEFAULT 0,
	nsr INTEGER NULL,
	siin_nsr INTEGER NOT NULL DEFAULT 0,
	modelo TEXT NOT NULL DEFAULT 'desktop',
	nome TEXT NOT NULL DEFAULT '',
	ip TEXT NOT NULL DEFAULT '127.0.0.1',
	porta INTEGER NOT NULL DEFAULT 3000,
	login TEXT NOT NULL DEFAULT '',
	senha TEXT NOT NULL DEFAULT '',
	config json NOT NULL DEFAULT '{}',
	status json NOT NULL DEFAULT '{}',
	ativo INTEGER NOT NULL DEFAULT 1
);

CREATE TABLE ifmodulo_biometria (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	pessoa_id INTEGER NOT NULL,
	vendor TEXT NOT NULL DEFAULT '',
	encode TEXT NOT NULL DEFAULT 'b64', --b64, hex, raw
	template text NOT NULL DEFAULT '',
	sincronizado INTEGER NOT NULL DEFAULT 0,
	json json NULL,
	FOREIGN KEY(pessoa_id) REFERENCES ifmodulo_pessoa(id)
);

CREATE TABLE ifmodulo_pessoa_equipamento (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	codigo_ifponto INTEGER NOT NULL UNIQUE,
	equipamento_id INTEGER NOT NULL,
	pessoa_id INTEGER NOT NULL,
	operacao TEXT NOT NULL DEFAULT 'incluir',
    situacao INTEGER NOT NULL DEFAULT '1', --1: espera, 2: processando, 3: feito, 4: erro
    sincronizado INTEGER NOT NULL DEFAULT 0,
	descricao TEXT NOT NULL DEFAULT '',
	FOREIGN KEY(equipamento_id) REFERENCES ifmodulo_equipamento(id),
	FOREIGN KEY(pessoa_id) REFERENCES ifmodulo_pessoa(id),
	UNIQUE(pessoa_id, equipamento_id)
);

CREATE TABLE ifmodulo_evento (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	pessoa_id INTEGER NULL,
	equipamento_id INTEGER NULL,
	codigo INTEGER NULL,
	nsr INTEGER NULL,
	afd TEXT NOT NULL DEFAULT '',
	descricao TEXT NOT NULL DEFAULT '',
	tipo_afd INTEGER NOT NULL DEFAULT 3, --99 para eventos não definidos no afd
	datahora TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	sincronizado INTEGER NOT NULL DEFAULT 0,
    tipo_evento INTEGER NOT NULL DEFAULT -1,
	UNIQUE (equipamento_id, nsr),
	UNIQUE (pessoa_id, datahora),
	FOREIGN KEY(pessoa_id) REFERENCES ifmodulo_pessoa(id),
	FOREIGN KEY(equipamento_id) REFERENCES ifmodulo_equipamento(id)
);

CREATE INDEX ifmodulo_pessoa_equipamento_situacao_index ON ifmodulo_pessoa_equipamento (situacao);
CREATE INDEX ifmodulo_pessoa_equipamento_sincronizado_index ON ifmodulo_pessoa_equipamento (sincronizado);
CREATE INDEX ifmodulo_biometria_sincronizado_index ON ifmodulo_biometria (sincronizado);
CREATE INDEX ifmodulo_pessoa_pis_index ON ifmodulo_pessoa (pis);
CREATE INDEX ifmodulo_evento_sincronizado_index ON ifmodulo_evento (sincronizado);
CREATE INDEX ifmodulo_evento_datahora_index ON ifmodulo_evento (datahora);
CREATE INDEX ifmodulo_evento_nsr_index ON ifmodulo_evento (nsr);

CREATE TABLE ifmodulo_nivel2 (
	id SERIAL PRIMARY KEY,
    	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	nome TEXT NOT NULL DEFAULT '' UNIQUE,
	descricao TEXT NOT NULL DEFAULT '',
    	codigo_ifponto INTEGER NOT NULL
);

CREATE TABLE ifmodulo_equipamento_nivel (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	nivel_id INTEGER NOT NULL,
	equipamento_id INTEGER NOT NULL,
    	codigo_ifponto INTEGER NOT NULL,
	UNIQUE(nivel_id, equipamento_id)
);

CREATE TABLE ifmodulo_pessoa_nivel (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	pessoa_id INTEGER NOT NULL,
	nivel_id INTEGER NOT NULL,
	dtinicio TIMESTAMP NULL,
	dtfim TIMESTAMP NULL,
	UNIQUE(nivel_id, pessoa_id)
);

CREATE TABLE ifmodulo_intervalo (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	nome TEXT NOT NULL DEFAULT '' UNIQUE,
	inicio TIME NOT NULL,
	fim TIME NOT NULL,
	-- 1   - dia
	-- 2   - Domingo
	-- 4   - Segunda
	-- 8   - Terça
    	-- 16  - Quarta
	-- 32  - Quinta
	-- 64  - Sexta
	-- 128 - Sabado
	-- 256 - Feriado
	dia INTEGER NOT NULL DEFAULT 1,
    	codigo_ifponto INTEGER NOT NULL,
	UNIQUE(inicio, fim, dia)
);

CREATE TABLE ifmodulo_intervalo_equipamento_nivel (
	id SERIAL PRIMARY KEY,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	intervalo_id INTEGER NOT NULL,
	equipamento_nivel_id INTEGER NOT NULL,
	sentido CHAR(1) DEFAULT 'A' NOT NULL,
	UNIQUE(intervalo_id, equipamento_nivel_id)
);
