/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.ifponto.Version;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Tunnel;
import com.ifractal.utils.TunnelListener;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public abstract class TunnelServer<T>
extends Producer
implements Runnable {
    public static final int MOD_UNDEFINED = 0;
    public static final int MOD_SIIN = 1;
    public static final int MOD_OBSERVER = 2;
    public static int timeout = 400;
    protected List<TunnelPeer<T>> peers = new LinkedList<TunnelPeer<T>>();
    protected final TunnelListener<T> listener;
    protected final T context;
    protected boolean alive = false;
    protected String id = null;
    protected int port = 0;

    public abstract boolean open(int var1);

    public abstract void close();

    public static String[] invoke(String[] args) {
        String className = Util.getValueFromArgs(args, "class");
        String methodName = Util.getValueFromArgs(args, "method");
        Object err = null;
        if (className == null || methodName == null) {
            return new String[]{"Parametros invalidos"};
        }
        try {
            Class<?> klass = Class.forName(className);
            Method meth = klass.getMethod(methodName, String[].class);
            String[] resp = (String[])meth.invoke(null, new Object[]{args});
            return resp;
        }
        catch (ClassNotFoundException e) {
            err = "ClassNotFoundException\n";
            err = (String)err + "Class nao encontrada: " + className + " - " + String.valueOf(e.getCause());
        }
        catch (InvocationTargetException e) {
            err = "InvocationTargetException\n";
            err = (String)err + "Falha ao tentar executar: " + methodName + " - " + String.valueOf(e.getCause());
        }
        catch (IllegalAccessException e) {
            err = "IllegalAccessException\n";
            err = (String)err + "Falha ao tentar executar: " + methodName + " - " + e.getMessage();
        }
        catch (NoSuchMethodException e) {
            err = "NoSuchMethodException\n";
            err = (String)err + "Falha ao tentar executar: " + methodName + " - " + e.getMessage();
        }
        catch (ClassCastException e) {
            err = "ClassCastException\n";
            err = (String)err + "Falha ao tentar executar: " + methodName + " - " + e.getMessage();
        }
        if (err != null) {
            Verbosity.println((String)err);
        }
        return null;
    }

    public static String[] getVersion(String[] args) {
        String[] resp = new String[]{"version", Version.getFormatedText()};
        return resp;
    }

    public TunnelServer(T ctx, TunnelListener<T> tl) {
        super(tl);
        this.context = ctx;
        this.listener = tl;
    }

    public void start() {
        Thread th = new Thread(this);
        th.start();
    }

    public void stop() {
        this.alive = false;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public TunnelPeer<T> getPeer(String id) {
        for (TunnelPeer<T> p : this.peers) {
            if (!p.id.equals(id)) continue;
            return p;
        }
        return null;
    }

    protected TunnelPeer<T> getPeerFromContext(T ctx) {
        boolean ok = false;
        block0: do {
            ok = false;
            for (TunnelPeer<T> p : this.peers) {
                if (p.context.equals(ctx)) {
                    return p;
                }
                long lt = p.getLifetime();
                if (lt <= (long)timeout) continue;
                this.peers.remove(p);
                this.listener.onClose(p.context, p);
                ok = true;
                continue block0;
            }
        } while (ok);
        return null;
    }

    protected int addPeer(TunnelPeer<T> pn) {
        TunnelPeer p = this.getPeerFromContext(pn.context);
        if (p != null) {
            this.peers.remove(p);
            this.listener.onClose(p.context, pn);
        }
        this.peers.add(pn);
        return this.peers.size();
    }

    public int peerIterator(Object user_data) {
        int q = 0;
        for (TunnelPeer<T> p : this.peers) {
            this.listener.peerIter(this.context, p, user_data);
            ++q;
        }
        return q;
    }

    public int broadcast(String[] msg) {
        return this.broadcast(null, null, msg);
    }

    public int broadcast(TunnelPeer<T> from, String[] msg) {
        return this.broadcast(from, null, msg);
    }

    public int broadcast(TunnelPeer<T> from, TunnelPeer<T>[] except, String[] msg) {
        if (msg == null) {
            return -1;
        }
        int q = 0;
        for (TunnelPeer<T> to : this.peers) {
            if (from == to) continue;
            boolean skip = false;
            for (TunnelPeer<T> e : except) {
                if (to != e) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            this.listener.onBroadcast(this.context, from, to, msg);
            ++q;
        }
        return q;
    }

    public static final void main(String[] args) throws InterruptedException {
        TunnelListener<String> tsl = new TunnelListener<String>(){

            @Override
            public String onAccept(String ctx, TunnelPeer<String> peer) {
                if (peer == null) {
                    return null;
                }
                String ip = peer.getIP();
                Verbosity.println("new peer: " + ip);
                String id = ip + " - " + System.currentTimeMillis();
                return id;
            }

            @Override
            public void onMessage(String ctx, TunnelServer<String> t, TunnelPeer<String> peer, String[] pack) {
                Verbosity.println("##########################################");
                for (String e : pack) {
                    Verbosity.println("'" + e + "'");
                }
                Verbosity.println("##########################################");
            }

            @Override
            public void onFail(String ctx, String msg) {
                Verbosity.println("Fail: " + msg);
            }

            @Override
            public boolean idle(String ctx) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    return false;
                }
                return true;
            }

            @Override
            public void onClose(String ctx, TunnelPeer<String> peer) {
                System.err.println("Close: " + ctx);
            }

            @Override
            public void onMessage(Producer prod, int level, String msg, int code) {
                System.err.println(msg);
            }

            @Override
            public void onMessage(Producer prod, int level, String msg) {
                this.onMessage(prod, level, msg, 0);
            }
        };
        if (args.length < 1) {
            System.err.println("\nUso:\n\tjava TunnelServer <PORT>\n");
            System.err.println("Exemplo:\n\tjava TunnelServer 8000\n");
            System.exit(1);
        }
        Tunnel<String> tn = new Tunnel<String>("Test", tsl);
        int port = Integer.parseInt(args[0]);
        ((TunnelServer)tn).open(port);
        tn.start();
    }
}

