/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.SQLChange;

public class SQL {
    public static final int SQLITE = 0;
    public static final int PGSQL = 1;
    public static final SQLChange[] changeTable = new SQLChange[]{new SQLChange(0, 19346, new String[]{"ALTER TABLE evento DROP COLUMN sincronizado;", "ALTER TABLE evento ADD COLUMN sincronizado INTEGER NOT NULL DEFAULT 0;", "ALTER TABLE biometria DROP COLUMN sincronizado;", "ALTER TABLE biometria ADD COLUMN sincronizado INTEGER NOT NULL DEFAULT 0;", "ALTER TABLE pessoa_equipamento DROP COLUMN sincronizado;", "ALTER TABLE pessoa_equipamento ADD COLUMN sincronizado INTEGER NOT NULL DEFAULT 0;", "ALTER TABLE equipamento DROP COLUMN ativo;", "ALTER TABLE equipamento ADD COLUMN ativo INTEGER NOT NULL DEFAULT 1;", "UPDATE evento SET sincronizado = 1 WHERE datahora < DATE(CURRENT_TIMESTAMP, '-2 day');"}), new SQLChange(0, 19363, new String[]{"ALTER TABLE evento ADD COLUMN tipo_evento INTEGER NOT NULL DEFAULT -1;"}), new SQLChange(0, 19402, new String[]{"CREATE INDEX pessoa_equipamento_situacao_index ON pessoa_equipamento (situacao);", "CREATE INDEX pessoa_equipamento_sincronizado_index ON pessoa_equipamento (sincronizado);", "CREATE INDEX biometria_sincronizado_index ON biometria (sincronizado);", "CREATE INDEX pessoa_pis_index ON pessoa (pis);", "CREATE INDEX evento_sincronizado_index ON evento (sincronizado);", "CREATE INDEX pessoa_equipamento_situacao_index ON pessoa_equipamento (situacao);", "CREATE INDEX pessoa_equipamento_sincronizado_index ON pessoa_equipamento (sincronizado);", "CREATE INDEX biometria_sincronizado_index ON biometria (sincronizado);", "CREATE INDEX pessoa_pis_index ON pessoa (pis);", "CREATE INDEX evento_sincronizado_index ON evento (sincronizado);", "CREATE INDEX evento_datahora_index ON evento (datahora);", "CREATE INDEX evento_nsr_index ON evento (nsr);"}), new SQLChange(0, 19432, new String[]{"CREATE TABLE nivel ( \n\tid INTEGER PRIMARY KEY AUTOINCREMENT, \n\tdtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, \n\tnome TEXT NOT NULL DEFAULT '' UNIQUE, \n\tdescricao TEXT NOT NULL DEFAULT '');", "CREATE TABLE equipamento_nivel ( \n\tid INTEGER PRIMARY KEY AUTOINCREMENT, \n\tdtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, \n\tnivel_id INTEGER NOT NULL, \n\tequipamento_id INTEGER NOT NULL, \n\tUNIQUE(nivel_id, equipamento_id));", "CREATE TABLE pessoa_nivel ( \n\tid INTEGER PRIMARY KEY AUTOINCREMENT, \n\tdtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, \n\tpessoa_id INTEGER NOT NULL, \n\tnivel_id INTEGER NOT NULL, \n\tdtinicio TIMESTAMP NULL, \n\tdtfim TIMESTAMP NULL, \n\tUNIQUE(nivel_id, pessoa_id));", "CREATE TABLE intervalo ( \n\tid INTEGER PRIMARY KEY AUTOINCREMENT, \n\tdtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, \n\tnome TEXT NOT NULL DEFAULT '' UNIQUE, \n\tinicio TIME NOT NULL, \n\tfim TIME NOT NULL, \n\t-- 1   - Todo dia\n\t-- 2   - Domingo\n\t-- 4   - Segunda\n\t-- 8   - Ter\u00e7a\n\t-- 16  - Quarta\n\t-- 32  - Quinta\n\t-- 64  - Sexta\n\t-- 128 - Sabado\n\t-- 256 - Feriado\n\tdia INTEGER NOT NULL DEFAULT 1, \n\tUNIQUE(inicio, fim, dia));", "CREATE TABLE intervalo_equipamento_nivel ( \n\tid INTEGER PRIMARY KEY AUTOINCREMENT, \n\tdtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, \n\tintervalo_id INTEGER NOT NULL, \n\tequipamento_nivel_id INTEGER NOT NULL, \n\tsentido CHAR(1) DEFAULT 'A' NOT NULL, \n\tUNIQUE(intervalo_id, equipamento_nivel_id));"}), new SQLChange(0, 19440, new String[]{"DELETE FROM nivel;", "DELETE FROM pessoa_nivel;", "DELETE FROM intervalo;", "DELETE FROM intervalo_equipamento_nivel;", "DELETE FROM equipamento_nivel;", "ALTER TABLE nivel ADD COLUMN codigo_ifponto INTEGER NOT NULL;", "ALTER TABLE intervalo ADD COLUMN codigo_ifponto INTEGER NOT NULL;", "ALTER TABLE equipamento_nivel ADD COLUMN codigo_ifponto INTEGER NOT NULL;"}), new SQLChange(0, 19492, new String[]{"ALTER TABLE pessoa ADD COLUMN cpf TEXT;"})};
    protected static final String Insert_equipamento_SQLITE = "INSERT INTO equipamento(codigo_ifponto,numero,modelo,nome,ip,porta,login,senha,config) VALUES(?,?,?,?,?,?,?,?,?);";
    protected static final String Insert_equipamento_PGSQL = "INSERT INTO ifmodulo_equipamento(codigo_ifponto,numero,modelo,nome,ip,porta,login,senha,config) VALUES(CAST(? AS INTEGER),CAST(? AS INTEGER),?,?,?,CAST(? AS INTEGER),?,?,to_json(?::json));";
    public static final String[] Insert_equipamento = new String[]{"INSERT INTO equipamento(codigo_ifponto,numero,modelo,nome,ip,porta,login,senha,config) VALUES(?,?,?,?,?,?,?,?,?);", "INSERT INTO ifmodulo_equipamento(codigo_ifponto,numero,modelo,nome,ip,porta,login,senha,config) VALUES(CAST(? AS INTEGER),CAST(? AS INTEGER),?,?,?,CAST(? AS INTEGER),?,?,to_json(?::json));"};
    protected static final String Update_equipamento_SQLITE = "UPDATE equipamento SET ativo = 1, dtupdated = CURRENT_TIMESTAMP, modelo = ?, nome = ?, ip = ?, porta = ?, login = ?, senha = ?, config = ?, timediff = ? WHERE codigo_ifponto = ?;";
    protected static final String Update_equipamento_PGSQL = "UPDATE ifmodulo_equipamento SET ativo = 1, dtupdated = CURRENT_TIMESTAMP, modelo = ?, nome = ?, ip = ?, porta = CAST(? AS INTEGER), login = ?, senha = ?, config = to_json(?::json), timediff = CAST(? AS INTEGER) WHERE codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Update_equipamento = new String[]{"UPDATE equipamento SET ativo = 1, dtupdated = CURRENT_TIMESTAMP, modelo = ?, nome = ?, ip = ?, porta = ?, login = ?, senha = ?, config = ?, timediff = ? WHERE codigo_ifponto = ?;", "UPDATE ifmodulo_equipamento SET ativo = 1, dtupdated = CURRENT_TIMESTAMP, modelo = ?, nome = ?, ip = ?, porta = CAST(? AS INTEGER), login = ?, senha = ?, config = to_json(?::json), timediff = CAST(? AS INTEGER) WHERE codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Update_inativa_equipamentos_SQLITE = "UPDATE equipamento SET ativo = 0;";
    protected static final String Update_inativa_equipamentos_PGSQL = "UPDATE ifmodulo_equipamento SET ativo = 0;";
    public static final String[] Update_inativa_equipamentos = new String[]{"UPDATE equipamento SET ativo = 0;", "UPDATE ifmodulo_equipamento SET ativo = 0;"};
    protected static final String Update_equipamento_nsr_SQLITE = "UPDATE equipamento SET nsr = ? WHERE codigo_ifponto = ?;";
    protected static final String Update_equipamento_nsr_PGSQL = "UPDATE ifmodulo_equipamento SET nsr = CAST(? AS INTEGER) WHERE codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Update_equipamento_nsr = new String[]{"UPDATE equipamento SET nsr = ? WHERE codigo_ifponto = ?;", "UPDATE ifmodulo_equipamento SET nsr = CAST(? AS INTEGER) WHERE codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Update_equipamento_siin_nsr_SQLITE = "UPDATE equipamento SET siin_nsr = ? WHERE codigo_ifponto = ?;";
    protected static final String Update_equipamento_siin_nsr_PGSQL = "UPDATE ifmodulo_equipamento SET siin_nsr = CAST(? AS INTEGER) WHERE codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Update_equipamento_siin_nsr = new String[]{"UPDATE equipamento SET siin_nsr = ? WHERE codigo_ifponto = ?;", "UPDATE ifmodulo_equipamento SET siin_nsr = CAST(? AS INTEGER) WHERE codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Update_Recollect_All_Nsr_SQLITE = "UPDATE equipamento SET nsr = CASE WHEN nsr = nsr THEN (nsr - ?) WHEN nsr < ? THEN nsr = 1 END;";
    protected static final String Update_Recollect_All_Nsr_PGSQL = "UPDATE ifmodulo_equipamento SET nsr = CASE WHEN nsr = nsr THEN (nsr - CAST(? AS INTEGER)) WHEN nsr < CAST(? AS INTEGER) THEN nsr = 1 END;";
    public static final String[] Update_Recollect_All_Nsr = new String[]{"UPDATE equipamento SET nsr = CASE WHEN nsr = nsr THEN (nsr - ?) WHEN nsr < ? THEN nsr = 1 END;", "UPDATE ifmodulo_equipamento SET nsr = CASE WHEN nsr = nsr THEN (nsr - CAST(? AS INTEGER)) WHEN nsr < CAST(? AS INTEGER) THEN nsr = 1 END;"};
    protected static final String Update_equipamento_status_SQLITE = "UPDATE equipamento SET status = ? WHERE codigo_ifponto = ?;";
    protected static final String Update_equipamento_status_PGSQL = "UPDATE ifmodulo_equipamento SET status = to_json(?::json) WHERE codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Update_equipamento_status = new String[]{"UPDATE equipamento SET status = ? WHERE codigo_ifponto = ?;", "UPDATE ifmodulo_equipamento SET status = to_json(?::json) WHERE codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Insert_pessoa_SQLITE = "INSERT INTO pessoa(codigo_ifponto,nome,pis,cpf,id_ifponto,verificar_biometria) VALUES (?,?,?,?,?,?);";
    protected static final String Insert_pessoa_PGSQL = "INSERT INTO ifmodulo_pessoa(codigo_ifponto,nome,pis,cpf,id_ifponto,verificar_biometria) VALUES (CAST(? AS INTEGER),?,?,?,?,CAST(? AS INTEGER));";
    public static final String[] Insert_pessoa = new String[]{"INSERT INTO pessoa(codigo_ifponto,nome,pis,cpf,id_ifponto,verificar_biometria) VALUES (?,?,?,?,?,?);", "INSERT INTO ifmodulo_pessoa(codigo_ifponto,nome,pis,cpf,id_ifponto,verificar_biometria) VALUES (CAST(? AS INTEGER),?,?,?,?,CAST(? AS INTEGER));"};
    protected static final String Update_pessoa_SQLITE = "UPDATE pessoa SET dtupdated = CURRENT_TIMESTAMP, nome = ?, pis = ?, cpf = ?, id_ifponto = ?, verificar_biometria = ? WHERE codigo_ifponto = ?;";
    protected static final String Update_pessoa_PGSQL = "UPDATE ifmodulo_pessoa SET dtupdated = CURRENT_TIMESTAMP, nome = ?, pis = ?, cpf = ?, id_ifponto = ?, verificar_biometria = CAST(? AS INTEGER) WHERE codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Update_pessoa = new String[]{"UPDATE pessoa SET dtupdated = CURRENT_TIMESTAMP, nome = ?, pis = ?, cpf = ?, id_ifponto = ?, verificar_biometria = ? WHERE codigo_ifponto = ?;", "UPDATE ifmodulo_pessoa SET dtupdated = CURRENT_TIMESTAMP, nome = ?, pis = ?, cpf = ?, id_ifponto = ?, verificar_biometria = CAST(? AS INTEGER) WHERE codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Insert_pessoa_equipamento_SQLITE = "INSERT INTO pessoa_equipamento(equipamento_id,pessoa_id, codigo_ifponto, operacao) SELECT e.id, p.id, ?, ? FROM equipamento e, pessoa p WHERE e.codigo_ifponto = ? AND p.codigo_ifponto = ?;";
    protected static final String Insert_pessoa_equipamento_PGSQL = "INSERT INTO ifmodulo_pessoa_equipamento(equipamento_id,pessoa_id, codigo_ifponto, operacao) SELECT e.id, p.id, CAST(? AS INTEGER), ? FROM ifmodulo_equipamento e, ifmodulo_pessoa p WHERE e.codigo_ifponto = CAST(? AS INTEGER) AND p.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Insert_pessoa_equipamento = new String[]{"INSERT INTO pessoa_equipamento(equipamento_id,pessoa_id, codigo_ifponto, operacao) SELECT e.id, p.id, ?, ? FROM equipamento e, pessoa p WHERE e.codigo_ifponto = ? AND p.codigo_ifponto = ?;", "INSERT INTO ifmodulo_pessoa_equipamento(equipamento_id,pessoa_id, codigo_ifponto, operacao) SELECT e.id, p.id, CAST(? AS INTEGER), ? FROM ifmodulo_equipamento e, ifmodulo_pessoa p WHERE e.codigo_ifponto = CAST(? AS INTEGER) AND p.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Select_equipamento_SQLITE = "SELECT codigo_ifponto, id FROM equipamento;";
    protected static final String Select_equipamento_PGSQL = "SELECT codigo_ifponto, id FROM ifmodulo_equipamento;";
    public static final String[] Select_equipamento = new String[]{"SELECT codigo_ifponto, id FROM equipamento;", "SELECT codigo_ifponto, id FROM ifmodulo_equipamento;"};
    protected static final String Select_pessoa_SQLITE = "SELECT codigo_ifponto, id FROM pessoa;";
    protected static final String Select_pessoa_PGSQL = "SELECT codigo_ifponto, id FROM ifmodulo_pessoa;";
    public static final String[] Select_pessoa = new String[]{"SELECT codigo_ifponto, id FROM pessoa;", "SELECT codigo_ifponto, id FROM ifmodulo_pessoa;"};
    protected static final String Update_pessoa_equipamento_SQLITE = "UPDATE pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = 1, sincronizado = 0, descricao = '', codigo_ifponto = ?, operacao = ? WHERE equipamento_id = ? AND pessoa_id = ?;";
    protected static final String Update_pessoa_equipamento_PGSQL = "UPDATE ifmodulo_pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = 1, sincronizado = 0, descricao = '', codigo_ifponto = CAST(? AS INTEGER), operacao = ? WHERE equipamento_id = CAST(? AS INTEGER) AND pessoa_id = CAST(? AS INTEGER);";
    public static final String[] Update_pessoa_equipamento = new String[]{"UPDATE pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = 1, sincronizado = 0, descricao = '', codigo_ifponto = ?, operacao = ? WHERE equipamento_id = ? AND pessoa_id = ?;", "UPDATE ifmodulo_pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = 1, sincronizado = 0, descricao = '', codigo_ifponto = CAST(? AS INTEGER), operacao = ? WHERE equipamento_id = CAST(? AS INTEGER) AND pessoa_id = CAST(? AS INTEGER);"};
    protected static final String Update_pessoa_equipamento_biodesk_SQLITE = "UPDATE pessoa_equipamento SET situacao = ?, descricao = ? WHERE situacao = 1;";
    protected static final String Update_pessoa_equipamento_biodesk_PGSQL = "UPDATE ifmodulo_pessoa_equipamento SET situacao = ?, descricao = ? WHERE situacao = 1;";
    public static final String[] Update_pessoa_equipamento_biodesk = new String[]{"UPDATE pessoa_equipamento SET situacao = ?, descricao = ? WHERE situacao = 1;", "UPDATE ifmodulo_pessoa_equipamento SET situacao = ?, descricao = ? WHERE situacao = 1;"};
    protected static final String Delete_cartoes_SQLITE = "DELETE FROM  WHERE pessoa_id IN (SELECT id FROM pessoa WHERE codigo_ifponto = ?);";
    protected static final String Delete_cartoes_PGSQL = "DELETE FROM  WHERE pessoa_id IN (SELECT id FROM ifmodulo_pessoa WHERE codigo_ifponto = CAST(? AS INTEGER));";
    public static final String[] Delete_cartoes = new String[]{"DELETE FROM  WHERE pessoa_id IN (SELECT id FROM pessoa WHERE codigo_ifponto = ?);", "DELETE FROM  WHERE pessoa_id IN (SELECT id FROM ifmodulo_pessoa WHERE codigo_ifponto = CAST(? AS INTEGER));"};
    protected static final String Delete_cartao_SQLITE = "DELETE FROM cartao WHERE numero = ?;";
    protected static final String Delete_cartao_PGSQL = "DELETE FROM ifmodulo_cartao WHERE numero = CAST(? AS INTEGER);";
    public static final String[] Delete_cartao = new String[]{"DELETE FROM cartao WHERE numero = ?;", "DELETE FROM ifmodulo_cartao WHERE numero = CAST(? AS INTEGER);"};
    protected static final String Insert_cartao_SQLITE = "INSERT INTO cartao(pessoa_id,numero,tipo,tecnologia,hrinicio,hrfim,liberador,ativo) SELECT p.id,?,?,?,?,?,?,? FROM pessoa p WHERE p.codigo_ifponto = ?;";
    protected static final String Insert_cartao_PGSQL = "INSERT INTO ifmodulo_cartao(pessoa_id,numero,tipo,tecnologia,hrinicio,hrfim,liberador,ativo) SELECT p.id,CAST(? AS INTEGER),?,?,TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'),TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'),CAST(? AS INTEGER),CAST(? AS INTEGER) FROM ifmodulo_pessoa p WHERE p.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Insert_cartao = new String[]{"INSERT INTO cartao(pessoa_id,numero,tipo,tecnologia,hrinicio,hrfim,liberador,ativo) SELECT p.id,?,?,?,?,?,?,? FROM pessoa p WHERE p.codigo_ifponto = ?;", "INSERT INTO ifmodulo_cartao(pessoa_id,numero,tipo,tecnologia,hrinicio,hrfim,liberador,ativo) SELECT p.id,CAST(? AS INTEGER),?,?,TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'),TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'),CAST(? AS INTEGER),CAST(? AS INTEGER) FROM ifmodulo_pessoa p WHERE p.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Update_cartao_SQLITE = "UPDATE cartao SET dtupdated = CURRENT_TIMESTAMP, tipo = ?, tecnologia = ?, hrinicio = ?, hrfim = ?, liberador = ?, ativo = ? WHERE numero = ?;";
    protected static final String Update_cartao_PGSQL = "UPDATE ifmodulo_cartao SET dtupdated = CURRENT_TIMESTAMP, tipo = ?, tecnologia = ?, hrinicio = TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'), hrfim = TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'), liberador = CAST(? AS INTEGER), ativo = CAST(? AS INTEGER) WHERE numero = CAST(? AS INTEGER);";
    public static final String[] Update_cartao = new String[]{"UPDATE cartao SET dtupdated = CURRENT_TIMESTAMP, tipo = ?, tecnologia = ?, hrinicio = ?, hrfim = ?, liberador = ?, ativo = ? WHERE numero = ?;", "UPDATE ifmodulo_cartao SET dtupdated = CURRENT_TIMESTAMP, tipo = ?, tecnologia = ?, hrinicio = TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'), hrfim = TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'), liberador = CAST(? AS INTEGER), ativo = CAST(? AS INTEGER) WHERE numero = CAST(? AS INTEGER);"};
    protected static final String Delete_bio_SQLITE = "DELETE FROM biometria WHERE pessoa_id IN (SELECT id FROM pessoa WHERE codigo_ifponto = ?);";
    protected static final String Delete_bio_PGSQL = "DELETE FROM ifmodulo_biometria WHERE pessoa_id IN (SELECT id FROM ifmodulo_pessoa WHERE codigo_ifponto = CAST(? AS INTEGER));";
    public static final String[] Delete_bio = new String[]{"DELETE FROM biometria WHERE pessoa_id IN (SELECT id FROM pessoa WHERE codigo_ifponto = ?);", "DELETE FROM ifmodulo_biometria WHERE pessoa_id IN (SELECT id FROM ifmodulo_pessoa WHERE codigo_ifponto = CAST(? AS INTEGER));"};
    protected static final String Delete_bio_desktop_SQLITE = "DELETE FROM biometria WHERE pessoa_id IN (SELECT id FROM pessoa WHERE pessoa_id = ?);";
    protected static final String Delete_bio_desktop_PGSQL = "DELETE FROM ifmodulo_biometria WHERE pessoa_id IN (SELECT id FROM ifmodulo_pessoa WHERE pessoa_id = CAST(? AS INTEGER));";
    public static final String[] Delete_bio_desktop = new String[]{"DELETE FROM biometria WHERE pessoa_id IN (SELECT id FROM pessoa WHERE pessoa_id = ?);", "DELETE FROM ifmodulo_biometria WHERE pessoa_id IN (SELECT id FROM ifmodulo_pessoa WHERE pessoa_id = CAST(? AS INTEGER));"};
    protected static final String Delete_events_SQLITE = "DELETE FROM evento WHERE equipamento_id IN (SELECT id FROM equipamento WHERE numero = ?);";
    protected static final String Delete_events_PGSQL = "DELETE FROM ifmodulo_evento WHERE equipamento_id IN (SELECT id FROM ifmodulo_equipamento WHERE numero = CAST(? AS INTEGER));";
    public static final String[] Delete_events = new String[]{"DELETE FROM evento WHERE equipamento_id IN (SELECT id FROM equipamento WHERE numero = ?);", "DELETE FROM ifmodulo_evento WHERE equipamento_id IN (SELECT id FROM ifmodulo_equipamento WHERE numero = CAST(? AS INTEGER));"};
    protected static final String Delete_Pessoa_Nivel_SQLITE = "DELETE FROM pessoa_nivel;";
    protected static final String Delete_Pessoa_Nivel_PGSQL = "DELETE FROM ifmodulo_pessoa_nivel;";
    public static final String[] Delete_Pessoa_Nivel = new String[]{"DELETE FROM pessoa_nivel;", "DELETE FROM ifmodulo_pessoa_nivel;"};
    protected static final String Delete_Nivel_SQLITE = "DELETE FROM nivel;";
    protected static final String Delete_Nivel_PGSQL = "DELETE FROM ifmodulo_nivel2;";
    public static final String[] Delete_Nivel = new String[]{"DELETE FROM nivel;", "DELETE FROM ifmodulo_nivel2;"};
    protected static final String Delete_Equipamento_Nivel_SQLITE = "DELETE FROM equipamento_nivel;";
    protected static final String Delete_Equipamento_Nivel_PGSQL = "DELETE FROM ifmodulo_equipamento_nivel;";
    public static final String[] Delete_Equipamento_Nivel = new String[]{"DELETE FROM equipamento_nivel;", "DELETE FROM ifmodulo_equipamento_nivel;"};
    protected static final String Delete_Intervalo_Equipamento_Nivel_SQLITE = "DELETE FROM intervalo_equipamento_nivel;";
    protected static final String Delete_Intervalo_Equipamento_Nivel_PGSQL = "DELETE FROM ifmodulo_intervalo_equipamento_nivel;";
    public static final String[] Delete_Intervalo_Equipamento_Nivel = new String[]{"DELETE FROM intervalo_equipamento_nivel;", "DELETE FROM ifmodulo_intervalo_equipamento_nivel;"};
    protected static final String Delete_Intervalo_SQLITE = "DELETE FROM intervalo;";
    protected static final String Delete_Intervalo_PGSQL = "DELETE FROM ifmodulo_intervalo;";
    public static final String[] Delete_Intervalo = new String[]{"DELETE FROM intervalo;", "DELETE FROM ifmodulo_intervalo;"};
    protected static final String Insert_Pessoa_Nivel_SQLITE = "INSERT INTO pessoa_nivel(pessoa_id, nivel_id) SELECT p.id, n.id FROM pessoa p, nivel n WHERE p.codigo_ifponto = ? AND n.codigo_ifponto = ?;";
    protected static final String Insert_Pessoa_Nivel_PGSQL = "INSERT INTO ifmodulo_pessoa_nivel(pessoa_id, nivel_id) SELECT p.id, n.id FROM ifmodulo_pessoa p, ifmodulo_nivel2 n WHERE p.codigo_ifponto = CAST(? AS INTEGER) AND n.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Insert_Pessoa_Nivel = new String[]{"INSERT INTO pessoa_nivel(pessoa_id, nivel_id) SELECT p.id, n.id FROM pessoa p, nivel n WHERE p.codigo_ifponto = ? AND n.codigo_ifponto = ?;", "INSERT INTO ifmodulo_pessoa_nivel(pessoa_id, nivel_id) SELECT p.id, n.id FROM ifmodulo_pessoa p, ifmodulo_nivel2 n WHERE p.codigo_ifponto = CAST(? AS INTEGER) AND n.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Insert_Nivel_SQLITE = "INSERT INTO nivel(nome, codigo_ifponto) VALUES (?,?);";
    protected static final String Insert_Nivel_PGSQL = "INSERT INTO ifmodulo_nivel2(nome, codigo_ifponto) VALUES (?, CAST(? AS INTEGER));";
    public static final String[] Insert_Nivel = new String[]{"INSERT INTO nivel(nome, codigo_ifponto) VALUES (?,?);", "INSERT INTO ifmodulo_nivel2(nome, codigo_ifponto) VALUES (?, CAST(? AS INTEGER));"};
    protected static final String Insert_Equipamento_Nivel_SQLITE = "INSERT INTO equipamento_nivel(nivel_id, equipamento_id, codigo_ifponto) SELECT n.id, eq.id, ? FROM nivel n, equipamento eq WHERE n.codigo_ifponto = ? AND eq.codigo_ifponto = ?;";
    protected static final String Insert_Equipamento_Nivel_PGSQL = "INSERT INTO ifmodulo_equipamento_nivel(nivel_id, equipamento_id, codigo_ifponto) SELECT n.id, eq.id, CAST(? AS INTEGER) FROM ifmodulo_nivel2 n, equipamento eq WHERE n.codigo_ifponto = CAST(? AS INTEGER) AND eq.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Insert_Equipamento_Nivel = new String[]{"INSERT INTO equipamento_nivel(nivel_id, equipamento_id, codigo_ifponto) SELECT n.id, eq.id, ? FROM nivel n, equipamento eq WHERE n.codigo_ifponto = ? AND eq.codigo_ifponto = ?;", "INSERT INTO ifmodulo_equipamento_nivel(nivel_id, equipamento_id, codigo_ifponto) SELECT n.id, eq.id, CAST(? AS INTEGER) FROM ifmodulo_nivel2 n, equipamento eq WHERE n.codigo_ifponto = CAST(? AS INTEGER) AND eq.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Insert_Intervalo_Equipamento_Nivel_SQLITE = "INSERT INTO intervalo_equipamento_nivel(equipamento_nivel_id, intervalo_id) SELECT eq.id, i.id FROM equipamento_nivel eq, intervalo i WHERE eq.codigo_ifponto = ? AND i.codigo_ifponto = ?;";
    protected static final String Insert_Intervalo_Equipamento_Nivel_PGSQL = "INSERT INTO ifmodulo_intervalo_equipamento_nivel(equipamento_nivel_id, intervalo_id) SELECT eq.id, i.id FROM ifmodulo_equipamento_nivel eq, intervalo i WHERE eq.codigo_ifponto = CAST(? AS INTEGER) AND i.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Insert_Intervalo_Equipamento_Nivel = new String[]{"INSERT INTO intervalo_equipamento_nivel(equipamento_nivel_id, intervalo_id) SELECT eq.id, i.id FROM equipamento_nivel eq, intervalo i WHERE eq.codigo_ifponto = ? AND i.codigo_ifponto = ?;", "INSERT INTO ifmodulo_intervalo_equipamento_nivel(equipamento_nivel_id, intervalo_id) SELECT eq.id, i.id FROM ifmodulo_equipamento_nivel eq, intervalo i WHERE eq.codigo_ifponto = CAST(? AS INTEGER) AND i.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Insert_Intervalo_SQLITE = "INSERT INTO intervalo(nome, inicio, fim, dia, codigo_ifponto) VALUES (?,?,?,?,?);";
    protected static final String Insert_Intervalo_PGSQL = "INSERT INTO ifmodulo_intervalo(nome, inicio, fim, dia, codigo_ifponto) VALUES (?,?::time,?::time,CAST(? AS INTEGER),CAST(? AS INTEGER));";
    public static final String[] Insert_Intervalo = new String[]{"INSERT INTO intervalo(nome, inicio, fim, dia, codigo_ifponto) VALUES (?,?,?,?,?);", "INSERT INTO ifmodulo_intervalo(nome, inicio, fim, dia, codigo_ifponto) VALUES (?,?::time,?::time,CAST(? AS INTEGER),CAST(? AS INTEGER));"};
    protected static final String Insert_bio_SQLITE = "INSERT INTO biometria(pessoa_id,sincronizado,template,vendor,encode) SELECT p.id,?,?,?,? FROM pessoa p WHERE p.codigo_ifponto = ?;";
    protected static final String Insert_bio_PGSQL = "INSERT INTO ifmodulo_biometria(pessoa_id,sincronizado,template,vendor,encode) SELECT p.id,CAST(? AS INTEGER),?,?,? FROM ifmodulo_pessoa p WHERE p.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Insert_bio = new String[]{"INSERT INTO biometria(pessoa_id,sincronizado,template,vendor,encode) SELECT p.id,?,?,?,? FROM pessoa p WHERE p.codigo_ifponto = ?;", "INSERT INTO ifmodulo_biometria(pessoa_id,sincronizado,template,vendor,encode) SELECT p.id,CAST(? AS INTEGER),?,?,? FROM ifmodulo_pessoa p WHERE p.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Insert_bio_desktop_SQLITE = "INSERT INTO biometria(pessoa_id,sincronizado,template,vendor,encode) Values (?,?,?,?,?);";
    protected static final String Insert_bio_desktop_PGSQL = "INSERT INTO ifmodulo_biometria(pessoa_id,sincronizado,template,vendor,encode) Values (CAST(? AS INTEGER),CAST(? AS INTEGER),?,?,?);";
    public static final String[] Insert_bio_desktop = new String[]{"INSERT INTO biometria(pessoa_id,sincronizado,template,vendor,encode) Values (?,?,?,?,?);", "INSERT INTO ifmodulo_biometria(pessoa_id,sincronizado,template,vendor,encode) Values (CAST(? AS INTEGER),CAST(? AS INTEGER),?,?,?);"};
    protected static final String Select_devices_SQLITE = "SELECT codigo_ifponto as codigo, numero as nro, nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff, ativo, config FROM equipamento;";
    protected static final String Select_devices_PGSQL = "SELECT codigo_ifponto as codigo, numero as nro, nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff, ativo, config FROM ifmodulo_equipamento;";
    public static final String[] Select_devices = new String[]{"SELECT codigo_ifponto as codigo, numero as nro, nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff, ativo, config FROM equipamento;", "SELECT codigo_ifponto as codigo, numero as nro, nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff, ativo, config FROM ifmodulo_equipamento;"};
    protected static final String Select_device_nro_SQLITE = "SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM equipamento e WHERE e.numero = ?;";
    protected static final String Select_device_nro_PGSQL = "SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM ifmodulo_equipamento e WHERE e.numero = CAST(? AS INTEGER);";
    public static final String[] Select_device_nro = new String[]{"SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM equipamento e WHERE e.numero = ?;", "SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM ifmodulo_equipamento e WHERE e.numero = CAST(? AS INTEGER);"};
    protected static final String Select_device_cod_SQLITE = "SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM equipamento e WHERE e.codigo_ifponto = ?;";
    protected static final String Select_device_cod_PGSQL = "SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM ifmodulo_equipamento e WHERE e.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Select_device_cod = new String[]{"SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM equipamento e WHERE e.codigo_ifponto = ?;", "SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM ifmodulo_equipamento e WHERE e.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Select_pessoas_SQLITE = "SELECT p.id_ifponto, p.pis, p.cpf, p.nome, p.verificar_biometria, p.dtupdated FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.numero = ?;";
    protected static final String Select_pessoas_PGSQL = "SELECT p.id_ifponto, p.pis, p.cpf, p.nome, p.verificar_biometria, p.dtupdated FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.numero = CAST(? AS INTEGER);";
    public static final String[] Select_pessoas = new String[]{"SELECT p.id_ifponto, p.pis, p.cpf, p.nome, p.verificar_biometria, p.dtupdated FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.numero = ?;", "SELECT p.id_ifponto, p.pis, p.cpf, p.nome, p.verificar_biometria, p.dtupdated FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.numero = CAST(? AS INTEGER);"};
    protected static final String Select_pessoa_nome_SQLITE = "SELECT id_ifponto, pis, cpf, nome, verificar_biometria, dtupdated, id FROM pessoa WHERE nome LIKE '%'||?||'%';";
    protected static final String Select_pessoa_nome_PGSQL = "SELECT id_ifponto, pis, cpf, nome, verificar_biometria, dtupdated, id FROM ifmodulo_pessoa WHERE nome LIKE '%'||?||'%';";
    public static final String[] Select_pessoa_nome = new String[]{"SELECT id_ifponto, pis, cpf, nome, verificar_biometria, dtupdated, id FROM pessoa WHERE nome LIKE '%'||?||'%';", "SELECT id_ifponto, pis, cpf, nome, verificar_biometria, dtupdated, id FROM ifmodulo_pessoa WHERE nome LIKE '%'||?||'%';"};
    protected static final String Select_pessoa_pis_SQLITE = "SELECT p.id_ifponto, p.pis, p.cpf, p.nome, p.verificar_biometria, p.dtupdated, p.id FROM pessoa p WHERE p.pis LIKE '%'||?||'%';";
    protected static final String Select_pessoa_pis_PGSQL = "SELECT p.id_ifponto, p.pis, p.cpf, p.nome, p.verificar_biometria, p.dtupdated, p.id FROM ifmodulo_pessoa p WHERE p.pis LIKE '%'||?||'%';";
    public static final String[] Select_pessoa_pis = new String[]{"SELECT p.id_ifponto, p.pis, p.cpf, p.nome, p.verificar_biometria, p.dtupdated, p.id FROM pessoa p WHERE p.pis LIKE '%'||?||'%';", "SELECT p.id_ifponto, p.pis, p.cpf, p.nome, p.verificar_biometria, p.dtupdated, p.id FROM ifmodulo_pessoa p WHERE p.pis LIKE '%'||?||'%';"};
    protected static final String Select_pendentes_SQLITE = "SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.cpf, p.verificar_biometria, pe.operacao as tipo FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.codigo_ifponto = ? AND pe.situacao = 1 limit ?;";
    protected static final String Select_pendentes_PGSQL = "SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.cpf, p.verificar_biometria, pe.operacao as tipo FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.codigo_ifponto = CAST(? AS INTEGER) AND pe.situacao = 1 limit CAST(? AS INTEGER);";
    public static final String[] Select_pendentes = new String[]{"SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.cpf, p.verificar_biometria, pe.operacao as tipo FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.codigo_ifponto = ? AND pe.situacao = 1 limit ?;", "SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.cpf, p.verificar_biometria, pe.operacao as tipo FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.codigo_ifponto = CAST(? AS INTEGER) AND pe.situacao = 1 limit CAST(? AS INTEGER);"};
    protected static final String Select_pendentes_processando_SQLITE = "SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.cpf, p.verificar_biometria, pe.operacao as tipo FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.codigo_ifponto = ? AND pe.situacao = 2;";
    protected static final String Select_pendentes_processando_PGSQL = "SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.cpf, p.verificar_biometria, pe.operacao as tipo FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.codigo_ifponto = CAST(? AS INTEGER) AND pe.situacao = 2;";
    public static final String[] Select_pendentes_processando = new String[]{"SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.cpf, p.verificar_biometria, pe.operacao as tipo FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.codigo_ifponto = ? AND pe.situacao = 2;", "SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.cpf, p.verificar_biometria, pe.operacao as tipo FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.codigo_ifponto = CAST(? AS INTEGER) AND pe.situacao = 2;"};
    protected static final String Select_descricao_pendente_SQLITE = "SELECT descricao FROM pessoa_equipamento WHERE codigo_ifponto = ?;";
    protected static final String Select_descricao_pendente_PGSQL = "SELECT descricao FROM ifmodulo_pessoa_equipamento WHERE codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Select_descricao_pendente = new String[]{"SELECT descricao FROM pessoa_equipamento WHERE codigo_ifponto = ?;", "SELECT descricao FROM ifmodulo_pessoa_equipamento WHERE codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Update_pendentes_SQLITE = "UPDATE pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = ?, sincronizado = ?, descricao = ? WHERE codigo_ifponto = ?;";
    protected static final String Update_pendentes_PGSQL = "UPDATE ifmodulo_pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = CAST(? AS INTEGER), sincronizado = CAST(? AS INTEGER), descricao = ? WHERE codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Update_pendentes = new String[]{"UPDATE pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = ?, sincronizado = ?, descricao = ? WHERE codigo_ifponto = ?;", "UPDATE ifmodulo_pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = CAST(? AS INTEGER), sincronizado = CAST(? AS INTEGER), descricao = ? WHERE codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Select_status_pessoa_SQLITE = "SELECT p.nome, p.id_ifponto AS pis, CASE WHEN pe.situacao = 1 THEN 'espera' WHEN pe.situacao = 2 THEN 'processando' WHEN pe.situacao = 3 THEN 'ok' WHEN pe.situacao = 4 THEN 'erro' END AS situacao, strftime('%d/%m/%Y %H:%M:%S', datetime(pe.dtupdated, 'localtime')) AS dtcadastro FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.numero = ? AND situacao <> 3 ORDER BY p.nome;";
    protected static final String Select_status_pessoa_PGSQL = "SELECT p.nome, p.id_ifponto AS pis, CASE WHEN pe.situacao = 1 THEN 'espera' WHEN pe.situacao = 2 THEN 'processando' WHEN pe.situacao = 3 THEN 'ok' WHEN pe.situacao = 4 THEN 'erro' END AS situacao, TO_CHAR(pe.dtupdated, 'DD/MM/YYYY HH24:mi:ss') AS dtcadastro FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.numero = CAST(? AS INTEGER) AND situacao <> 3 ORDER BY p.nome;";
    public static final String[] Select_status_pessoa = new String[]{"SELECT p.nome, p.id_ifponto AS pis, CASE WHEN pe.situacao = 1 THEN 'espera' WHEN pe.situacao = 2 THEN 'processando' WHEN pe.situacao = 3 THEN 'ok' WHEN pe.situacao = 4 THEN 'erro' END AS situacao, strftime('%d/%m/%Y %H:%M:%S', datetime(pe.dtupdated, 'localtime')) AS dtcadastro FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.numero = ? AND situacao <> 3 ORDER BY p.nome;", "SELECT p.nome, p.id_ifponto AS pis, CASE WHEN pe.situacao = 1 THEN 'espera' WHEN pe.situacao = 2 THEN 'processando' WHEN pe.situacao = 3 THEN 'ok' WHEN pe.situacao = 4 THEN 'erro' END AS situacao, TO_CHAR(pe.dtupdated, 'DD/MM/YYYY HH24:mi:ss') AS dtcadastro FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.numero = CAST(? AS INTEGER) AND situacao <> 3 ORDER BY p.nome;"};
    protected static final String Select_status_equipamento_tot_SQLITE = "SELECT pe.situacao, COUNT(pe.id) AS total FROM pessoa_equipamento pe INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.numero = ? GROUP BY 1;";
    protected static final String Select_status_equipamento_tot_PGSQL = "SELECT pe.situacao, COUNT(pe.id) AS total FROM ifmodulo_pessoa_equipamento pe INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.numero = CAST(? AS INTEGER) GROUP BY 1;";
    public static final String[] Select_status_equipamento_tot = new String[]{"SELECT pe.situacao, COUNT(pe.id) AS total FROM pessoa_equipamento pe INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.numero = ? GROUP BY 1;", "SELECT pe.situacao, COUNT(pe.id) AS total FROM ifmodulo_pessoa_equipamento pe INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.numero = CAST(? AS INTEGER) GROUP BY 1;"};
    protected static final String Select_equipamentos_SQLITE = "SELECT e.numero, e.nome, e.modelo, COUNT(pe.id) AS total_pessoas FROM pessoa_equipamento pe INNER JOIN equipamento e ON e.id = pe.equipamento_id GROUP BY 1;";
    protected static final String Select_equipamentos_PGSQL = "SELECT e.numero, e.nome, e.modelo, COUNT(pe.id) AS total_pessoas FROM ifmodulo_pessoa_equipamento pe INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id GROUP BY 1;";
    public static final String[] Select_equipamentos = new String[]{"SELECT e.numero, e.nome, e.modelo, COUNT(pe.id) AS total_pessoas FROM pessoa_equipamento pe INNER JOIN equipamento e ON e.id = pe.equipamento_id GROUP BY 1;", "SELECT e.numero, e.nome, e.modelo, COUNT(pe.id) AS total_pessoas FROM ifmodulo_pessoa_equipamento pe INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id GROUP BY 1;"};
    protected static final String Select_status_evento_sinc_SQLITE = "SELECT ev.sincronizado AS sincronizado, CASE WHEN sincronizado = 0 THEN 'processando' WHEN sincronizado = 1 THEN 'sincronizado' END AS sincronizado, COUNT(ev.id) AS total FROM evento ev INNER JOIN equipamento e ON e.id = ev.equipamento_id WHERE e.numero = ? GROUP BY 1;";
    protected static final String Select_status_evento_sinc_PGSQL = "SELECT ev.sincronizado AS sincronizado, CASE WHEN sincronizado = 0 THEN 'processando' WHEN sincronizado = 1 THEN 'sincronizado' END AS sincronizado, COUNT(ev.id) AS total FROM ifmodulo_evento ev INNER JOIN ifmodulo_equipamento e ON e.id = ev.equipamento_id WHERE e.numero = CAST(? AS INTEGER) GROUP BY 1;";
    public static final String[] Select_status_evento_sinc = new String[]{"SELECT ev.sincronizado AS sincronizado, CASE WHEN sincronizado = 0 THEN 'processando' WHEN sincronizado = 1 THEN 'sincronizado' END AS sincronizado, COUNT(ev.id) AS total FROM evento ev INNER JOIN equipamento e ON e.id = ev.equipamento_id WHERE e.numero = ? GROUP BY 1;", "SELECT ev.sincronizado AS sincronizado, CASE WHEN sincronizado = 0 THEN 'processando' WHEN sincronizado = 1 THEN 'sincronizado' END AS sincronizado, COUNT(ev.id) AS total FROM ifmodulo_evento ev INNER JOIN ifmodulo_equipamento e ON e.id = ev.equipamento_id WHERE e.numero = CAST(? AS INTEGER) GROUP BY 1;"};
    protected static final String Select_equipamentos_StatusDB_SQLITE = "SELECT e.numero, e.nome, e.modelo FROM equipamento e;";
    protected static final String Select_equipamentos_StatusDB_PGSQL = "SELECT e.numero, e.nome, e.modelo FROM ifmodulo_equipamento e;";
    public static final String[] Select_equipamentos_StatusDB = new String[]{"SELECT e.numero, e.nome, e.modelo FROM equipamento e;", "SELECT e.numero, e.nome, e.modelo FROM ifmodulo_equipamento e;"};
    protected static final String Select_status_evento_tot_SQLITE = "SELECT eq.id, MAX(e.nsr) AS nsr, strftime('%d/%m/%Y %H:%M:%S', MAX(datetime(e.dtupdated, 'localtime'))) AS dtcadastro, strftime('%d/%m/%Y %H:%M:%S', MAX(e.datahora)) AS datahora FROM evento e INNER JOIN equipamento eq on eq.id = e.equipamento_id WHERE eq.numero = ? GROUP BY 1;";
    protected static final String Select_status_evento_tot_PGSQL = "SELECT eq.id, MAX(e.nsr) AS nsr, TO_CHAR(MAX(e.dtupdated), 'DD/MM/YYYY HH24:mi:ss') AS dtcadastro, TO_CHAR(MAX(e.datahora), 'DD/MM/YYYY HH24:mi:ss') AS datahora FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq on eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) GROUP BY 1;";
    public static final String[] Select_status_evento_tot = new String[]{"SELECT eq.id, MAX(e.nsr) AS nsr, strftime('%d/%m/%Y %H:%M:%S', MAX(datetime(e.dtupdated, 'localtime'))) AS dtcadastro, strftime('%d/%m/%Y %H:%M:%S', MAX(e.datahora)) AS datahora FROM evento e INNER JOIN equipamento eq on eq.id = e.equipamento_id WHERE eq.numero = ? GROUP BY 1;", "SELECT eq.id, MAX(e.nsr) AS nsr, TO_CHAR(MAX(e.dtupdated), 'DD/MM/YYYY HH24:mi:ss') AS dtcadastro, TO_CHAR(MAX(e.datahora), 'DD/MM/YYYY HH24:mi:ss') AS datahora FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq on eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) GROUP BY 1;"};
    protected static final String Select_cartoes_SQLITE = "SELECT c.numero as nro, c.tipo, c.hrinicio, c.hrfim, c.liberador, c.json, c.id, c.dtupdated FROM cartao c WHERE c.pessoa_id = ? AND c.ativo = 1 Order by c.dtupdated desc;";
    protected static final String Select_cartoes_PGSQL = "SELECT c.numero as nro, c.tipo, c.hrinicio, c.hrfim, c.liberador, c.json, c.id, c.dtupdated FROM ifmodulo_cartao c WHERE c.pessoa_id = CAST(? AS INTEGER) AND c.ativo = 1 Order by c.dtupdated desc;";
    public static final String[] Select_cartoes = new String[]{"SELECT c.numero as nro, c.tipo, c.hrinicio, c.hrfim, c.liberador, c.json, c.id, c.dtupdated FROM cartao c WHERE c.pessoa_id = ? AND c.ativo = 1 Order by c.dtupdated desc;", "SELECT c.numero as nro, c.tipo, c.hrinicio, c.hrfim, c.liberador, c.json, c.id, c.dtupdated FROM ifmodulo_cartao c WHERE c.pessoa_id = CAST(? AS INTEGER) AND c.ativo = 1 Order by c.dtupdated desc;"};
    protected static final String Select_bios_SQLITE = "SELECT b.vendor, b.encode, b.template, b.json FROM biometria b INNER JOIN pessoa p ON p.id = pessoa_id WHERE p.id = ?;";
    protected static final String Select_bios_PGSQL = "SELECT b.vendor, b.encode, b.template, b.json FROM ifmodulo_biometria b INNER JOIN ifmodulo_pessoa p ON p.id = pessoa_id WHERE p.id = CAST(? AS INTEGER);";
    public static final String[] Select_bios = new String[]{"SELECT b.vendor, b.encode, b.template, b.json FROM biometria b INNER JOIN pessoa p ON p.id = pessoa_id WHERE p.id = ?;", "SELECT b.vendor, b.encode, b.template, b.json FROM ifmodulo_biometria b INNER JOIN ifmodulo_pessoa p ON p.id = pessoa_id WHERE p.id = CAST(? AS INTEGER);"};
    protected static final String Select_bio_SQLITE = "SELECT b.template FROM biometria b INNER JOIN pessoa p ON p.id = pessoa_id WHERE p.id = ?;";
    protected static final String Select_bio_PGSQL = "SELECT b.template FROM ifmodulo_biometria b INNER JOIN ifmodulo_pessoa p ON p.id = pessoa_id WHERE p.id = CAST(? AS INTEGER);";
    public static final String[] Select_bio = new String[]{"SELECT b.template FROM biometria b INNER JOIN pessoa p ON p.id = pessoa_id WHERE p.id = ?;", "SELECT b.template FROM ifmodulo_biometria b INNER JOIN ifmodulo_pessoa p ON p.id = pessoa_id WHERE p.id = CAST(? AS INTEGER);"};
    protected static final String Select_qtd_pessoa_SQLITE = "SELECT COUNT(*) AS qtd_pessoa FROM pessoa";
    protected static final String Select_qtd_pessoa_PGSQL = "SELECT COUNT(*) AS qtd_pessoa FROM ifmodulo_pessoa";
    public static final String[] Select_qtd_pessoa = new String[]{"SELECT COUNT(*) AS qtd_pessoa FROM pessoa", "SELECT COUNT(*) AS qtd_pessoa FROM ifmodulo_pessoa"};
    protected static final String Select_qtd_bio_SQLITE = "SELECT COUNT(*) AS qtd_bio FROM biometria";
    protected static final String Select_qtd_bio_PGSQL = "SELECT COUNT(*) AS qtd_bio FROM ifmodulo_biometria";
    public static final String[] Select_qtd_bio = new String[]{"SELECT COUNT(*) AS qtd_bio FROM biometria", "SELECT COUNT(*) AS qtd_bio FROM ifmodulo_biometria"};
    protected static final String Insert_evento_SQLITE = "INSERT INTO evento (pessoa_id,equipamento_id, nsr, afd, tipo_afd, datahora, descricao, tipo_evento, codigo) SELECT p.id, e.id, ?, ?, ?, ?, ?, ?, ? FROM pessoa p, equipamento e WHERE ((p.pis != ? AND p.pis = ?) OR (p.id_ifponto != ? AND p.id_ifponto = ?)) AND e.codigo_ifponto = ?;";
    protected static final String Insert_evento_PGSQL = "INSERT INTO ifmodulo_evento (pessoa_id,equipamento_id, nsr, afd, tipo_afd, datahora, descricao, tipo_evento, codigo) SELECT p.id, e.id, CAST(? AS INTEGER), ?, CAST(? AS INTEGER), TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'), ?, CAST(? AS INTEGER), CAST(? AS INTEGER) FROM ifmodulo_pessoa p, ifmodulo_equipamento e WHERE ((p.pis != ? AND p.pis = ?) OR (p.id_ifponto != ? AND p.id_ifponto = ?)) AND e.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Insert_evento = new String[]{"INSERT INTO evento (pessoa_id,equipamento_id, nsr, afd, tipo_afd, datahora, descricao, tipo_evento, codigo) SELECT p.id, e.id, ?, ?, ?, ?, ?, ?, ? FROM pessoa p, equipamento e WHERE ((p.pis != ? AND p.pis = ?) OR (p.id_ifponto != ? AND p.id_ifponto = ?)) AND e.codigo_ifponto = ?;", "INSERT INTO ifmodulo_evento (pessoa_id,equipamento_id, nsr, afd, tipo_afd, datahora, descricao, tipo_evento, codigo) SELECT p.id, e.id, CAST(? AS INTEGER), ?, CAST(? AS INTEGER), TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'), ?, CAST(? AS INTEGER), CAST(? AS INTEGER) FROM ifmodulo_pessoa p, ifmodulo_equipamento e WHERE ((p.pis != ? AND p.pis = ?) OR (p.id_ifponto != ? AND p.id_ifponto = ?)) AND e.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Insert_evento_anonimo_SQLITE = "INSERT INTO evento (equipamento_id, nsr, afd, tipo_afd, datahora, descricao, tipo_evento, codigo) SELECT e.id, ?, ?, ?, ?, ?, ?, ? FROM equipamento e WHERE e.codigo_ifponto = ?;";
    protected static final String Insert_evento_anonimo_PGSQL = "INSERT INTO ifmodulo_evento (equipamento_id, nsr, afd, tipo_afd, datahora, descricao, tipo_evento, codigo) SELECT e.id, CAST(? AS INTEGER), ?, CAST(? AS INTEGER), TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'), ?, CAST(? AS INTEGER), CAST(? AS INTEGER) FROM ifmodulo_equipamento e WHERE e.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Insert_evento_anonimo = new String[]{"INSERT INTO evento (equipamento_id, nsr, afd, tipo_afd, datahora, descricao, tipo_evento, codigo) SELECT e.id, ?, ?, ?, ?, ?, ?, ? FROM equipamento e WHERE e.codigo_ifponto = ?;", "INSERT INTO ifmodulo_evento (equipamento_id, nsr, afd, tipo_afd, datahora, descricao, tipo_evento, codigo) SELECT e.id, CAST(? AS INTEGER), ?, CAST(? AS INTEGER), TO_TIMESTAMP(?,'YYYY-MM-DD HH24:MI:SS'), ?, CAST(? AS INTEGER), CAST(? AS INTEGER) FROM ifmodulo_equipamento e WHERE e.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Insert_evento_pis_SQLITE = "INSERT INTO evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM pessoa p, equipamento e WHERE p.pis = ? AND e.numero = ?;";
    protected static final String Insert_evento_pis_PGSQL = "INSERT INTO ifmodulo_evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM ifmodulo_pessoa p, ifmodulo_equipamento e WHERE p.pis = ? AND e.numero = CAST(? AS INTEGER);";
    public static final String[] Insert_evento_pis = new String[]{"INSERT INTO evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM pessoa p, equipamento e WHERE p.pis = ? AND e.numero = ?;", "INSERT INTO ifmodulo_evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM ifmodulo_pessoa p, ifmodulo_equipamento e WHERE p.pis = ? AND e.numero = CAST(? AS INTEGER);"};
    protected static final String Insert_evento_login_SQLITE = "INSERT INTO evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM pessoa p, equipamento e WHERE p.login = ? AND p.senha = ? AND e.numero = ?;";
    protected static final String Insert_evento_login_PGSQL = "INSERT INTO ifmodulo_evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM ifmodulo_pessoa p, ifmodulo_equipamento e WHERE p.login = ? AND p.senha = ? AND e.numero = CAST(? AS INTEGER);";
    public static final String[] Insert_evento_login = new String[]{"INSERT INTO evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM pessoa p, equipamento e WHERE p.login = ? AND p.senha = ? AND e.numero = ?;", "INSERT INTO ifmodulo_evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM ifmodulo_pessoa p, ifmodulo_equipamento e WHERE p.login = ? AND p.senha = ? AND e.numero = CAST(? AS INTEGER);"};
    protected static final String Select_evento_nsr_SQLITE = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, sincronizado FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? AND e.nsr = ?;";
    protected static final String Select_evento_nsr_PGSQL = "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, sincronizado FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) AND e.nsr = CAST(? AS INTEGER);";
    public static final String[] Select_evento_nsr = new String[]{"SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, sincronizado FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? AND e.nsr = ?;", "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, sincronizado FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) AND e.nsr = CAST(? AS INTEGER);"};
    protected static final String Select_ultimo_evento_nro_SQLITE = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, sincronizado FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? ORDER BY datahora DESC limit 1;";
    protected static final String Select_ultimo_evento_nro_PGSQL = "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, sincronizado FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) ORDER BY datahora DESC limit 1;";
    public static final String[] Select_ultimo_evento_nro = new String[]{"SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, sincronizado FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? ORDER BY datahora DESC limit 1;", "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, sincronizado FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) ORDER BY datahora DESC limit 1;"};
    protected static final String Select_ultimo_evento_SQLITE = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.id as nsr, printf('%09d%d%s%012d', e.id, tipo_afd, strftime('%d%m%Y%H%M',datahora), p.pis, p.cpf) as afd, p.nome, p.pis, p.cpf FROM evento e INNER JOIN pessoa p ON p.id = e.pessoa_id WHERE e.id = last_insert_rowid();";
    protected static final String Select_ultimo_evento_PGSQL = "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.id as nsr, format('%09d%d%s%012d', e.id, tipo_afd, TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss'), p.pis, p.cpf) as afd, p.nome, p.pis, p.cpf FROM ifmodulo_evento e INNER JOIN ifmodulo_pessoa p ON p.id = e.pessoa_id WHERE e.id = currval('evento_id_seq'::regclass);";
    public static final String[] Select_ultimo_evento = new String[]{"SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.id as nsr, printf('%09d%d%s%012d', e.id, tipo_afd, strftime('%d%m%Y%H%M',datahora), p.pis, p.cpf) as afd, p.nome, p.pis, p.cpf FROM evento e INNER JOIN pessoa p ON p.id = e.pessoa_id WHERE e.id = last_insert_rowid();", "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.id as nsr, format('%09d%d%s%012d', e.id, tipo_afd, TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss'), p.pis, p.cpf) as afd, p.nome, p.pis, p.cpf FROM ifmodulo_evento e INNER JOIN ifmodulo_pessoa p ON p.id = e.pessoa_id WHERE e.id = currval('evento_id_seq'::regclass);"};
    protected static final String Select_ultimos_eventos_SQLITE = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, printf('%09d%d%s%012d', e.id, tipo_afd, strftime('%d%m%Y%H%M',datahora), p.pis, p.cpf) as afd, p.nome, p.pis, p.cpf FROM evento e INNER JOIN pessoa p ON p.id = e.pessoa_id INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? limit ?;";
    protected static final String Select_ultimos_eventos_PGSQL = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, printf('%09d%d%s%012d', e.id, tipo_afd, strftime('%d%m%Y%H%M',datahora), p.pis, p.cpf) as afd, p.nome, p.pis, p.cpf FROM ifmodulo_evento e INNER JOIN ifmodulo_pessoa p ON p.id = e.pessoa_id INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) limit CAST(? AS INTEGER);";
    public static final String[] Select_ultimos_eventos = new String[]{"SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, printf('%09d%d%s%012d', e.id, tipo_afd, strftime('%d%m%Y%H%M',datahora), p.pis, p.cpf) as afd, p.nome, p.pis, p.cpf FROM evento e INNER JOIN pessoa p ON p.id = e.pessoa_id INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? limit ?;", "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, printf('%09d%d%s%012d', e.id, tipo_afd, strftime('%d%m%Y%H%M',datahora), p.pis, p.cpf) as afd, p.nome, p.pis, p.cpf FROM ifmodulo_evento e INNER JOIN ifmodulo_pessoa p ON p.id = e.pessoa_id INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) limit CAST(? AS INTEGER);"};
    protected static final String Select_descricao_no_sync_events_SQLITE = "SELECT e.descricao, e.id as evento_id FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? AND e.sincronizado = 0 ORDER BY datahora limit ?";
    protected static final String Select_descricao_no_sync_events_PGSQL = "SELECT e.descricao, e.id as evento_id FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) AND e.sincronizado = 0 ORDER BY datahora limit CAST(? AS INTEGER)";
    public static final String[] Select_descricao_no_sync_events = new String[]{"SELECT e.descricao, e.id as evento_id FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? AND e.sincronizado = 0 ORDER BY datahora limit ?", "SELECT e.descricao, e.id as evento_id FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) AND e.sincronizado = 0 ORDER BY datahora limit CAST(? AS INTEGER)"};
    protected static final String Select_no_sync_events_SQLITE = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, codigo, e.tipo_evento FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? AND e.sincronizado = 0 ORDER BY datahora limit ?;";
    protected static final String Select_no_sync_events_PGSQL = "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, codigo, e.tipo_evento FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) AND e.sincronizado = 0 ORDER BY datahora limit CAST(? AS INTEGER);";
    public static final String[] Select_no_sync_events = new String[]{"SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, codigo, e.tipo_evento FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? AND e.sincronizado = 0 ORDER BY datahora limit ?;", "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, codigo, e.tipo_evento FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) AND e.sincronizado = 0 ORDER BY datahora limit CAST(? AS INTEGER);"};
    protected static final String Select_no_sync_events_afd_SQLITE = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, codigo FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? AND e.sincronizado = 0 ORDER BY datahora limit ?;";
    protected static final String Select_no_sync_events_afd_PGSQL = "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, codigo FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) AND e.sincronizado = 0 ORDER BY datahora limit CAST(? AS INTEGER);";
    public static final String[] Select_no_sync_events_afd = new String[]{"SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, codigo FROM evento e INNER JOIN equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = ? AND e.sincronizado = 0 ORDER BY datahora limit ?;", "SELECT TO_CHAR(datahora, 'YYYY-MM-DD HH24:mi:ss') as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, codigo FROM ifmodulo_evento e INNER JOIN ifmodulo_equipamento eq ON eq.id = e.equipamento_id WHERE eq.numero = CAST(? AS INTEGER) AND e.sincronizado = 0 ORDER BY datahora limit CAST(? AS INTEGER);"};
    protected static final String Select_no_sync_results_SQLITE = "SELECT pe.dtupdated as datahora, pe.codigo_ifponto as cod, p.nome, p.codigo_ifponto as codigo, pe.descricao as status, CASE situacao WHEN '3' THEN '0' WHEN '4' THEN '1' END as cod_error FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.numero = ? AND pe.sincronizado = 0 AND (pe.situacao = '3' OR pe.situacao = '4') limit ?";
    protected static final String Select_no_sync_results_PGSQL = "SELECT pe.dtupdated as datahora, pe.codigo_ifponto as cod, p.nome, p.codigo_ifponto as codigo, pe.descricao as status, CASE situacao WHEN '3' THEN '0' WHEN '4' THEN '1' END as cod_error FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.numero = CAST(? AS INTEGER) AND pe.sincronizado = 0 AND (pe.situacao = '3' OR pe.situacao = '4') limit CAST(? AS INTEGER)";
    public static final String[] Select_no_sync_results = new String[]{"SELECT pe.dtupdated as datahora, pe.codigo_ifponto as cod, p.nome, p.codigo_ifponto as codigo, pe.descricao as status, CASE situacao WHEN '3' THEN '0' WHEN '4' THEN '1' END as cod_error FROM pessoa p INNER JOIN pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN equipamento e ON e.id = pe.equipamento_id WHERE e.numero = ? AND pe.sincronizado = 0 AND (pe.situacao = '3' OR pe.situacao = '4') limit ?", "SELECT pe.dtupdated as datahora, pe.codigo_ifponto as cod, p.nome, p.codigo_ifponto as codigo, pe.descricao as status, CASE situacao WHEN '3' THEN '0' WHEN '4' THEN '1' END as cod_error FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_equipamento pe ON p.id = pe.pessoa_id INNER JOIN ifmodulo_equipamento e ON e.id = pe.equipamento_id WHERE e.numero = CAST(? AS INTEGER) AND pe.sincronizado = 0 AND (pe.situacao = '3' OR pe.situacao = '4') limit CAST(? AS INTEGER)"};
    protected static final String Select_no_sync_bios_SQLITE = "SELECT p.codigo_ifponto as codigo, p.pis, p.cpf, b.template, b.vendor, b.encode, b.id as bio_id FROM pessoa p INNER JOIN biometria b ON p.id = b.pessoa_id WHERE b.sincronizado = 0 limit ?;";
    protected static final String Select_no_sync_bios_PGSQL = "SELECT p.codigo_ifponto as codigo, p.pis, p.cpf, b.template, b.vendor, b.encode, b.id as bio_id FROM ifmodulo_pessoa p INNER JOIN ifmodulo_biometria b ON p.id = b.pessoa_id WHERE b.sincronizado = 0 limit CAST(? AS INTEGER);";
    public static final String[] Select_no_sync_bios = new String[]{"SELECT p.codigo_ifponto as codigo, p.pis, p.cpf, b.template, b.vendor, b.encode, b.id as bio_id FROM pessoa p INNER JOIN biometria b ON p.id = b.pessoa_id WHERE b.sincronizado = 0 limit ?;", "SELECT p.codigo_ifponto as codigo, p.pis, p.cpf, b.template, b.vendor, b.encode, b.id as bio_id FROM ifmodulo_pessoa p INNER JOIN ifmodulo_biometria b ON p.id = b.pessoa_id WHERE b.sincronizado = 0 limit CAST(? AS INTEGER);"};
    protected static final String Update_sync_evento_SQLITE = "UPDATE evento SET sincronizado = 1 WHERE id = ?;";
    protected static final String Update_sync_evento_PGSQL = "UPDATE ifmodulo_evento SET sincronizado = 1 WHERE id = CAST(? AS INTEGER);";
    public static final String[] Update_sync_evento = new String[]{"UPDATE evento SET sincronizado = 1 WHERE id = ?;", "UPDATE ifmodulo_evento SET sincronizado = 1 WHERE id = CAST(? AS INTEGER);"};
    protected static final String Update_rollback_evento_SQLITE = "UPDATE evento SET sincronizado = 0 WHERE id = ?;";
    protected static final String Update_rollback_evento_PGSQL = "UPDATE ifmodulo_evento SET sincronizado = 0 WHERE id = CAST(? AS INTEGER);";
    public static final String[] Update_rollback_evento = new String[]{"UPDATE evento SET sincronizado = 0 WHERE id = ?;", "UPDATE ifmodulo_evento SET sincronizado = 0 WHERE id = CAST(? AS INTEGER);"};
    protected static final String Update_rollback_eventos_from_nsr_SQLITE = "UPDATE evento SET sincronizado = 0 WHERE equipamento_id IN (SELECT id FROM equipamento WHERE numero = ?) AND nsr >= ?;";
    protected static final String Update_rollback_eventos_from_nsr_PGSQL = "UPDATE ifmodulo_evento SET sincronizado = 0 WHERE equipamento_id IN (SELECT id FROM ifmodulo_equipamento WHERE numero = CAST(? AS INTEGER)) AND nsr >= ?;";
    public static final String[] Update_rollback_eventos_from_nsr = new String[]{"UPDATE evento SET sincronizado = 0 WHERE equipamento_id IN (SELECT id FROM equipamento WHERE numero = ?) AND nsr >= ?;", "UPDATE ifmodulo_evento SET sincronizado = 0 WHERE equipamento_id IN (SELECT id FROM ifmodulo_equipamento WHERE numero = CAST(? AS INTEGER)) AND nsr >= ?;"};
    protected static final String Update_sync_result_SQLITE = "UPDATE pessoa_equipamento SET sincronizado = 1 WHERE codigo_ifponto = ?;";
    protected static final String Update_sync_result_PGSQL = "UPDATE ifmodulo_pessoa_equipamento SET sincronizado = 1 WHERE codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Update_sync_result = new String[]{"UPDATE pessoa_equipamento SET sincronizado = 1 WHERE codigo_ifponto = ?;", "UPDATE ifmodulo_pessoa_equipamento SET sincronizado = 1 WHERE codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Update_rollback_result_SQLITE = "UPDATE pessoa_equipamento SET sincronizado = 0 WHERE codigo_ifponto = ?;";
    protected static final String Update_rollback_result_PGSQL = "UPDATE ifmodulo_pessoa_equipamento SET sincronizado = 0 WHERE codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Update_rollback_result = new String[]{"UPDATE pessoa_equipamento SET sincronizado = 0 WHERE codigo_ifponto = ?;", "UPDATE ifmodulo_pessoa_equipamento SET sincronizado = 0 WHERE codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Update_sync_bio_SQLITE = "UPDATE biometria SET sincronizado = 1 WHERE id = ?;";
    protected static final String Update_sync_bio_PGSQL = "UPDATE ifmodulo_biometria SET sincronizado = 1 WHERE id = CAST(? AS INTEGER);";
    public static final String[] Update_sync_bio = new String[]{"UPDATE biometria SET sincronizado = 1 WHERE id = ?;", "UPDATE ifmodulo_biometria SET sincronizado = 1 WHERE id = CAST(? AS INTEGER);"};
    protected static final String Select_intervalo_SQLITE = "SELECT i.nome, i.dia, inicio, fim FROM pessoa p INNER JOIN pessoa_nivel pn ON p.id = pn.pessoa_id INNER JOIN equipamento_nivel en ON pn.nivel_id = en.nivel_id INNER JOIN intervalo_equipamento_nivel ien ON en.id = ien.equipamento_nivel_id INNER JOIN intervalo i ON i.id = ien.intervalo_id WHERE p.codigo_ifponto = ?;";
    protected static final String Select_intervalo_PGSQL = "SELECT i.nome, i.dia, CAST((3600 * EXTRACT(HOURS FROM inicio) + 60 * EXTRACT(MINUTES FROM inicio) + EXTRACT(SECONDS FROM inicio)) AS INTEGER) as inicio, CAST((3600 * EXTRACT(HOURS FROM fim) + 60 * EXTRACT(MINUTES FROM fim) + EXTRACT(SECONDS FROM fim)) AS INTEGER) as fim FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_nivel pn ON p.id = pn.pessoa_id INNER JOIN ifmodulo_equipamento_nivel en ON pn.nivel_id = en.nivel_id INNER JOIN ifmodulo_intervalo_equipamento_nivel ien ON en.id = ien.equipamento_nivel_id INNER JOIN ifmodulo_intervalo i ON i.id = ien.intervalo_id INNER JOIN ifmodulo_equipamento e ON e.id = en.equipamento_id WHERE e.numero = CAST(? AS INTEGER) AND p.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Select_intervalo = new String[]{"SELECT i.nome, i.dia, inicio, fim FROM pessoa p INNER JOIN pessoa_nivel pn ON p.id = pn.pessoa_id INNER JOIN equipamento_nivel en ON pn.nivel_id = en.nivel_id INNER JOIN intervalo_equipamento_nivel ien ON en.id = ien.equipamento_nivel_id INNER JOIN intervalo i ON i.id = ien.intervalo_id WHERE p.codigo_ifponto = ?;", "SELECT i.nome, i.dia, CAST((3600 * EXTRACT(HOURS FROM inicio) + 60 * EXTRACT(MINUTES FROM inicio) + EXTRACT(SECONDS FROM inicio)) AS INTEGER) as inicio, CAST((3600 * EXTRACT(HOURS FROM fim) + 60 * EXTRACT(MINUTES FROM fim) + EXTRACT(SECONDS FROM fim)) AS INTEGER) as fim FROM ifmodulo_pessoa p INNER JOIN ifmodulo_pessoa_nivel pn ON p.id = pn.pessoa_id INNER JOIN ifmodulo_equipamento_nivel en ON pn.nivel_id = en.nivel_id INNER JOIN ifmodulo_intervalo_equipamento_nivel ien ON en.id = ien.equipamento_nivel_id INNER JOIN ifmodulo_intervalo i ON i.id = ien.intervalo_id INNER JOIN ifmodulo_equipamento e ON e.id = en.equipamento_id WHERE e.numero = CAST(? AS INTEGER) AND p.codigo_ifponto = CAST(? AS INTEGER);"};
    protected static final String Select_dupla_passagem_SQLITE = "Select ev.datahora, inicio, fim From evento ev INNER JOIN equipamento e ON ev.equipamento_id = e.id INNER JOIN equipamento_nivel en ON en.equipamento_id = e.id INNER JOIN nivel n ON en.nivel_id = n.id INNER JOIN intervalo_equipamento_nivel ien ON ien.equipamento_nivel_id = en.id INNER JOIN intervalo i ON i.id = ien.intervalo_id where e.numero = ? AND ev.codigo = ? AND ev.datahora >= current_date;";
    protected static final String Select_dupla_passagem_PGSQL = "Select ev.datahora, 3600 * EXTRACT(HOURS FROM ev.datahora) + 60 * EXTRACT(MINUTES FROM ev.datahora) + EXTRACT(SECONDS FROM ev.datahora) as reg, 3600 * EXTRACT(HOURS FROM i.inicio) + 60 * EXTRACT(MINUTES FROM i.inicio) + EXTRACT(SECONDS FROM i.inicio) as inicio, 3600 * EXTRACT(HOURS FROM i.fim) + 60 * EXTRACT(MINUTES FROM i.fim) + EXTRACT(SECONDS FROM i.fim) as fim From ifmodulo_evento ev INNER JOIN ifmodulo_equipamento e ON ev.equipamento_id = e.id INNER JOIN ifmodulo_equipamento_nivel en ON en.equipamento_id = e.id INNER JOIN ifmodulo_ifmodulo_nivel2 n ON en.nivel_id = n.id INNER JOIN ifmodulo_intervalo_equipamento_nivel ien ON ien.equipamento_nivel_id = en.id INNER JOIN ifmodulo_intervalo i ON i.id = ien.intervalo_id where ev.datahora >= current_date AND current_time > i.inicio AND current_time < i.fim AND ev.datahora::time > i.inicio AND ev.datahora::time < i.fim AND e.numero = CAST(? AS INTEGER) AND ev.codigo = CAST(? AS INTEGER);";
    public static final String[] Select_dupla_passagem = new String[]{"Select ev.datahora, inicio, fim From evento ev INNER JOIN equipamento e ON ev.equipamento_id = e.id INNER JOIN equipamento_nivel en ON en.equipamento_id = e.id INNER JOIN nivel n ON en.nivel_id = n.id INNER JOIN intervalo_equipamento_nivel ien ON ien.equipamento_nivel_id = en.id INNER JOIN intervalo i ON i.id = ien.intervalo_id where e.numero = ? AND ev.codigo = ? AND ev.datahora >= current_date;", "Select ev.datahora, 3600 * EXTRACT(HOURS FROM ev.datahora) + 60 * EXTRACT(MINUTES FROM ev.datahora) + EXTRACT(SECONDS FROM ev.datahora) as reg, 3600 * EXTRACT(HOURS FROM i.inicio) + 60 * EXTRACT(MINUTES FROM i.inicio) + EXTRACT(SECONDS FROM i.inicio) as inicio, 3600 * EXTRACT(HOURS FROM i.fim) + 60 * EXTRACT(MINUTES FROM i.fim) + EXTRACT(SECONDS FROM i.fim) as fim From ifmodulo_evento ev INNER JOIN ifmodulo_equipamento e ON ev.equipamento_id = e.id INNER JOIN ifmodulo_equipamento_nivel en ON en.equipamento_id = e.id INNER JOIN ifmodulo_ifmodulo_nivel2 n ON en.nivel_id = n.id INNER JOIN ifmodulo_intervalo_equipamento_nivel ien ON ien.equipamento_nivel_id = en.id INNER JOIN ifmodulo_intervalo i ON i.id = ien.intervalo_id where ev.datahora >= current_date AND current_time > i.inicio AND current_time < i.fim AND ev.datahora::time > i.inicio AND ev.datahora::time < i.fim AND e.numero = CAST(? AS INTEGER) AND ev.codigo = CAST(? AS INTEGER);"};
    protected static final String Insert_evento_online_SQLITE = "INSERT INTO evento (pessoa_id,equipamento_id, codigo) SELECT p.id, e.id, ? FROM pessoa p, equipamento e WHERE e.numero = ? AND p.codigo_ifponto = ?;";
    protected static final String Insert_evento_online_PGSQL = "INSERT INTO ifmodulo_evento (pessoa_id,equipamento_id, codigo) SELECT p.id, e.id, CAST(? AS INTEGER) FROM ifmodulo_pessoa p, ifmodulo_equipamento e WHERE e.numero = CAST(? AS INTEGER) AND p.codigo_ifponto = CAST(? AS INTEGER);";
    public static final String[] Insert_evento_online = new String[]{"INSERT INTO evento (pessoa_id,equipamento_id, codigo) SELECT p.id, e.id, ? FROM pessoa p, equipamento e WHERE e.numero = ? AND p.codigo_ifponto = ?;", "INSERT INTO ifmodulo_evento (pessoa_id,equipamento_id, codigo) SELECT p.id, e.id, CAST(? AS INTEGER) FROM ifmodulo_pessoa p, ifmodulo_equipamento e WHERE e.numero = CAST(? AS INTEGER) AND p.codigo_ifponto = CAST(? AS INTEGER);"};
}

