/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import android.content.Context;
import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.SQL;
import com.ifractal.ifponto.SQLChange;
import com.ifractal.ifponto.Version;
import com.ifractal.utils.ConnectDB;
import com.ifractal.utils.ConnectDBAndroid;
import com.ifractal.utils.ConnectJDBC;
import com.ifractal.utils.ConsumerDB;
import com.ifractal.utils.Getopts;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.SessionDB;
import com.ifractal.utils.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class IfpontoDB
extends Producer
implements ConsumerDB,
Cloneable {
    public static final String INIFILE = IFPONTO_config.filename.replace("/", File.separator);
    public static HashMap<String, String> config = null;
    protected ConnectDB cdb = null;
    protected String dbname = null;
    protected SessionDB sess = null;

    public IfpontoDB(String[] args, Observer obs) {
        super(obs);
    }

    public void init(String[] params, Observer obs) {
        config = IFPONTO_config.getParams();
        Getopts.parseIniFile(config, INIFILE);
        Getopts.parseStringArray(config, params);
        JSONObject jo = new JSONObject();
        jo.putAll(config);
        try {
            Class.forName("org.postgresql.Driver");
            Class.forName("android.database.sqlite.SQLiteOpenHelper");
            this.dbname = config.get("DB").replace("/", File.separator);
            this.cdb = new ConnectDBAndroid((Context)Producer.androidContext, this.dbname, Version.getRevision(), this);
            return;
        }
        catch (ClassNotFoundException cnfe) {
            this.dbname = config.get("DB").equals("conf/ifponto.db") ? "jdbc:sqlite:" + config.get("DB").replace("/", File.separator) : config.get("DB");
            this.cdb = new ConnectJDBC(this.dbname, Version.getRevision(), this, obs);
            return;
        }
    }

    @Override
    public String getSQLSchema() {
        this.sendMessage(4, "Inicializa Banco de Dados.");
        InputStream is = this.getClass().getResourceAsStream("/com/ifractal/ifponto/rep.sql");
        String content = Util.getContent(is);
        return content;
    }

    @Override
    public String[] getStatements() {
        int i = 0;
        if (config.get("DBM").equals("PGSQL")) {
            i = 1;
        }
        String[] sts = new String[]{"Insert_equipamento", SQL.Insert_equipamento[i], "Update_equipamento", SQL.Update_equipamento[i], "Update_inativa_equipamentos", SQL.Update_inativa_equipamentos[i], "Update_equipamento_nsr", SQL.Update_equipamento_nsr[i], "Update_equipamento_siin_nsr", SQL.Update_equipamento_siin_nsr[i], "Update_equipamento_status", SQL.Update_equipamento_status[i], "Insert_pessoa", SQL.Insert_pessoa[i], "Update_pessoa", SQL.Update_pessoa[i], "Insert_pessoa_equipamento", SQL.Insert_pessoa_equipamento[i], "Select_equipamento", SQL.Select_equipamento[i], "Select_pessoa", SQL.Select_pessoa[i], "Update_pessoa_equipamento", SQL.Update_pessoa_equipamento[i], "Update_pessoa_equipamento", SQL.Update_pessoa_equipamento[i], "Update_pessoa_equipamento_biodesk", SQL.Update_pessoa_equipamento_biodesk[i], "Delete_cartao", SQL.Delete_cartao[i], "Insert_cartao", SQL.Insert_cartao[i], "Update_cartao", SQL.Update_cartao[i], "Delete_bio", SQL.Delete_bio[i], "Delete_bio_desktop", SQL.Delete_bio_desktop[i], "Update_Recollect_All_Nsr", SQL.Update_Recollect_All_Nsr[i], "Delete_events", SQL.Delete_events[i], "Insert_bio", SQL.Insert_bio[i], "Insert_bio_desktop", SQL.Insert_bio_desktop[i], "Delete_Pessoa_Nivel", SQL.Delete_Pessoa_Nivel[i], "Delete_Nivel", SQL.Delete_Nivel[i], "Delete_Equipamento_Nivel", SQL.Delete_Equipamento_Nivel[i], "Delete_Intervalo_Equipamento_Nivel", SQL.Delete_Intervalo_Equipamento_Nivel[i], "Delete_Intervalo", SQL.Delete_Intervalo[i], "Insert_Pessoa_Nivel", SQL.Insert_Pessoa_Nivel[i], "Insert_Nivel", SQL.Insert_Nivel[i], "Insert_Equipamento_Nivel", SQL.Insert_Equipamento_Nivel[i], "Insert_Intervalo_Equipamento_Nivel", SQL.Insert_Intervalo_Equipamento_Nivel[i], "Insert_Intervalo", SQL.Insert_Intervalo[i], "Select_devices", SQL.Select_devices[i], "Select_device_nro", SQL.Select_device_nro[i], "Select_device_cod", SQL.Select_device_cod[i], "Select_pessoas", SQL.Select_pessoas[i], "Select_pessoa_nome", SQL.Select_pessoa_nome[i], "Select_pessoa_pis", SQL.Select_pessoa_pis[i], "Select_qtd_pessoa", SQL.Select_qtd_pessoa[i], "Select_qtd_bio", SQL.Select_qtd_bio[i], "Select_pendentes", SQL.Select_pendentes[i], "Select_pendentes_processando", SQL.Select_pendentes_processando[i], "Select_descricao_pendente", SQL.Select_descricao_pendente[i], "Select_status_evento_tot", SQL.Select_status_evento_tot[i], "Select_status_evento_sinc", SQL.Select_status_evento_sinc[i], "Select_status_equipamento_tot", SQL.Select_status_equipamento_tot[i], "Select_status_pessoa", SQL.Select_status_pessoa[i], "Select_equipamentos", SQL.Select_equipamentos[i], "Select_equipamentos_StatusDB", SQL.Select_equipamentos_StatusDB[i], "Update_pendentes", SQL.Update_pendentes[i], "Select_cartoes", SQL.Select_cartoes[i], "Select_bios", SQL.Select_bios[i], "Select_bio", SQL.Select_bio[i], "Select_evento_nsr", SQL.Select_evento_nsr[i], "Select_ultimo_evento_nro", SQL.Select_ultimo_evento_nro[i], "Select_ultimo_evento", SQL.Select_ultimo_evento[i], "Select_ultimos_eventos", SQL.Select_ultimos_eventos[i], "Select_descricao_no_sync_events", SQL.Select_descricao_no_sync_events[i], "Select_no_sync_events", SQL.Select_no_sync_events[i], "Select_no_sync_events_afd", SQL.Select_no_sync_events_afd[i], "Select_no_sync_results", SQL.Select_no_sync_results[i], "Select_no_sync_bios", SQL.Select_no_sync_bios[i], "Update_sync_evento", SQL.Update_sync_evento[i], "Update_rollback_evento", SQL.Update_rollback_evento[i], "Update_rollback_eventos_from_nsr", SQL.Update_rollback_eventos_from_nsr[i], "Update_sync_result", SQL.Update_sync_result[i], "Update_rollback_result", SQL.Update_rollback_result[i], "Update_sync_bio", SQL.Update_sync_bio[i], "Insert_evento", SQL.Insert_evento[i], "Insert_evento_anonimo", SQL.Insert_evento_anonimo[i], "Insert_evento_pis", SQL.Insert_evento_pis[i], "Insert_evento_login", SQL.Insert_evento_login[i], "Select_intervalo", SQL.Select_intervalo[i], "Select_dupla_passagem", SQL.Select_dupla_passagem[i], "Insert_evento_online", SQL.Insert_evento_online[i]};
        return sts;
    }

    @Override
    public String[] getSQLChangeSchema(int lastVersion) {
        int db = 0;
        if (config.get("DBM").equals("PGSQL")) {
            db = 1;
        }
        this.sendMessage(4, "Atualiza versao do banco de dados.");
        int len = 0;
        for (SQLChange ch : SQL.changeTable) {
            if (ch.database != db || ch.version <= lastVersion) continue;
            len += ch.changes.length;
        }
        if (len < 1) {
            return null;
        }
        int i = 0;
        String[] changes = new String[len];
        for (SQLChange ch : SQL.changeTable) {
            if (ch.database != db || ch.version <= lastVersion) continue;
            for (String s : ch.changes) {
                changes[i++] = s;
            }
        }
        return changes;
    }

    public boolean open(Object ctx, Observer obs) {
        this.setAndroidContext(ctx);
        return this.open(obs);
    }

    public boolean open(Observer obs) {
        this.sess = this.cdb.getNewSession(this, obs);
        if (this.sess == null) {
            this.sendMessage(2, "Falha ao tentar inicializar banco de dados: " + this.dbname);
            return false;
        }
        return true;
    }

    public void close() {
    }

    public void updateStatus(String codigo, JSONObject config) {
        String[] values = new String[]{config.toString(), codigo};
        this.sess.execute("Update_equipamento_status", values, null, null);
    }

    public void updateNsr(String codigo, String nsr) {
        String[] values = new String[]{nsr, codigo};
        this.sess.execute("Update_equipamento_nsr", values, null, null);
    }

    public int getSiinNsr(String codigo) {
        String[] values = new String[]{codigo};
        JSONArray jdevice = this.sess.execute("Select_device_cod", values, null, null);
        if (jdevice == null || jdevice.size() < 1 || !((JSONObject)jdevice.get(0)).containsKey((Object)"siin_nsr")) {
            return -1;
        }
        if (((JSONObject)jdevice.get(0)).get((Object)"siin_nsr") == null) {
            return -1;
        }
        return Integer.parseInt(((JSONObject)jdevice.get(0)).get((Object)"siin_nsr").toString());
    }

    public int getNsr(String codigo) {
        String[] values = new String[]{codigo};
        JSONArray jdevice = this.sess.execute("Select_device_cod", values, null, null);
        if (jdevice == null || jdevice.size() < 1 || !((JSONObject)jdevice.get(0)).containsKey((Object)"nsr")) {
            return 1;
        }
        if (((JSONObject)jdevice.get(0)).get((Object)"nsr") == null) {
            return 1;
        }
        return Integer.parseInt(((JSONObject)jdevice.get(0)).get((Object)"nsr").toString());
    }

    public JSONArray getLastEventByNro(String nro) {
        String[] values = new String[]{nro};
        JSONArray res = this.sess.execute("Select_ultimo_evento_nro", values, null, null);
        return res;
    }

    public JSONArray getEventByNsr(String nro, String nsr) {
        String[] values = new String[]{nro, nsr};
        JSONArray res = this.sess.execute("Select_evento_nsr", values, null, null);
        return res;
    }

    public int updateOffs(final String codigo, JSONArray offs) {
        String[] values;
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject off, Object[] pars, int[] count) {
                boolean done = false;
                String tipo_registro = "3";
                String datahora = "";
                String descricao = off.toString();
                count[1] = count[1] + 1;
                int nsr_default = count[1];
                if (off.containsKey((Object)"data") && off.containsKey((Object)"hora")) {
                    String year = off.get((Object)"data").toString().substring(4, 8);
                    String month = off.get((Object)"data").toString().substring(2, 4);
                    String day = off.get((Object)"data").toString().substring(0, 2);
                    String hour = off.get((Object)"hora").toString().substring(0, 2);
                    String min = off.get((Object)"hora").toString().substring(2, 4);
                    datahora = String.format("%s-%s-%s %s:%s:00", year, month, day, hour, min);
                } else if (off.containsKey((Object)"afd")) {
                    String afd = off.get((Object)"afd").toString();
                    String year = "";
                    String month = "";
                    String day = "";
                    String hour = "";
                    String[] min = "";
                    if (afd.length() >= 21 && afd.substring(20, 21).equals("T")) {
                        if (afd.length() < 28) {
                            return 0;
                        }
                        year = afd.substring(10, 14);
                        month = afd.substring(15, 17);
                        day = afd.substring(18, 20);
                        hour = afd.substring(21, 23);
                        min = afd.substring(24, 26);
                        datahora = String.format("%s-%s-%s %s:%s:00", year, month, day, hour, min);
                    } else {
                        if (afd.length() < 24) {
                            return 0;
                        }
                        year = afd.substring(14, 18);
                        month = afd.substring(12, 14);
                        day = afd.substring(10, 12);
                        hour = afd.substring(18, 20);
                        min = afd.substring(20, 22);
                        datahora = String.format("%s-%s-%s %s:%s:00", year, month, day, hour, min);
                    }
                }
                String[] defaults = new String[]{"nsr", Integer.toString(nsr_default), "afd", "", "tipo_registro", tipo_registro, "datahora", datahora, "pis", "", "empty", "", "nro_cartao", "", "codigo_ifponto", codigo, "descricao", descricao, "tipo_evento", "-1", "codigo", "0", "empty", ""};
                Util.fillObject(off, defaults);
                String[] keys = new String[]{"nsr", "afd", "tipo_registro", "datahora", "descricao", "tipo_evento", "codigo", "empty", "pis", "empty", "nro_cartao", "codigo_ifponto"};
                String[] out = Util.fillStringArray(off, keys, null);
                String[] out2 = new String[]{out[0], out[1], out[2], out[3], descricao, out[5], out[6], out[11]};
                while (out[7].length() >= 1 && out[7].charAt(0) == '0') {
                    out[7] = out[7].substring(1);
                }
                JSONArray ret2 = IfpontoDB.this.sess.execute("Insert_evento", out, null, null);
                if (ret2 != null && ((JSONObject)ret2.get(0)).containsKey((Object)"error") && ((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0")) {
                    done = true;
                }
                if (!done) {
                    ret2 = IfpontoDB.this.sess.execute("Insert_evento_anonimo", out2, null, null);
                }
                if (ret2 != null && ((JSONObject)ret2.get(0)).containsKey((Object)"error") && ((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0")) {
                    done = true;
                } else {
                    IfpontoDB.this.sendMessage(2, "Falha Insert evento anonimo:");
                    for (String v : out2) {
                        IfpontoDB.this.sendMessage(2, v);
                    }
                }
                if (!done) {
                    IfpontoDB.this.sendMessage(2, "Falha ao tentar inserir evento: -->" + off.toString() + "<--");
                    return 0;
                }
                int last_nsr = Integer.parseInt(out[0]);
                if (last_nsr > count[0]) {
                    count[0] = last_nsr;
                }
                return 0;
            }
        };
        int nsr_default = this.getNsr(codigo);
        int[] count = new int[]{0, nsr_default};
        Util.jsonIter(offs, iter2, null, count);
        String nsr = "" + count[0];
        int siin_nsr = this.getSiinNsr(codigo);
        if (count[0] < 1 && siin_nsr <= 0) {
            return 0;
        }
        if (siin_nsr > 0) {
            nsr = "" + siin_nsr;
            values = new String[]{"0", codigo};
            this.sess.execute("Update_equipamento_siin_nsr", values, null, null);
        }
        values = new String[]{nsr, codigo};
        this.sess.execute("Update_equipamento_nsr", values, null, null);
        return Integer.parseInt(nsr);
    }

    public JSONArray insertEventLogin(String login, String pass, int nro) {
        String[] values = new String[]{login, pass, "" + nro};
        JSONArray ret2 = this.sess.execute("Insert_evento_login", values, null, null);
        if (ret2 == null || !((JSONObject)ret2.get(0)).containsKey((Object)"error") || !((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0")) {
            return null;
        }
        JSONArray event = this.sess.execute("Select_ultimo_evento", null, null, null);
        return event;
    }

    public JSONArray insertEventPIS(String pis, int nro) {
        String[] values = new String[]{pis, "" + nro};
        JSONArray ret2 = this.sess.execute("Insert_evento_pis", values, null, null);
        if (ret2 == null || !((JSONObject)ret2.get(0)).containsKey((Object)"error") || !((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0")) {
            return null;
        }
        JSONArray event = this.sess.execute("Select_ultimo_evento", null, null, null);
        return event;
    }

    public JSONArray getLastEvents(String nro, int limit) {
        String[] values = new String[]{nro, "" + limit};
        JSONArray res = this.sess.execute("Select_ultimos_eventos", values, null, null);
        return res;
    }

    public JSONArray getDevices() {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jdev, Object[] pars, int[] count) {
                JSONParser parser = new JSONParser();
                String status = jdev.get((Object)"status").toString();
                if (status.equals("")) {
                    JSONObject jstat = new JSONObject();
                    long unixtime = 0L;
                    jstat.put((Object)"unixtime", (Object)unixtime);
                    jstat.put((Object)"msg", (Object)"Sem comunica\u00e7\u00e3o.");
                    jstat.put((Object)"notificacoes", jstat.get((Object)"msg"));
                    status = jstat.toString();
                }
                try {
                    JSONObject jstatus = (JSONObject)parser.parse(status);
                    jdev.put((Object)"status", (Object)jstatus);
                }
                catch (ClassCastException cce) {
                    IfpontoDB.this.sendMessage(3, "Device status - JSONObject invalido: " + status);
                }
                catch (ParseException pe) {
                    IfpontoDB.this.sendMessage(3, "Device status - JSON invalido: " + status);
                }
                String conf = jdev.get((Object)"config").toString();
                if (conf.equals("")) {
                    return 0;
                }
                try {
                    JSONObject jconf = (JSONObject)parser.parse(conf);
                    for (Object key : jconf.keySet()) {
                        jdev.put(key, jconf.get(key));
                    }
                    jdev.remove((Object)"config");
                }
                catch (ClassCastException cce) {
                    IfpontoDB.this.sendMessage(3, "Device config - JSONObject invalido: " + conf);
                }
                catch (ParseException pe) {
                    IfpontoDB.this.sendMessage(3, "Device config - JSON invalido: " + conf);
                }
                return 0;
            }
        };
        JSONArray jdevs = this.sess.execute("Select_devices", null, null, null);
        if (jdevs == null) {
            return jdevs;
        }
        Util.jsonIter(jdevs, iter2, null, null);
        return jdevs;
    }

    public JSONArray getDeviceByNro(int nro) {
        String[] values = new String[]{"" + nro};
        JSONArray res = this.sess.execute("Select_device_nro", values, null, null);
        return res;
    }

    public JSONArray getDeviceByCod(int codigo) {
        String[] values = new String[]{"" + codigo};
        JSONArray res = this.sess.execute("Select_device_cod", values, null, null);
        return res;
    }

    public JSONArray getDeviceUsers(String nro) {
        String[] values = new String[]{nro};
        JSONArray res = this.sess.execute("Select_pessoas", values, null, null);
        return res;
    }

    public JSONArray getUserByName(String nome) {
        String[] values = new String[]{nome};
        JSONArray res = this.sess.execute("Select_pessoa_nome", values, null, null);
        return res;
    }

    public JSONArray getUserByPis(String pis) {
        String[] values = new String[]{pis};
        JSONArray res = this.sess.execute("Select_pessoa_pis", values, null, null);
        return res;
    }

    public JSONArray getQtdUsers() {
        JSONArray res = this.sess.execute("Select_qtd_pessoa", null, null, null);
        return res;
    }

    public JSONArray getQtdBio() {
        JSONArray res = this.sess.execute("Select_qtd_bio", null, null, null);
        return res;
    }

    public JSONArray getBio(JSONArray jusers) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                String pessoa_id = user.get((Object)"codigo").toString();
                count[0] = count[0] + 1;
                String[] values = new String[]{pessoa_id};
                JSONArray bios = IfpontoDB.this.sess.execute("Select_bios", values, null, null);
                user.put((Object)"templates", (Object)bios);
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(jusers, iter2, null, count);
        return jusers;
    }

    public JSONArray selectBio(String id) {
        String[] values = new String[]{id};
        JSONArray res = this.sess.execute("Select_bio", values, null, null);
        return res;
    }

    public JSONArray getNotSyncResults(int nro, int limit) {
        if (limit > 200) {
            this.sendMessage(4, "Limite para a quantidade de offs ultrapassado. (" + limit + "/200)");
            return null;
        }
        String[] values = new String[]{"" + nro, "" + limit};
        JSONArray res = this.sess.execute("Select_no_sync_results", values, null, null);
        return res;
    }

    public int updateSyncResults(JSONArray results) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject res, Object[] pars, int[] count) {
                String codigo_ifponto = res.get((Object)"cod").toString();
                String[] values = new String[]{codigo_ifponto};
                JSONArray ret2 = IfpontoDB.this.sess.execute("Update_sync_result", values, null, null);
                if (ret2 == null || !((JSONObject)ret2.get(0)).containsKey((Object)"error") || !((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                count[0] = count[0] + 1;
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(results, iter2, null, count);
        return count[0];
    }

    public int rollbackSyncResults(JSONArray results) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject res, Object[] pars, int[] count) {
                String codigo_ifponto = res.get((Object)"cod").toString();
                String[] values = new String[]{codigo_ifponto};
                JSONArray ret2 = IfpontoDB.this.sess.execute("Update_rollback_result", values, null, null);
                if (ret2 == null || !((JSONObject)ret2.get(0)).containsKey((Object)"error") || !((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                count[0] = count[0] + 1;
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(results, iter2, null, count);
        return count[0];
    }

    public JSONArray getNotSyncEventsDescricao(int nro, int limit) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject event, Object[] pars, int[] count) {
                JSONParser parser = new JSONParser();
                JSONObject jOff = new JSONObject();
                String sOff = event.get((Object)"descricao").toString();
                String evento_id = event.get((Object)"evento_id").toString();
                try {
                    jOff = (JSONObject)parser.parse(sOff);
                }
                catch (ParseException pe) {
                    return 0;
                }
                jOff.put((Object)"evento_id", (Object)evento_id);
                ((JSONArray)pars[0]).add((Object)jOff);
                return 0;
            }
        };
        String[] values = new String[]{"" + nro, "" + limit};
        JSONArray res = this.sess.execute("Select_descricao_no_sync_events", values, null, null);
        JSONArray offs = new JSONArray();
        Util.jsonIter(res, iter2, new Object[]{offs}, null);
        return offs;
    }

    public JSONArray getNotSyncEvents(int nro, int limit) {
        String[] values = new String[]{"" + nro, "" + limit};
        JSONArray res = this.sess.execute("Select_no_sync_events", values, null, null);
        return res;
    }

    public JSONArray getNotSyncEventsAfd(int nro, int limit) {
        String[] values = new String[]{"" + nro, "" + limit};
        JSONArray res = this.sess.execute("Select_no_sync_events_afd", values, null, null);
        return res;
    }

    public int updateSyncEvents(JSONArray events) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject event, Object[] pars, int[] count) {
                count[0] = count[0] + 1;
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(events, iter2, null, count);
        return count[0];
    }

    public int rollbackSyncEvents(JSONArray events) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject event, Object[] pars, int[] count) {
                String evento_id = event.get((Object)"evento_id").toString();
                count[0] = count[0] + 1;
                String[] values = new String[]{evento_id};
                IfpontoDB.this.sess.execute("Update_rollback_evento", values, null, null);
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(events, iter2, null, count);
        return count[0];
    }

    public void rollbackSyncEventsFromNsr(String nro, String startNsr) {
        String[] values = new String[]{nro, startNsr};
        this.sess.execute("Update_rollback_eventos_from_nsr", values, null, null);
    }

    public JSONArray getNotSyncBios(int limit) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                JSONObject template = new JSONObject();
                JSONArray templates = new JSONArray();
                template.put((Object)"template", (Object)user.get((Object)"template").toString());
                template.put((Object)"vendor", (Object)user.get((Object)"vendor").toString());
                template.put((Object)"encode", (Object)user.get((Object)"encode").toString());
                template.put((Object)"bio_id", (Object)user.get((Object)"bio_id").toString());
                templates.add((Object)template);
                user.remove((Object)"template");
                user.remove((Object)"vendor");
                user.remove((Object)"encode");
                user.remove((Object)"bio_id");
                user.put((Object)"templates", (Object)templates);
                return 0;
            }
        };
        String[] values = new String[]{"" + limit};
        JSONArray list = this.sess.execute("Select_no_sync_bios", values, null, null);
        Util.jsonIter(list, iter2, null, null);
        return list;
    }

    public int updateSyncBios(JSONArray templates) {
        final IfaceJSONIter iterTemps = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject temp, Object[] pars, int[] count) {
                String bio_id = temp.get((Object)"bio_id").toString();
                String[] values = new String[]{bio_id};
                JSONArray ret2 = IfpontoDB.this.sess.execute("Update_sync_bio", values, null, null);
                if (ret2 == null || !((JSONObject)ret2.get(0)).containsKey((Object)"error") || !((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                count[0] = count[0] + 1;
                return 0;
            }
        };
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject template, Object[] pars, int[] count) {
                JSONArray temps = (JSONArray)template.get((Object)"templates");
                Util.jsonIter(temps, iterTemps, null, count);
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(templates, iter2, null, count);
        return count[0];
    }

    public JSONArray getProcessingUsers(String codigo_ifponto_device) {
        String[] vals = new String[]{codigo_ifponto_device};
        JSONArray list = this.sess.execute("Select_pendentes_processando", vals, null, null);
        return list;
    }

    public JSONArray getPendingUsers(String codigo_ifponto_device, int limit) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                JSONObject card;
                String codigo_ifponto = user.get((Object)"cod").toString();
                String pessoa_id = user.get((Object)"pessoa_id").toString();
                String[] values = new String[]{pessoa_id};
                JSONArray cards = IfpontoDB.this.sess.execute("Select_cartoes", values, null, null);
                user.put((Object)"nro_cartao", (Object)cards);
                if (cards != null && cards.size() > 0 && cards.get(0) != null && (card = (JSONObject)cards.get(0)).containsKey((Object)"nro")) {
                    user.put((Object)"cracha", card.get((Object)"nro"));
                }
                JSONArray bios = IfpontoDB.this.sess.execute("Select_bios", values, null, null);
                user.put((Object)"templates", (Object)bios);
                String situacao = "2";
                String sincronizado = "0";
                String descricao = "";
                values = new String[]{situacao, sincronizado, descricao, codigo_ifponto};
                IfpontoDB.this.sess.execute("Update_pendentes", values, null, null);
                return 0;
            }
        };
        String[] vals = new String[]{codigo_ifponto_device, Integer.toString(limit)};
        JSONArray list = this.sess.execute("Select_pendentes", vals, null, null);
        Util.jsonIter(list, iter2, null, null);
        return list;
    }

    public int updatePendingUsers(String codigo, JSONArray result) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                String[] defaults = new String[]{"status", "", "cod", "0", "cod_error", "0"};
                Util.fillObject(user, defaults);
                String codigo_ifponto = user.get((Object)"cod").toString();
                String[] values = new String[]{codigo_ifponto};
                JSONArray jdesc = IfpontoDB.this.sess.execute("Select_descricao_pendente", values, null, null);
                Object desc = "";
                if (jdesc.size() > 0) {
                    desc = ((JSONObject)jdesc.get(0)).get((Object)"descricao").toString();
                }
                if (!((String)desc).isEmpty()) {
                    desc = (String)desc + " | ";
                }
                String situacao = "3";
                String sincronizado = "0";
                String descricao = (String)desc + user.get((Object)"status").toString();
                String cod_error = user.get((Object)"cod_error").toString();
                if (!cod_error.equals("0")) {
                    situacao = "4";
                }
                String[] values2 = new String[]{situacao, sincronizado, descricao, codigo_ifponto};
                IfpontoDB.this.sess.execute("Update_pendentes", values2, null, null);
                return 0;
            }
        };
        Util.jsonIter(result, iter2, null, null);
        return 0;
    }

    public int rollbackPendingUsers(JSONArray list) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                String codigo_ifponto = user.get((Object)"cod").toString();
                count[0] = count[0] + 1;
                String situacao = "1";
                String sincronizado = "0";
                String erro = "";
                String[] values = new String[]{situacao, sincronizado, erro, codigo_ifponto};
                IfpontoDB.this.sess.execute("Update_pendentes", values, null, null);
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(list, iter2, null, count);
        return count[0];
    }

    public int updateBio(String pessoa_id, String vendor, String encode, String template) {
        String[] values = new String[]{pessoa_id, "0", template, vendor, encode};
        this.sess.execute("Insert_bio_desktop", values, null, null);
        return 0;
    }

    public JSONArray deleteBioDesktop(String pessoa_id) {
        String[] values = new String[]{pessoa_id};
        JSONArray res = this.sess.execute("Delete_bio_desktop", values, null, null);
        return res;
    }

    public void update_Recollect_All_Nsr(String nsr, String nro) {
        String[] values = new String[]{nsr, nro};
        this.sess.execute("Update_Recollect_All_Nsr", values, null, null);
    }

    public int deleteEvents(String nro) {
        String[] values = new String[]{nro};
        this.sess.execute("Delete_events", values, null, null);
        return 0;
    }

    public JSONObject statusDB() {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jeq, Object[] pars, int[] count) {
                String nro = jeq.get((Object)"numero").toString();
                JSONArray jpessoas = IfpontoDB.this.sess.execute("Select_status_pessoa", new String[]{nro}, null, null);
                JSONArray jtot = IfpontoDB.this.sess.execute("Select_status_equipamento_tot", new String[]{nro}, null, null);
                JSONArray jev = IfpontoDB.this.sess.execute("Select_status_evento_sinc", new String[]{nro}, null, null);
                JSONArray jevtot = IfpontoDB.this.sess.execute("Select_status_evento_tot", new String[]{nro}, null, null);
                jeq.put((Object)"pessoas", (Object)jpessoas);
                jeq.put((Object)"situacao_total", (Object)jtot);
                jeq.put((Object)"sincronizado_total", (Object)jev);
                jeq.put((Object)"evento_total", (Object)jevtot);
                return 0;
            }
        };
        JSONArray eq = this.sess.execute("Select_equipamentos_StatusDB", null, null, null);
        JSONObject r = new JSONObject();
        Util.jsonIter(eq, iter2, null, null);
        r.put((Object)"equipamentos", (Object)eq);
        return r;
    }

    public int updateBio(JSONObject user, boolean sync) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject temp, Object[] pars, int[] count) {
                String codigo_pessoa = (String)pars[1];
                String sincronizado = (String)pars[2];
                count[0] = count[0] + 1;
                String[] defaults = new String[]{"vendor", "unknown", "encode", "b64", "sincronizado", sincronizado};
                Util.fillObject(temp, defaults);
                String[] keys = new String[]{"sincronizado", "template", "vendor", "encode", null};
                String[] values = new String[]{codigo_pessoa};
                String[] out = Util.fillStringArray(temp, keys, values);
                if (out != null) {
                    IfpontoDB.this.sess.execute("Insert_bio", out, null, null);
                }
                return 0;
            }
        };
        String operacao = user.get((Object)"tipo").toString();
        String codigo_ifponto = user.get((Object)"codigo").toString();
        JSONArray temps = (JSONArray)user.get((Object)"templates");
        if (temps != null && temps.size() > 0 || operacao.equals("excluir")) {
            this.sess.execute("Delete_bio", new String[]{codigo_ifponto}, null, null);
        }
        if (temps == null || operacao.equals("excluir")) {
            return 0;
        }
        int[] count = new int[]{0};
        String sincronizado = "0";
        if (sync) {
            sincronizado = "1";
        }
        Util.jsonIter(temps, iter2, new Object[]{null, codigo_ifponto, sincronizado}, count);
        return count[0];
    }

    public int updateCartoes(JSONObject user) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject card, Object[] pars, int[] count) {
                String codigo_pessoa = (String)pars[1];
                if (card.containsKey((Object)"devolucao") && card.get((Object)"devolucao").equals("t") && card.containsKey((Object)"nro")) {
                    IfpontoDB.this.sess.execute("Delete_cartao", new String[]{card.get((Object)"nro").toString()}, null, null);
                    return 0;
                }
                count[0] = count[0] + 1;
                String[] defaults = new String[]{"tipo", "Funcion\u00e1rio", "tecnologia", "Proximidade", "hrinicio", "", "hrfim", "", "liberador", "0", "ativo", "1"};
                Util.fillObject(card, defaults);
                String[] uKeys = new String[]{"tipo", "tecnologia", "hrinicio", "hrfim", "liberador", "ativo", "nro"};
                String[] iKeys = new String[]{"nro", "tipo", "tecnologia", "hrinicio", "hrfim", "liberador", "ativo", null};
                String[] values = new String[]{codigo_pessoa};
                String[] uFields = Util.fillStringArray(card, uKeys, null);
                String[] iFields = Util.fillStringArray(card, iKeys, values);
                if (uFields != null && iFields != null) {
                    IfpontoDB.this.sess.execute("Update_cartao", uFields, "Insert_cartao", iFields);
                }
                return 0;
            }
        };
        String operacao = user.get((Object)"tipo").toString();
        JSONArray cards = (JSONArray)user.get((Object)"nro_cartao");
        String codigo_ifponto = user.get((Object)"codigo").toString();
        if (operacao.equals("excluir") || cards == null) {
            this.sess.execute("Delete_cartoes", new String[]{codigo_ifponto}, null, null);
            return 0;
        }
        int[] count = new int[]{0};
        Util.jsonIter(cards, iter2, new Object[]{null, codigo_ifponto}, count);
        return count[0];
    }

    public int updateUserList(JSONObject dev) {
        JSONArray users = (JSONArray)dev.get((Object)"pessoas");
        if (users == null) {
            return 0;
        }
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                String codigo_equipamento = (String)pars[1];
                HashMap pessoas = (HashMap)pars[2];
                HashMap equipamentos = (HashMap)pars[3];
                count[0] = count[0] + 1;
                String[] defaults = new String[]{"verificar_biometria", "1"};
                Util.fillObject(user, defaults);
                String id_ifponto_key = Device.getID(user);
                String pis_key = "pis";
                String cpf_key = "cpf";
                if (!user.containsKey((Object)"pis")) {
                    pis_key = id_ifponto_key;
                }
                if (!user.containsKey((Object)"cpf")) {
                    cpf_key = id_ifponto_key;
                }
                String[] uKeys = new String[]{"nome", pis_key, cpf_key, id_ifponto_key, "verificar_biometria", "codigo"};
                String[] uFields = Util.fillStringArray(user, uKeys, null);
                String[] iKeys = new String[]{"codigo", "nome", pis_key, cpf_key, id_ifponto_key, "verificar_biometria"};
                String[] iFields = Util.fillStringArray(user, iKeys, null);
                if (uFields == null || iFields == null) {
                    return 0;
                }
                while (uFields[1].length() >= 1 && uFields[1].charAt(0) == '0') {
                    uFields[1] = uFields[1].substring(1);
                }
                while (iFields[2].length() >= 1 && iFields[2].charAt(0) == '0') {
                    iFields[2] = iFields[2].substring(1);
                }
                IfpontoDB.this.sess.execute("Update_pessoa", uFields, "Insert_pessoa", iFields);
                defaults = new String[]{"cod", "0", "codigo", "0", "tipo", "incluir"};
                Util.fillObject(user, defaults);
                String operacao = user.get((Object)"tipo").toString();
                uFields = new String[]{user.get((Object)"cod").toString(), operacao, (String)equipamentos.get(codigo_equipamento), (String)pessoas.get(user.get((Object)"codigo").toString())};
                iFields = new String[]{user.get((Object)"cod").toString(), operacao, codigo_equipamento, user.get((Object)"codigo").toString()};
                JSONArray ret2 = IfpontoDB.this.sess.execute("Update_pessoa_equipamento", uFields, "Insert_pessoa_equipamento", iFields);
                if (ret2 == null || !((JSONObject)ret2.get(0)).containsKey((Object)"error") || !((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                IfpontoDB.this.updateCartoes(user);
                IfpontoDB.this.updateBio(user, true);
                return 0;
            }
        };
        HashMap<String, String> pessoas = this.selectUserListPessoa();
        HashMap<String, String> equipamentos = this.selectUserListEquipamento();
        int[] count = new int[]{0};
        String codigo_ifponto = dev.get((Object)"codigo").toString();
        Util.jsonIter(users, iter2, new Object[]{null, codigo_ifponto, pessoas, equipamentos}, count);
        return count[0];
    }

    public JSONArray updateUserDesktop(String sync, String desc) {
        String[] values = new String[]{sync, desc};
        JSONArray res = this.sess.execute("Update_pessoa_equipamento_biodesk", values, null, null);
        return res;
    }

    public HashMap<String, String> selectUserListPessoa() {
        return this.sess.getHash("Select_pessoa", null);
    }

    public HashMap<String, String> selectUserListEquipamento() {
        return this.sess.getHash("Select_equipamento", null);
    }

    public int updateUserList(JSONArray jpessoas, int codigo_ifponto_device) {
        JSONObject dev = new JSONObject();
        dev.put((Object)"pessoas", (Object)jpessoas);
        dev.put((Object)"codigo", (Object)codigo_ifponto_device);
        int r = this.updateUserList(dev);
        return r;
    }

    public int updateDevices(JSONArray devs) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject dev, Object[] pars, int[] count) {
                int n;
                String[] iKeys;
                String[] iFields;
                String[] defaults = new String[]{"user", "", "pass", "", "json_config", "", "diferenca_horario", "0"};
                Util.fillObject(dev, defaults);
                String[] uKeys = new String[]{"modelo", "nome", "ip", "porta", "user", "pass", "json_config", "diferenca_horario", "codigo"};
                String[] uFields = Util.fillStringArray(dev, uKeys, null);
                if (uFields[uKeys.length - 3].equals("")) {
                    uFields[uKeys.length - 3] = "{}";
                }
                if ((iFields = Util.fillStringArray(dev, iKeys = new String[]{"codigo", "nro", "modelo", "nome", "ip", "porta", "user", "pass", "json_config"}, null))[iKeys.length - 1].equals("")) {
                    iFields[iKeys.length - 1] = "{}";
                }
                if (iFields == null || uFields == null) {
                    return 0;
                }
                JSONArray ret2 = IfpontoDB.this.sess.execute("Update_equipamento", uFields, "Insert_equipamento", iFields);
                if (ret2 == null || ret2.size() < 1 || !((JSONObject)ret2.get(0)).containsKey((Object)"error") || !((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                if (dev.containsKey((Object)"nsr_modificar") && dev.get((Object)"nsr_modificar") != null) {
                    String[] values = new String[]{dev.get((Object)"nsr_modificar").toString(), iFields[0]};
                    IfpontoDB.this.sendMessage(5, "SIIN_NSR CHANGED TO modified");
                    IfpontoDB.this.sess.execute("Update_equipamento_siin_nsr", values, null, null);
                }
                count[0] = count[0] + 1;
                if (dev.containsKey((Object)"pessoas") && (n = IfpontoDB.this.updateUserList(dev)) > 0) {
                    IfpontoDB.this.sendMessage(4, "\t" + dev.get((Object)"nome").toString() + ": " + n);
                }
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(devs, iter2, new Object[0], count);
        return count[0];
    }

    public boolean disableDevices() {
        JSONArray ret2 = this.sess.execute("Update_inativa_equipamentos", null, null, null);
        return ret2 != null && ret2.size() >= 1 && ((JSONObject)ret2.get(0)).containsKey((Object)"error") && ((JSONObject)ret2.get(0)).get((Object)"error").toString().equals("0");
    }

    public int updateAcesso(JSONObject jacesso) {
        String[] tables;
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jobj, Object[] pars, int[] count) {
                String tb = (String)pars[0];
                if (tb.equals("nivel")) {
                    String[] values = new String[]{jobj.get((Object)"nome").toString(), jobj.get((Object)"codigo").toString()};
                    IfpontoDB.this.sess.execute("Insert_Nivel", values, null, null);
                } else if (tb.equals("leitor_nivel")) {
                    String[] values = new String[]{jobj.get((Object)"codigo").toString(), jobj.get((Object)"cod_nivel").toString(), jobj.get((Object)"cod_leitor").toString()};
                    IfpontoDB.this.sess.execute("Insert_Equipamento_Nivel", values, null, null);
                } else if (tb.equals("nivel_pessoa")) {
                    String[] values = new String[]{jobj.get((Object)"cod_pessoa").toString(), jobj.get((Object)"cod_nivel").toString()};
                    IfpontoDB.this.sess.execute("Insert_Pessoa_Nivel", values, null, null);
                } else if (tb.equals("intervalo")) {
                    String[] week = new String[]{"dom", "seg", "ter", "qua", "qui", "sex", "sab", "fer"};
                    int day = 0;
                    int p = 1;
                    for (String d : week) {
                        p *= 2;
                        if (!jobj.containsKey((Object)d) || !jobj.get((Object)d).toString().equals("1")) continue;
                        day += p;
                    }
                    String[] values = new String[]{jobj.get((Object)"nome").toString(), jobj.get((Object)"inicio").toString().substring(11), jobj.get((Object)"fim").toString().substring(11), "" + day, jobj.get((Object)"codigo").toString()};
                    IfpontoDB.this.sess.execute("Insert_Intervalo", values, null, null);
                } else if (tb.equals("intervalo_leitor_nivel")) {
                    String[] values = new String[]{jobj.get((Object)"cod_leitor_nivel").toString(), jobj.get((Object)"cod_intervalo").toString()};
                    IfpontoDB.this.sess.execute("Insert_Intervalo_Equipamento_Nivel", values, null, null);
                } else {
                    System.out.println("Tabela desconhecida");
                }
                return 0;
            }
        };
        for (String tb : tables = new String[]{"nivel", "leitor_nivel", "nivel_pessoa", "intervalo", "intervalo_leitor_nivel"}) {
            if (jacesso.containsKey((Object)tb)) continue;
            return -1;
        }
        this.sess.execute("Delete_Nivel", null, null, null);
        this.sess.execute("Delete_Equipameto_Nivel", null, null, null);
        this.sess.execute("Delete_Pessoa_Nivel", null, null, null);
        this.sess.execute("Delete_Intervalo", null, null, null);
        this.sess.execute("Delete_Intervalo_Equipamento_Nivel", null, null, null);
        for (String tb : tables) {
            Util.jsonIter((JSONArray)jacesso.get((Object)tb), iter2, new Object[]{tb}, null);
        }
        return 0;
    }

    public IfpontoDB clone() {
        try {
            IfpontoDB db = (IfpontoDB)super.clone();
            db.sess = null;
            return db;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    public static final void main(String[] args) throws IOException {
        Method[] meths = IfpontoDB.class.getMethods();
        if (args.length < 2) {
            System.err.println("iFractal - DB Test");
            System.err.println("\nUso:");
            System.err.println("\tshell$ java com.ifractal.ifponto.IfpontoDB <SQLITE> <METHOD> <TYPE> <VALUE> ... <TYPE N> <VALUE N>");
            System.err.println("\nOnde <CMD>:");
            for (Method m : meths) {
                String nm = m.getName();
                if (!nm.startsWith("get") && !nm.startsWith("insert") && !nm.startsWith("disable") && !nm.startsWith("update") && !nm.startsWith("roll")) continue;
                System.err.print("\t" + nm + "(");
                Type[] tps = m.getGenericParameterTypes();
                for (int k = 0; k < tps.length; ++k) {
                    if (k > 0) {
                        System.err.print(", ");
                    }
                    System.err.print(tps[k].toString());
                }
                System.err.println(")");
            }
            System.err.println("\nExemplos:");
            System.err.println("\tshell$ java com.ifractal.ifponto.Ifponto - getDevices");
            System.err.println("\tshell$ java com.ifractal.ifponto.Ifponto - updateDevices JSONArray list.json");
            System.err.println("\tshell$ java com.ifractal.ifponto.Ifponto - getDeviceByNro int 10");
            System.err.println();
            System.exit(1);
        }
        Observer obs = new Observer(){

            @Override
            public void onMessage(Producer prod, int level, String msg, int code) {
                System.out.println(String.valueOf(prod.getClass()) + "|" + code + "|" + msg);
            }

            @Override
            public void onMessage(Producer prod, int verbosityLevel, String msg) {
                this.onMessage(prod, verbosityLevel, msg, 0);
            }
        };
        String dbfile = "./conf/ifponto.db";
        if (!args[0].equals("-")) {
            dbfile = args[0];
        }
        String cmd = args[1];
        int k = 2;
        while (k + 1 < args.length) {
            if (args[k].startsWith("JSON")) {
                args[k + 1] = new String(Files.readAllBytes(Paths.get(args[k + 1], new String[0])));
            }
            ++k;
        }
        IfpontoDB idb = new IfpontoDB(null, null);
        idb.init(new String[]{"DB", dbfile}, null);
        if (!idb.open(obs)) {
            System.err.println("Falha ao tentar inicializar banco de dados: " + dbfile);
            return;
        }
        String ret2 = null;
        HashMap<String, String> map = idb.selectUserListEquipamento();
        System.out.println("equipamentos: " + map.size());
        map = idb.selectUserListPessoa();
        System.out.println("pessoas: " + map.size());
        idb.close();
        if (ret2 == null) {
            System.err.println("Retorna void ou Falha ao tentar executar: " + cmd);
        } else {
            System.out.println(ret2);
        }
    }
}

