#ifndef URL_H
#define URL_H

#include <ornamentos.h>

typedef struct
{
	char *url;
	char *protocol;
	char *user;
	char *pass;
	char *host;
	char *port;
	char *path;
	char *file;
	char *query;
	char filename[PATH_LEN];
} URL;


URL * url_make(_IN char *host, _IN char *port, _IN char *path);
URL * url_new(_IN char *);
char * url_get_protocol(_IN URL *);
char * url_get_user(_IN URL *);
char * url_get_pass(_IN URL *);
char * url_get_host(_IN URL *);
char * url_get_port(_IN URL *);
char * url_get_path(_IN URL *);
char * url_get_file(_IN URL *);
char * url_get_query(_IN URL *);
void url_free(_IN URL *);

typedef int (*URL_PROGRESS_FUNC)(void *user_data, double dltotal, double dlnow, double ultotal, double ulnow);

int url_execute_get(
	_IN URL *, 
	_OUT unsigned char **resp, 
	_CALLBACK URL_PROGRESS_FUNC, 
	_INOUT void *user_data);

int url_execute_post(
	_IN URL *, 
	_IN char **post_list, 
	_OUT unsigned char **resp, 
	_CALLBACK URL_PROGRESS_FUNC, 
	_INOUT void *user_data);

int url_execute_post_debug(
	_IN URL *, 
	_IN char **post_list, 
	_OUT unsigned char **resp, 
	_CALLBACK URL_PROGRESS_FUNC, 
	_INOUT void *user_data);

int url_execute_post_auth(
	_IN URL *, 
	_IN char **post_list, 
	_OUT unsigned char **resp, 
	_CALLBACK URL_PROGRESS_FUNC, 
	_INOUT void *user_data,
	_IN char *user,
	_IN char *pass);

int url_execute_upload(
	_IN URL *, 
	_IN char **post_list, 
	_IN char **file_list, 
	_OUT unsigned char **resp, 
	_CALLBACK URL_PROGRESS_FUNC, 
	_INOUT void *user_data);

#endif
