/** @file siin_ws.h
\ingroup 

\note API de integração. 
\author iFractal       desenvolvimento@ifractal.com.br
**/

//gsoap ns service name: siin
//gsoap ns service type: siin
//gsoap ns service style: document
//gsoap ns service port: https://127.0.0.1:9002/
//gsoap ns service namespace: urn:siin
//gsoap full service encoding: literal



/**
Estrutura para solicitacao de demissao.
**/
struct ns__Demissao 
{
	char *matricula;	/*!< Identificacao do funcionario no sistema legado. */
	char *dtdemissao;
};

struct DemissaoPack
{
	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Demissao *funcionario;
};

struct ns__Afastamento
{
	char *matricula;
	char *dtinicio;
	char *dtfim;
	char *desc_afastamento;
	char *id_afastamento;
};

struct AfastamentoPack
{

	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Afastamento *funcionario;

};

struct ns__Transferencia
{
	char *matricula;
	char *id_cargo;
	char *cargo;
	char *id_depto;
	char *depto;
	char *id_empresa;
	char *empresa;
};

struct TransferenciaPack
{
	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Transferencia *funcionario;
};

struct ns__Binding
{
	char *key;
	char *val;
};

struct ns__Funcionario
{
	char *matricula;
	char *nome;
	char *rg;
	int __size;
	struct ns__Binding *extra;	
};

struct TratarFuncionarioPack
{
	char *clientId 1;
	char *user 1;
	char *pass 1;
	int __size;
	struct ns__Binding *funcionario;
};

// deprecated - InsertFuncionarioPack
struct RegistrarFuncionarioPack
{
	char *clientId 1;
	char *user 1;
	char *pass 1;
	int __size;
	struct ns__Funcionario *funcionario;
};

struct ns__Result
{
	char *chave;
	char *descricao;
	int codigo_interno;
	int codigo_retorno;
};

struct ns__ResultArray
{
	int __size;
	struct ns__Result *result;	
};

struct ns__ResultAux
{
	char *id_legado;
	char *situacao;
	int codigo;
};

struct ns__ResultAuxArray
{
	int __size;
	struct ns__ResultAux *resultaux;	
};

struct ns__Resultado
{
	char *codigo_legado;
	char *descricao;
	int codigo_interno;
	int codigo_retorno;
};

struct ns__ResultadoArray
{
	int __size;
	struct ns__Resultado *resultado;	
};

struct ns__Cargo 
{
	char *id_legado;
	char *nome;
	int __size;
	struct ns__Binding *extra;	
};

struct CargoPack
{
	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Cargo *cargo;
};

struct ns__Depto 
{
	char *id_legado;
	char *nome;
	int __size;
	struct ns__Binding *extra;	
};

struct DeptoPack
{
	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Depto *depto;
};

struct ns__Empresa 
{
	char *nro;
	char *nome;
	char *cnpj;
	int __size;
	struct ns__Binding *extra;	
};

struct EmpresaPack
{
	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Empresa *empresa;
};

struct ns__Justificativa
{
	char *id_legado;
	char *nome;
	int __size;
	struct ns__Binding *extra;	
};

struct JustificativaPack
{
	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Justificativa *justificativa;
};

struct ns__Horario
{
	int __size;
	struct ns__Binding *extra;	
};

struct HorarioPack
{
	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Horario *horario;
};

struct ns__Escala
{
	int __size;
	struct ns__Binding *extra;	
};

struct EscalaPack
{
	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Escala *escala;
};

struct ns__Cadastro 
{
	char *integracao;
	int __size;
	struct ns__Binding *extra;	
};

struct CadastroPack
{
	char *clientId;
	char *user;
	char *pass;
	char *integracao;
	char *json;		
};


/**

Pacote para solicitacao de consulta 
**/
struct ConsultaPack
{
	char *clientId;		/*!< Identificacao do funcionario no sistema legado. */
	char *user;		/*!< Usuario do sistema siin */
	char *pass;		/*!< Senha do sistema siin */
	char *json;		/*!< JSON com os dados da consulta (tabela /filtros) */
};

struct RemoverAfastamentoPack
{
	char *clientId;
	char *user;
	char *pass;
	int __size;
	struct ns__Afastamento *funcionario;
};


int ns__cadastro(struct CadastroPack *pack, char **json);
int ns__consultaGeral(struct CadastroPack *pack, char **json);
int ns__exclusao(struct CadastroPack *pack, char **json);

