#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ifractal.h>


// ////////////////////////////////////////////////////////////////////////
_PUBLIC int qp_encode(_IN const unsigned char *inbuf, _IN size_t length, _OUT char **outbuf)
{
	if ((inbuf == NULL) || (outbuf == NULL) || (length < 1))
		return(-1);

	return(0);
}
// ////////////////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////////////////
_PUBLIC int qp_decode(_IN const char *inbuf, _IN size_t length, _OUT unsigned char **outbuf)
{
	STRING_BUFFER *sb;
	char buf[] = {0,0};
	int i, len;

	if ((inbuf == NULL) || (outbuf == NULL) || (length < 1))
		return(-1);

	sb = string_new("");

	for (i = 0 ; i < length ; i++)
	{
		if (inbuf[i] != '=')
		{
			buf[0] = inbuf[i];
			string_append(sb, buf);
			continue;
		}

		if (inbuf[i + 1] == '\n')
		{
			i++;
			continue;
		}

		if (inbuf[i + 2] == '\n')
		{
			i += 2;
			continue;
		}

		if (inbuf[i + 1] < 'A')
			buf[0] = 16 * (inbuf[i + 1] - '0');
		else
			buf[0] = 16 * (inbuf[i + 1] - 'A' + 10);
		
		if (inbuf[i + 2] < 'A')
			buf[0] += inbuf[i + 2] - '0';
		else
			buf[0] += inbuf[i + 2] - 'A' + 10;

		string_append(sb, buf);
		i += 2;
	}

	*outbuf = (unsigned char *) if_strdup(string_get_text(sb));
	string_free(sb);

	len = strlen((char *) *outbuf);

	return(len);
}
// ////////////////////////////////////////////////////////////////////////


#ifdef STANDALONE
// ////////////////////////////////////////////////////////////////////////
int main(int argc, char **argv)
{
	char *bufin = NULL, *bufout;
	int len;

	if (argc < 2)
	{
		fprintf(stderr, "\nLe stdin (quoted-printable) e decodifica para stdout.\n\n");
		fprintf(stderr, "\nUso:\n\tshell$ %s -\n\n", argv[0]);
		return(1);
	}

	len = cgi_get_content(stdin, &bufin);

	qp_decode(bufin, len, (unsigned char **) &bufout);
	fprintf(stdout, "%s", bufout);
	if_free(bufout);
	if_free(bufin);

	return(0);
}
// ////////////////////////////////////////////////////////////////////////
#endif

