#ifndef PARSER_H
#define PARSER_H

#include <ifractal.h>

#define MAX_CSV_FIELDS		512

typedef JSON_VALUE * (*IF_PARSER_FUNC_POINTER)(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

typedef JSON_VALUE * (*IF_PARSER_MODULE_FUNC_INIT)();
typedef void (*IF_PARSER_MODULE_FUNC_FINALIZE)();

typedef struct _IF_PARSER_MODULE
{
	char name[PATH_LEN];
	IF_PARSER_MODULE_FUNC_INIT init;
	IF_PARSER_MODULE_FUNC_FINALIZE finalize;
	JSON_VALUE *funcs;
	struct _IF_PARSER_MODULE *next;
} IF_PARSER_MODULE;


typedef struct
{
	char *json_config;
	IF_PARSER_FUNC_POINTER func;
} IF_PARSER_FUNC_DEF;


// Interface
JSON_VALUE * parser_module_func_init();
void parser_module_func_finalize();

// Methods
IF_PARSER_MODULE * parser_module_new();
JSON_VALUE * parser_compile_json_funcs(IF_PARSER_FUNC_DEF *funcs);
int parser_init_modules();
int parser_finalize_modules();


JSON_VALUE * parser_process(_IN JSON_VALUE *templ, _IN char *txt_content, _IN int txt_length);

/*
typedef void (*CGI_FUNC)(IF_CGI_PARAM *web_params, ...);

typedef struct
{
	char *name;
	char *params_type;
	CGI_FUNC func;
} CGI_FUNC_MAP;
*/

typedef void (*PROCESS_TOKEN_FUNC)(
	_INOUT JSON_VALUE *result, 
	_INOUT JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token, 
	_IN char *line,
	_IN int line_n);

typedef struct
{
	char *type;
	PROCESS_TOKEN_FUNC process;
} PARSER_TYPE_MAP;


int parser_get_lines(_INOUT char *content, _OUT char ***lines);

void addException(_INOUT JSON_VALUE *result, _IN char *description, _INOUT JSON_VALUE *data_source, int line);
int if_get_content(_IN FILE *fd, _OUT char **ref);

JSON_VALUE * parser_process(_IN JSON_VALUE *templ, _IN char *txt_content, _IN int content_length);
char * fixo2json(_IN char *json_template, _IN char *txt);
char * json2fixo(char *templ, char *dados_json);
char * processa_dados_modelo(char *globals_json, char *record_json, char *modelo_html);
char * process_model(JSON_VALUE *globals, JSON_VALUE *record, char *modelo_html);
char * result_add_fields(char *result, char *csv, char separador, char *key);
JSON_VALUE * parser_csv2json(char *csv, char separador, _IN JSON_VALUE *templ);
char * csv2json(char *csv, char separador, _IN char *templ);
int json_result_add_fields(_INOUT JSON_VALUE *json_result, _IN JSON_VALUE *json_csv, char *key);

unsigned char * get_barcode(_IN char *barcode, _IN int height, _OUT int *pnglen);

void parser_apply_functions(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token);

int core_purge_spaces(char *data);


char * barras_bb_sem_registro(char *agencia, char *conta, char *nosso_nro, char *vencimento, char *valor);
char * barras_bb(char *nosso_nro, char *carteira, char *vencimento, char *valor);
char * barras_bradesco(char *agencia, char *conta, char *nosso_nro, char *carteira, char *vencimento, char *valor);
char * barras_santander(char *cod_cedente, char *nosso_nro, char *carteira, char *vencimento, char *valor);
char * barras_cef(char *agencia, char *cod_cedente, char *nosso_nro, char *vencimento, char *valor);
char * barras_itau(char *agencia, char *cod_cedente, char *nosso_nro, char *carteira, char *vencimento, char *valor);
char * barras_itau_198(char *carteira, char *nosso_nro, char *nro_doc, char *cod_cedente, char *vencimento, char *valor);
char * barras_panamericano(char *agencia, char *carteira, char *cod_cedente, char *nosso_nro, char *vencimento, char *valor);
char * barras_citi(char *carteira, char *cod_cedente, char *nosso_nro, char *vencimento, char *valor);
char * barras_cef_sigcb(char *carteira, char *cod_cedente, char *nosso_nro, char *vencimento, char *valor);

char * barras2linha(char *barras);
char * linha2barras(char *linha);
char * barras_DAC10(char *);
char * barras_DAC11(char *);

char calc_DAC10(char *br, int i, int f);
char calc_DAC11(char *br, int i, int f);

#endif
