#include <ifractal.h>

#define MODULE		"MODXXXXLOAD"

#define verbose3(ref,def,format,...)	verbose2(ref,def,stdout,MODULE,format, ##__VA_ARGS__)

IF_GETOPT XXXXload_config[] = {
	{0, 'v', IF_GETOPT_TYPE_NUMBER, "VERBOSITY", "4", 0, "Nivel do LOG de 1 a 5 (default 4)"},
	{0, 'c', IF_GETOPT_TYPE_STRING, "CONFIG", "conf/upload.json", 0, "Arquivo JSON com configuracoes."},
	{0, 0, 0, 0, 0, 0, 0}
};


// ////////////////////////////////////////////////////////////////////////
int modXXXX_save_file(JSON_VALUE *post, unsigned char *resp, int len)
{
	char *fopen_param = json_object_get_string(post, "fopen_param");
	char *out_filename = json_object_get_string(post, "out_filename");
	FILE *fd;

	if (fopen_param[0] == 0)
		fopen_param = "w";

	if (out_filename[0] == 0)
		return(-1);

	fd = fopen(out_filename, fopen_param);
	if (fd == NULL)
	{
		verbose(stderr, "Falha ao tentar salvar: '%s'\n", out_filename);
		return(-2);
	}

	fwrite(resp, 1, len, fd);

	fclose(fd);

	return(0);
}
// ////////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_PUBLIC void * modXXXXload_run(THREAD_STATE *state, int id, void *user_data)
{
	JSON_ARRAY_ITER_CALLACK config_iter = (JSON_ARRAY_ITER_CALLACK) user_data;
	JSON_VALUE *jconfarray;
	char *config;
	int count;
	FILE *fd;

	config = if_getopt_getValue(XXXXload_config, "CONFIG");
	fd = fopen(config, "r");
	if (fd == NULL)
	{
		verbose(stderr, "|%s| Falha ao tentar ler arquivo. '%s'\n", MODULE, config);
		return(NULL);
	}

	jconfarray = json_parse_file(fd);
	fclose(fd);
	if (jconfarray == NULL)
	{
		verbose(stderr, "|%s| Falha ao tentar ler configuracoes. Arquivo invalido: '%s'\n", MODULE, config);
		return(NULL);
	}

	if (json_get_type(jconfarray) != JSON_ARRAY_TYPE)
	{
		verbose(stderr, "|%s| Configuracao invalida. \"%s\"\n", MODULE, config);
		return(NULL);
	}

	for (count = 0 ; *state == TH_ALIVE ; count++)
	{
		json_array_iter(jconfarray, config_iter, &count);

		if_sleep(1000);
	}

	json_value_free(jconfarray);

	return(NULL);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_PUBLIC int modXXXXload_rename(char *to, char *from)
{
	int r;

#ifdef WIN32
	char buf[PATH_LEN];
	DWORD err;
	r = MoveFileEx(from, to, MOVEFILE_REPLACE_EXISTING);
	if (!r)
	{
		r = 1;
		err = GetLastError();
		FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, 0, err, 0, buf, PATH_LEN, 0);
		verbose(stderr, "Erro ao tentar mover '%s' - %s\n", from, buf);
	}
	else
		r = 0;
#else
	r = rename(from, to);
#endif

	return(r);
}
// //////////////////////////////////////////////////////////////////////


