#include <ifractal.h>


#define DESCRIPT	"iFractal - Sistema de Integracao Inteligente"

IF_GETOPT config[] = {
	{0, 'h', IF_GETOPT_TYPE_STRING, "host", "ifractal.srv.br", 0, "IP do sistema."},
	{0, 'p', IF_GETOPT_TYPE_NUMBER, "port", "80", 0, "Porta do sistema."},
	{0, 'c', IF_GETOPT_TYPE_STRING, "path", "", 0, "PATH do cliente."},
	{0, 'u', IF_GETOPT_TYPE_STRING, "user", "", 0, "Usuario do sistema."},
	{0, 'x', IF_GETOPT_TYPE_STRING, "pass", "", 0, "senha."},
	{0, 'f', IF_GETOPT_TYPE_STRING, "cnab", "", 0, "Arquivo de dados."},
	{0, 't', IF_GETOPT_TYPE_STRING, "config", "", 0, "Arquivo de configuracao JSON."},
	{0, 'm', IF_GETOPT_TYPE_STRING, "csv", "", 0, "Arquivo de mailing em formato CSV."},
	{0, 'a', IF_GETOPT_TYPE_STRING, "params", "", 0, "Sequencia de parametros key/value."},
	{0, 'r', IF_GETOPT_TYPE_NONE, "planilha", "", 0, "Consulta relatorio com planilha CSV."},
	{0, 0, 0, 0, 0, 0, 0}
};


// ////////////////////////////////////////////////////////////
int show_result(IRESULTSET *result)
{
	int r, f, i, j;

	r = result_count(result);
	if (r < 0)
	{
		fprintf(stderr, "ERRO MSG: %s\n", result_getErrParam(result, "msg"));
		return(12);
	}

	f = result_getFieldCount(result);
	printf("Fields: %d\n", f);
	for (i = 0 ; i < f ; i++)
		printf("\t'%s'\n", result_getFieldName(result, i));

	r = result_count(result);
	if (r < 0)
		printf("Err: %s\n", result_getErrParam(result, "err"));
	printf("Records: %d\n", r);
	for (i = 0 ; i < r ; i++)
	{
		for (j = 0 ; j < f ; j++)
			printf("%s|", result_getValue(result, i, j));

		printf("\n");
	}

	return(0);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int processa_cnab(ICONNECTION *conn, char *cnab_file, char *templ_file, char *csv_file)
{
	ICNAB *cnab;
	int r, i;

	cnab = cnab_importFile(cnab_file, templ_file);
	if (cnab == NULL)
		return(11);

	//show_result(cnab_getRecords(cnab));

	r = cnab_getGlobalCount(cnab);
	for (i = 0 ; i < r ; i++)
		printf("'%s':'%s'\n", cnab_getGlobalName(cnab, i), cnab_getGlobalValue(cnab, i));

	if ((csv_file != NULL) && (csv_file[0] != 0))
	{
		r = cnab_addMailing(cnab, csv_file, ';', "id");
		printf("%d registros foram relacionados.", r);
	}

	//conn_sendCNAB(conn, cnab);

	conn_sendCNAB_background(conn, cnab);
	while (cnab_getSendingState(conn, cnab) > 0)
	{
		if_sleep(1000);
		printf(".\n");
	}

	fprintf(stderr, "success: %s\ninfo: \"%s\"\n", 
		cnab_getResponseParam(cnab, "success"), 
		cnab_getResponseParam(cnab, "info"));

	cnab_close(cnab);
	
	return(0);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
void test_create_rs()
{
	char *fields[] = {"id", "nome", "descricao", NULL};
	char *values[] = {"x", "iFractal", "Teste resultset", NULL}; 
	IRESULTSET *rs;
	int i, k;

	rs = result_new();

	for (i = 0 ; fields[i] != NULL ; i++)
		result_column_add(rs, fields[i]);

	for (k = 0 ; k < 10 ; k++)
	{
		result_row_add(rs);
		for (i = 0 ; fields[i] != NULL ; i++)
			result_row_set_value(rs, fields[i], values[i]);
	}

	show_result(rs);

	result_close(rs);
}
// ////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////
int main(int argc, char **argv)
{
	char *host, *port, *path, *user, *pass, *cnab, *templ, *csv, *ver;
	IRESULTSET *result, *result_out;
	ICONNECTION *conn;
	int r, i, p;
	
	r = if_getopt(config, argc, argv);
	if (!if_getopt_isChecked(config, "path"))
	{
		ver = siin_version();
		fprintf(stderr, "\niFractal Desenvolvimento de Software\n\n");
		fprintf(stderr, "Versao: %s\nDescricao: %s\n", ver, DESCRIPT);
		fprintf(stderr, "Ajuda:\n");
		if_getopt_help(config);
		if_free(ver);

		fprintf(stderr, "\nUso:\n");
		fprintf(stderr, "\tshell$ %s --path <PATH do CLIENTE> -u <USUARIO> -x <SENHA MD5> --params <KEY1> <VALUE1> ... <KEY N> <VALUE N>\n", argv[0]);
		fprintf(stderr, "\nExemplos:\n");

		fprintf(stderr, "\tEnvio de CNAB:\n");
		fprintf(stderr, "\tshell$ %s --path cliente/conf/processa_dados.php -u admin -x senha --cnab arquivocnab.txt --config config_cnab.json --params \"cod_campanha\" \"6\" \"nome_mailing\" \"carta tipo 1\" \"num_modelo\" \"5\"\n", argv[0]);

		fprintf(stderr, "\n\tEnvio de CNAB relacionado com mailing CSV:\n");
		fprintf(stderr, "\tshell$ %s --path cliente/db/consulta.php -u admin -x senha --cnab arquivocnab.txt --config config_cnab.json --csv mailing.csv --params \"cod_campanha\" \"32\" \"nome_mailing\" \"carta tipo 1\" \"num_modelo\" \"5\"\n", argv[0]);

		fprintf(stderr, "\n\tEnvio de CSV:\n");
		fprintf(stderr, "\tshell$ %s --path cliente/db/consulta.php -u admin -x senha --csv arquivo.csv --params \"cod_campanha\" \"32\" \"nome_mailing\" \"carta tipo 1\" \"pag\" \"envio_csv\"\n", argv[0]);

		fprintf(stderr, "\n\tConsultar Envios por ID:\n");
		fprintf(stderr, "\tshell$ %s --path cliente/db/consulta.php -u admin -x senha --params \"pag\" \"relatorio_detalhe_envio\" \"qtd_ultimos\" \"20\" \"dtde\" \"DD/MM/YYYY\" \"cmd\" \"get\" \"id\" \"A380\"\n", argv[0]);

		fprintf(stderr, "\n\tConsultar relatorio CSV:\n");
		fprintf(stderr, "\tshell$ %s --planilha --path \"listen/gera_relatorio.php?login=XXXX&senha=xxxx&tipo=sms&data=2008-09-15&hora=14:00\"\n", argv[0]);

		fprintf(stderr, "\n");

		//result = result_new_json(json_parse_mem("[{'name':'VERBOSITY','type':'number','hint':'Nivel do LOG de 1 a 5 (default 4)','value':'5'},{'name':'CONFIG','type':'string','hint':'Arquivo JSON com configuracoes.','value':'conf/upload.json'},{'name':'login','type':'string','hint':'Login para conexao.','value':'36450'},{'name':'password','type':'string','hint':'Senha.','value':'gmac50'}]"));
		//show_result(result);
		//result_close(result);

		//test_create_rs();

		return(r);
	}

	host = if_getopt_getValue(config, "host");
	port = if_getopt_getValue(config, "port");
	path = if_getopt_getValue(config, "path");
	user = if_getopt_getValue(config, "user");
	pass = if_getopt_getValue(config, "pass");

	conn = conn_create(host, port, path);
	conn_addParam(conn, "login", user);
	conn_addParam(conn, "senha", pass);

	if (if_getopt_isChecked(config, "params"))
	{
		fprintf(stderr, "Params:\n");
		p = if_getopt_getIndex(config, "params");
		for (i = p ; (i + 1) < argc ; i += 2)
		{
			conn_addParam(conn, argv[i], argv[i + 1]);
			fprintf(stderr, "\t'%s':'%s'\n", argv[i], argv[i + 1]);
		}
	}

	if (if_getopt_isChecked(config, "cnab"))
	{
		cnab = if_getopt_getValue(config, "cnab");
		templ = if_getopt_getValue(config, "config");
		csv = if_getopt_getValue(config, "csv");
		r = processa_cnab(conn, cnab, templ, csv);
	}
	else if (if_getopt_isChecked(config, "csv"))
	{
		csv = if_getopt_getValue(config, "csv");
		result = result_importCSV(csv, ';');
        
		r = show_result(result);
		result_out = conn_sendData(conn, result);
		result_close(result);

		r = show_result(result_out);
		result_close(result_out);
	}
	else if (if_getopt_isChecked(config, "planilha"))
	{
		result = conn_getData_CSV(conn, ';');
		if (result == NULL)
			return(9);
        
		r = show_result(result);
		result_close(result);

	}
	else
	{
		result = conn_getData(conn);
		if (result == NULL)
			return(10);
        
		r = show_result(result);
		result_close(result);
	}

	conn_close(conn);

	return(r);
}
// ////////////////////////////////////////////////////////////


