#ifndef JAVA_UTILS_H
#define JAVA_UTILS_H

#include <ifractal.h>

#include <jni.h>

// Para ver assinaturas dos metodos
// javap -s -p <class>


JavaVM * if_loadJVM(char *classpath, char *libpath, char *stack);
void if_unloadJVM(JavaVM *);


// ([Ljava/lang/String;)J
int if_JVM_callStaticInt64Method(
	_IN JavaVM *, 
	_IN char *classname, 
	_IN char *meth, 
	_IN size_t argc,
	_IN char *argv[], 
	_OUT int64_t *returnValue);

// ([Ljava/lang/String;)Ljava/lang/String;
int if_JVM_callStaticStringMethod(
	_IN JavaVM *, 
	_IN char *classname, 
	_IN char *meth, 
	_IN size_t argc,
	_IN char *argv[], 
	_OUT char **returnValue);

// ([Ljava/lang/String;)[B
int if_JVM_callStaticBytesMethod(
	_IN JavaVM *, 
	_IN char *classname, 
	_IN char *meth, 
	_IN size_t argc,
	_IN char *argv[], 
	_OUT uint8_t **data,
	_OUT size_t *datalen);


// ([Ljava/lang/String;)Ljava/lang/Object;
int if_JVM_callStaticObjectMethod(
	_IN JavaVM *, 
	_IN char *classname, 
	_IN char *meth, 
	_IN size_t argc,
	_IN char *argv[], 
	_OUT intptr_t *obj);

// ([Ljava/lang/String;)J
int if_JVM_callInt64Method(
	_IN JavaVM *, 
	_IN intptr_t obj, 
	_IN char *meth, 
	_IN size_t argc,
	_IN char *argv[], 
	_OUT int64_t *returnValue);

// ([Ljava/lang/String;)Ljava/lang/String;
int if_JVM_callStringMethod(
	_IN JavaVM *, 
	_IN intptr_t obj, 
	_IN char *meth, 
	_IN size_t argc,
	_IN char *argv[], 
	_OUT char **returnValue);

// ([Ljava/lang/String;)[B
int if_JVM_callBytesMethod(
	_IN JavaVM *, 
	_IN intptr_t obj, 
	_IN char *meth, 
	_IN size_t argc,
	_IN char *argv[], 
	_OUT uint8_t **data,
	_OUT size_t *datalen);

#endif
