#include <ifractal.h>
#include <ifdevice.h>


#define MODULE		"ifPonto"


// Globais
extern IF_GETOPT ifponto_config[];
extern char *IFPONTO_PREBIO_FILE;
extern char *IFPONTO_BIO_FILE;
extern char *IFPONTO_CARD_FILE;
extern char *IFPONTO_LIST_FILE;
extern char *IFPONTO_CONFIG_FILE;

THREAD_STATE alive = TH_ALIVE;
IFLOG logger;

#define READERS_MAX	1000
char *timediff[READERS_MAX + 2];
char *centralizadores[READERS_MAX + 2];


// /////////////////////////////////////////////////////////////////// //
int ifponto_delete_status_iter(DIR_CONTEXT *dir, FILE_CONTEXT *ctx, void *user_data)
{
	int *qty = (int *) user_data;
	char *str;

	if (!fs_file_check(ctx, "config_", IFPONTO_JSON_SUFFIX))
		return(0);

	str = ctx->filename;
	verboseDEBUG(&logger, "Deleta: %s\n", str);
	if (fs_delete(str))
		verboseERROR(&logger, "Erro ao tentar apagar arquivo: '%s'.\n", str);
	else
		*qty += 1;

	return(0);
}
// /////////////////////////////////////////////////////////////////// //
int ifponto_delete_status()
{
	char *path_log = if_getopt_getValue(ifponto_config, "PATH_LOG");
	DIR_CONTEXT *dir = fs_dir_new(path_log);
	int qty = 0;

	if (dir == NULL)
		return(0);

	fs_dir_iter(dir, ifponto_delete_status_iter, &qty);

	fs_dir_free(dir);

	return(qty);
}
// /////////////////////////////////////////////////////////////////// //


// /////////////////////////////////////////////////////////////////// //
int ifponto_get_off_files_iter(DIR_CONTEXT *dir, FILE_CONTEXT *ctx, void *user_data)
{
	void **params = (void **) user_data;
	JSON_VALUE *jreader = (JSON_VALUE *) params[0];
	JSON_VALUE *delete_files = (JSON_VALUE *) params[1];
	int *qty = (int *) params[2];
	int nro = json_object_get_int(jreader, "nro");
	JSON_VALUE *joffs, *aux, *jevents;
	char path_off[PATH_LEN];
	char *field = NULL;
	int qty_max, i, n;
	char *str;
	FILE *fd;
	char *fields[] = {
		"off_", "eventos",
		"result_", "pessoas",
		"bio_", "templates",
		NULL, NULL
	};

	for (i = 0 ; fields[i] != NULL ; i += 2)
	{
		snprintf(path_off, PATH_LEN, "%s%d_", fields[i], nro);
		if (fs_file_check(ctx, path_off, IFPONTO_JSON_SUFFIX))
			field = fields[i + 1];
	}

	if (field == NULL)
		return(0);

	qty_max = atoi(if_getopt_getValue(ifponto_config, "QTD_OFF_FILES"));
	if (*qty > qty_max)
		return(1);
	else
		*qty += 1;

	fd = fopen(ctx->filename, "r");
	if (fd == NULL)
	{
		verboseERROR(&logger, "Falha ao tentar abrir arquivo: '%s'.\n", ctx->filename);
		return(0);
	}

	joffs = json_parse_file(fd);
	fclose(fd);

	if (joffs == NULL)
	{
		verboseERROR(&logger, "Arquivo corrompido: '%s'.\n", ctx->filename);
		return(0);
	}

	n = json_array_length(joffs);
	if (n < 1)
	{
		verboseERROR(&logger, "Arquivo JSON invalido: '%s'.\n", ctx->filename);
		goto ifponto_get_off_files_iter_end;
	}

	aux = json_array_index(joffs, 0);
	if ((strcmp(field, "pessoas") == 0) && (json_object_get_string(aux, "codigo")[0] == 0))
		field = "crachas";

	verboseDEBUG(&logger, "Anexa: '%s'.\n", ctx->filename);
	jevents = json_object_find(jreader, field);
	if (jevents == NULL)
	{
		jevents = json_array_new(1);
		json_object_add(jreader, field, jevents);
	}

	for (i = 0 ; i < n ; i++)
	{
		aux = json_array_index(joffs, i);

		// Forca compatibilidade
		str = json_object_get_string(aux, "cracha");

		if (str[0] != 0)
			json_object_add(aux, "nro_cartao", json_string_new(str));

		json_array_add(jevents, json_clone(aux));
	}

ifponto_get_off_files_iter_end:
	json_value_free(joffs);

	str = ctx->filename;
	json_array_add(delete_files, json_string_new(str));

	return(0);
}
// /////////////////////////////////////////////////////////////////// //
int ifponto_get_off_files(JSON_VALUE *jreader, JSON_VALUE *delete_files, int *qty)
{
	char *path_off = if_getopt_getValue(ifponto_config, "PATH_OFF");
	void *params[] = {jreader, delete_files, qty};
	DIR_CONTEXT *dir = fs_dir_new(path_off);

	if (dir == NULL)
		return(-1);

	fs_dir_iter(dir, ifponto_get_off_files_iter, params);

	fs_dir_free(dir);

	return(0);
}
// /////////////////////////////////////////////////////////////////// //


// /////////////////////////////////////////////////////////////////// //
void ifponto_make_db_url_path(_OUT char **path)
{
	char *p = if_malloc(BUFFER_LEN); 

	*path = p;
	//p += snprintf(p, BUFFER_LEN, "%s", if_getopt_getValue(ifponto_config, "DB"));
	p += snprintf(p, BUFFER_LEN, "%s", if_getopt_getValue(ifponto_config, "SIIN_PATH"));

	if (if_getopt_getValue(ifponto_config, "READERS")[0] == 0)
		return;

	snprintf(p, BUFFER_LEN - (p - *path), "?nros=%%5B%s%%5D", if_getopt_getValue(ifponto_config, "READERS"));
}
// /////////////////////////////////////////////////////////////////// //
int ifponto_get_status_iter(DIR_CONTEXT *dir, FILE_CONTEXT *ctx, void *user_data)
{
	char *purge[] = {"READERS","ATIVO","WEBHOST","porta","ip","centralizador","nome","modelo","CLIENTID","CENTRALIZADORES","ONLINE","SIIN_PATH","WEBPORT","verbosity","OFFLINE","DB","JVERBOSITY","LIBRARY_PATH","library","QTD_OFF_FILES","VERBOSITY","LISTENERS","CLASSPATH",NULL};
	void **params = (void **) user_data;
	JSON_VALUE *arr = (JSON_VALUE *) params[0];
	JSON_VALUE *delete_files = (JSON_VALUE *) params[1];
	int *qty = (int *) params[2];
	JSON_VALUE *jstatus;
	FILE *fd;
	int i;

	if (!fs_file_check(ctx, "status_", IFPONTO_JSON_SUFFIX))
		return(0);

	fd = fopen(ctx->filename, "r");
	if (fd == NULL)
	{
		verboseERROR(&logger, "Falha ao tentar abrir arquivo de status: '%s'.\n", ctx->filename);
		return(0);
	}

	jstatus = json_parse_file(fd);
	fclose(fd);

	if (jstatus == NULL)
		return(0);

	for (i = 0 ; purge[i] != NULL ; i++)
		json_object_remove(jstatus, purge[i]);

	json_object_add(jstatus, "qty_online", json_integer_new(0));
	json_object_add(jstatus, "qty_offline", json_integer_new(0));
	json_object_add(jstatus, "segundos_offline", json_integer_new(0));

	ifponto_get_off_files(jstatus, delete_files, qty);

	json_array_add(arr, jstatus);

	verboseDEBUG(&logger, "Anexa: '%s'.\n", ctx->filename);

	return(0);
}
// /////////////////////////////////////////////////////////////////// //
JSON_VALUE * ifponto_get_status(JSON_VALUE *delete_files)
{
	char *path_log = if_getopt_getValue(ifponto_config, "PATH_LOG");
	int qty = 0;
	JSON_VALUE *arr = json_array_new(2);
	DIR_CONTEXT *dir = fs_dir_new(path_log);
	void *params[] = {arr, delete_files, &qty};

	if (dir == NULL)
		return(arr);

	fs_dir_iter(dir, ifponto_get_status_iter, params);

	fs_dir_free(dir);

	return(arr);
}
// /////////////////////////////////////////////////////////////////// //
int ifponto_delete_files(JSON_VALUE *jfile, void *user_data)
{
	char *str = json_get_string(jfile);
	verboseDEBUG(&logger, "Apaga arquivo de offs. (%s)\n", str);
	if (fs_delete(str))
		verboseERROR(&logger, "Erro ao tentar apagar arquivo: '%s'.\n", str);

	return(0);
}
// /////////////////////////////////////////////////////////////////// //
_CALLBACK int siin_equipamentos_progress(void *user_data, double dltotal, double dlnow, double ultotal, double ulnow)
{
	unsigned char *transfer = (unsigned char *) user_data;

	if (dltotal > 0.0)
	{
		if (dltotal == dlnow)
		{
			if (transfer[0] == 0)
				verboseINFO(&logger, "Download Finalizado.\n");
        
			transfer[0] = 1;
		}
		else if (dlnow > 0.0)
			verboseDEBUG(&logger, "Download: %0.0lf/%0.0lf\n", dlnow, dltotal);
	}

	if (ultotal > 0.0)
	{
		if (ultotal == ulnow)
		{
			if (transfer[1] == 0)
				verboseINFO(&logger, "Upload Finalizado.\n");
        
			transfer[1] = 1;
		}
		else if (ulnow > 0.0)
			verboseDEBUG(&logger, "Upload: %0.0lf/%0.0lf\n", ulnow, ultotal);
	}

	return(0);
}
// /////////////////////////////////////////////////////////////////// //
JSON_VALUE * ifponto_get_info()
{
	int i;
	JSON_VALUE *info;

	info = json_object_new(1);
	siin_machine_info(info);

	for (i = 0 ; ifponto_config[i].long_opt != NULL ; i++)
	{
		json_object_add(info, ifponto_config[i].long_opt, json_string_new(ifponto_config[i].arg));
	}

	return(info);
}
// /////////////////////////////////////////////////////////////////// //
JSON_VALUE * ifponto_decript_data(char *cipher, char *key)
{
	unsigned char *dat = NULL;
	JSON_VALUE *jdat = NULL;
	char *strjson = NULL;
	int len, datlen = 0;

	datlen = b64_decode(cipher, &dat);
	if ((dat == NULL) || (datlen < 2))
	{
		verboseDEBUG(&logger, "ifponto_decript_dat - falha base64: -->%s<--\n", cipher);
		goto ifponto_decript_dat_err;
	}

	strjson = if_malloc(datlen + 2);
	memset(strjson, 0, datlen + 2);

	rc4bin(key, dat, datlen, (unsigned char *) strjson);

	len = strlen(strjson);
	if (len < 2)
		goto ifponto_decript_dat_err;

	jdat = json_parse_mem(strjson);

	verboseDEBUG(&logger, "ifponto_decript_dat - Resp: -->%s<--\n", strjson);
	if (jdat == NULL)
		verboseERROR(&logger, "ifponto_decript_dat - Falha na criptografia.\n");

ifponto_decript_dat_err:
	if_free(dat);
	if_free(strjson);

	return(jdat);
}
// /////////////////////////////////////////////////////////////////// //
char * ifponto_encript_data(char *txt, char *key)
{
	unsigned char *ciphertext = malloc(sizeof(unsigned char) * strlen(txt));
	char *b64;

	rc4(key, txt, ciphertext);
	b64_encode(ciphertext, strlen(txt), &b64);
	if_free(ciphertext);

	return(b64);
}
// /////////////////////////////////////////////////////////////////// //
int ifponto_process_response(JSON_VALUE *json, JSON_VALUE *jfiles, IFPONTO_OBSERVER *obs)
{
	char msg[PATH_LEN];
	int qty, err = 0;
	char *id;

	if ((json == NULL) || (json_get_type(json) != JSON_OBJECT_TYPE))
	{
		if (obs != NULL)
		{
			snprintf(msg, PATH_LEN, "Limpa chave para forcar sincronizacao.\n");
			obs->callback("inc", msg, obs->user_data);
		}

		//verboseINFO(&logger, "%s\n", msg);
		if_getopt_setValue(ifponto_config, "CHAVE", "");
		if_getopt_save(CONFIG_INI, ifponto_config);
		return(-1);
	}

	id = json_object_get_string(json, "id");
	if (id[0] != 0)
	{
		if_getopt_setValue(ifponto_config, "CHAVE", if_strdup(id));
		if_getopt_save(CONFIG_INI, ifponto_config);
	}

	if (json_object_find(json, "erro") == NULL)
		return(-2);

	err = json_object_get_int(json, "erro");
	if (err == 0)
	{
		qty = json_array_iter(jfiles, ifponto_delete_files, NULL);
		if (qty > 0)
			verboseINFO(&logger, "Arquivos apagados: %d\n", qty);
	}
	else
	{
		if (obs != NULL)
		{
			snprintf(msg, PATH_LEN, "Erro: %d - %s\n", err, json_object_get_string(json, "msg"));
			obs->callback("inc", msg, obs->user_data);
		}

		verboseERROR(&logger, "%s\n", msg);
	}

	return(0);
}
// /////////////////////////////////////////////////////////////////// //
JSON_VALUE * ifponto_get_siin(IFPONTO_OBSERVER *obs)
{
	char *chave = if_getopt_getValue(ifponto_config, "CHAVE");
	char *clientid = if_getopt_getValue(ifponto_config, "CLIENTID");
	char *list[] = {"modulo","SIIN", "versao",siin_version(), NULL,NULL};
	JSON_VALUE *json_config = NULL, *jstatus, *arr, *delete_files, *jinfo;
	char *webhost, *webport, *jsontxt, *dados;
	unsigned char transfer[] = {0,0};
	char *path = NULL;
	char *db = NULL;
	URL *url;
	char key[PATH_LEN], unixtime[30];
	time_t now = time(NULL);

	snprintf(unixtime, sizeof(unixtime), "%ld", now);
	char *postlist[] = {"dados","", "unixtime",unixtime , NULL,NULL};

	webhost = if_getopt_getValue(ifponto_config, "WEBHOST");
	webport = if_getopt_getValue(ifponto_config, "WEBPORT");

	jstatus = json_object_new_list(list);
	delete_files = json_array_new(1);

	if ((strcmp(chave, clientid) == 0) || (chave[0] == 0))
	{
		int i;
		for (i = 0 ; clientid[i] != 0 ; i++)
			if (clientid[i] == '/')
			{
				clientid += i + 1;
				break;
			}

		memset(key, '0', PATH_LEN);

		int len = strlen(clientid);
		if (len < 8)
			snprintf(key + (8 - len), PATH_LEN, "%s", clientid);
		else
			snprintf(key, PATH_LEN, "%s", clientid);
	}
	else
	{
		arr = ifponto_get_status(delete_files);
		json_object_add(jstatus, "equipamentos", arr);

		snprintf(key, PATH_LEN, "%02X%s%02X", 
			(unsigned char) ((now >> 16) & 0xFF), 
			chave, 
			(unsigned char) ((now >> 8) & 0xFF));
	}

	jinfo = ifponto_get_info();
	if (jinfo != NULL)
		json_object_add(jstatus, "info", jinfo);

	jsontxt = json_serialize(jstatus); 
	json_value_free(jstatus);

	//verboseDEBUG(&logger, "KEY: '%s'\n", key);
	dados = ifponto_encript_data(jsontxt, key);
	postlist[1] = dados;

	ifponto_make_db_url_path(&path);

	verboseINFO(&logger, "ifponto_get_siin - Req: -->%s<--\n", path);
	verboseDEBUG(&logger, "POST-->%s=%s<--\n", postlist[0], jsontxt);
	verboseDEBUG(&logger, "POST-->%s=%s<--\n", postlist[2], postlist[3]);

	url = url_make(webhost, webport, path);
	if_free(path);

	if (logger.verbosity >= IF_VERB_DEBUG)
		url_execute_post_debug(url, postlist, (unsigned char **) &db, NULL, NULL);
	else
		url_execute_post(url, postlist, (unsigned char **) &db, siin_equipamentos_progress, transfer);

	url_free(url);
	if_free(jsontxt);
	if_free(dados);

	if (db == NULL)
	{
		verboseERROR(&logger, "Erro ao tentar acessar servidor.\n");
		json_config = NULL;
	}
	else
	{
		json_config = ifponto_decript_data(db, key);
		if_free(db);

		ifponto_process_response(json_config, delete_files, obs);
	}

	json_value_free(delete_files);

	return(json_config);
}
// /////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
int ifponto_save_prebio_iter(JSON_VALUE *jpessoa, void *user_data)
{
	void **params = (void **) user_data;
	JSON_VALUE *bio = (JSON_VALUE *) params[0];
	JSON_VALUE *pre = (JSON_VALUE *) params[1];
	JSON_VALUE *aux = json_object_find(jpessoa, "templates");

	if ((aux == NULL) || (json_array_length(aux) == 0))
		json_array_add(pre, json_clone(jpessoa));
	else
		json_array_add(bio, json_clone(jpessoa));

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int ifponto_save_prebio(JSON_VALUE *jpessoas, int nro)
{
	JSON_VALUE *bio = json_array_new(1);
	JSON_VALUE *pre = json_array_new(1);
	void *params[] = {bio, pre};
	char filename[PATH_LEN];
	time_t now = time(NULL);
	struct tm *dt = localtime(&now);
	int q;

	json_array_iter(jpessoas, ifponto_save_prebio_iter, params);
	
	q = json_array_length(bio);
	if (q > 0)
	{
		snprintf(filename, PATH_LEN, IFPONTO_BIO_FILE, nro, 
			dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday, 
			dt->tm_hour, dt->tm_min, dt->tm_sec,
			(intptr_t) jpessoas);
        
		json_serialize_file(bio, filename);
	}
	
	q = json_array_length(pre);
	if (q > 0)
	{
		snprintf(filename, PATH_LEN, IFPONTO_PREBIO_FILE, nro, 
			dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday, 
			dt->tm_hour, dt->tm_min, dt->tm_sec,
			(intptr_t) jpessoas);
        
		if (centralizadores[0] != NULL)	
			json_serialize_file(pre, filename);
	}

	json_value_free(bio);
	json_value_free(pre);

	return(q);
}
// ///////////////////////////////////////////////////////////////////// //
void ifponto_save_list(JSON_VALUE *jpessoas, char *filename_mask, int nro)
{
	char filename[PATH_LEN];
	time_t now = time(NULL);
	struct tm *dt;

	dt = localtime(&now);
	snprintf(filename, PATH_LEN, filename_mask, nro, 
		dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday, 
		dt->tm_hour, dt->tm_min, dt->tm_sec,
		(intptr_t) jpessoas);

	json_serialize_file(jpessoas, filename);
}
// ///////////////////////////////////////////////////////////////////// //
int ifponto_tokenizer(char *str, char *tk[])
{
	char *p, *pi;
	int i;

	for (i = 0, p = str, pi = p ; (*p != 0) && (i < READERS_MAX) ; p++)
	{
		if ((*p != ',') && (*p != ';') && (*p != '|'))
			continue;

		*p = 0;
		tk[i++] = pi;
		pi = p + 1; 
	}

	tk[i++] = pi;
	tk[i++] = NULL;
	tk[i] = NULL;

	return(i - 1);
}
// ///////////////////////////////////////////////////////////////////// //
int ifponto_init_timediff()
{
	char *p;
	int n;

	memset(timediff, 0, sizeof(timediff));

	p = if_getopt_getValue(ifponto_config, "TIMEDIFF");
	n = ifponto_tokenizer(p, timediff);

	return(n / 2);
}
// ///////////////////////////////////////////////////////////////////// //
int ifponto_init_centralizadores()
{
	char *p;
	int n;

	memset(centralizadores, 0, sizeof(centralizadores));

	p = if_getopt_getValue(ifponto_config, "CENTRALIZADORES");
	if (p[0] == 0)
		return(0);

	n = ifponto_tokenizer(p, centralizadores);

	return(n);
}
// ///////////////////////////////////////////////////////////////////// //
int ifponto_get_timediff(int nro)
{
	int i;

	for (i = 0 ; (timediff[i] != NULL) && (timediff[i + 1] != NULL) ; i += 2)
		if (atoi(timediff[i]) == nro)
			return(atoi(timediff[i + 1]));

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int ifponto_isCentralizador(int nro)
{
	int i;

	for (i = 0 ; centralizadores[i] != NULL ; i++)
	{
		if (atoi(centralizadores[i]) == nro)
			return(1);
	}

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int ifponto_update_nsr(JSON_VALUE *jreader)
{
	char filename[PATH_LEN];
	char *nsr = json_object_get_string(jreader, "nsr_modificar");
	char *nro = json_object_get_string(jreader, "nro");
	FILE *fd;

	if ((nsr[0] == 0) || (nro[0] == 0))
		return(0);

	snprintf(filename, sizeof(filename), "conf%c%s.nsr", PATH_SEPARATOR, nro);
	fd = fopen(filename, "w");
	if (fd == NULL)
		return(-1);

	fprintf(fd, "%s\n", nsr);
	fclose(fd);

	return(atoi(nsr));
}
// ///////////////////////////////////////////////////////////////////// //
// Para manter compatibilidade
int ifponto_perform_pessoa_operacao_iter(JSON_VALUE *reg, void *user_data)
{
	char *tipo = json_object_get_string(reg, "tipo");

	if (strncmp(tipo, "excluir", 7) == 0)
		json_object_add(reg, "tipo_operacao", json_integer_new(3));
	else
		json_object_add(reg, "tipo_operacao", json_integer_new(1));

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int ifponto_perform_pessoa_iter(JSON_VALUE *pessoa, void *user_data)
{
	JSON_VALUE *cartoes = json_object_find(pessoa, "nro_cartao");
	JSON_VALUE *cartao;
	char *cracha = json_object_get_string(pessoa, "cracha");
	char *tipo_operacao = json_object_get_string(pessoa, "tipo_operacao");
	char *verifica_bio = json_object_get_string(pessoa, "verifica_bio");
	char *cartao_fields[] = {"tecnologia","rfid", "nro",NULL, NULL,NULL};
	char *fields[] = {"tipo","atualizar", "verificar_biometria","1", NULL,NULL};
	int i;

	if ((cartoes == NULL) || (json_array_length(cartoes) < 1))
	{
		// Ajusta cracha
		cartao_fields[3] = cracha;
		cartoes = json_array_new(1);
		json_array_add(cartoes, json_object_new_list(cartao_fields));
		json_object_add(pessoa, "nro_cartao", cartoes);

		if (tipo_operacao[0] == '3')
			fields[1] = "excluir";

		fields[3] = verifica_bio;

		for (i = 0 ; fields[i] != NULL ; i += 2)
			json_object_add(pessoa, fields[i], json_string_new(fields[i + 1]));
	}
	else
	{
		cartao = json_array_index(cartoes, 0);
		cracha = json_object_get_string(cartao, "nro");
		json_object_add(pessoa, "cracha", json_string_new(cracha));

		ifponto_perform_pessoa_operacao_iter(pessoa, user_data);
	
		verifica_bio = json_object_get_string(pessoa, "verificar_biometria");
		json_object_add(pessoa, "verifica_bio", json_string_new(verifica_bio));
	}

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
_CALLBACK int ifponto_perform_reader_iter(char *key, JSON_VALUE *jval, void *user_data)
{
	JSON_VALUE *jreader = (JSON_VALUE *) user_data;
	JSON_VALUE *val = json_clone(jval);
	json_object_add(jreader, key, val);
	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int ifponto_perform_reader(JSON_VALUE *jreader, void *user_data)
{
	char *fields[] = {"CLIENTID", "PATH_LOG", "PATH_OFF", NULL};
	char *remove[] = {"pessoas", "senha", "login_relogio", "ponto", "ativo", "login_relogio", "senha_relogio", "dupla_checagem", "crachas", "json_config", NULL};
	JSON_VALUE *jpessoas, *jcrachas, *json_config;
	char filename[PATH_LEN];
	char *str_json_config;
	int i, nro, td, ct;

	str_json_config = json_object_get_string(jreader, "json_config");
	if ((str_json_config != NULL) && (str_json_config[0] != 0))
	{ 
		json_config = json_parse_mem(str_json_config);
		if ((json_config != NULL) && (json_get_type(json_config) == JSON_OBJECT_TYPE))
		{
			json_object_iter(json_config, ifponto_perform_reader_iter, jreader);
		}
		else
		{
			verboseERROR(&logger, "\"json_config\" deve ser um objeto JSON. - '%s'\n", str_json_config);
		}

		json_value_free(json_config);
	}

	jcrachas = json_object_find(jreader, "crachas");
	jpessoas = json_object_find(jreader, "pessoas");
	nro = json_object_get_int(jreader, "nro");
	td = ifponto_get_timediff(nro);
	ct = ifponto_isCentralizador(nro);

	if ((jcrachas != NULL) && (json_array_length(jcrachas) > 0))
	{
		json_array_iter(jcrachas, ifponto_perform_pessoa_operacao_iter, NULL);
		ifponto_save_list(jcrachas, IFPONTO_CARD_FILE, nro);
	}

	if ((jpessoas != NULL) && (json_array_length(jpessoas) > 0))
	{
		json_array_iter(jpessoas, ifponto_perform_pessoa_iter, NULL);
		ifponto_save_list(jpessoas, IFPONTO_LIST_FILE, nro);

		ifponto_save_prebio(jpessoas, nro);
	}

	json_object_add(jreader, "timediff", json_integer_new(td));
	json_object_add(jreader, "centralizador", json_integer_new(ct));

	if (json_object_find(jreader, "verbosity") == NULL)
		json_object_add(jreader, "verbosity", json_integer_new(logger.verbosity));

	for (i = 0 ; fields[i] != NULL ; i++) 
		json_object_add(jreader, fields[i], json_string_new(if_getopt_getValue(ifponto_config, fields[i])));

	for (i = 0 ; remove[i] != NULL ; i++)
		json_object_remove(jreader, remove[i]);

	snprintf(filename, PATH_LEN, IFPONTO_CONFIG_FILE, nro);
	json_serialize_file(jreader, filename);

	ifponto_update_nsr(jreader);

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //


// Implementacao Modulo WEB //////////////////////////////////////////// //
// /////////////////////////////////////////////////////////////////// //
void ifponto_init_params(IF_GETOPT *opts)
{
	char *clientid;
	char buf[PATH_LEN];
	int len;

	clientid = if_getopt_getValue(opts, "CLIENTID");
	if (clientid[0] == 0)
		verbose(stderr, "CLIENTID nao definido em '%s'.\n", CONFIG_INI);

	if (if_getopt_getValue(opts, "CHAVE")[0] == 0)
	{
		if_getopt_setValue(opts, "CHAVE", if_strdup(clientid));
		if_getopt_save(CONFIG_INI, opts);
		verbose(stdout, "Arquivo '%s' atualizado.\n", CONFIG_INI);
	}

	len = strlen(clientid);
	if (strncmp(clientid, if_getopt_getValue(opts, "SIIN_PATH"), len) == 0)
		return;

	snprintf(buf, PATH_LEN, "%s/db/%s", clientid, SIIN_PATH_DEFAULT);
	if_getopt_setValue(opts, "SIIN_PATH", if_strdup(buf));

	snprintf(buf, PATH_LEN, "%s/db/%s", clientid, ONLINE_DEFAULT);
	if_getopt_setValue(opts, "ONLINE", if_strdup(buf));

	if_getopt_save(CONFIG_INI, opts);
	verbose(stdout, "Arquivo '%s' gerado.\n", CONFIG_INI);
}
// ///////////////////////////////////////////////////////////////////// //
int if_modweb_init(MODSIIN *mod)
{
	verbose(stdout, "Le configuracao: %s.\n", CONFIG_INI);
	if (if_getopt_ini(CONFIG_INI, ifponto_config) < 1)
		verboseERROR(&logger, "Falha ao tentar ler: %s\n", CONFIG_INI);

	int ativo = atoi(if_getopt_getValue(ifponto_config, "ATIVO"));
	if (!ativo)
	{
		verbose(stderr, "|%s| inativo.\n", MODULE);
		return(0);
	}

	ifponto_init_params(ifponto_config);

	logger.verbosity = atoi(if_getopt_getValue(ifponto_config, "VERBOSITY"));
	snprintf(logger.source, sizeof(logger.source), "%s", MODULE);
	verbose(stdout, "|%s| VERBOSITY = %d\n", MODULE, logger.verbosity);

	if (logger.verbosity >= IF_VERB_DEBUG)
	{
		verbose(stdout, "|%s| - %s\n", MODULE, CONFIG_INI);
		if_getopt_verbose(ifponto_config);
		verbose(stdout, "\n");
	}

	ifponto_init_timediff();
	ifponto_init_centralizadores();

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int if_modweb_finalize(MODSIIN *mod)
{
	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
void * if_modweb_run(THREAD_STATE *state, int id, void *user_data)
{
	IFPONTO_OBSERVER *obs = (IFPONTO_OBSERVER *) user_data;
	int delay = atoi(if_getopt_getValue(ifponto_config, "LOOP"));
	JSON_VALUE *jdata = NULL, *jreaders;
	char msg[PATH_LEN];
	//int port;
	int n;

	n = ifponto_delete_status();
	verboseINFO(&logger, "Arquivos 'config' deletados: %d\n", n);

	if (obs != NULL)
	{
		snprintf(msg, PATH_LEN, "Running...\n");
		obs->callback("inc", msg, obs->user_data);
	}

	while (*state == TH_ALIVE)
	{
		if_sleep(1000);

		json_value_free(jdata);
		jdata = ifponto_get_siin(obs);
		if (jdata == NULL)
			continue;

		if (json_get_type(jdata) != JSON_OBJECT_TYPE)
			continue;

		jreaders = json_object_find(jdata, "equipamentos");
		if ((jreaders == NULL) || (json_get_type(jreaders) != JSON_ARRAY_TYPE))
			continue;

		json_array_iter(jreaders, ifponto_perform_reader, obs);

		if (obs == NULL)
		{
			if_sleep(delay * 1000);
		}
		else
		{
			for (n = 0 ; (n < delay) && (*state == TH_ALIVE) ; n++)
			{
				float per = (float) (delay - n) / (float) delay;
				snprintf(msg, PATH_LEN, "%f", per);
				obs->callback("sleep", msg, obs->user_data);
				if_sleep(1000);
			}
			obs->callback("sleep", "0", obs->user_data);
		}
	}

	if (obs != NULL)
	{
		snprintf(msg, PATH_LEN, "Parado.\n");
		obs->callback("run", msg, obs->user_data);
	}

	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
// FIM - Implementacao Modulo WEB ////////////////////////////////////// //


