#ifndef IFPONTO_H
#define IFPONTO_H

#include <ifractal.h>

#ifdef WITH_PNG
#include <png.h>
#endif

#ifdef WIN32
#define CONFIG_INI	"conf\\ifponto.ini"
#else
#define CONFIG_INI	"conf/ifponto.ini"
#endif

#define SIIN_PATH_DEFAULT	"siin_equipamentos.php"
#define ONLINE_DEFAULT		"online.php"

#define IFPONTO_MAX_OFF_FILES		10
#define IFPONTO_MAX_TEMPLATE_LEN	50000

#define IFRACTALSRV			"ifractal.srv.br"
#define IFPONTO_OFF_BKP_FILE		"offbkp%d.csv"

#define IFPONTO_BIO_PREFIX		"bio_"
#define IFPONTO_PREBIO_PREFIX		"prebio_"
#define IFPONTO_JSON_SUFFIX		".json"

#ifdef WIN32
#define IFPONTO_USERS_FILE_DEFAULT		"conf\\users.json"
#define IFPONTO_OFF_JSON_FILE_DEFAULT		"off\\off_%d_%04d%02d%02d_%02d%02d%02d_%X.json"
#define IFPONTO_STATUS_FILE_DEFAULT		"log\\status_%d.json"
#define IFPONTO_CONFIG_FILE_DEFAULT		"log\\config_%d.json"
#define IFPONTO_LIST_FILE_DEFAULT		"log\\list_%d_%04d%02d%02d_%02d%02d%02d_%X.json"
#define IFPONTO_CARD_FILE_DEFAULT		"log\\card_%d_%04d%02d%02d_%02d%02d%02d_%X.json"
#define IFPONTO_PREBIO_FILE_DEFAULT		"log\\prebio_%d_%04d%02d%02d_%02d%02d%02d_%X.json"
#define IFPONTO_BIO_FILE_DEFAULT		"log\\bio_%d_%04d%02d%02d_%02d%02d%02d_%X.json"
#define IFPONTO_OFF_BIO_FILE_DEFAULT		"off\\bio_%d_%04d%02d%02d_%02d%02d%02d_%X.json"
#define IFPONTO_RESULT_FILE_DEFAULT		"off\\result_%d_%04d%02d%02d_%02d%02d%02d_%lX.json"
#else
#define IFPONTO_USERS_FILE_DEFAULT		"conf/users.json"
#define IFPONTO_OFF_JSON_FILE_DEFAULT		"off/off_%d_%04d%02d%02d_%02d%02d%02d_%lX.json"
#define IFPONTO_STATUS_FILE_DEFAULT		"log/status_%d.json"
#define IFPONTO_CONFIG_FILE_DEFAULT		"log/config_%d.json"
#define IFPONTO_LIST_FILE_DEFAULT		"log/list_%d_%04d%02d%02d_%02d%02d%02d_%lX.json"
#define IFPONTO_CARD_FILE_DEFAULT		"log/card_%d_%04d%02d%02d_%02d%02d%02d_%lX.json"
#define IFPONTO_PREBIO_FILE_DEFAULT		"log/prebio_%d_%04d%02d%02d_%02d%02d%02d_%lX.json"
#define IFPONTO_BIO_FILE_DEFAULT		"log/bio_%d_%04d%02d%02d_%02d%02d%02d_%lX.json"
#define IFPONTO_OFF_BIO_FILE_DEFAULT		"off/bio_%d_%04d%02d%02d_%02d%02d%02d_%X.json"
#define IFPONTO_RESULT_FILE_DEFAULT		"off/result_%d_%04d%02d%02d_%02d%02d%02d_%lX.json"
#endif

#define SUPREMA_BIO_LEN			0x180
#define MAX_TEMPLATE_VERIFY		1000

#define PIS_MAX_LEN			20

void init_config_masks();

typedef enum
{
	IFPONTO_EV_OFF_LEITOR,
	IFPONTO_EV_OFF_MATRICULA,
	IFPONTO_EV_OFF_CANAL,
	IFPONTO_EV_OFF_DATAHORA,
	IFPONTO_EV_OFF_SENTIDO,
	IFPONTO_EV_OFF_LEN
} IFPONTO_EVENTOS_OFF;

// Ajuste para REP (portaria 1510)
#define IFPONTO_EV_OFF_PIS		IFPONTO_EV_OFF_MATRICULA
#define IFPONTO_EV_OFF_NSR		IFPONTO_EV_OFF_CANAL

typedef enum
{
	SCANNER_RESULT_OK = 0,
	SCANNER_RESULT_MODULE_ERROR = -1,
	SCANNER_RESULT_SCANNER_ERROR = -2,
	SCANNER_RESULT_CAPTURE_ERROR = -3,
	SCANNER_RESULT_IDENTIFY_DB_ERROR = -4,
	SCANNER_RESULT_IDENTIFY_ERROR = -5,
	SCANNER_RESULT_VERIFY_ERROR = -6,
	SCANNER_RESULT_BIO_NOT_FOUND = -7,
	SCANNER_RESULT_BIO_NOT_ENROLLED = -8,
	SCANNER_RESULT_INVALID_PARAMETERS = -9,
	SCANNER_RESULT_ENROLL_DB_ERROR = -10,
	SCANNER_RESULT_DELETE_ERROR = -11,
	SCANNER_RESULT_UP_FIRMWARE_ERROR = -12,
	SCANNER_RESULT_EXTRACT_ERROR = -13,
} SCANNER_RESULT;

typedef enum
{
	DOW_SUNDAY,
	DOW_MONDAY,
	DOW_TUESDAY,
	DOW_WEDNESDAY,
	DOW_THURSDAY,
	DOW_FRIDAY,
	DOW_SATURDAY,
	DOW_HOLYDAY,
	DOW_LEN
} C0_DOW;

typedef struct
{
	uint8_t yr;
	uint8_t mon;
	uint8_t dom;
	uint8_t hr;
	uint8_t min;
	uint8_t sec;
	C0_DOW dow;
} C0_TIMESTAMP;


typedef enum
{
	IFDEVICE4J_MODEL_UNKNOWN,
	IFDEVICE4J_MODEL_HENRY8x,
	IFDEVICE4J_MODEL_ZK,
	IFDEVICE4J_MODEL_CID,
	IFDEVICE4J_MODEL_VT,
	IFDEVICE4J_MODEL_DOTNET,
	IFDEVICE4J_MODEL_DIMEP,
	IFDEVICE4J_MODEL_RWT,
	IFDEVICE4J_MODEL_HENRY7x,
	IFDEVICE4J_MODEL_TEST,
	IFDEVICE4J_MODEL_LEN
} IFDEVICE4J_MODEL;

typedef struct _IFDEVICE4J IFDEVICE4J; 

typedef JSON_VALUE * (*IFDEVICE4J_getInfo)(IFDEVICE4J *, intptr_t sock);
typedef time_t (*IFDEVICE4J_getTime)(IFDEVICE4J *, intptr_t sock);
typedef intptr_t (*IFDEVICE4J_setTime)(IFDEVICE4J *, intptr_t diff);
typedef JSON_VALUE * (*IFDEVICE4J_sendUsers)(IFDEVICE4J *, JSON_VALUE *users);
typedef JSON_VALUE * (*IFDEVICE4J_getUsers)(IFDEVICE4J *, intptr_t);
typedef JSON_VALUE * (*IFDEVICE4J_sendBio)(IFDEVICE4J *, JSON_VALUE *users);
typedef JSON_VALUE * (*IFDEVICE4J_getBio)(IFDEVICE4J *, JSON_VALUE *users);
typedef JSON_VALUE * (*IFDEVICE4J_getEvents)(IFDEVICE4J *, intptr_t nsr);

typedef intptr_t (*IFDEVICE4J_method)(IFDEVICE4J *, intptr_t nsr);

typedef void (*IFDEVICE4J_free)(IFDEVICE4J *);

typedef JSON_VALUE * (*IFDEVICE4J_online_callback)(int argc, char *argv[], void *context, char *method_name);
typedef int (*IFDEVICE4J_online)(IFDEVICE4J *, IFDEVICE4J_online_callback, void *context);

typedef enum
{
	IFDEVICE_RESPONSE_NOP,
	IFDEVICE_RESPONSE_ACCESS_CODE,
	IFDEVICE_RESPONSE_AUTH,
	IFDEVICE_RESPONSE_TURN,
	IFDEVICE_RESPONSE_MSG1,
	IFDEVICE_RESPONSE_MSG2,
	IFDEVICE_RESPONSE_NAME,
	IFDEVICE_RESPONSE_COD_PESSOA,
	IFDEVICE_RESPONSE_COD_UNIDADE,
	IFDEVICE_RESPONSE_COD_CARGO,
	IFDEVICE_RESPONSE_COD_CARTAO,
	IFDEVICE_RESPONSE_PASSWORD,
	IFDEVICE_RESPONSE_DATAHORA,
	IFDEVICE_RESPONSE_LEN
} IFDEVICE_RESPONSE_CSV;

#define IFDEVICE_CARD_MAX	24

typedef struct
{
	char card[IFDEVICE_CARD_MAX];
	uint32_t access_id;
	uint32_t user_id;
	uint32_t card_id;
	char turn;
} IFDEVICE_LAST_ACCESS;

struct _IFDEVICE4J
{
	IFDEVICE4J_MODEL type;
	IFLOG log;
	int codigo;
	int nro;
	int sock;
	char host[HOST_LEN];
	char port[PORT_LEN];
	JSON_VALUE *config;

	IFDEVICE4J_getInfo getInfo;
	IFDEVICE4J_getTime getTime;
	IFDEVICE4J_setTime setTime;
	IFDEVICE4J_sendUsers sendUsers;
	IFDEVICE4J_getUsers getUsers;
	IFDEVICE4J_sendBio sendBio;
	IFDEVICE4J_getBio getBio;
	IFDEVICE4J_getEvents getEvents;

	IFDEVICE4J_free free;
	IFDEVICE4J_online online;

	IFDEVICE_LAST_ACCESS last;
};

typedef IFDEVICE4J IFDEVICE;

typedef struct
{
	IFDEVICE device;
	uint16_t sessionid;
	uint16_t replyid;
	uint16_t model;
} ZK;

typedef struct
{
	IFDEVICE device;
	int last_nsr;
} CID;

typedef struct
{
	IFDEVICE device;
} VT;

typedef struct
{
	IFDEVICE device;
	unsigned char sequence;
} DIMEP;

typedef struct
{
	IFDEVICE device;
	char cpf[12];
} RWT;


void henry7x_init(IFDEVICE4J *);
void henry8x_init(IFDEVICE4J *);
void ZK_init(IFDEVICE4J *);
void CID_init(IFDEVICE4J *);
void IDBIO_init(IFDEVICE4J *);
void VT_init(IFDEVICE4J *);
void RWT_init(IFDEVICE4J *);
void dotnet_init(IFDEVICE4J *);
void dimep_init(IFDEVICE4J *);

typedef union
{
	uint8_t data[512];
	IFDEVICE4J dev4j;
	ZK zk;
	CID cid;
	VT vt;
	RWT rwt;
	DIMEP dimep;
} IFDEVICE_GENERIC;

IFDEVICE4J * IFPONTO_ifponto4j_new(JSON_VALUE *jconfig);
void IFPONTO_ifponto4j_free(IFDEVICE4J *);

void IFPONTO_device_init(IFDEVICE *, JSON_VALUE *);

typedef enum
{
	DESKTOP_OPTION_BIO,
	DESKTOP_OPTION_PASS,
	DESKTOP_OPTION_PHOTO,
	DESKTOP_OPTION_LEN
} DESKTOP_OPTION;


struct _HAMSTERS
{
	char *name;
	char *library;
	char *vendor;
};

typedef struct _SCANNER SCANNER; 

typedef struct
{
	intptr_t handle;
	char name[PATH_LEN];
} SCANNER_DEVICE;

_PUBLIC typedef SCANNER_RESULT (*SCANNER_init)(SCANNER *);	// "ifdevice_init"
typedef SCANNER_RESULT (*SCANNER_finalize)(SCANNER *);
typedef SCANNER_RESULT (*SCANNER_enumerate)(SCANNER *, SCANNER_DEVICE **, size_t *device_count);
typedef SCANNER_RESULT (*SCANNER_deleteBio)(SCANNER *, char *id, int *qty);
typedef SCANNER_RESULT (*SCANNER_captureImage)(SCANNER *scan, int qty_samples, void *user_data);
typedef SCANNER_RESULT (*SCANNER_enroll)(SCANNER *scan, int qty_frames, char *id, int8_t *quality, void *user_data);
typedef SCANNER_RESULT (*SCANNER_identify)(SCANNER *scan, char *id, size_t id_len, int *finger, int32_t *score, void *user_data);
typedef SCANNER_RESULT (*SCANNER_verify)(SCANNER *scan, char *id, int *finger, void *user_data);
typedef SCANNER_RESULT (*SCANNER_delete_all)();
typedef SCANNER_RESULT (*SCANNER_update_firmware)(char *filePath);


typedef int (*SCANNER_TEMPLATE_CALLBACK)(SCANNER *scan, char *vendor, uint8_t *templ, size_t len, int8_t quality, void *user_data);
typedef int (*SCANNER_IMAGE_CALLBACK)(SCANNER *scan, uint8_t *imageBuf, uint32_t width, uint32_t height, void *user_data);
typedef int (*SCANNER_MESSAGE_CALLBACK)(SCANNER *scan, char *vendor, char *msg, void *user_data);

struct _SCANNER
{
	IFDEVICE dev;
	intptr_t lib_handle;

	SCANNER_init init;
	SCANNER_finalize finalize;
	SCANNER_enumerate enumerate;
	SCANNER_deleteBio deleteBio;
	SCANNER_captureImage captureImage;
	SCANNER_enroll enroll;
	SCANNER_identify identify;
	SCANNER_verify verify;
	SCANNER_delete_all delete_all;
	SCANNER_update_firmware update_firmware;
	size_t template_size;
	size_t image_size;
	uint32_t width;
	uint32_t height;
	uint32_t dpi;
	SCANNER_TEMPLATE_CALLBACK template_callback;
	SCANNER_IMAGE_CALLBACK image_callback;
	SCANNER_MESSAGE_CALLBACK message_callback;

	uint8_t device_selected;
	size_t device_count;
	SCANNER_DEVICE *device;

	intptr_t hwnd;

#ifdef WIN32
	void (*windows_callback)(SCANNER *, HWND, UINT message, WPARAM, LPARAM);
#endif
};

SCANNER * IFPONTO_SCANNER_new(JSON_VALUE *, SCANNER_TEMPLATE_CALLBACK, SCANNER_IMAGE_CALLBACK, SCANNER_MESSAGE_CALLBACK);
SCANNER * IFPONTO_SCANNER_new_with_hwnd(JSON_VALUE *, intptr_t hwnd, SCANNER_TEMPLATE_CALLBACK, SCANNER_IMAGE_CALLBACK, SCANNER_MESSAGE_CALLBACK);

void IFPONTO_SCANNER_free(SCANNER *);

int scanner_set_device(SCANNER *, uint8_t);
int scanner_get_image_filename(char *path, char *filename, size_t len, char *id, int finger, int count);
int scanner_get_template_filename(char *path, char *filename, size_t len, char *id, int finger);
int scanner_file_deleteBio(SCANNER *, char *id);

#ifdef WITH_PNG
typedef void (*PNG_WRITE_CALLBACK)(png_structp, png_bytep, png_size_t);
int ifdevice_BW8_to_PNG(SCANNER *scan, uint8_t *img, int width, int height, PNG_WRITE_CALLBACK, void *user_data);
#endif

int ifdevice_addResult(JSON_VALUE *reg, JSON_VALUE *res, char *resp, int err);
char * ifdevice_getID(JSON_VALUE *user);
int ifdevice_get_password_hash(char *);

#define TEMPLATE_SUFFIX		".templ"

typedef void (*IFPONTO_OBSERVER_CALLBACK)(char *title, char *msg, void *user_data);

typedef struct
{
	void *user_data;
	IFPONTO_OBSERVER_CALLBACK callback;
} IFPONTO_OBSERVER;

void ifponto_save_list(JSON_VALUE *jpessoas, char *filename_mask, int nro);

JSON_VALUE * scanner_file_getUsers(IFDEVICE4J *, char *vendor);
JSON_VALUE * scanner_file_sendBio(IFDEVICE4J *, JSON_VALUE *jusers, char *vendor);
JSON_VALUE * scanner_file_getBio(IFDEVICE4J *, JSON_VALUE *jusers, char *vendor);

char * scanner_get_msg(SCANNER_RESULT);

void show_check_individual();

int print_mask_2(FILE *fd, char *mask, int p1, int p2);
int java_ifponto_config(FILE *fd);
int h_result_config(FILE *fd);
int c_result_config(FILE *fd);
int cs_result_config(FILE *fd);
	
JSON_VALUE * ifponto_get_devices();
void ifponto_suspend(int nro);
void ifponto_resume(int nro);

int ifdevice_drawBWLine(uint8_t *img, size_t width, size_t height, int x1, int y1, int x2, int y2, uint32_t pattern);
int ifdevice_drawBWRect(uint8_t *img, size_t img_width, size_t img_height, 
	int x, int y, int width, int height, uint32_t pattern);


int scanner_getopt_fill_json_object(IF_GETOPT *, JSON_VALUE *);

SCANNER_RESULT scanner_enroll_image(
	SCANNER *scan, uint8_t *img_bw8, size_t width, size_t height, 
	int qty_frames, char *id, int8_t *quality, void *user_data);

SCANNER_RESULT scanner_identify_image(
	SCANNER *scan, uint8_t *img_bw8, size_t width, size_t height, 
	char *id, size_t id_len, int *finger, int32_t *score, void *user_data);

SCANNER_RESULT scanner_verify_image(
	SCANNER *scan, uint8_t *img_bw8, size_t width, size_t height, 
	char *id, int *finger, void *user_data);

#endif

