#include <ifractal.h>
#include <ifdevice.h>

#define CMD_CONN		0x01
#define CMD_CONN_START		0x00
#define CMD_CONN_END		0x01

#define CMD_INFO		0x02
#define CMD_INFO_STATUS		0x00
#define CMD_INFO_REDE		0x10
#define CMD_INFO_VERAO		0x20
#define CMD_INFO_EMPRESA	0x30
#define CMD_INFO_DATETIME	0x40
#define CMD_INFO_SET_DATETIME	0x41

#define CMD_AFD			0x03
#define CMD_GET_USERS		0x01
#define CMD_SET_USER		0x20
#define CMD_SET_USER_OK		0x13
#define CMD_SET_USER_ERR	0x23
#define CMD_SEND_USER_BIO	0x30
#define CMD_GET_USER_BIO	0x31
#define CMD_DEL_USER_BIO	0x32
#define CMD_DEL_PIS		0x40
#define CMD_AFD_NSR		0x51
#define CMD_AFD_COLETA		0x52

#define CID_DEFAULT_PORT	1818
#define CID_QTD_BLOCOS		10

#define CID_BIO_LEN		0x1000

typedef struct
{
	unsigned char cmd[2];
	unsigned char length[2];	// big endian
} CIDHEADER;

typedef struct
{
	unsigned char papel_acumulado[4];
	unsigned char restante_bobina[4];
	unsigned char tamanho_bobina[4];
	unsigned char cortes[4];
	unsigned char uptime[4];
	unsigned char nsr[4];
	char serial[20];
} CIDINFO;

typedef struct
{
	unsigned char total_blocos[4];
	unsigned char unknown[2];
	unsigned char bloco[2];
	unsigned char posicao[2];
	unsigned char tamanho_bloco[2];
} CIDAFDADDRESS;

typedef struct
{
	unsigned char pis[8];
	unsigned char rfid[4];
	unsigned char codigo[4];
	char senha[6];
	char nome[52];
	char barras[14];
	uint8_t unknown1;
	uint8_t unknown2;
	uint8_t qty_bio;
	uint8_t privilegio;
} CIDUSER;

int CID_open(IFDEVICE *);
int CID_close(IFDEVICE *);
time_t CID_getTime(IFDEVICE *);
int CID_setTime(IFDEVICE *, int timediff);
int CID_getInfo(IFDEVICE *, _INOUT CIDINFO **);
int CID_coleta(IFDEVICE *, uint32_t nsr, JSON_VALUE *);

int CID_sendUser(IFDEVICE *, CIDUSER *user);
int CID_excluiUser(IFDEVICE *, CIDUSER *user);

typedef int CID_USER_CALLBACK(CIDUSER *, void *user_data);
int CID_getUsers(IFDEVICE *, CID_USER_CALLBACK, void *user_data);

typedef int CID_BIO_CALLBACK(unsigned char *pis, unsigned char *data, size_t len, void *user_data);
int CID_getBio(IFDEVICE *, unsigned char *pis, CID_BIO_CALLBACK, void *user_data);

