#include <ifractal.h>
#include <ifdevice.h>

#define DEFAULT_PORT			"3000"

#define HENRY_DISPLAY_LEN		32
#define HENRY_MSG_LEN			34
#define	HENRY_TIMEOUT			1
#define	HENRY_TIMEOUT2			5
#define HENRY_DATAHORA_LEN		11
#define HENRY_CATRACA_LEN		2
#define HENRY_CONFIGURACAO_LEN		64
#define HENRY_MAPA_LEN			16
#define HENRY_BLOCO_MEM_LEN		64

#define HENRY_MSG_ONLINE		0x80
#define HENRY_ENVIA_CONFIGURACAO	0x81
#define HENRY_RECUPERA_BATIDAS		0x83
#define HENRY_RECEBE_CONFIGURACAO	0x91
#define HENRY_AJUSTA_HORA		0x82
#define HENRY_ENVIA_MSG			0x84
#define HENRY_SUPREMA			0x85
#define HENRY_ENVIA_MAPA		0x88
#define HENRY_CMDS_ORION6		0x97
#define HENRY_RECEBE_MAPA		0x98
#define HENRY_POOLING			0x90
#define HENRY_RECEBE_HORA		0x92
#define HENRY_RECEBE_BATIDAS		0x93
#define HENRY_APAGA_BATIDAS		0x89
#define HENRY_RECEBE_QTD_BATIDAS	0x99
#define HENRY_RECEBE_QTD_REGLEN		2
#define HENRY_CATRACA			0x86

#define CATRACA_NORMAL			0x00
#define CATRACA_ENTRADA			0x01
#define CATRACA_SAIDA			0x02
#define CATRACA_LIBERADA		0x03


// Configuracoes ////////
#define CONF_BYTE_ONOFF			0
typedef enum {
	CONF_OFFLINE,
	CONF_ONLINE,
	CONF_ONOFF,
	CONF_ONOFF_CTRL
} CONF_LINE;
#define CONF_BYTE_CARD			1
typedef enum {
	CONF_CARD_V = 130,
	CONF_CARD_VI = 131,
	} CONF_CARD;
	
#define CONF_BYTE_TECLADO		2
typedef enum {
	CONF_TECL_DESATIVADO, 
	CONF_TECL_PERGUNTA, 
	CONF_TECL_LEITOR1, 
	CONF_TECL_LEITOR2,
	CONF_TECL_LEITOR3,
	CONF_TECL_ATALHO
	} CONF_TECLADO;

#define CONF_BYTE_RELE1			3
#define CONF_BYTE_RELE2			4
#define CONF_BYTE_RELE3			5
typedef enum {
	CONF_RELE_DESATIVADO,
	CONF_RELE_SIRENE,
	CONF_RELE_PORTA,
	CONF_RELE_OUTROS
	} CONF_RELE;

#define CONF_RELE_NA			0x00
#define CONF_RELE_NF			0x10

// Byte 5 - sempre 0

#define CONF_BYTE_LEITOR1		7
#define CONF_BYTE_LEITOR2		8
#define CONF_BYTE_LEITOR3		9
typedef enum 
{
	CONF_LEITOR_DESATIVADO,
	CONF_LEITOR_ES,
	CONF_LEITOR_ENTRADA,
	CONF_LEITOR_SAIDA,
	CONF_LEITOR_SE,
	CONF_LEITOR_AUTO,
} CONF_LEITOR;

#define CONF_BYTE_NIVEL_ACESSO		10

#define CONF_BYTE_CONTROLE_ACESSO	11
typedef enum
{
	CONF_ACESSO_LIVRE,
	CONF_ACESSO_NAO_CADASTRADOS,
	CONF_ACESSO_CADASTRADOS
} CONF_ACESSO;

#define CONF_BYTE_CONTROLE_FLAGS	12
typedef enum
{
	CONF_ACESSO_GRAVAR_TODOS,
	CONF_ACESSO_GRAVAR_BLOQUEADOS,
	CONF_ACESSO_GRAVAR_LIBERADOS,
	CONF_ACESSO_NAO_GRAVAR
} CONF_ACESSO_FLAGS;

#define	CONF_ATIVAR_MASTER		0x04	// bit 2
#define	CONF_TRABALHAR_OFF		0x08	// bit 3
#define	CONF_SINALIZAR_50		0x10	// bit 4
#define	CONF_ATIVAR_SENHA		0x20	// bit 5
#define	CONF_CATRACA			0x40	// bit 6

// Byte 13 - toques do modem

// Byte 14 - tipo do codigo de barras
#define CONF_BYTE_TIPO_BARRAS		14

#define CONF_BARRAS_PADRAO_D		0x01
#define CONF_BARRAS_LETRAS		0x04
#define CONF_BARRAS_PADRAO_LIVRE	0x10
#define CONF_BARRAS_PADRAO_AUTO		0x20
#define CONF_BARRAS_PADRAO_DESCRIPT	0x40

#define CONF_BYTE_QTD_DIGITOS		15
#define CONF_BYTE_TEMPO_RELE1		16
#define CONF_BYTE_TEMPO_RELE2		17
#define CONF_BYTE_TEMPO_RELE3		18
#define CONF_BYTE_REVISTA		19

// Byte 20 e 21 - senha
#define CONF_BYTE_SENHA			20

// Byte 22, 23 e 24 - digitos selecionados
#define CONF_BYTE_DIGITOS_SELECIONADOS	22

// Byte 25 a 36 - Empresas
// Byte 37 a 48 - Reservado

// //////////////////////

enum
{
	HH_NRO,
	HH_CMD,
	HH_FIRMWARE,
	HH_STATUS,
	HH_REGLEN,
	HH_LSB,
	HH_HSB,
	HH_CHECKSUM,
	HEADER_LEN
} HENRY_HEADER;


int henry_envia_header(IFDEVICE4J *, unsigned char *);
int henry_recebe_header(IFDEVICE4J *, unsigned char *);


// //////////////////////////////////////////////////////////////
// Cria uma nova instancia do equipamento
IFDEVICE4J * henry_new();


// //////////////////////////////////////////////////////////////
// Fica bloqueada (em pooling)
// chama callback a cada ciclo ocioso.
// *** Sai do pooling se callback retornar um numero diferente de ZERO. ***
// Retorno:
// A matricula retorna no campo ultimo da struct IFDEVICE4J.
// Retorno conforme enum abaixo
typedef enum {
	HENRY_ESPERA_OFF,	// existem registros off-line
	HENRY_ESPERA_FIM,	// finalizado (conforme retorno do callback)
	HENRY_ESPERA_ERRO	// Erro de comunicacao
	} HENRY_ESPERA;
//HENRY_ESPERA henry_wait(IFDEVICE4J *, IA_CALLBACKS *, int pooling_sec);
//HENRY_ESPERA henry_wait_in(IFDEVICE4J *, IA_CALLBACKS *, int pooling_sec);


// //////////////////////////////////////////////////////////////
// Envia autorizacao
// Esta funcao deve ser chamada apos um retorno ok da funcao espera
//void henry_msg_online(IFDEVICE4J *leitor, IA_COMANDO *);

// //////////////////////////////////////////////////////////////
// Le os registros off-line
// Retorno:
// qtd de registros lidos
// -1 em caso de erro
//
// A funcao callback eh chamada a cada registro.
//int henry_get_registros(IFDEVICE4J *, IA_OFFLINE_CALLBACK);

// //////////////////////////////////////////////////////////////
// Ajusta mensagens padrao
int henry_mensagem_padrao(IFDEVICE4J *leitor, char *msg, char *msg_entrada, unsigned char tempo_entrada, char *msg_saida, unsigned char tempo_saida);

// //////////////////////////////////////////////////////////////
// Ajusta data/hora
int henry_set_data(IFDEVICE4J *leitor, unsigned char ano, unsigned char mes, unsigned char dia, unsigned char hor, unsigned char min);

// //////////////////////////////////////////////////////////////
// Le data/hora/qtd de registros offline
int henry_get_data(IFDEVICE4J *leitor, unsigned char *ano, unsigned char *mes, unsigned char *dia, unsigned char *hor, unsigned char *min);


// //////////////////////////////////////////////////////////////
int henry_set_catraca(IFDEVICE4J *leitor, unsigned char cmd, unsigned char tempo);

// //////////////////////////////////////////////////////////////
int henry_get_configuracao(IFDEVICE4J *leitor);
int henry_set_configuracao(IFDEVICE4J *leitor);

int henry_set_configuracao_card(IFDEVICE4J *leitor, 
	unsigned char online, 
	unsigned char card, 
	unsigned char teclado, 
	unsigned char rele1, 
	unsigned char tempo1, 
	unsigned char rele2, 
	unsigned char tempo2, 
	unsigned char rele3, 
	unsigned char tempo3); 

int henry_set_configuracao_barras(IFDEVICE4J *leitor, unsigned char tipo, unsigned char qtd_dig, int digs_selecionados);
int henry_set_configuracao_acesso(IFDEVICE4J *leitor, CONF_LEITOR l1, CONF_LEITOR l2, CONF_ACESSO acesso, int flags);
int henry_get_content(_IN IFDEVICE4J *l, _INOUT unsigned char *header, _OUT unsigned char **buf);


// Pooling em segundos
#define HENRY_POOLING_NORMAL	3
#define HENRY_POOLING_GPRS	120


