#include <ifractal.h>

#include <tlhelp32.h>

#include <metahost.h>


ICLRMetaHost *metaHost = NULL;
ICLRRuntimeInfo *runtimeInfo = NULL;


// ////////////////////////////////////////////////////////
ICLRRuntimeHost * loadDotNetInstance()
{	int result = 0;

	ICLRRuntimeHost *runtimeHost = NULL;

	// Load .NET
	result = CLRCreateInstance(&CLSID_CLRMetaHost, &IID_ICLRMetaHost, (LPVOID*) &metaHost);
	if (result != S_OK)
		return(NULL);

	// Replace .NET version with the one you want to load (or which is already loaded)
	result = ICLRMetaHost_GetRuntime(metaHost, 
		L"v4.0.30319", &IID_ICLRRuntimeInfo, (LPVOID *) &runtimeInfo);
	if (result != S_OK)
		return(NULL);

	result = ICLRRuntimeInfo_GetInterface(runtimeInfo, 
		&CLSID_CLRRuntimeHost, &IID_ICLRRuntimeHost, (LPVOID *) &runtimeHost);
	switch (result)
	{
		case S_OK:
			break;
	
		case E_POINTER:
			verbose(stderr, "ppUnk is null.\n");
			return(NULL);

		case E_OUTOFMEMORY:
			verbose(stderr, "Not enough memory is available to handle the request.\n");
			return(NULL);

		default:
			verbose(stderr, "A different runtime was already bound to the legacy CLR version 2 activation policy.\n");
			return(NULL);
	}

	// Start runtime
	result = ICorRuntimeHost_Start(runtimeHost);
	if (result != S_OK)
		return(NULL);

	return(runtimeHost);
}
// ////////////////////////////////////////////////////////
void unloadDotNetInstance(ICLRRuntimeHost *runtimeHost)
{
	int result = 0;

	// Unload .NET
	result = ICorRuntimeHost_Stop(runtimeHost);
	verbose(stderr, "unloadDotNetInstance: %d\n", result);

	// free resources
	ICLRMetaHost_Release(metaHost);
	ICLRRuntimeInfo_Release(runtimeInfo);
	ICorRuntimeHost_Release(runtimeHost);
}
// ////////////////////////////////////////////////////////
int callDefaultDotNetMethod(ICLRRuntimeHost *runtimeHost, char *dll, char *klass, char *meth, char *arg, int32_t *returnValue)
{
	char *in[] = {dll, klass, meth, arg};
	unsigned char *pars[4];
	int result = 0;

	for (int i = 0 ; i < 4 ; i++)
	{
		pars[i] = if_malloc(strlen(in[i]) * 2 + 2);
		for (int k = 0 ; in[i][k] != 0 ; k++)
			pars[i][k * 2] = in[i][k];
	}

	// Execute managed assembly
	result = ICLRRuntimeHost_ExecuteInDefaultAppDomain(
		runtimeHost,
		(LPCWSTR) pars[0], (LPCWSTR) pars[1], (LPCWSTR) pars[2], (LPCWSTR) pars[3],
		returnValue);

	for (int i = 0 ; i < 4 ; i++)
		if_free(pars[i]);

	return(result);
}
// ////////////////////////////////////////////////////////


