#ifndef ZK_H
#define ZK_H

#include <ifractal.h>
#include <ifdevice.h>

#define CMD_CHECK		0x1AA	// Acorda equipamento (nao documentado)

#define CMD_CONNECT 		1000	// Connection request
#define CMD_EXIT 		1001	// Disconnect
#define CMD_ENABLEDEVICE 	1002	// Enable machine in normal work state
#define CMD_DISABLEDEVICE 	1003	// Disable machine in work state, display “in the work ...” on LCD
#define CMD_RESTART 		1004	// Restart machine
#define CMD_POWEROFF 		1005	// Power off
#define CMD_SLEEP 		1006	// Enable machine in sleep
#define CMD_RESUME 		1007	// Awake sleeping machine (not support at present)
#define CMD_CAPTUREFINGER 	1009	// Capture fingerprint image
#define CMD_TEST_TEMP 		1011	// Test whether a fingerprint exists
#define CMD_CAPTUREIMAGE 	1012	// Capture all image
#define CMD_REFRESHDATA 	1013	// Refresh data in the machine
#define CMD_REFRESHOPTION 	1014	// Refresh configuration parameter
#define CMD_TESTVOICE 		1017	// Play voice
#define CMD_GET_VERSION 	1100	// Get firmware version
#define CMD_CHANGE_SPEED 	1101	// Change transmission speed
#define CMD_AUTH 		1102	// Connection authorization
#define CMD_PREPARE_DATA 	1500	// Prepare to transmit data
#define CMD_DATA 		1501	// send a data packet
#define CMD_FREE_DATA 		1502	// Free buffer memory

#define CMD_REQUEST 		1503	// Faz coleta (nao documentado)
#define CMD_REQUEST_DATA	0x05E0	// Solicita pacote (nao documentado)

#define CMD_DB_RRQ 		7	// Read a data in machine
#define CMD_USER_WRQ 		8	// Upload user information (from PC to terminal)
#define CMD_USERTEMP_RRQ 	9	// Read a fingerprint template or all data
#define CMD_USERTEMP_WRQ 	10	// Upload a fingerprint template
#define CMD_OPTIONS_RRQ 	11	// Read a configuration parameter in the machine
#define CMD_OPTIONS_WRQ 	12	// Set machine configuration parameter
#define CMD_ATTLOG_RRQ 		13	// Read all attendance record
#define CMD_CLEAR_DATA 		14	// Clear data

#define CMD_CLEAR_ATTLOG	15 // Clear attendance log
#define CMD_DELETE_USER		18 // Delete some user
#define CMD_DELETE_USERTEMP	19 // delete a fingerprint template
#define CMD_CLEAR_ADMIN		20 // Clear administrator

#define CMD_USERGRP_RRQ		21 // Read user subgroup
#define CMD_USERGRP_WRQ		22 // Set user subgroup
#define CMD_USERTZ_RRQ		23 // Read user time zone setting
#define CMD_USERTZ_WRQ		24 // Write user time zone setting
#define CMD_GRPTZ_RRQ		25 // Read group time zone setting
#define CMD_GRPTZ_WRQ		26 // write group time zone setting
#define CMD_TZ_RRQ		27 // Read time zone setting
#define CMD_TZ_WRQ		28 // Write time zone setting
#define CMD_ULG_RRQ		29 // Read unlocking combination
#define CMD_ULG_WRQ		30 // Write unlocking combination
#define CMD_UNLOCK		31 // unlock
#define CMD_CLEAR_ACC		32 // Recover access control setting as default state
#define CMD_CLEAR_OPLOG		33 // Delete all attendance log in the machine
#define CMD_OPLOG_RRQ		34 // Read management record
#define CMD_GET_FREE_SIZES	50 // Get machine state, such as user record and so on
#define CMD_ENABLE_CLOCK	57 // Enable machine in normal work state

#define CMD_STARTVERIFY		60 // Enable machine in verification state
#define CMD_STARTENROLL		61 // Start to enroll a user, enable machine in enrolling user state
#define CMD_CANCELCAPTURE	62 // Enable machine in waiting for command CMD_STARTENROLL for detailed information.
#define CMD_STATE_RRQ		64 // Get machine state
#define CMD_WRITE_LCD		66 // Write LCD
#define CMD_CLEAR_LCD		67 // Clear LCD subtitle (clear screen)
#define CMD_GET_PINWIDTH	69 // Get user PIN length

#define CMD_SMS_WRQ		70 // Upload SMS
#define CMD_SMS_RRQ		71 // Download SMS
#define CMD_DELETE_SMS		72 // Delete SMS
#define CMD_UDATA_WRQ		73 // Set user SMS
#define CMD_DELETE_UDATA	74 // Delete user SMS
#define CMD_DOORSTATE_RRQ	75 // Get door state

#define CMD_WRITE_MIFARE	76 // Write Mifare card
#define CMD_READ_MIFARE		77 // Read Mifare card
#define CMD_EMPTY_MIFARE	78 // Clear Mifare card
#define CMD_GET_TIME		201 // Get machine time
#define CMD_SET_TIME		202 // Set machine time

#define CMD_REG_EVENT		500 // Register event

#define EF_ATTLOG		1 // Pass real-time verification
#define EF_FINGER		2 // Press fingerprint at the real time (return data type sign at the real time)
#define EF_ENROLLUSER		4 // Enroll user at the real time
#define EF_ENROLLFINGER		8 // Enroll fingerprint at the real time
#define EF_BUTTON		16 // Press button at the real time
#define EF_UNLOCK		32 // Unlock at the real time
#define EF_VERIFY		64 // Verify fingerprint at the real time
#define EF_FPFTR		128 // Extract fingerprint feature at the real time
#define EF_ALARM		256 // Alarm signal

#define CMD_ACK_OK		2000 // Returned value after successful execution
#define CMD_ACK_ERROR		2001 // Returned value after failed execution
#define CMD_ACK_DATA		2002 // Return value
#define CMD_ACK_RETRY		2003 // Registered event occurred
#define CMD_ACK_REPEAT		2004 // CMD_ACK_UNAUTH 2005 Unauthorized connection
#define CMD_ACK_UNKNOWN		0xffff // Unknown command
#define CMD_ACK_ERROR_CMD	0xfffd // Command error
#define CMD_ACK_ERROR_INIT	0xfffc // Not Initialized
#define CMD_ACK_ERROR_DATA	0xfffb // 

#define FCT_ATTLOG		1 // Attendance record
#define FCT_WORKCODE		8 // WorkCode
#define FCT_FINGERTMP		2 // Fingerprint data
#define FCT_OPLOG		4 // Operation log
#define FCT_USER		5 // User record
#define FCT_SMS			6 // SMS
#define FCT_UDATA		7 // User SMS


#define ZK_DEFAULT_PORT		4370
#define ZK_START_PORT		50000
#define MAXPACKET 		2048

typedef struct
{
	uint16_t cmd;
	uint16_t checksum;
	uint16_t sessionid;
	uint16_t replyid;
} ZKHEADER;

typedef struct
{
	uint32_t pin;
	uint32_t zktime;
	uint8_t status;
	uint8_t verified;
	uint16_t reserved;
	uint32_t workcode;
} ZKLOG;

typedef struct
{
	uint16_t pin;
	char matricula[24];
	uint8_t status_padding[2];
	uint32_t zktime;
	uint32_t workcode;
	uint8_t verified;
} ZKFACELOG;


// 20 00 - PIN
// 00 00 - 
// FF FF FF A4
// S(53) t(74) e(65) n(6E) i(69) o(6F) 00 08 - Name
// 28 FE 0D 00 - RFID
// 00 81 01 00 00 00 00 00


#define ZK_ORDINARY_USER	0
#define ZK_ADMIN_USER		8

typedef struct
{
	uint16_t pin;
	uint16_t privilege;
	uint32_t unknown1;
	char name[8];
	uint32_t rfid;
	uint16_t unknown2;
	uint16_t group;
	uint32_t id;
} ZKUSER;



#define ZKFACEUSER_OFFSET_PIN		0
#define ZKFACEUSER_OFFSET_PASS		3
#define ZKFACEUSER_OFFSET_NAME		11
#define ZKFACEUSER_OFFSET_CARD		35
#define ZKFACEUSER_OFFSET_MATRICULA	48

#define ZKFACEUSER_PACK_LEN		72

typedef struct
{
	uint16_t pin;
	char pass[8];
	char name[24];
	char matricula[24];
	uint32_t card;
} ZKFACEUSER;

typedef struct
{
	uint32_t pin2;
	uint16_t flags;
	uint8_t year;
	uint8_t mon;
	uint8_t day;
	uint8_t hour;
	uint8_t min;
	uint8_t sec;
} ZKONLINE;

typedef struct
{
	char matricula[24];
	uint8_t padding[2];
	uint8_t year;
	uint8_t mon;
	uint8_t day;
	uint8_t hour;
	uint8_t min;
	uint8_t sec;
} ZKONLINEFACE;

typedef enum {ZK_PLAIN_MODEL, ZK_FACE_MODEL} ZK_MODEL;

int ZK_open(IFDEVICE *, int wakeup);
int ZK_close(IFDEVICE *);

#endif
