#include <ifractal.h>

#include <tlhelp32.h>


// ////////////////////////////////////////////////////////
int win_proc_iter(PROC_LIST_CALLBACK cb, void *user_data)
{
	HANDLE hSnapShot = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
	PROCESSENTRY32 Pe32;
	Pe32.dwSize = sizeof(PROCESSENTRY32);
	int r, i;

	i = 0;
	Process32First(hSnapShot, &Pe32);
	do
	{
		r = cb(Pe32.szExeFile, 
			(int) Pe32.th32ProcessID, 
			(int) Pe32.th32ParentProcessID, 
			(int) Pe32.cntThreads, user_data);

		i++;

		if (r)
			break;
	}
	while (Process32Next(hSnapShot, &Pe32));

	CloseHandle (hSnapShot);

	return(i);
}
// ////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////
void listWindows()
{
	char buf[PATH_LEN];
	HWND handle;
	int len;

	handle = FindWindow(NULL, NULL);
	for ( ; handle != NULL ; handle = GetWindow(handle, GW_HWNDNEXT))
	{
		len = GetWindowTextA(handle, buf, PATH_LEN);
		if (len > 0)
		{
			fprintf(stdout, "%s\n", buf);
			fflush(stdout);
		}
	}
}
// ////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////
int setDLLHooks(_IN char *dll_name, _IN DWORD thread_id, _INOUT IF_HOOK *hook_array, int array_len)
{
	int i;
	HINSTANCE hinstDLL; 
	void *hookhandle;

	hinstDLL = LoadLibrary(dll_name);
	if (hinstDLL == NULL)
	{
		fprintf(stderr, "Falha ao tentar carregar: '%s'.\n", dll_name);
		return(0); 
	}

	for (i = 0 ; i < array_len ; i++)
	{
		hook_array[i].func = (HOOKPROC) GetProcAddress(hinstDLL, hook_array[i].func_name);
		if (hook_array[i].func == NULL)
		{
			fprintf(stderr, "HOOK: Simbolo nao localizado '%s'.\n", 
				hook_array[i].func_name);
			return(i - 1); 
		}
        
		hookhandle = SetWindowsHookEx( 
			hook_array[i].hookid,
			hook_array[i].func,
			hinstDLL,
			thread_id);
        
		if (hookhandle == NULL)
		{
			fprintf(stderr, "Falha ao tentar iniciar \"HOOK\" (%d).\n", hook_array[i].hookid);
			return(i - 1);
		}
	}

	return(i);
}
// ////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////
int setLocalHooks(_IN HINSTANCE self, _IN DWORD thread_id, _IN IF_HOOK *hook_array, int array_len)
{
	void *hookhandle;
	int i;

	for (i = 0 ; i < array_len ; i++)
	{
		hookhandle = SetWindowsHookEx( 
			hook_array[i].hookid,
			hook_array[i].func,
			self,
			thread_id);

		if (hookhandle == NULL)
		{
			fprintf(stderr, "Falha ao tentar iniciar \"HOOK\" (%d).\n", hook_array[i].hookid);
			return(i - 1);
		}
	}

	return(i);
}
// ////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////
_PRIVATE char * w32_make_args(char **args)
{
	char *p, *buf = if_malloc(BUFFER_LEN);
	int i;

	for (p = buf, i = 0 ; args[i] != NULL ; i++)
		p += snprintf(p, BUFFER_LEN - (p - buf), "\"%s\" ", args[i]);

	return(buf);
}
// ////////////////////////////////////////////////////////
_PUBLIC HANDLE start_proc(
	_IN char **args, 
	_IN char **envs, 
	_IN char *path,
	_INOUT PROCESS_INFORMATION *pi,
	_OUT HANDLE *newstdin, 
	_OUT HANDLE *newstdout,
	_OUT HANDLE *read_stdout,
	_OUT HANDLE *write_stdin)
{
	int i, len;
	char *envblock, *p, *buf_args;
	STARTUPINFO si;
	SECURITY_ATTRIBUTES sa;

	sa.lpSecurityDescriptor = NULL;
	sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	sa.bInheritHandle = 1;

	GetStartupInfo(&si);
	si.wShowWindow = SW_HIDE;

	if (newstdin != NULL)
	{
		if (!CreatePipe(newstdin, write_stdin, &sa, 0)) //create stdin pipe
		{
			verbose(stderr, "Falha ao criar pipe\n");
			return(NULL);
		}
        
		if (!CreatePipe(read_stdout, newstdout, &sa, 0))	//create stdout pipe
		{
			verbose(stderr, "Falha ao criar pipe\n");
			CloseHandle(*newstdin);
			CloseHandle(*write_stdin);
			return(NULL);
		}

		si.dwFlags = STARTF_USESTDHANDLES|STARTF_USESHOWWINDOW;
		si.hStdOutput = *newstdout;
		si.hStdError = *newstdout;
		si.hStdInput = *newstdin;
	}

	if (envs != NULL)
	{
		// Ajusta environment block
		for (len = 0, i = 0 ; envs[i] != NULL ; i++)
			len += strlen(envs[i]) + 1;
        
		envblock = MALLOC(len + 1);
		for (p = envblock, i = 0 ; envs[i] != NULL ; i++)
		{
			p += snprintf(p, len, "%s", envs[i]);
			p++;
			*p = 0;
		}
	}
	else
		envblock = NULL;

	buf_args = w32_make_args(args);

	LPCTSTR lpAppName = args[0];

	//spawn the child process
	if (!CreateProcess(lpAppName, buf_args, NULL, NULL, FALSE, CREATE_NO_WINDOW, envblock, NULL, &si, pi))
	{
		fprintf(stderr, "Falha ao tentar iniciar: '%s'.\n", args[0]);

		if (newstdin != NULL)
		{
			CloseHandle(*newstdin);
			CloseHandle(*newstdout);
			CloseHandle(*read_stdout);
			CloseHandle(*write_stdin);
		}

		FREE(buf_args);
		FREE(envblock);

		return(NULL);
	}

	FREE(buf_args);
	FREE(envblock);

	return(pi->hProcess);
}
// ////////////////////////////////////////////////////////


