#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef __linux__
#include <wait.h>
#elif __APPLE__
#include <sys/wait.h>
#endif


// ////////////////////////////////////////////////////////////////////////
int start_proc(char **args, char **envs, char *path, int *pin, int *pout, int *perr)
{
	int pid;

	// Pipes entre o monitor (PAI)
	// e stdin/stdout/stderr da aplicacao (FILHO)
	if ((pipe(pin) < 0) || (pipe(pout) < 0) || (pipe(perr) < 0))
		return(-1);

	pid = fork();
	if (pid < 0)
		return(-2);
	
	// Filho
	if (pid == 0)
	{
		// Posiciona o diretorio do processo
		if (path != NULL)
		{
			if (chdir(path))
			{
				fprintf(stderr, "Falha ao tentar ajustar path: '%s'\n", path);
				exit(1);
			}
		}

		//////////////////////////////////////////////////
		// redireciona entrada/saida/erro padrao do filho
		// p/ os pipes (pin, pout, perr) do pai
		
		// stdout
		close(pout[0]);
		dup2(pout[1], 1);
		
		// stderr
		close(perr[0]);
		dup2(perr[1], 2);
		
		// stdin
		close(pin[1]);
		dup2(pin[0], 0);
		///////////////////////////////////////////////////
			
		// executa o processo
		if (envs == NULL)
			execv(args[0], args);
		else
			execve(args[0], args, envs);
		
		// Se a aplicacao existir e tudo der certo
		// esse codigo nunca serah executado
		fprintf(stderr, "Falha ao tentar executar: '%s'\n", args[0]);
		exit(2);
	} 
	
	// PAI continua
	// Fecha a "ponta" de saida (stdout) do pipe
	close(pout[1]);
	
	// Fecha a "ponta" de saida (stderr) do pipe
	close(perr[1]);
		
	// Fecha a "ponta" de entrada (stdin) do pipe
	close(pin[0]);

	// PID do filho
	return(pid);
}
// ////////////////////////////////////////////////////////////////////////

