#include <ifractal.h>
#include <tunnel.h>

#include <glib.h>


// ///////////////////////////////////////////////////////////////////// //
TUNNEL_STREAM * tunnel_stream_new(int port, char *clientid, TUNNEL_STREAM_TYPE type, char **fields)
{
	char aux[PORT_LEN];
	TUNNEL_STREAM *stream = if_malloc(sizeof(TUNNEL_STREAM));
	snprintf(stream->clientid, PATH_LEN, "%s", clientid);
	stream->type = type;

	do
	{
		snprintf(aux, PORT_LEN, "%d", port++);
		verbose(stdout, "Tenta abrir stream porta: %s\n", aux);
		stream->ssock = openServerTCP(aux);

		if (port > 65000)
		{
			verbose(stdout, "Falha ao tentar abrir stream.\n");
			goto tunnel_stream_new_err;
		}
	}
	while (stream->ssock < 1);

	strncpy(stream->tunnel_port, aux, PORT_LEN);
	verbose(stdout, "%s - Stream porta: %s ONLINE\n", stream->clientid, aux);

	char *admin_ip = json_get_list_param(fields, "admin");
	strncpy(stream->admin_ip, admin_ip, PORT_LEN);

	char *filename = json_get_list_param(fields, "filename");
	char *client_ip = json_get_list_param(fields, "ip");
	char *client_port = json_get_list_param(fields, "port");

	switch (type)
	{
		case TUNNEL_STREAM_TYPE_SHELL:
			break;

		case TUNNEL_STREAM_TYPE_PROXY:
			strncpy(stream->client_ip, client_ip, IP_LEN);
			strncpy(stream->client_port, client_port, PORT_LEN);
			break;
			
		case TUNNEL_STREAM_TYPE_DOWNLOAD:
		case TUNNEL_STREAM_TYPE_UPLOAD:
			strncpy(stream->filename, filename, IP_LEN);
			break;
	}

	return(stream);

tunnel_stream_new_err:

	tunnel_stream_free(stream);

	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
void tunnel_stream_free(TUNNEL_STREAM *tn)
{
	if (tn == NULL)
		return;

	if (tn->thread != NULL)
		g_thread_join(tn->thread);

	if (tn->ssock > 0)
		if_closesocket(tn->ssock);

	if_free(tn);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
TUNNEL_STREAM_PAIR * tunnel_stream_pair_new(char *admin_ip, char *client_ip, int sock)
{
	TUNNEL_STREAM_PAIR *pair;

	if (((admin_ip == NULL) && (client_ip == NULL)) || (sock < 1))
		return(NULL);

	pair = if_malloc(sizeof(TUNNEL_STREAM_PAIR));
	pair->last = pair->start = time(NULL);
	pair->up = pair->down = 0;

	if (admin_ip == NULL)
	{
		strncpy(pair->client_ip, client_ip, IP_LEN);
		pair->client_sock = sock;
	}
	else
	{
		strncpy(pair->admin_ip, admin_ip, IP_LEN);
		pair->admin_sock = sock;
	}

	return(pair);
}
// ///////////////////////////////////////////////////////////////////// //
void tunnel_stream_pair_free(TUNNEL_STREAM_PAIR *pair)
{
	if (pair == NULL)
		return;

	if (pair->admin_sock > 0)
		if_closesocket(pair->admin_sock);

	if (pair->client_sock > 0)
		if_closesocket(pair->client_sock);

	if_free(pair);
}
// ///////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
TUNNEL_CLIENT_STREAM * tunnel_client_stream_new(TUNNEL_STREAM_TYPE type, char *header)
{
	// TODO
	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
void tunnel_client_stream_free(TUNNEL_CLIENT_STREAM *ts)
{
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
TUNNEL_CLIENT_STREAM_PAIR * tunnel_client_stream_pair_new(TUNNEL_CLIENT_STREAM *ts)
{
	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
void tunnel_client_stream_pair_free(TUNNEL_CLIENT_STREAM_PAIR *tp)
{
}
// ///////////////////////////////////////////////////////////////////// //

