/*
	robin verton, dec 2015
	implementation of the rc4 algo
*/

#include <ifractal.h>

#define RC4_LEN 256


// ////////////////////////////////////////////////////////////
void swap(unsigned char *a, unsigned char *b)
{
	int tmp = *a;
	*a = *b;
	*b = tmp;
}
// ////////////////////////////////////////////////////////////
int KSA(char *key, unsigned char *S)
{
	int len = strlen(key);
	int j = 0;

	int i;
	for(i = 0; i < RC4_LEN; i++)
		S[i] = i;

	for(i = 0; i < RC4_LEN; i++) {
		j = (j + S[i] + key[i % len]) % RC4_LEN;

		swap(&S[i], &S[j]);
	}

	return 0;
}
// ////////////////////////////////////////////////////////////
void PRGA(unsigned char *S, unsigned char *datain, size_t len, unsigned char *dataout)
{
	int i = 0;
	int j = 0;

	size_t n;
	for(n = 0 ; n < len ; n++)
	{
		i = (i + 1) % RC4_LEN;
		j = (j + S[i]) % RC4_LEN;

		swap(&S[i], &S[j]);
		int rnd = S[(S[i] + S[j]) % RC4_LEN];

		dataout[n] = rnd ^ datain[n];
	}
}
// ////////////////////////////////////////////////////////////
int rc4(char *key, char *plaintext, unsigned char *ciphertext)
{
	unsigned char S[RC4_LEN];
	KSA(key, S);
	PRGA(S, (unsigned char *) plaintext, strlen(plaintext), ciphertext);
	return 0;
}
// ////////////////////////////////////////////////////////////
int rc4bin(_IN char *key, _IN unsigned char *datain, _IN size_t len, unsigned char *dataout)
{
	unsigned char S[RC4_LEN];

	if (len < 1)
		return(0);

	KSA(key, S);
	PRGA(S, datain, len, dataout);

	return(len);
}
// ////////////////////////////////////////////////////////////


#ifdef STANDALONE

// ////////////////////////////////////////////////////////////
int main(int argc, char *argv[])
{
	if (argc < 3)
	{
		fprintf(stderr, "Usage: %s <key> <file>\n", argv[0]);
		return(1);
	}

	unsigned char *ciphertext, *buf;
	size_t len;
	char *b64;
	FILE *fd;

	fd = fopen(argv[2], "r");
	if (fd == NULL)
	{
		fprintf(stderr, "Falha ao tentar abrir: '%s'\n", argv[2]);
		return(2);
	}

	len = cgi_get_content(fd, (char **) &buf);
	fclose(fd);

	ciphertext = malloc(len);
	rc4bin(argv[1], buf, len, ciphertext);
	if_free(buf);

	base64_encode(ciphertext, len, &b64);
	printf("%s\n", b64);
	if_free(b64);

	char *dataout = malloc(len + 1);
	memset(dataout, 0, len + 1);
	rc4bin(argv[1], ciphertext, len, dataout);
	printf("-->%s<--\n", dataout);
	if_free(dataout);

	return(0);
}
// ////////////////////////////////////////////////////////////

#endif
