#include <ifractal.h>


// ///////////////////////////////////////////////////////////////////// //
int overwrite(char *path)
{
	DIR *dir;
	struct dirent *de;
	char name[PATH_LEN];
	char buf[BUFFER_LEN];
	FILE *fd_in, *fd_out;
	int len, qtd, n;
	
	fprintf(stdout, "Procura arquivos em: '%s'.\n", path);
	if ((dir = opendir(path)) == NULL)
	{
		fprintf(stderr, "Erro ao tentar ler: '%s'.\n", path);
		return(-1);
	}
		
	for (qtd = 0 ; (de = readdir(dir)) != NULL ; )
	{
		len = strlen(de->d_name);
		if ((len < 3) || (strcmp(de->d_name + len - 3, ".in") != 0))
		{
			continue;
		}

		snprintf(name, PATH_LEN, "%s%c%s", path, PATH_SEPARATOR, de->d_name);
		len = strlen(name);

		// Verifica se arquivo "out" existe
		name[len - 3] = 0;
		fd_out = fopen(name, "rb");
		if (fd_out != NULL)
		{
			fprintf(stdout, "'%s' nao alterado...\n", name);
			fclose(fd_out);
			continue;
		}

		fd_out = fopen(name, "wb");
		if (fd_out == NULL)
		{
			fprintf(stderr, "Falha ao tentar criar '%s'.\n", name);
			continue;
		}
		
		name[len - 3] = '.';
		fd_in = fopen(name, "rb");
		if (fd_in == NULL)
		{
			fprintf(stderr, "Falha ao tentar ler '%s'.\n", name);
			fclose(fd_out);
			continue;
		}

		name[len - 3] = 0;
		fprintf(stdout, "Copia: '%s.in' para '%s'\n", name, name);
		while ((n = fread(buf, 1, BUFFER_LEN, fd_in)) > 0)
			fwrite(buf, 1, n, fd_out);

		fclose(fd_out);
		fclose(fd_in);

		qtd++;
	}

	closedir(dir);

	return(qtd);
}
// ///////////////////////////////////////////////////////////////////// //




// //////////////////////////////////////////////////////////////////
int main(int argc, char **argv) 
{ 
	if (argc < 2)
	{
		fprintf(stderr, "Uso:\nshell$ %s <PATH>\n", argv[0]);
		return(1);
	}

	overwrite(argv[1]);
	
	return(0);
}
// //////////////////////////////////////////////////////////////////


